/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.HTTPStreamerCupertinoIndexBase;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IMediaReaderCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerApplicationContextCupertinoStreamer;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.MediaStreamDisconnected;
import com.wowza.wms.stream.MediaStreamMap;

public class HTTPStreamerCupertinoIndexFile
extends HTTPStreamerCupertinoIndexBase {
    private IMediaReaderCupertino mediaReader = null;
    private String cupertinoEncryptionBaseURL = null;
    private String cupertinoEncryptionLiveRepeaterSharedSecret = null;
    private ID3Frames id3FramesHeader = new ID3Frames();
    private ID3Frames id3FramesFooter = new ID3Frames();
    private ID3Frames id3FramesHeaderAudio = new ID3Frames();
    private ID3Frames id3FramesFooterAudio = new ID3Frames();
    private boolean cupertinoEncryptionAPIBased = false;
    private String rawStreamName = null;

    public void fillChunk(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
        Object object;
        Object object2;
        ID3Frames iD3Frames;
        ((HTTPStreamerApplicationContextCupertinoStreamer)this.appContext).notifyVODListenerOnFillChunkStart(this, iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
        ID3Frames iD3Frames2 = iD3Frames = bl ? this.id3FramesHeaderAudio : this.id3FramesHeader;
        if (!iD3Frames.isEmpty()) {
            object2 = iD3Frames.serialize(true, true, 0);
            liveStreamPacketizerCupertinoChunk.addBlock((byte[])object2, 0, ((byte[])object2).length);
        }
        if (this.mediaReader != null) {
            this.mediaReader.fillChunk(iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
        }
        if (!(object2 = (Object)(bl ? this.id3FramesFooterAudio : this.id3FramesFooter)).isEmpty()) {
            object = object2.serialize(true, true, 0);
            liveStreamPacketizerCupertinoChunk.addBlock((byte[])object, 0, ((Object)object).length);
        }
        if ((object = iHTTPStreamerCupertinoIndexItem.getEncInfo()) != null) {
            if (this.cupertinoEncryptionAPIBased) {
                this.appInstance.getModFunctions().onHTTPCupertinoEncryptionKeyVODChunk((HTTPStreamerSessionCupertino)this.httpStreamerSession, (IHTTPStreamerCupertinoIndex)this, (CupertinoEncInfo)object, (long)liveStreamPacketizerCupertinoChunk.getChunkIndex(), 3);
            }
            LiveStreamPacketizerCupertinoUtils.encryptChunk(liveStreamPacketizerCupertinoChunk, (CupertinoEncInfo)object);
        }
        ((HTTPStreamerApplicationContextCupertinoStreamer)this.appContext).notifyVODListenerOnFillChunkEnd(this, iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
    }

    public void init(IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        super.init(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string, string2, string3);
        MediaStreamMap mediaStreamMap = this.appInstance.getStreams();
        this.stream = new MediaStreamDisconnected();
        this.stream.init(mediaStreamMap, 0, new WMSProperties());
        this.stream.setName(string3, null, string2, null, 0.0, -1.0, 1);
        this.rawStreamName = string;
        WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
        WMSProperties wMSProperties2 = this.appInstance.getProperties();
        this.cupertinoEncryptionBaseURL = wMSProperties.getPropertyStr("cupertinoEncryptionBaseURL", this.cupertinoEncryptionBaseURL);
        this.cupertinoEncryptionBaseURL = wMSProperties2.getPropertyStr("cupertinoEncryptionBaseURL", this.cupertinoEncryptionBaseURL);
        this.cupertinoEncryptionLiveRepeaterSharedSecret = wMSProperties.getPropertyStr("cupertinoEncryptionLiveRepeaterSharedSecret", this.cupertinoEncryptionLiveRepeaterSharedSecret);
        this.cupertinoEncryptionLiveRepeaterSharedSecret = wMSProperties2.getPropertyStr("cupertinoEncryptionLiveRepeaterSharedSecret", this.cupertinoEncryptionLiveRepeaterSharedSecret);
        this.cupertinoEncryptionAPIBased = wMSProperties.getPropertyBoolean("cupertinoEncryptionAPIBased", this.cupertinoEncryptionAPIBased);
        this.cupertinoEncryptionAPIBased = wMSProperties2.getPropertyBoolean("cupertinoEncryptionAPIBased", this.cupertinoEncryptionAPIBased);
    }

    public void indexFile(IHTTPStreamerSession iHTTPStreamerSession) {
        Object object;
        if (this.mediaReader != null) {
            this.mediaReader.indexFile(this);
        }
        String string = this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + this.streamName;
        if (this.cupertinoEncryptionAPIBased) {
            object = new CupertinoEncInfo();
            this.appInstance.getModFunctions().onHTTPCupertinoEncryptionKeyVODChunk((HTTPStreamerSessionCupertino)iHTTPStreamerSession, (IHTTPStreamerCupertinoIndex)this, (CupertinoEncInfo)object, -1L, 1);
            if (((CupertinoEncInfo)object).isValid()) {
                this.encInfo = object;
            }
        } else if (this.cupertinoEncryptionBaseURL != null) {
            object = this.appInstance.getVHost().getHTTPStreamerContext();
            byte[] byArray = object.getEncKey(this.appInstance, this.streamName);
            if (byArray != null) {
                String string2;
                if (iHTTPStreamerSession != null) {
                    this.appInstance.getModFunctions().onHTTPCupertinoEncryptionKeyCreateVOD((HTTPStreamerSessionCupertino)iHTTPStreamerSession, byArray);
                }
                if (!(string2 = this.cupertinoEncryptionBaseURL).endsWith("/")) {
                    string2 = string2 + "/";
                }
                string2 = string2 + this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + HTTPStreamerUtils.urlEncode((String)this.rawStreamName) + "/key.m3u8key";
                this.encInfo = new CupertinoEncInfo(BufferUtils.encodeHexString((byte[])byArray), byArray, string2);
                this.encInfo.setInternal(true);
            }
        } else {
            this.encInfo = LiveStreamPacketizerCupertinoUtils.getEncInfo(this.appInstance, this.streamName);
        }
        if (this.encInfo != null) {
            if (this.encInfo.getEncKey() != null) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("HTTPStreamerCupertinoIndexFile.init[" + string + "]: Encrypt Cupertino stream: key: *" + this.encInfo.getEncKey().substring(28));
            }
            if (this.encInfo.getEncUrl() != null) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("HTTPStreamerCupertinoIndexFile.init[" + string + "]: Encrypt Cupertino stream: url: " + this.encInfo.getEncUrl());
            }
        }
        object = this.items.iterator();
        long l = 0L;
        CupertinoEncInfo cupertinoEncInfo = this.encInfo;
        while (object.hasNext()) {
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = (IHTTPStreamerCupertinoIndexItem)object.next();
            if (this.cupertinoEncryptionAPIBased) {
                CupertinoEncInfo cupertinoEncInfo2 = null;
                cupertinoEncInfo2 = this.encInfo == null ? new CupertinoEncInfo() : this.encInfo.clone();
                this.appInstance.getModFunctions().onHTTPCupertinoEncryptionKeyVODChunk((HTTPStreamerSessionCupertino)iHTTPStreamerSession, (IHTTPStreamerCupertinoIndex)this, cupertinoEncInfo2, ++l, 2);
                if (cupertinoEncInfo2.isValid() && !cupertinoEncInfo2.equals(cupertinoEncInfo)) {
                    cupertinoEncInfo = cupertinoEncInfo2;
                }
            }
            iHTTPStreamerCupertinoIndexItem.setEncInfo(cupertinoEncInfo);
        }
    }

    public void close() {
        super.close();
        try {
            if (this.mediaReader != null) {
                this.mediaReader.close();
            }
            this.mediaReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexFile.class).error("HTTPStreamerCupertinoIndexFile.close: " + exception.toString());
        }
    }

    public void open() {
        super.open();
        if (this.mediaReader != null) {
            this.close();
        }
        this.mediaReader = null;
        try {
            String string = this.streamExt + "cupertino";
            IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)this.stream.getStreams().getAppInstance(), (MediaReaderList)this.stream.getStreams().getVHost().getMediaReaders(), (String)string);
            if (iMediaReader != null) {
                IApplicationInstance iApplicationInstance = this.stream.getStreams().getAppInstance();
                String string2 = iApplicationInstance.getStreamStoragePath();
                iMediaReader.init(iApplicationInstance, this.stream, string, string2, this.streamName);
                iMediaReader.open(string2, this.streamName);
                if (iMediaReader instanceof IMediaReaderCupertino) {
                    this.mediaReader = (IMediaReaderCupertino)iMediaReader;
                } else {
                    iMediaReader.close();
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexFile.class).error("HTTPStreamerCupertinoIndexFile.open: MediaReader is not an Cupertino MediaReader: " + this.streamExt + ":" + this.streamName);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexFile.class).error("HTTPStreamerCupertinoIndexFile.open: " + exception.toString());
        }
    }

    public int getID3Bitrate(boolean bl) {
        ID3Frames iD3Frames;
        int n = 0;
        ID3Frames iD3Frames2 = bl ? this.id3FramesHeaderAudio : this.id3FramesHeader;
        ID3Frames iD3Frames3 = iD3Frames = bl ? this.id3FramesFooterAudio : this.id3FramesFooter;
        if (this.chunkDurationTarget > 0) {
            n = (int)((long)n + (long)iD3Frames2.getSize() * 8L * 1000L / (long)this.chunkDurationTarget);
            n = (int)((long)n + (long)iD3Frames2.getSize() * 8L * 1000L / (long)this.chunkDurationTarget);
        }
        return n;
    }

    public IMediaReaderCupertino getMediaReader() {
        return this.mediaReader;
    }

    public ID3Frames getID3FramesHeader() {
        return this.id3FramesHeader;
    }

    public ID3Frames getID3FramesFooter() {
        return this.id3FramesFooter;
    }

    public ID3Frames getID3FramesHeaderAudio() {
        return this.id3FramesHeaderAudio;
    }

    public ID3Frames getID3FramesFooterAudio() {
        return this.id3FramesFooterAudio;
    }
}

