/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrPlayerAdapter;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.cupertinostreaming.dvr.DvrPlayerAdapterCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.CupertinoStreamingURL;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerApplicationContextCupertinoStreamer;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

public class HTTPStreamerAdapterCupertinoStreamer
extends HTTPStreamerAdapterBase {
    private static final Class<HTTPStreamerAdapterCupertinoStreamer> CLASS = HTTPStreamerAdapterCupertinoStreamer.class;
    private static final String CLASSNAME = "HTTPStreamerAdapterCupertinoStreamer";
    protected boolean debugLog = false;
    private static final boolean debugDvr = false;
    protected int requestTimeout = 8000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    protected String playlistMimeType = "application/vnd.apple.mpegurl";
    protected String videoMimeType = "video/MP2T";
    protected String audioAACMimeType = "audio/x-aac";
    protected String audioMP3MimeType = "audio/mpeg";
    protected String keyMimeType = "binary/octet-stream";
    protected String audioOnlyQueryParameter = "wowzaaudioonly";
    private IDvrPlayerAdapter dvrPlayerAdapter = new DvrPlayerAdapterCupertino();

    public HTTPStreamerAdapterCupertinoStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    public void init() {
        super.init();
        this.playlistMimeType = this.getProperties().getPropertyStr("playlistMimeType", this.playlistMimeType);
        this.videoMimeType = this.getProperties().getPropertyStr("videoMimeType", this.videoMimeType);
        this.audioAACMimeType = this.getProperties().getPropertyStr("videoAACMimeType", this.audioAACMimeType);
        this.audioMP3MimeType = this.getProperties().getPropertyStr("videoMP3MimeType", this.audioMP3MimeType);
        this.keyMimeType = this.getProperties().getPropertyStr("keyMimeType", this.keyMimeType);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        this.audioOnlyQueryParameter = this.getProperties().getPropertyStr("audioOnlyQueryParameter", this.audioOnlyQueryParameter);
        if (WMSLoggerFactory.getLogger(null).isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    public static int getChunkDurationTarget(IApplicationInstance iApplicationInstance) {
        WMSProperties wMSProperties = iApplicationInstance.getHTTPStreamerProperties();
        int n = 10000;
        n = wMSProperties.getPropertyInt("chunkDurationTarget", n);
        n = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", n);
        return n;
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        boolean bl = super.canHandle(string);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(CLASS).debug("HTTPStreamerAdapterCupertinoStreaming.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterCupertinoStreaming.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            int n;
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            if (this.debugLog) {
                WMSLoggerFactory.getLogger(null).debug("HTTPStreamerAdapterCupertinoStreaming.service: " + string);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("range");
            String string3 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string3 != null && string3.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            boolean bl2 = false;
            if (string2 != null && (string2 = string2.trim()).length() > 0 && (n = string2.indexOf("=")) >= 0 && (string2 = string2.substring(n + 1)).equals("0-1")) {
                bl2 = true;
            }
            if ((n = string.indexOf("?")) >= 0) {
                string = string.substring(0, n);
            }
            if (bl2) {
                this.onCheckAvailibility(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".m3u") || string.endsWith(".m3u8")) {
                this.onPlaylist(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".m3u8key")) {
                this.onEncKey(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".ts") || string.endsWith(".aac") || string.endsWith(".mp3")) {
                this.onMediaFile(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("HTTPStreamerAdapterCupertinoStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void onCheckAvailibility(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block16: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block16;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(CLASS).info("onCheckAvailibility: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block16;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onCheckAvailibility: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block16;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block16;
                String string5 = "";
                if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    boolean bl5 = HTTPStreamerSessionCupertino.doesFileExist(iHTTPStreamerApplicationContext, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (!bl5) break block16;
                    string5 = "#E";
                } else if (bl3) {
                    ILiveStreamPacketizer iLiveStreamPacketizer;
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    if (bl4) {
                        this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                    }
                    if ((iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                        if (bl4) {
                            bl = true;
                        } else {
                            WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        }
                        break block16;
                    }
                    string5 = "#E";
                } else {
                    boolean bl6 = HTTPStreamerSessionCupertino.doesFileExist(iHTTPStreamerApplicationContext, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (!bl6) break block16;
                    string5 = "#E";
                }
                iHTTPResponse.setHeader("Content-Type", "application/x-mpegURL");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                OutputStream outputStream = iHTTPResponse.getOutputStream();
                outputStream.write(string5.getBytes());
                bl2 = true;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino = new HTTPStreamerSessionCupertino();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionCupertino.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = iHTTPRequest.getServerPort();
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionCupertino.setServerIp(string4);
        hTTPStreamerSessionCupertino.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = (string5 = HTTPStreamerUtils.urlDecode((String)string5)).indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionCupertino.setUri(string5);
        hTTPStreamerSessionCupertino.setQueryStr(string6);
        hTTPStreamerSessionCupertino.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionCupertino.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionCupertino.setIpAddress(iHTTPRequest.getRemoteAddr());
        hTTPStreamerSessionCupertino.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionCupertino, iApplicationInstance, string);
        return hTTPStreamerSessionCupertino;
    }

    public void onPlaylist(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block87: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                Object object3;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block87;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(CLASS).info("onPlaylist: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block87;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                boolean bl3 = map.containsKey(this.audioOnlyQueryParameter);
                String string6 = this.determineDvrId(map);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block87;
                }
                HTTPStreamerApplicationContextCupertinoStreamer hTTPStreamerApplicationContextCupertinoStreamer = (HTTPStreamerApplicationContextCupertinoStreamer)iHTTPStreamerApplicationContext;
                String string7 = hTTPStreamerApplicationContextCupertinoStreamer.getPlaylistHostDomain();
                String string8 = iHTTPRequest.getHeader("host");
                string8 = string7 != null ? hTTPStreamerApplicationContextCupertinoStreamer.getPlaylistHostProtocol() + string7 : (string8 != null ? hTTPStreamerApplicationContextCupertinoStreamer.getPlaylistHostProtocol() + string8 : "");
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string9 = this.getStreamDomainStr(iApplicationInstance, string4);
                String string10 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string10 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string10);
                }
                boolean bl4 = false;
                boolean bl5 = false;
                if (iHTTPStreamerSession == null) {
                    bl4 = true;
                    bl5 = true;
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string10, string9);
                    if (string10 != null && string10.equals(iHTTPStreamerSession.getSessionId())) {
                        bl4 = false;
                    }
                }
                boolean bl6 = this.isDvr(iApplicationInstance, string6);
                boolean bl7 = this.isLive(iApplicationInstance);
                boolean bl8 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl8, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block87;
                if (iHTTPStreamerSession == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Should not get here [" + string + "]: " + string2 + "/" + string3);
                    break block87;
                }
                if (bl5) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                String string11 = HTTPUtils.assembleQueryStr((Map)map);
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (bl7 && bl8 && !hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    ILiveStreamPacketizer iLiveStreamPacketizer;
                    object3 = iApplicationInstance.getStreams();
                    if (bl8) {
                        this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                    }
                    if ((iLiveStreamPacketizer = object3.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                        if (bl8) {
                            bl = true;
                        } else {
                            WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        }
                        break block87;
                    }
                }
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        iHTTPStreamerSession.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                        iHTTPStreamerSession.setSessionType(bl7 ? 1 : 2);
                    }
                    iHTTPStreamerSession.touch(l);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist[" + string + "]: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block87;
                }
                if (bl5) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist[" + string + "]: Session not accepted.");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block87;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string9)) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist[" + string + "]: Not valid stream name [" + string9 + "]: " + iHTTPStreamerSession.validStreamDomainToString());
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block87;
                }
                object3 = "";
                boolean bl9 = false;
                boolean bl10 = false;
                if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    object2 = iHTTPStreamerSession.getUserQueryStr();
                    if (object2 != null) {
                        if (string11.length() > 0) {
                            string11 = string11 + "&";
                        }
                        string11 = string11 + (String)object2;
                    }
                    if ((object = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName)) == null) break block87;
                    object3 = object.getPlaylistStr(bl3);
                    bl4 = false;
                    bl9 = true;
                    if (iHTTPStreamerSession != null) {
                        iHTTPStreamerSession.addStreamDomainStrs(object.getStreamNamesRaw());
                        if (bl8) {
                            iHTTPStreamerSession.lockRepeaterStreams(object.getStreamNames(), this.liveStreamPacketizer, this.liveStreamRepeater, iHTTPStreamerApplicationContext.getStreamTypeStr());
                        }
                    }
                } else if (bl4) {
                    int n;
                    object2 = iHTTPStreamerSession.getUserQueryStr();
                    if (object2 != null) {
                        if (string11.length() > 0) {
                            string11 = string11 + "&";
                        }
                        string11 = string11 + (String)object2;
                    }
                    if ((n = ((String)(object = string)).indexOf("?")) > 0) {
                        object = ((String)object).substring(0, n);
                    }
                    boolean bl11 = hTTPStreamerApplicationContextCupertinoStreamer.isAutoCreateMultibitratePlaylist();
                    boolean bl12 = hTTPStreamerApplicationContextCupertinoStreamer.isUseCalculatedVideoBitrate();
                    boolean bl13 = hTTPStreamerApplicationContextCupertinoStreamer.isUseCalculatedAudioBitrate();
                    boolean bl14 = hTTPStreamerApplicationContextCupertinoStreamer.isCalculatePlaylistBitrates();
                    boolean bl15 = hTTPStreamerApplicationContextCupertinoStreamer.isCalculateCodecs();
                    boolean bl16 = hTTPStreamerApplicationContextCupertinoStreamer.isCalculateResolution();
                    boolean bl17 = hTTPStreamerApplicationContextCupertinoStreamer.isRelativePlaylistPlaylists();
                    int n2 = hTTPStreamerApplicationContextCupertinoStreamer.getDefaultVideoBitrate();
                    int n3 = hTTPStreamerApplicationContextCupertinoStreamer.getDefaultAudioBitrate();
                    int n4 = hTTPStreamerApplicationContextCupertinoStreamer.getMaxCalulatedAudioBitrate();
                    int n5 = hTTPStreamerApplicationContextCupertinoStreamer.getMaxCalulatedVideoBitrate();
                    int n6 = hTTPStreamerApplicationContextCupertinoStreamer.getBitrateAdjustmentFactor();
                    String string12 = "";
                    String string13 = "";
                    String string14 = "";
                    LiveStreamPacketizerCupertino liveStreamPacketizerCupertino = null;
                    boolean bl18 = false;
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex = null;
                    if (bl11 || bl14) {
                        Object object4;
                        if (bl7) {
                            ILiveStreamPacketizer iLiveStreamPacketizer;
                            object4 = iApplicationInstance.getStreams();
                            if (bl8) {
                                this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                            }
                            if ((iLiveStreamPacketizer = object4.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                                if (bl8) {
                                    bl = true;
                                } else {
                                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                                }
                            } else {
                                String string15;
                                String string16;
                                liveStreamPacketizerCupertino = (LiveStreamPacketizerCupertino)iLiveStreamPacketizer;
                                bl18 = liveStreamPacketizerCupertino.isAudioOnlyRendition();
                                String string17 = liveStreamPacketizerCupertino.getCodecsStr();
                                if (string17 != null) {
                                    string13 = ",CODECS=\"" + string17 + "\"";
                                }
                                if ((string16 = liveStreamPacketizerCupertino.getCodecsAudioStr()) != null) {
                                    string14 = ",CODECS=\"" + string16 + "\"";
                                }
                                if ((string15 = liveStreamPacketizerCupertino.getResolutionStr()) != null) {
                                    string12 = ",RESOLUTION=" + string15;
                                }
                            }
                        } else {
                            iHTTPStreamerCupertinoIndex = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                            if (iHTTPStreamerCupertinoIndex != null) {
                                String string18;
                                String string19;
                                bl18 = iHTTPStreamerCupertinoIndex.getAudioBitrate() > 0 && iHTTPStreamerCupertinoIndex.getVideoBitrate() > 0;
                                object4 = iHTTPStreamerCupertinoIndex.getCodecsStr();
                                if (object4 != null) {
                                    string13 = ",CODECS=\"" + (String)object4 + "\"";
                                }
                                if ((string19 = iHTTPStreamerCupertinoIndex.getCodecsAudioStr()) != null) {
                                    string14 = ",CODECS=\"" + string19 + "\"";
                                }
                                if ((string18 = iHTTPStreamerCupertinoIndex.getResolutionStr()) != null) {
                                    string12 = ",RESOLUTION=" + string18;
                                }
                            }
                        }
                    }
                    if (bl) break block87;
                    if (bl12) {
                        long l2 = 0L;
                        if (liveStreamPacketizerCupertino != null) {
                            l2 = liveStreamPacketizerCupertino.getCalculatedBitrate();
                        } else if (iHTTPStreamerCupertinoIndex != null) {
                            l2 = iHTTPStreamerCupertinoIndex.getAudioBitrate() + iHTTPStreamerCupertinoIndex.getVideoBitrate() + iHTTPStreamerCupertinoIndex.getID3Bitrate(false);
                        }
                        if (l2 > 0L) {
                            l2 = l2 * (long)n6 / 100L;
                        }
                        if (l2 > 0L) {
                            n2 = (int)l2;
                            if (n5 > 0 && n2 > n5) {
                                n2 = n5;
                            }
                        }
                    }
                    if (bl13) {
                        long l3 = 0L;
                        if (liveStreamPacketizerCupertino != null) {
                            l3 = liveStreamPacketizerCupertino.getCalculatedAudioBitrate();
                        } else if (iHTTPStreamerCupertinoIndex != null) {
                            l3 = iHTTPStreamerCupertinoIndex.getAudioBitrate() + iHTTPStreamerCupertinoIndex.getID3Bitrate(true);
                        }
                        if (l3 > 0L) {
                            l3 = l3 * (long)n6 / 100L;
                        }
                        if (l3 > 0L) {
                            n3 = (int)l3;
                            if (n4 > 0 && n3 > n4) {
                                n3 = n4;
                            }
                        }
                    }
                    if (!bl15) {
                        string13 = "";
                        string14 = "";
                    }
                    if (!bl16) {
                        string12 = "";
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("#EXTM3U\n");
                    stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + n2 + string13 + string12 + "\n");
                    stringBuffer.append((bl17 ? "playlist.m3u8" : string8 + "/" + HTTPStreamerUtils.urlEncode((String)object)) + "?" + string11 + "\n");
                    if (bl11 && bl18) {
                        stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + n3 + string14 + "\n");
                        stringBuffer.append((bl17 ? "playlist.m3u8" : string8 + "/" + HTTPStreamerUtils.urlEncode((String)object)) + "?" + this.audioOnlyQueryParameter + "&" + string11 + "\n");
                    }
                    object3 = stringBuffer.toString();
                } else {
                    if (bl6) {
                        object2 = iApplicationInstance.getStreams();
                        if (!this.dvrPlayerAdapter.isPlaylistReady(string, iApplicationInstance, string6, string4, 0L)) {
                            bl = true;
                            break block87;
                        }
                        bl10 = this.dvrPlayerAdapter.isPlaylistEmpty(string, iApplicationInstance, string6, string4, 0L);
                        if (bl10) {
                            bl = true;
                            break block87;
                        }
                        object3 = new String(this.dvrPlayerAdapter.getAbsolutePlaylist(string, iApplicationInstance, string6, string4, 0L));
                        object3 = ((String)object3).replace("{query}", string11);
                    } else if (bl7) {
                        object2 = iApplicationInstance.getStreams();
                        if (bl8) {
                            this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                        }
                        if ((object = object2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                            if (bl8) {
                                bl = true;
                            } else {
                                WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                            }
                            break block87;
                        }
                        object3 = bl3 ? ((LiveStreamPacketizerCupertino)object).getPlaylistAudioStr() : ((LiveStreamPacketizerCupertino)object).getPlaylistStr();
                        bl10 = ((LiveStreamPacketizerCupertino)object).isEmptyPlaylist();
                        if (bl10) {
                            bl = true;
                            break block87;
                        }
                    } else {
                        object2 = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                        if (object2 == null) break block87;
                        object3 = object2.getPlaylistStr(bl3);
                    }
                    bl9 = true;
                }
                if (object3 == null) {
                    if (bl8) {
                        bl = true;
                    }
                } else if (((String)object3).length() <= 0) {
                    if (bl8) {
                        bl = true;
                    }
                } else {
                    if (bl9) {
                        object3 = ((String)object3).replace("{domain}", string8);
                        object3 = ((String)object3).replace("{application}", HTTPStreamerUtils.urlEncode((String)string2));
                        object3 = ((String)object3).replace("{appInstance}", HTTPStreamerUtils.urlEncode((String)string3));
                        object3 = ((String)object3).replace("{stream}", HTTPStreamerUtils.urlEncode((String)string4));
                        object3 = ((String)object3).replace("{query}", string11);
                        object3 = ((String)object3).replace("{audioOnly}", "&" + this.audioOnlyQueryParameter);
                    }
                    if (this.debugLog) {
                        System.out.println(this.playlistMimeType + ":\n" + (String)object3);
                    }
                    iHTTPResponse.setHeader("Content-Type", this.playlistMimeType);
                    iHTTPResponse.setHeader("Cache-Control", "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    object2 = ((String)object3).getBytes();
                    object = iHTTPResponse.getOutputStream();
                    ((OutputStream)object).write((byte[])object2);
                    bl2 = true;
                    if (object2 != null && iHTTPStreamerSession != null) {
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(((Object)object2).length + iHTTPResponse.getHeaderSize()), 1L);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    public void onEncKey(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block20: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block20;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(CLASS).info("onEncKey: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block20;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                boolean bl3 = map.containsKey(this.audioOnlyQueryParameter);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block20;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl4 = this.isLive(iApplicationInstance);
                boolean bl5 = this.isRepeater(iApplicationInstance);
                String string7 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string7 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string7);
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl5, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block20;
                boolean bl6 = true;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl6 = iHTTPStreamerSession.isActive();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey[" + string + "]: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block20;
                }
                if (!bl6 || iHTTPStreamerSession == null) break block20;
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                CupertinoEncInfo cupertinoEncInfo = null;
                if (bl4) {
                    object2 = iApplicationInstance.getStreams();
                    object = object2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    if (object == null) {
                        WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                        break block20;
                    }
                    cupertinoEncInfo = ((LiveStreamPacketizerCupertino)object).getEncryptionInfo();
                } else {
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex = object2 = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object2 == null) break block20;
                    cupertinoEncInfo = object2.getEncInfo();
                }
                if (cupertinoEncInfo != null && cupertinoEncInfo.isInternal()) {
                    iApplicationInstance.getModFunctions().onHTTPCupertinoEncryptionKeyRequest((HTTPStreamerSessionCupertino)iHTTPStreamerSession, iHTTPRequest, iHTTPResponse);
                    if (!iHTTPStreamerSession.isAcceptSession()) {
                        WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey[" + string + "]: Session not accepted.");
                        iHTTPResponse.setResponseCode(403);
                        bl2 = true;
                    } else {
                        object2 = cupertinoEncInfo.getEncKeyBytes();
                        if (object2 != null) {
                            iApplicationInstance.getModFunctions().onHTTPCupertinoEncryptionKeyData((HTTPStreamerSessionCupertino)iHTTPStreamerSession, iHTTPRequest, iHTTPResponse, (byte[])object2);
                            iHTTPResponse.setHeader("Content-Type", this.keyMimeType);
                            iHTTPResponse.setHeader("Cache-Control", "no-cache");
                            iHTTPResponse.setHeader("Date", this.getHTTPDate());
                            object = iHTTPResponse.getOutputStream();
                            ((OutputStream)object).write((byte[])object2);
                            if (object2 != null && iHTTPStreamerSession != null) {
                                iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(((MediaStreamMap)object2).length + iHTTPResponse.getHeaderSize()), 1L);
                            }
                            bl2 = true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error("HTTPStreamerAdapterCupertinoStreaming.onEncKey: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMediaFile(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block35: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            int n = 0;
            try {
                Object object;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block35;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(CLASS).info("onMediaFile: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block35;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                boolean bl3 = map.containsKey(this.audioOnlyQueryParameter);
                String string6 = this.determineDvrId(map);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block35;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string7 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl4 = this.isDvr(iApplicationInstance, string6);
                boolean bl5 = this.isLive(iApplicationInstance);
                boolean bl6 = this.isRepeater(iApplicationInstance);
                String string8 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string8 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string8);
                }
                boolean bl7 = false;
                if (iHTTPStreamerSession == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string8, string7);
                    bl7 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl6, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block35;
                if (bl7) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl8 = true;
                int n2 = 0;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl8 = iHTTPStreamerSession.isActive();
                    n2 = iHTTPStreamerSession.getSessionType();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile[" + string + "]: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block35;
                }
                if (bl7) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string7)) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile[" + string + "]: Not valid stream name [" + string7 + "]: " + iHTTPStreamerSession.validStreamDomainToString());
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block35;
                }
                if (!bl8) break block35;
                if (iHTTPStreamerSession != null && !iHTTPStreamerSession.isAcceptSession()) {
                    WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile[" + string + "]: Session not accepted.");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block35;
                }
                int n3 = string.lastIndexOf("/");
                if (n3 < 0) break block35;
                String string9 = string.substring(n3 + 1);
                int n4 = string9.indexOf("?");
                if (n4 >= 0) {
                    string9 = string9.substring(0, n4);
                }
                if (n2 == 0) {
                    n2 = bl5 ? 1 : 2;
                }
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = null;
                if (bl4) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    liveStreamPacketizerCupertinoChunk = this.getDvrCupertinoFragments(mediaStreamMap, string6, string4, string9);
                } else if (n2 == 2) {
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex;
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex2 = iHTTPStreamerCupertinoIndex = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (iHTTPStreamerCupertinoIndex == null) break block35;
                    liveStreamPacketizerCupertinoChunk = iHTTPStreamerCupertinoIndex.getChunk(string9, bl3);
                    ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).logVODChunk(liveStreamPacketizerCupertinoChunk);
                } else {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    if (bl6) {
                        this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                    }
                    if ((object = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                        WMSLoggerFactory.getLogger(CLASS).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        break block35;
                    }
                    liveStreamPacketizerCupertinoChunk = bl3 ? ((LiveStreamPacketizerCupertino)object).getChunkAudioByFilename(string9) : ((LiveStreamPacketizerCupertino)object).getChunkByFilename(string9);
                    ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).logLiveChunk(liveStreamPacketizerCupertinoChunk);
                }
                if (liveStreamPacketizerCupertinoChunk != null) {
                    void var37_44;
                    if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                    }
                    String string10 = this.videoMimeType;
                    switch (liveStreamPacketizerCupertinoChunk.getStreamMode()) {
                        case 3: {
                            String string11 = this.audioAACMimeType;
                            break;
                        }
                        case 2: {
                            String string12 = this.audioMP3MimeType;
                            break;
                        }
                    }
                    iHTTPResponse.setHeader("Content-Type", (String)var37_44);
                    iHTTPResponse.setHeader("Cache-Control", liveStreamPacketizerCupertinoChunk.isCacheable() ? "public" : "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    object = iHTTPResponse.getOutputStream();
                    IFasterByteArrayWriteReference iFasterByteArrayWriteReference = null;
                    if (object instanceof IFasterByteArrayWriteReference) {
                        iFasterByteArrayWriteReference = (IFasterByteArrayWriteReference)object;
                    }
                    List<LiveStreamingCupertinoBlock> list = liveStreamPacketizerCupertinoChunk.getBlockList();
                    for (LiveStreamingCupertinoBlock liveStreamingCupertinoBlock : list) {
                        if (iFasterByteArrayWriteReference != null) {
                            iFasterByteArrayWriteReference.write(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen(), true);
                        } else {
                            ((OutputStream)object).write(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
                        }
                        n += liveStreamingCupertinoBlock.getLen();
                    }
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(CLASS).info("onMediaFile: contentLength:" + n);
                    }
                    if (iHTTPStreamerSession != null) {
                        LiveStreamingCupertinoBlock liveStreamingCupertinoBlock;
                        liveStreamingCupertinoBlock = iHTTPStreamerSession.getStream();
                        if (liveStreamingCupertinoBlock != null) {
                            liveStreamingCupertinoBlock.getMediaIOPerformance().incrementMessagesOut((long)n, 1L);
                        }
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(n + iHTTPResponse.getHeaderSize()), 1L);
                    }
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (bl2) return;
        if (bl) {
            rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            return;
        }
        iHTTPResponse.setResponseCode(404);
    }

    protected LiveStreamPacketizerCupertinoChunk getDvrCupertinoFragments(MediaStreamMap mediaStreamMap, String string, String string2, String string3) {
        int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string3);
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string, false);
        DvrChunk dvrChunk = null;
        DvrManifestEntry dvrManifestEntry = null;
        DvrChunk dvrChunk2 = null;
        DvrManifestEntry dvrManifestEntry2 = null;
        if (iDvrStore != null) {
            dvrManifestEntry = iDvrStore.getDvrEntryByIndex(string2, 9, n);
            dvrChunk = iDvrStore.getDvrChunkByIndex(string2, 9, n);
            dvrManifestEntry2 = iDvrStore.getDvrEntryByIndex(string2, 8, n);
            dvrChunk2 = iDvrStore.getDvrChunkByIndex(string2, 8, n);
        }
        return (LiveStreamPacketizerCupertinoChunk)this.dvrPlayerAdapter.convertDvrChunks(dvrManifestEntry, dvrChunk, dvrManifestEntry2, dvrChunk2);
    }
}

