/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class CupertinoEncInfo {
    public static final String KEYPARAMPREFIX = "cupertinostreaming-aes128-";
    public static final int ENCKEYBITLENGTH = 128;
    public static final int ENCKEYBYTELENGTH = 16;
    public static final String HASH_ALGO = "MD5";
    public static final String ENCRYPT_ALGO = "RC4";
    private String encKey = null;
    private String encUrl = null;
    private byte[] encKeyBytes = null;
    private byte[] encRepeaterBytes = null;
    private boolean isInternal = false;
    private WMSProperties properties = null;

    public WMSProperties getProperties() {
        if (this.properties == null) {
            this.properties = new WMSProperties();
        }
        return this.properties;
    }

    public CupertinoEncInfo() {
        this.encKey = null;
        this.encUrl = null;
        this.encKeyBytes = null;
    }

    public CupertinoEncInfo(String string, byte[] byArray, String string2) {
        this.encKey = string;
        this.encUrl = string2;
        this.encKeyBytes = byArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CupertinoEncInfo) {
            CupertinoEncInfo cupertinoEncInfo = (CupertinoEncInfo)object;
            return this.encKey == cupertinoEncInfo.encKey && this.encUrl == cupertinoEncInfo.encUrl && this.isInternal == cupertinoEncInfo.isInternal && Arrays.equals(this.encKeyBytes, cupertinoEncInfo.encKeyBytes) && Arrays.equals(this.encRepeaterBytes, cupertinoEncInfo.encRepeaterBytes);
        }
        return false;
    }

    public CupertinoEncInfo clone() {
        CupertinoEncInfo cupertinoEncInfo = new CupertinoEncInfo();
        cupertinoEncInfo.encKey = this.encKey;
        cupertinoEncInfo.encUrl = this.encUrl;
        if (this.encKeyBytes != null) {
            cupertinoEncInfo.encKeyBytes = new byte[this.encKeyBytes.length];
            System.arraycopy(this.encKeyBytes, 0, cupertinoEncInfo.encKeyBytes, 0, cupertinoEncInfo.encKeyBytes.length);
        }
        if (this.encRepeaterBytes != null) {
            cupertinoEncInfo.encRepeaterBytes = new byte[this.encRepeaterBytes.length];
            System.arraycopy(this.encRepeaterBytes, 0, cupertinoEncInfo.encRepeaterBytes, 0, cupertinoEncInfo.encRepeaterBytes.length);
        }
        cupertinoEncInfo.isInternal = this.isInternal;
        if (this.properties != null) {
            cupertinoEncInfo.properties = new WMSProperties();
            cupertinoEncInfo.properties.putAll((Map)this.properties);
        }
        return cupertinoEncInfo;
    }

    public boolean isValid() {
        return this.encKeyBytes != null && this.encUrl != null;
    }

    public static byte[] encryptionKeyToRepeaterKey(byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            String string2 = string + ":" + "WowzaMediaServerCool!";
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGO);
            byte[] byArray3 = messageDigest.digest(string2.getBytes());
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ENCRYPT_ALGO);
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, ENCRYPT_ALGO);
            Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
            cipher.init(1, secretKeySpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoEncInfo.class).error("CupertinoEncInfo.encryptionKeyToRepeaterKey: " + exception.toString());
        }
        return byArray2;
    }

    public static byte[] repeaterKeyToEncryptionKey(byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            String string2 = string + ":" + "WowzaMediaServerCool!";
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGO);
            byte[] byArray3 = messageDigest.digest(string2.getBytes());
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ENCRYPT_ALGO);
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, ENCRYPT_ALGO);
            Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
            cipher.init(2, secretKeySpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoEncInfo.class).error("CupertinoEncInfo.repeaterKeyToEncryptionKey: " + exception.toString());
        }
        return byArray2;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public void setEncKey(String string) {
        this.encKey = string;
    }

    public String getEncUrl() {
        return this.encUrl;
    }

    public void setEncUrl(String string) {
        this.encUrl = string;
    }

    public byte[] getEncKeyBytes() {
        return this.encKeyBytes;
    }

    public void setEncKeyBytes(byte[] byArray) {
        this.encKeyBytes = byArray;
        this.encKey = byArray != null ? BufferUtils.encodeHexString((byte[])byArray) : null;
    }

    public byte[] getEncRepeaterBytes() {
        return this.encRepeaterBytes;
    }

    public void setEncRepeaterBytes(byte[] byArray) {
        this.encRepeaterBytes = byArray;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean bl) {
        this.isInternal = bl;
    }
}

