/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.IRandomAccessWriter2;
import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DirectRandomAccessWriter
implements IRandomAccessWriter2 {
    private static final Class<DirectRandomAccessWriter> CLASS = DirectRandomAccessWriter.class;
    private static final String CLASSNAME = "DirectRandomAccessWriter";
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = "";
    protected String fullPath = "";
    protected File file = null;
    protected RandomAccessFile randomFile = null;
    protected Object randomFileLock = new Object();
    protected int direction = 1;
    protected boolean sentSeekError = false;
    protected IOPerformanceCounter streamIOPerformanceCounter = null;
    protected IOPerformanceCounter clientIOPerformanceCounter = null;

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.basePath = string;
        this.mediaName = string2;
        this.mediaExtension = string3;
        this.file = iMediaStream.getStreamFileForRead(string2, string3, iMediaStream.getQueryStr());
        this.fullPath = this.file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilePointer() {
        try {
            Object object = this.randomFileLock;
            synchronized (object) {
                if (this.randomFile != null) {
                    return this.randomFile.getFilePointer();
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("DirectRandomAccessWriter.getFilePointer: " + exception.toString());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long l) {
        block9: {
            try {
                if (l < 0L) {
                    l = 0L;
                }
                Object object = this.randomFileLock;
                synchronized (object) {
                    if (this.randomFile != null) {
                        this.randomFile.seek(l);
                    }
                }
            }
            catch (Exception exception) {
                if (this.sentSeekError) break block9;
                String string = "unknown";
                Exception exception2 = exception;
                if (exception2 != null) {
                    StackTraceElement[] stackTraceElementArray = exception2.getStackTrace();
                    if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                        string = stackTraceElementArray[0].getClassName() + "." + stackTraceElementArray[0].getMethodName() + "(" + stackTraceElementArray[0].getFileName() + ":" + stackTraceElementArray[0].getLineNumber() + ")";
                    }
                    string = exception2.toString() + " (" + string + ")";
                }
                WMSLoggerFactory.getLogger(CLASS).error("DirectRandomAccessWriter.seek[" + this.mediaName + "," + string + "]: " + exception.toString());
                exception.printStackTrace();
                this.sentSeekError = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) {
        try {
            Object object = this.randomFileLock;
            synchronized (object) {
                if (this.randomFile != null) {
                    this.randomFile.write(byArray, n, n2);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("DirectRandomAccessWriter.read: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.randomFileLock;
        synchronized (object) {
            if (this.randomFile != null) {
                this.close();
            }
            this.randomFile = new WowzaRandomAccessFile(new File(this.fullPath), "rw");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.randomFileLock;
        synchronized (object) {
            if (this.randomFile != null) {
                this.randomFile.close();
            }
            this.randomFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.randomFileLock;
        synchronized (object) {
            return this.randomFile != null;
        }
    }

    public int getDirecton() {
        return this.direction;
    }

    public void setDirecton(int n) {
        this.direction = n;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long lastModified() {
        try {
            return this.file.lastModified();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("DirectRandomAccessWriter.lastModified: " + exception.toString());
            return 0L;
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("DirectRandomAccessWriter.length: " + exception.toString());
            return 0L;
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    public void setClientIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        this.clientIOPerformanceCounter = iOPerformanceCounter;
    }

    public void setStreamIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        this.streamIOPerformanceCounter = iOPerformanceCounter;
    }
}

