/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.ITextWriter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class DirectTextFileWriter
implements ITextWriter {
    private static final Class<DirectTextFileWriter> CLASS = DirectTextFileWriter.class;
    private static final String CLASSNAME = "DirectTextFileWriter";
    protected IApplicationInstance appInstance;
    protected IMediaStream stream;
    protected String basePath;
    protected String mediaName;
    protected File file;
    protected String fullPath;
    protected Object fileLock = new Object();
    protected FileWriter fileWriter = null;
    protected boolean append = false;

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.basePath = string;
        this.mediaName = string2;
        this.file = new File(string, string2);
        this.fullPath = this.file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.fileWriter != null) {
                this.close();
            }
            this.fileWriter = new FileWriter(this.file.getAbsolutePath(), this.append);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
            this.fileWriter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.fileLock;
        synchronized (object) {
            return this.fileWriter != null;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long lastModified() {
        try {
            return this.file.lastModified();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("lastModified: " + exception.toString());
            return 0L;
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("length: " + exception.toString());
            return 0L;
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    public void write(byte[] byArray, int n, int n2) {
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        try {
            Object object = this.fileLock;
            synchronized (object) {
                if (this.fileWriter != null) {
                    this.fileWriter.write(cArray, n, n2);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("DirectTextFileWriter.write: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) throws IOException {
        try {
            Object object = this.fileLock;
            synchronized (object) {
                if (this.fileWriter != null) {
                    this.fileWriter.write(string, n, n2);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("DirectTextFileWriter.write: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

