/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.HTTPByteReaderResult;
import com.wowza.util.SystemUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class HTTPByteReader {
    public static final int MAXHEADERSIZE = 4096;
    public static final int BUFFERINCSIZE = 1024;
    public static final int TIMEOUT = 6000;
    public static final int SENDBUFFERSIZE = 8000;
    public static final int RECEIVEBUFFERSIZE = 65000;
    public static final String CRLF = "\r\n";
    public static final int HEADINDEX_STATUS = 0;
    public static final int HEADINDEX_CONTENTLENGTH = 1;
    public static final int HEADINDEX_LASTMODIFIED = 2;
    public static final int HEADINDEX_SIZE = 3;
    protected String host = null;
    protected int port = 80;
    protected String reqPath = null;
    protected String proxyHost = null;
    protected int proxyPort = 80;
    protected FastDateFormat dateFormat = null;
    protected Socket socket = null;
    protected StringBuffer msgBuf = new StringBuffer();
    protected int maxRetries = 3;
    protected int maxUsesBeforeReconnect = 12;
    protected int uses = 0;
    protected int readTimeout = 6000;
    protected int connectionTimeout = 6000;
    protected List<String> debugInfo = null;
    protected String debugPrefix = null;
    protected boolean requestFullURL = false;
    protected String[] parseDateFormats = null;
    protected int sendBufferSize = 8000;
    protected int receiveBufferSize = 65000;
    protected String userAgent = null;

    public HTTPByteReader(String string, int n) {
        this.host = string;
        this.port = n;
        this.proxyHost = string;
        this.proxyPort = n;
        this.dateFormat = FastDateFormat.getInstance((String)"E, dd MMM yyyy HH:mm:ss zzz", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
        this.parseDateFormats = new String[1];
        this.parseDateFormats[0] = "E, dd MMM yyyy HH:mm:ss zzz";
    }

    public void setProxyAddress(String string, int n) {
        this.proxyHost = string;
        this.proxyPort = n;
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    public void connect() {
        if (this.socket != null) {
            this.close();
        }
        try {
            this.socket = new Socket();
            this.socket.setKeepAlive(true);
            this.socket.setSendBufferSize(this.sendBufferSize);
            this.socket.setReceiveBufferSize(this.receiveBufferSize);
            this.socket.setSoTimeout(this.readTimeout);
            this.socket.connect(new InetSocketAddress(this.proxyHost, this.proxyPort), this.connectionTimeout);
        }
        catch (Exception exception) {
            this.close();
        }
    }

    protected void reconnect() {
        this.connect();
    }

    public boolean isOpen() {
        return this.socket != null;
    }

    protected void parseHeader(SendResult sendResult, byte[] byArray, int n, int n2, boolean bl) {
        try {
            for (int i = 0; i < n2; ++i) {
                String[] stringArray;
                if (byArray[i + n] != 13 || i + 3 >= n2 || byArray[i + n] != 13 || byArray[i + n + 1] != 10 || byArray[i + n + 2] != 13 || byArray[i + n + 3] != 10) continue;
                sendResult.gotHeader = true;
                sendResult.headerLength = i + 4;
                String string = new String(byArray, n, (int)sendResult.headerLength);
                while (((stringArray = string.substring(0, 1)).equals("\n") || stringArray.equals("\r")) && (string = string.substring(1)).length() != 0) {
                }
                string = string.replace(CRLF, "\n").replace("\r", "\n");
                stringArray = string.split("\n");
                for (int j = 0; j < stringArray.length; ++j) {
                    Object object;
                    if (stringArray[j].length() == 0) continue;
                    if (this.debugInfo != null) {
                        object = this.debugPrefix + stringArray[j];
                        this.debugInfo.add((String)object);
                    }
                    if (j == 0) {
                        object = stringArray[j].split(" ");
                        if (((String[])object).length <= 1) continue;
                        try {
                            sendResult.status = Integer.parseInt(object[1]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    int n3 = stringArray[j].indexOf(":");
                    if (n3 < 0) continue;
                    String string2 = stringArray[j].substring(0, n3).trim();
                    String string3 = stringArray[j].substring(n3 + 1).trim();
                    if (string2.equalsIgnoreCase("Content-Length")) {
                        try {
                            sendResult.contentLength = Long.parseLong(string3);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (string2.equalsIgnoreCase("Last-Modified")) {
                        try {
                            sendResult.lastModified = DateUtils.parseDate((String)string3, (String[])this.parseDateFormats);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("Content-Range")) continue;
                    if ((string3 = string3.trim()).startsWith("bytes ")) {
                        string3 = string3.substring("bytes ".length());
                    }
                    String[] stringArray2 = string3.split("[/]");
                    String[] stringArray3 = stringArray2[0].split("[-]");
                    try {
                        sendResult.contentRangeStart = Long.parseLong(stringArray3[0]);
                        sendResult.contentRangeStop = Long.parseLong(stringArray3[1]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("HTTPByteReader.parseHeader[" + this.getConextPath() + "]: " + exception.toString());
        }
    }

    public HTTPByteReaderResult read(String string, long l, int n) {
        this.reqPath = string;
        return this.readDirect(string, l, n);
    }

    protected String getRequestPath(String string, String string2, int n) {
        if (this.requestFullURL) {
            string = "http://" + string2 + ":" + n + (string.startsWith("/") ? string : "/" + string);
        }
        return string;
    }

    protected String getConextPath() {
        String string = "";
        if (this.reqPath != null) {
            string = this.reqPath;
        }
        return "http://" + this.host + ":" + this.port + (string.startsWith("/") ? string : "/" + string);
    }

    protected void getHeadCommand(String string) {
        this.msgBuf.setLength(0);
        this.msgBuf.append("HEAD " + this.getRequestPath(string, this.host, this.port) + " HTTP/1.1" + CRLF);
        this.msgBuf.append("Host: " + this.host + ":" + this.port + CRLF);
        if (this.userAgent != null) {
            this.msgBuf.append("User-Agent: " + this.userAgent + CRLF);
        }
        this.msgBuf.append("Connection: keep-alive\r\n");
        this.msgBuf.append("Proxy-Connection: keep-alive\r\n");
        this.msgBuf.append(CRLF);
    }

    public long[] head(String string) {
        long[] lArray = null;
        this.reqPath = string;
        this.getHeadCommand(string);
        byte[] byArray = this.msgBuf.toString().getBytes();
        for (int i = 0; i < this.maxRetries; ++i) {
            SendResult sendResult;
            if (!this.isOpen()) {
                this.reconnect();
            }
            if (!this.isOpen() || (sendResult = this.sendRequest(byArray, true)) == null) continue;
            lArray = new long[]{sendResult.status, sendResult.contentLength, sendResult.lastModified != null ? sendResult.lastModified.getTime() : 0L};
            break;
        }
        ++this.uses;
        if (this.uses >= this.maxUsesBeforeReconnect) {
            this.uses = 0;
            this.close();
        }
        return lArray;
    }

    protected void getGetCommand(String string, long l, int n) {
        long l2 = l;
        long l3 = l + (long)n - 1L;
        this.msgBuf.setLength(0);
        this.msgBuf.append("GET " + this.getRequestPath(string, this.host, this.port) + " HTTP/1.1" + CRLF);
        this.msgBuf.append("Host: " + this.host + ":" + this.port + CRLF);
        if (this.userAgent != null) {
            this.msgBuf.append("User-Agent: " + this.userAgent + CRLF);
        }
        this.msgBuf.append("Range: bytes=" + l2 + "-" + l3 + CRLF);
        this.msgBuf.append("Connection: keep-alive\r\n");
        this.msgBuf.append("Proxy-Connection: keep-alive\r\n");
        this.msgBuf.append(CRLF);
    }

    public HTTPByteReaderResult readDirect(String string, long l, int n) {
        HTTPByteReaderResult hTTPByteReaderResult = null;
        this.reqPath = string;
        long l2 = l;
        long l3 = l + (long)n - 1L;
        this.getGetCommand(string, l, n);
        byte[] byArray = this.msgBuf.toString().getBytes();
        for (int i = 0; i < this.maxRetries; ++i) {
            this.debugPrefix = "readDirect[" + i + "]: ";
            if (!this.isOpen()) {
                this.reconnect();
            }
            if (!this.isOpen()) continue;
            SendResult sendResult = this.sendRequest(byArray, n, false);
            if (sendResult != null && sendResult.buffer != null && sendResult.status >= 200 && sendResult.status < 300 && sendResult.contentLength == (long)n) {
                if (sendResult.contentRangeStart != l2) {
                    WMSLoggerFactory.getLogger(null).debug("badRangeStart: " + sendResult.contentRangeStart + "/" + l2);
                } else if (sendResult.contentRangeStop != l3) {
                    WMSLoggerFactory.getLogger(null).debug("badRangeStop: " + sendResult.contentRangeStop + "/" + l3);
                } else {
                    hTTPByteReaderResult = new HTTPByteReaderResult();
                    hTTPByteReaderResult.buffer = sendResult.buffer;
                    hTTPByteReaderResult.contentLength = sendResult.contentLength;
                    hTTPByteReaderResult.headerLength = sendResult.headerLength;
                }
            }
            if (hTTPByteReaderResult != null) break;
        }
        if (hTTPByteReaderResult == null) {
            this.dumpDebug();
        }
        this.debugInfo = null;
        ++this.uses;
        if (this.uses >= this.maxUsesBeforeReconnect) {
            this.uses = 0;
            this.close();
        }
        return hTTPByteReaderResult;
    }

    protected void dumpDebug() {
        if (this.debugInfo == null) {
            return;
        }
        for (String string : this.debugInfo) {
            System.out.println(string);
        }
    }

    public SendResult sendRequest(byte[] byArray, boolean bl) {
        return this.sendRequest(byArray, 0, bl);
    }

    public SendResult sendRequest(byte[] byArray, int n, boolean bl) {
        if (this.socket == null) {
            return null;
        }
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            outputStream = this.socket.getOutputStream();
            inputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        if (outputStream == null || inputStream == null) {
            return null;
        }
        SendResult sendResult = new SendResult();
        sendResult.buffer = new byte[n + 4096];
        try {
            outputStream.write(byArray);
            int n2 = 0;
            do {
                int n3;
                int n4;
                if ((n4 = sendResult.buffer.length - n2) <= 0) {
                    byte[] byArray2 = new byte[sendResult.buffer.length + 1024];
                    System.arraycopy(sendResult.buffer, 0, byArray2, 0, sendResult.buffer.length);
                    sendResult.buffer = byArray2;
                    n4 = sendResult.buffer.length - n2;
                }
                if ((n3 = inputStream.read(sendResult.buffer, n2, n4)) == -1) {
                    sendResult = null;
                    break;
                }
                n2 += n3;
                if (sendResult.gotHeader) continue;
                this.parseHeader(sendResult, sendResult.buffer, 0, n2, bl);
            } while (!sendResult.gotHeader || (long)n2 < sendResult.size() && !bl);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("HTTPByteReader.sendRequest[" + this.getConextPath() + "]: " + exception.toString());
            sendResult = null;
        }
        if (sendResult == null) {
            this.close();
        } else if (!sendResult.keepAlive) {
            this.close();
        }
        return sendResult;
    }

    public int getMaxUsesBeforeReconnect() {
        return this.maxUsesBeforeReconnect;
    }

    public void setMaxUsesBeforeReconnect(int n) {
        this.maxUsesBeforeReconnect = n;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public boolean isRequestFullURL() {
        return this.requestFullURL;
    }

    public void setRequestFullURL(boolean bl) {
        this.requestFullURL = bl;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    class SendResult {
        public long contentLength = 0L;
        public long headerLength = 0L;
        public long contentRead = 0L;
        public Date lastModified = null;
        public int status = 500;
        public boolean gotHeader = false;
        public boolean gotMessage = false;
        public byte[] buffer = null;
        public boolean keepAlive = true;
        public long contentRangeStart = 0L;
        public long contentRangeStop = 0L;

        SendResult() {
        }

        public long size() {
            return this.contentLength + this.headerLength;
        }
    }
}

