/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;

public final class FileCache {
    private static FileCache instance = null;
    private File basePath = null;

    public static FileCache getInstance() {
        if (instance == null) {
            instance = new FileCache();
        }
        return instance;
    }

    public void setBasePath(File file) {
        this.basePath = file;
        if (!this.basePath.exists()) {
            this.basePath.mkdir();
        }
    }

    public String getCacheName(URL uRL) {
        String string = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = uRL.toString().getBytes("UTF-8");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            for (int i = 0; i < byArray2.length; ++i) {
                int n = byArray2[i] & 0xFF;
                if (n < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DebugUtils.class).error("getCacheName: " + exception.toString());
        }
        return string;
    }

    public String urlToPath(URL uRL) {
        String string = this.getCacheName(uRL);
        return this.basePath.toString() + File.separatorChar + string;
    }

    private String urlToTmpPath(URL uRL) {
        String string = this.getCacheName(uRL);
        return this.basePath.toString() + File.separatorChar + "_" + string;
    }

    public File getFile(URL uRL) {
        File file = new File(this.urlToPath(uRL));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public void cacheURL(URL uRL) {
        try {
            File file = new File(this.urlToPath(uRL));
            if (!file.exists()) {
                int n;
                URLConnection uRLConnection = uRL.openConnection();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                File file2 = new File(this.urlToTmpPath(uRL));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                int n2 = 10240;
                byte[] byArray = new byte[n2];
                do {
                    if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
                    bufferedOutputStream.write(byArray, 0, n);
                } while (n != -1);
                bufferedInputStream.close();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                WMSLoggerFactory.getLogger(FileCache.class).error("cacheURL: " + this.getCacheName(uRL) + "=" + uRL.toString());
                file2.renameTo(file);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FileCache.class).error("cacheURL: " + exception.toString());
        }
    }
}

