/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.client;

import com.wowza.util.NoMBean;
import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.client.ConnectionCounterBase;
import com.wowza.wms.client.ConnectionHolder;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public class ConnectionCounterSimple
extends ConnectionCounterBase {
    private long total = 0L;
    private long totalAccepted = 0L;
    private long totalRejected = 0L;
    private long[] totalRejectedByReason = new long[2];
    private long current = 0L;
    private Date lastConnectAcceptedTime = null;
    private long lastConnectAcceptedStamp = 0L;
    private Date lastConnectRejectedTime = null;
    private long lastConnectRejectedStamp = 0L;
    private Date lastDisconnectTime = null;
    private long lastDisconnectStamp = 0L;
    private Date[] lastConnectRejectedByReasonTime = new Date[2];
    private long[] lastConnectRejectedByReasonStamp = new long[2];

    public ConnectionCounterSimple() {
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.totalRejectedByReason.length; ++i) {
            this.totalRejectedByReason[i] = 0L;
            this.lastConnectRejectedByReasonTime[i] = null;
            this.lastConnectRejectedByReasonStamp[i] = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void incrementAccept(ConnectionHolder connectionHolder, Date date, long l) {
        ConnectionCounterSimple connectionCounterSimple = this;
        synchronized (connectionCounterSimple) {
            this.lastConnectAcceptedTime = date;
            this.lastConnectAcceptedStamp = l;
            ++this.total;
            ++this.totalAccepted;
            ++this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void incrementReject(ConnectionHolder connectionHolder, int n, Date date, long l) {
        ConnectionCounterSimple connectionCounterSimple = this;
        synchronized (connectionCounterSimple) {
            this.lastConnectRejectedTime = date;
            this.lastConnectRejectedStamp = l;
            this.lastConnectRejectedByReasonTime[n] = date;
            this.lastConnectRejectedByReasonStamp[n] = l;
            int n2 = n;
            this.totalRejectedByReason[n2] = this.totalRejectedByReason[n2] + 1L;
            ++this.total;
            ++this.totalRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void decrement(ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
        ConnectionCounterSimple connectionCounterSimple = this;
        synchronized (connectionCounterSimple) {
            this.lastDisconnectTime = date;
            this.lastDisconnectStamp = l;
            if (bl) {
                --this.current;
            }
        }
    }

    public synchronized long getCurrent() {
        return this.current;
    }

    public synchronized long getLastConnectAcceptedStamp() {
        return this.lastConnectAcceptedStamp;
    }

    public synchronized String getLastConnectAcceptedStampString() {
        return this.formatStamp(this.lastConnectAcceptedStamp);
    }

    public synchronized Date getLastConnectAcceptedTime() {
        return this.lastConnectAcceptedTime;
    }

    public synchronized String getLastConnectAcceptedTimeString() {
        return this.formatDate(this.lastConnectAcceptedTime);
    }

    public synchronized long getLastConnectRejectedStamp() {
        return this.lastConnectRejectedStamp;
    }

    public synchronized String getLastConnectRejectedStampString() {
        return this.formatStamp(this.lastConnectRejectedStamp);
    }

    public synchronized Date getLastConnectRejectedTime() {
        return this.lastConnectRejectedTime;
    }

    public synchronized String getLastConnectRejectedTimeString() {
        return this.formatDate(this.lastConnectRejectedTime);
    }

    public synchronized String getLastConnectRejectedByReasonStampString(int n) {
        return this.formatStamp(this.lastConnectRejectedByReasonStamp[n]);
    }

    public synchronized long getLastConnectRejectedByReasonStamp(int n) {
        return this.lastConnectRejectedByReasonStamp[n];
    }

    public synchronized Date getLastConnectRejectedByReasonTime(int n) {
        return this.lastConnectRejectedByReasonTime[n];
    }

    public synchronized String getLastConnectRejectedByReasonTimeString(int n) {
        return this.formatDate(this.lastConnectRejectedByReasonTime[n]);
    }

    public synchronized String getLastDisconnectStampString() {
        return this.formatStamp(this.lastDisconnectStamp);
    }

    public synchronized long getLastDisconnectStamp() {
        return this.lastDisconnectStamp;
    }

    public synchronized Date getLastDisconnectTime() {
        return this.lastDisconnectTime;
    }

    public synchronized String getLastDisconnectTimeString() {
        return this.formatDate(this.lastDisconnectTime);
    }

    public synchronized long getTotal() {
        return this.total;
    }

    public synchronized long getTotalAccepted() {
        return this.totalAccepted;
    }

    public synchronized long getTotalRejected() {
        return this.totalRejected;
    }

    private String formatDate(Date date) {
        return date == null ? "never" : FastDateFormat.getInstance((String)"EEE, MMM d yyyy HH:mm:ss Z", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale).format(date);
    }

    private String formatStamp(long l) {
        return l == 0L ? "never" : StringUtils.stampToString(System.currentTimeMillis() - l);
    }
}

