/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.drm.playready;

import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PlayReadyEncryptor {
    public static boolean initProvider = true;
    public static final int CTR_IVSIZESMALL = 8;
    public static final int CTR_IVSIZELARGE = 16;
    private SecretKeySpec key = null;
    private Cipher cipher = null;
    private PlayReadyKeyInfo keyInfo = null;
    private long iv = 0L;
    private int blockCounter = 0;
    private byte[] ivBytes = null;
    private int algorithmId = 1;
    private int blockSize = 16;
    private byte[] iv16 = new byte[16];
    private byte[] counterOut = new byte[16];

    private void initProvider() {
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(PlayReadyEncryptor.class).info("PlayReadyEncryptor.init: addBouncyCastleSecurityProvider: " + exception.toString());
            }
            initProvider = false;
        }
    }

    public void init(PlayReadyKeyInfo playReadyKeyInfo) {
        this.keyInfo = playReadyKeyInfo;
        this.algorithmId = playReadyKeyInfo.getAlgorithmId();
        this.initProvider();
        Random random = new Random(System.currentTimeMillis());
        byte[] byArray = new byte[8];
        random.nextBytes(byArray);
        this.iv = BufferUtils.byteArrayToLong(byArray);
        byte[] byArray2 = playReadyKeyInfo.getContentKey();
        this.key = new SecretKeySpec(byArray2, "AES");
        try {
            switch (this.algorithmId) {
                case 1: {
                    this.cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
                    this.cipher.init(1, this.key);
                    break;
                }
                case 2: {
                    this.cipher = Cipher.getInstance("AES/CBC/NoPadding", "BC");
                    break;
                }
                default: {
                    WMSLoggerFactory.getLogger(PlayReadyEncryptor.class).error("PlayReadyEncryptor.initKey: AlgorithmId is not supported: " + this.algorithmId);
                    break;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PlayReadyEncryptor.class).error("PlayReadyEncryptor.initKey: " + exception.toString());
        }
    }

    private byte[] initIV(long l) {
        byte[] byArray = null;
        switch (this.algorithmId) {
            case 1: {
                byArray = new byte[8];
                BufferUtils.longToByteArray(l, byArray, 0, 8);
                break;
            }
            case 2: {
                byArray = new byte[16];
                BufferUtils.longToByteArray(l, byArray, 0, 8);
                BufferUtils.longToByteArray(l, byArray, 8, 8);
            }
        }
        return byArray;
    }

    public byte[] startEncrypt() {
        this.ivBytes = this.initIV(this.iv);
        System.arraycopy(this.ivBytes, 0, this.iv16, 0, 8);
        ++this.iv;
        this.blockCounter = 0;
        return this.ivBytes;
    }

    public void stopEncrypt() {
    }

    private byte[] encryptChunkCBC(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        try {
            this.cipher.init(1, (Key)this.key, new IvParameterSpec(this.ivBytes));
            int n3 = n2 - n2 % 16;
            this.cipher.doFinal(byArray, n, n3, byArray2, 0);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PlayReadyEncryptor.class).error("PlayReadyEncryptor.encryptChunkCBC: " + exception.toString());
        }
        return byArray2;
    }

    public void startSegment() {
    }

    private byte[] encryptChunkCTR(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        try {
            int n3;
            this.iv16[13] = (byte)(this.blockCounter >> 16 & 0xFF);
            this.iv16[14] = (byte)(this.blockCounter >> 8 & 0xFF);
            this.iv16[15] = (byte)(this.blockCounter & 0xFF);
            int n4 = 0;
            int n5 = n;
            do {
                if (n4 + (n3 = this.blockSize) > n2) {
                    n3 = n2 - n4;
                }
                this.cipher.update(this.iv16, 0, 16, this.counterOut, 0);
                for (int i = 0; i < n3; ++i) {
                    byArray2[n4 + i] = (byte)(this.counterOut[i] ^ byArray[n5 + i]);
                }
                ++this.blockCounter;
                this.iv16[13] = (byte)(this.blockCounter >> 16 & 0xFF);
                this.iv16[14] = (byte)(this.blockCounter >> 8 & 0xFF);
                this.iv16[15] = (byte)(this.blockCounter & 0xFF);
                n5 += n3;
            } while ((n4 += n3) < n2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PlayReadyEncryptor.class).error("PlayReadyEncryptor.encryptChunkCTR: " + exception.toString());
            exception.printStackTrace();
        }
        return byArray2;
    }

    private byte[] encryptChunkCTR2(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        try {
            byte[] byArray3 = new byte[16];
            System.arraycopy(this.ivBytes, 0, byArray3, 0, 8);
            BufferUtils.longToByteArray(this.blockCounter, byArray3, 8, 8, false);
            this.cipher.init(1, (Key)this.key, new IvParameterSpec(byArray3));
            this.cipher.doFinal(byArray, n, n2, byArray2, 0);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PlayReadyEncryptor.class).error("PlayReadyEncryptor.encryptChunkCTR: " + exception.toString());
        }
        return byArray2;
    }

    public byte[] encryptChunk(byte[] byArray, int n, int n2) {
        switch (this.algorithmId) {
            case 1: {
                return this.encryptChunkCTR(byArray, n, n2);
            }
            case 2: {
                return this.encryptChunkCBC(byArray, n, n2);
            }
        }
        return null;
    }

    public PlayReadyKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(int n) {
        this.algorithmId = n;
    }

    public boolean isBlockAligned() {
        return true;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
    }
}

