/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.dvr.DvrStreamStoreBase;
import com.wowza.wms.dvr.IDvrChunker;
import com.wowza.wms.logging.WMSLoggerFactory;

public class DvrArtifactChunker
implements IDvrChunker {
    protected DvrStreamStoreBase streamStore = null;
    private int chunkGroupingSeconds = 600;

    public DvrArtifactChunker(DvrStreamStoreBase dvrStreamStoreBase, int n) {
        this.streamStore = dvrStreamStoreBase;
        this.chunkGroupingSeconds = n;
        if (n <= 5) {
            String string = String.format("DVR directory chunking of %d seconds is too small.  Reset to the default of %d seconds.", n, 600);
            WMSLoggerFactory.getLogger(DvrArtifactChunker.class).warn(string);
            n = 600;
        }
    }

    public String determineChunkGroupIdentifier(long l) {
        long l2 = this.calculateChunkGroupTime(l);
        long l3 = l2 / 3600L;
        long l4 = l2 % 3600L;
        long l5 = l4 / 60L;
        long l6 = l4 % 60L;
        String string = String.format("%04d_%02d_%02d", l3, l5, l6);
        return string;
    }

    public long calculateChunkGroupTime(long l) {
        long l2 = l / 1000L / (long)this.chunkGroupingSeconds * (long)this.chunkGroupingSeconds;
        return l2;
    }

    public int getChunkGroupDuration() {
        return this.chunkGroupingSeconds;
    }

    public void setChunkGroupDuration(int n) {
        this.chunkGroupingSeconds = n;
    }
}

