/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.dvr.DvrChunkArtifact;
import com.wowza.wms.dvr.DvrManifestEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrChannelManifest {
    private static final String CLASSNAME = "DvrChannelManifest";
    private long dvrTime = 0L;
    private int type;
    private long runningSize = 0L;
    private final TreeMap<Long, DvrManifestEntry> timeMap = new TreeMap();
    private final TreeMap<Integer, DvrManifestEntry> indexMap = new TreeMap();

    public DvrChannelManifest(int n) {
        this.type = n;
    }

    public void addToManifest(DvrManifestEntry dvrManifestEntry) {
        long l = dvrManifestEntry.getStartTimecode();
        int n = dvrManifestEntry.getIndex();
        this.put(n, l, dvrManifestEntry);
        this.incrementRunningSize(dvrManifestEntry);
    }

    private void incrementRunningSize(DvrManifestEntry dvrManifestEntry) {
        DvrChunkArtifact dvrChunkArtifact;
        if (dvrManifestEntry != null && (dvrChunkArtifact = dvrManifestEntry.getDvrArtifact()) != null) {
            this.runningSize += (long)dvrChunkArtifact.size;
        }
    }

    private void decrementRunningSize(DvrManifestEntry dvrManifestEntry) {
        DvrChunkArtifact dvrChunkArtifact;
        if (dvrManifestEntry != null && (dvrChunkArtifact = dvrManifestEntry.getDvrArtifact()) != null) {
            this.runningSize -= (long)dvrChunkArtifact.size;
        }
    }

    public long getChunksSize() {
        return this.runningSize;
    }

    public Map<Long, DvrManifestEntry> getTimeMap() {
        return Collections.unmodifiableMap(this.timeMap);
    }

    public Map<Integer, DvrManifestEntry> getIndexMap() {
        return Collections.unmodifiableMap(this.indexMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Integer n, Long l, DvrManifestEntry dvrManifestEntry) {
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            this.indexMap.put(n, dvrManifestEntry);
            this.timeMap.put(l, dvrManifestEntry);
            this.dvrTime = dvrManifestEntry.getStopTimecode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DvrManifestEntry getDvrEntryAtTime(long l) {
        DvrManifestEntry dvrManifestEntry = null;
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            dvrManifestEntry = this.timeMap.get(l);
        }
        return dvrManifestEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DvrManifestEntry getDvrEntryByIndex(int n) {
        DvrManifestEntry dvrManifestEntry = null;
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            dvrManifestEntry = this.indexMap.get(n);
        }
        return dvrManifestEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DvrManifestEntry getDvrEntryStartingBeforeTime(long l, boolean bl) {
        DvrManifestEntry dvrManifestEntry = null;
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            SortedMap<Long, DvrManifestEntry> sortedMap = this.getTimeMapHeadCopy(l, bl);
            if (!sortedMap.isEmpty()) {
                long l2 = sortedMap.lastKey();
                dvrManifestEntry = (DvrManifestEntry)sortedMap.get(l2);
            }
        }
        return dvrManifestEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DvrManifestEntry> getDvrEntriesStartingAtTime(long l) {
        ArrayList<DvrManifestEntry> arrayList = new ArrayList<DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            SortedMap<Long, DvrManifestEntry> sortedMap = this.getTimeMapTailCopy(l, true);
            arrayList.addAll(sortedMap.values());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DvrManifestEntry> getDvrEntriesStartingAfterTime(long l) {
        SortedMap<Long, DvrManifestEntry> sortedMap;
        ArrayList<DvrManifestEntry> arrayList = new ArrayList<DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            sortedMap = this.getTimeMapTailCopy(l, false);
            sortedMap.remove(l);
        }
        arrayList.addAll(sortedMap.values());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DvrManifestEntry> getDvrEntriesStartingAtTime(long l, int n) {
        ArrayList<DvrManifestEntry> arrayList = new ArrayList();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            List<DvrManifestEntry> list = this.getDvrEntriesStartingAtTime(l);
            try {
                arrayList = list.subList(0, Math.min(list.size(), n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DvrManifestEntry> getDvrEntriesEndingBeforeTime(long l) {
        ArrayList<DvrManifestEntry> arrayList = new ArrayList<DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            SortedMap<Long, DvrManifestEntry> sortedMap = this.getTimeMapEndingBeforeTime(l);
            arrayList.addAll(sortedMap.values());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Long, DvrManifestEntry> getTimeMapEndingBeforeTime(long l) {
        long l2;
        long l3;
        SortedMap<Long, DvrManifestEntry> sortedMap;
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            sortedMap = this.getTimeMapHeadCopy(l, false);
        }
        if (!sortedMap.isEmpty() && (l3 = ((DvrManifestEntry)sortedMap.get(l2 = sortedMap.lastKey().longValue())).getStopTimecode()) >= l) {
            sortedMap.remove(l2);
        }
        return sortedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, DvrManifestEntry> getIndexMapEndingBeforeTime(long l) {
        TreeMap<Integer, DvrManifestEntry> treeMap = new TreeMap<Integer, DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            SortedMap<Long, DvrManifestEntry> sortedMap = this.getTimeMapEndingBeforeTime(l);
            for (DvrManifestEntry dvrManifestEntry : sortedMap.values()) {
                treeMap.put(dvrManifestEntry.getIndex(), dvrManifestEntry);
            }
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(List<DvrManifestEntry> list) {
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            if (list == null || list.isEmpty()) {
                return;
            }
            for (DvrManifestEntry dvrManifestEntry : list) {
                this.remove(dvrManifestEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(DvrManifestEntry dvrManifestEntry) {
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            int n = dvrManifestEntry.getIndex();
            long l = dvrManifestEntry.getStartTimecode();
            this.indexMap.remove(n);
            this.timeMap.remove(l);
            this.decrementRunningSize(dvrManifestEntry);
        }
    }

    public boolean isEmpty() {
        return this.timeMap.isEmpty();
    }

    public long getDvrTime() {
        return this.dvrTime;
    }

    public void setDvrTime(long l) {
        this.dvrTime = l;
    }

    public int getLastIndex() {
        if (this.indexMap.isEmpty()) {
            return 0;
        }
        return this.indexMap.lastKey();
    }

    public List<DvrManifestEntry> getDvrEntries() {
        return new ArrayList<DvrManifestEntry>(this.getIndexMap().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calculateClosestTime(long l) {
        long l2 = l;
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            if (this.timeMap.isEmpty()) {
                return l;
            }
            long l3 = this.timeMap.lastKey();
            try {
                l3 = this.timeMap.tailMap(l).firstKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l4 = this.timeMap.firstKey();
            try {
                l4 = this.timeMap.headMap(l).lastKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l5 = Math.abs(l - l3);
            long l6 = Math.abs(l - l4);
            l2 = l5 == 0L || l5 <= l6 ? l3 : l4;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<Long, DvrManifestEntry> getTimeMapTailCopy(long l, boolean bl) {
        TreeMap<Long, DvrManifestEntry> treeMap = new TreeMap<Long, DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            Long l2 = new Long(l);
            treeMap.putAll(this.timeMap.tailMap(l2));
            if (!bl) {
                treeMap.remove(l2);
            }
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<Long, DvrManifestEntry> getTimeMapHeadCopy(long l, boolean bl) {
        TreeMap<Long, DvrManifestEntry> treeMap = new TreeMap<Long, DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this;
        synchronized (dvrChannelManifest) {
            Long l2 = new Long(l);
            treeMap.putAll(this.timeMap.headMap(l2));
            if (bl) {
                treeMap.put(l2, this.timeMap.get(l2));
            }
        }
        return treeMap;
    }
}

