/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.media.model.IMediaCodecInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrPacketHolder {
    private AMFPacket packet = null;
    private AMFPacket metaDataPacket = null;
    private List<DvrPacketHolder> holders = null;
    private long packetTimecode = 0L;
    private long realTime = 0L;
    private int duration = 0;
    private int codec = 0;
    private int type = 0;
    private boolean isCodecConfig = false;
    private boolean isKey = false;
    private int packetCount = 0;
    private int dataLen = 0;
    private IMediaCodecInfo codecInfo = null;

    public DvrPacketHolder() {
    }

    public DvrPacketHolder(AMFPacket aMFPacket, long l) {
        this.packet = aMFPacket;
        this.packetTimecode = l;
        if (aMFPacket != null) {
            this.dataLen += this.extractDataSize(aMFPacket);
            this.duration = (int)aMFPacket.getTimecode();
        }
    }

    public DvrPacketHolder(AMFPacket aMFPacket, int n, int n2, boolean bl, long l) {
        this.packet = aMFPacket;
        this.type = n;
        this.codec = n2;
        this.isCodecConfig = bl;
        this.packetTimecode = l;
        if (aMFPacket != null && !bl) {
            this.dataLen += this.extractDataSize(aMFPacket);
            this.duration = (int)aMFPacket.getTimecode();
        }
    }

    private int extractDataSize(AMFPacket aMFPacket) {
        int n = aMFPacket.getSize();
        if (aMFPacket.getType() == 8 && FLVUtils.getAudioCodec(aMFPacket) == 10) {
            n += 5;
        }
        return n;
    }

    public AMFPacket getPacket() {
        return this.packet;
    }

    public void setPacketTimecode(long l) {
        this.packetTimecode = l;
    }

    public long getPacketTimecode() {
        return this.packetTimecode;
    }

    public void setRealTimecode(long l) {
        this.realTime = l;
    }

    public long getRealTimecode() {
        return this.realTime;
    }

    public void addHolder(DvrPacketHolder dvrPacketHolder) {
        if (this.holders == null) {
            this.holders = new ArrayList<DvrPacketHolder>();
        }
        this.holders.add(dvrPacketHolder);
        if (!dvrPacketHolder.isCodecConfig()) {
            ++this.packetCount;
            this.dataLen += this.extractDataSize(dvrPacketHolder.getPacket());
        }
        if (this.holders.size() == 1) {
            this.packet = dvrPacketHolder.packet;
            this.packetTimecode = dvrPacketHolder.packetTimecode;
            this.metaDataPacket = dvrPacketHolder.metaDataPacket;
        } else if (this.holders.size() > 1) {
            this.duration = (int)(dvrPacketHolder.packetTimecode - this.packetTimecode);
        }
    }

    public boolean isGroup() {
        return this.holders != null;
    }

    public List<DvrPacketHolder> getHolders() {
        return this.holders;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isCodecConfig() {
        return this.isCodecConfig;
    }

    public void setCodecConfig(boolean bl) {
        this.isCodecConfig = bl;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean bl) {
        this.isKey = bl;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(int n) {
        this.dataLen = n;
    }

    public IMediaCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    public void setCodecInfo(IMediaCodecInfo iMediaCodecInfo) {
        this.codecInfo = iMediaCodecInfo;
    }

    public AMFPacket getMetaDataPacket() {
        return this.metaDataPacket;
    }

    public void setMetaDataPacket(AMFPacket aMFPacket) {
        this.metaDataPacket = aMFPacket;
    }

    public static AMFPacket getLastPacket(DvrPacketHolder dvrPacketHolder) {
        if (dvrPacketHolder.isGroup()) {
            List<DvrPacketHolder> list = dvrPacketHolder.getHolders();
            int n = list.size();
            return DvrPacketHolder.getLastPacket(list.get(n - 1));
        }
        return dvrPacketHolder.getPacket();
    }

    public static AMFPacket getFirstPacket(DvrPacketHolder dvrPacketHolder) {
        if (dvrPacketHolder.isGroup()) {
            List<DvrPacketHolder> list = dvrPacketHolder.getHolders();
            return DvrPacketHolder.getLastPacket(list.get(0));
        }
        return dvrPacketHolder.getPacket();
    }

    public String toString() {
        String string = String.format("(%s %s)", this.isKey ? "KEY, " : "", this.isCodecConfig ? "isCodec" : "");
        String string2 = this.type == 8 ? "A" : (this.type == 9 ? "V" : "D");
        return String.format("[DvrPacketHolder %s rt=%d pt=%d dur=%d %s codec=%d numPackets=%d dataLen=%d pkt=%s]", string2, this.realTime, this.packetTimecode, this.duration, string, this.codec, this.packetCount, this.dataLen, this.packet);
    }
}

