/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrPlayerAdapter;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.httpstreamer.cupertinostreaming.dvr.DvrPlayerAdapterCupertino;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.List;

public abstract class DvrPlayerAdapterBase
implements IDvrPlayerAdapter {
    private static final Class<DvrPlayerAdapterCupertino> CLASS = DvrPlayerAdapterCupertino.class;
    private static final Object CLASSNAME = "DvrPlayerAdapterBase";
    private static final boolean debug = false;

    protected long determineDvrStartTime(long l, IDvrStreamStore iDvrStreamStore) {
        long l2;
        int n = iDvrStreamStore.getDvrStorageWindowSeconds();
        if (n > 0) {
            l2 = iDvrStreamStore.getTimeController().getCurrentTime() / 1000L;
            long l3 = l2 - (long)n;
            if (l3 < 0L) {
                l3 = 0L;
            }
            if (l < l3) {
                l = l3;
            }
        }
        l2 = iDvrStreamStore.calculateClosestTime(9, l * 1000L);
        return l2;
    }

    public boolean isPlaylistReady(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return false;
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.isPlaylistReady(iDvrStore, string3, l);
    }

    private boolean isPlaylistReady(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return true;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return true;
        }
        IDvrManifest iDvrManifest = iDvrStreamStore.getManifest();
        List<DvrManifestEntry> list = iDvrManifest.getDvrEntriesAtTime(9, l);
        return list.size() > iDvrStore.getMinimumAvailableChunks();
    }

    public boolean isPlaylistEmpty(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return true;
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.isPlaylistEmpty(iDvrStore, string3, l);
    }

    private boolean isPlaylistEmpty(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return true;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return true;
        }
        IDvrManifest iDvrManifest = iDvrStreamStore.getManifest();
        List<DvrManifestEntry> list = iDvrManifest.getDvrEntriesAtTime(9, l);
        return list.isEmpty();
    }
}

