/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrPacketHolder;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.IDvrStoreListener;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.model.DvrStoreItem;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DvrStoreBase
implements IDvrStore {
    static final String CLASSNAME = "DvrStoreBase";
    private static final Class<DvrStoreBase> CLASS = DvrStoreBase.class;
    protected int dvrWindowSeconds = 0;
    protected int dvrMinimumAvailableChunks = 3;
    protected Map<String, IDvrStreamStore> streams = new HashMap<String, IDvrStreamStore>();
    protected String storeName;
    protected String dvrBaseDirectory = "";
    private IApplicationInstance appInstance;
    private DvrStoreItem dvrStoreItem;
    protected WMSProperties properties = new WMSProperties();
    private List<IDvrStoreListener> dvrStoreListeners = new ArrayList<IDvrStoreListener>();

    protected abstract IDvrStreamStore createStreamStore(String var1);

    @Override
    public void init(String string, IApplicationInstance iApplicationInstance, DvrStoreItem dvrStoreItem) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DvrStoreBase.init() store=" + string + " app=" + iApplicationInstance + " item=" + dvrStoreItem);
        this.storeName = string;
        this.appInstance = iApplicationInstance;
        this.dvrStoreItem = dvrStoreItem;
        this.initProperties();
    }

    protected void initProperties() {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        this.properties.putAll(this.dvrStoreItem.getProperties());
        this.properties.putAll(this.appInstance.getDvrStoreProperties());
        wMSLogger.info("DvrStoreBase.initProperties properties: " + this.properties);
        String string = this.properties.getPropertyStr("dvrPath", "");
        if (string.equals("")) {
            string = this.appInstance.getStreamStorageDir() + "/" + "dvrStorage";
        }
        this.setDvrBasePath(string);
        wMSLogger.info(String.format("%s.initProperties dvrBasePath=%s", CLASSNAME, string));
        this.dvrWindowSeconds = this.properties.getPropertyInt("dvrWindowDuration", 0);
        wMSLogger.info(String.format("%s.initProperties dvrWindowSizeSeconds=%d", CLASSNAME, this.dvrWindowSeconds));
        this.dvrMinimumAvailableChunks = this.properties.getPropertyInt("dvrMinimumAvailableChunks", 3);
        if (this.dvrMinimumAvailableChunks < 3) {
            wMSLogger.warn(String.format("%s.initProperties Attempt to set dvrMinimumAvailableChunks to %d.  Resetting to minimum of %d.", CLASSNAME, this.dvrMinimumAvailableChunks, 3));
            this.dvrMinimumAvailableChunks = 3;
        }
        wMSLogger.info(String.format("%s.initProperties dvrMinimumAvailableChunks=%d", CLASSNAME, this.dvrMinimumAvailableChunks));
    }

    public String getAppContextString() {
        String string = null;
        if (this.appInstance != null) {
            string = this.appInstance.getContextStr();
        }
        if (string == null || "".equals(string)) {
            return "noAppContext";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DvrStoreBase.shutdown()");
        if (this.streams != null) {
            object = this.streams.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.removeStream(string);
            }
        }
        object = this.streams;
        synchronized (object) {
            this.streams.clear();
        }
        this.appInstance.notifyDvrStoreDestroy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDvrStreamStore getStreamStore(String string, boolean bl) {
        IDvrStreamStore iDvrStreamStore = null;
        boolean bl2 = false;
        IApplicationInstance iApplicationInstance = this.getAppInstance();
        Map<String, IDvrStreamStore> map = this.streams;
        synchronized (map) {
            iDvrStreamStore = this.streams.get(string);
        }
        if (iDvrStreamStore == null && bl) {
            try {
                iDvrStreamStore = this.createStreamStore(string);
                bl2 = true;
                map = this.streams;
                synchronized (map) {
                    this.streams.put(string, iDvrStreamStore);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).warn("DvrStoreBase.getStreamStore: Error instantiating IDvrStreamStore[" + string + "]: " + exception.toString());
            }
        }
        if (bl2 && iDvrStreamStore != null) {
            iDvrStreamStore.init();
            iApplicationInstance.notifyDvrStreamStoreInit(this, iDvrStreamStore, string);
            WMSLoggerFactory.getLogger(null).info("DvrStoreBase.getStreamStore: Create dvr stream store: " + iDvrStreamStore);
        }
        return iDvrStreamStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStream(String string) {
        IDvrStreamStore iDvrStreamStore;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DvrStoreBase.removeStream() this:" + this + " stream=" + string);
        Object object = this.streams;
        synchronized (object) {
            iDvrStreamStore = this.streams.get(string);
        }
        if (iDvrStreamStore == null) {
            wMSLogger.warn("DvrStoreBase.removeStream() stream " + string + " does not exist in this DVR.");
            return;
        }
        object = this.getAppInstance();
        object.notifyDvrStreamStoreDestroy(this, iDvrStreamStore, string);
        Map<String, IDvrStreamStore> map = this.streams;
        synchronized (map) {
            this.streams.remove(string);
        }
    }

    @Override
    public void storeChunks(String string, int n, DvrPacketHolder dvrPacketHolder, int n2, DvrPacketHolder dvrPacketHolder2, int n3, DvrPacketHolder dvrPacketHolder3) {
        IDvrStreamStore iDvrStreamStore = this.getStreamStore(string, true);
        if (iDvrStreamStore != null) {
            iDvrStreamStore.storeChunks(n, dvrPacketHolder, n2, dvrPacketHolder2, n3, dvrPacketHolder3);
        } else {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: streamStore '%s' not found.", CLASSNAME, "storeChunks", string));
        }
    }

    @Override
    public void storeOnMetadata(long l, String string, AMFPacket aMFPacket) {
        if (aMFPacket != null) {
            IDvrStreamStore iDvrStreamStore = this.getStreamStore(string, true);
            if (iDvrStreamStore != null) {
                iDvrStreamStore.storeOnMetadata(l, aMFPacket);
            } else {
                WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
                wMSLogger.warn(String.format("%s.%s: streamStore '%s' not found.", CLASSNAME, "storeOnMetadata", string));
            }
        } else {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: empty or null DvrPacketHolder for %s/pet=%d.", CLASSNAME, "storeOnMetadata", string, l));
        }
    }

    @Override
    public DvrChunk getDvrChunkAtTime(String string, int n, long l) {
        WMSLogger wMSLogger;
        DvrChunk dvrChunk = null;
        IDvrStreamStore iDvrStreamStore = this.getStreamStore(string, true);
        if (iDvrStreamStore == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: streamStore '%s' not found.", CLASSNAME, "getDvrChunkAtTime", string));
        } else {
            dvrChunk = iDvrStreamStore.getDvrChunkAtTime(n, l);
        }
        if (dvrChunk == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: no chunk found for %s/%d/t=%d.", CLASSNAME, "getDvrChunkAtTime", string, n, l));
        }
        return dvrChunk;
    }

    @Override
    public DvrChunk getDvrChunkByIndex(String string, int n, int n2) {
        WMSLogger wMSLogger;
        DvrChunk dvrChunk = null;
        IDvrStreamStore iDvrStreamStore = this.getStreamStore(string, true);
        if (iDvrStreamStore == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: streamStore '%s' not found.", CLASSNAME, "getDvrChunkByIndex", string));
        } else {
            dvrChunk = iDvrStreamStore.getDvrChunkByIndex(n, n2);
        }
        if (dvrChunk == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: no chunk found for %s/%d/i=%d.", CLASSNAME, "getDvrChunkByIndex", string, n, n2));
        }
        return dvrChunk;
    }

    @Override
    public DvrManifestEntry getDvrEntryByIndex(String string, int n, int n2) {
        WMSLogger wMSLogger;
        DvrManifestEntry dvrManifestEntry = null;
        IDvrStreamStore iDvrStreamStore = this.getStreamStore(string, true);
        if (iDvrStreamStore == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: streamStore '%s' not found.", CLASSNAME, "getDvrEntryByIndex", string));
        } else {
            dvrManifestEntry = iDvrStreamStore.getDvrEntryByIndex(n, n2);
        }
        if (dvrManifestEntry == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: no record found for %s/%d/i=%d.", CLASSNAME, "getDvrEntryByIndex", string, n, n2));
        }
        return dvrManifestEntry;
    }

    @Override
    public List<DvrManifestEntry> getDvrEntriesAtTime(String string, int n, long l, int n2) {
        WMSLogger wMSLogger;
        List<DvrManifestEntry> list = null;
        IDvrStreamStore iDvrStreamStore = this.getStreamStore(string, true);
        if (iDvrStreamStore == null) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: streamStore '%s' not found.", CLASSNAME, "getDvrEntriesAtTime", string));
        } else {
            list = iDvrStreamStore.getDvrEntriesAtTime(n, l, n2);
        }
        if (list == null || list.isEmpty()) {
            wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: no records found for %s/%d/t=%d.", CLASSNAME, "getDvrEntriesAtTime", string, n, l));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDvrStoreListener(IDvrStoreListener iDvrStoreListener) {
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            this.dvrStoreListeners.add(iDvrStoreListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDvrStoreListener(IDvrStoreListener iDvrStoreListener) {
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            this.dvrStoreListeners.remove(iDvrStoreListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preNotifyChunkAdded(IDvrStreamStore iDvrStreamStore) {
        ArrayList<IDvrStoreListener> arrayList = null;
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            arrayList = new ArrayList<IDvrStoreListener>(this.dvrStoreListeners);
        }
        for (IDvrStoreListener iDvrStoreListener : arrayList) {
            iDvrStoreListener.preChunkAdded(this, iDvrStreamStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postNotifyChunkAdded(IDvrStreamStore iDvrStreamStore) {
        ArrayList<IDvrStoreListener> arrayList = null;
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            arrayList = new ArrayList<IDvrStoreListener>(this.dvrStoreListeners);
        }
        for (IDvrStoreListener iDvrStoreListener : arrayList) {
            iDvrStoreListener.postChunkAdded(this, iDvrStreamStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preNotifyChunkPurged(IDvrStreamStore iDvrStreamStore, DvrManifestEntry dvrManifestEntry) {
        ArrayList<IDvrStoreListener> arrayList = null;
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            arrayList = new ArrayList<IDvrStoreListener>(this.dvrStoreListeners);
        }
        for (IDvrStoreListener iDvrStoreListener : arrayList) {
            iDvrStoreListener.preChunkPurged(this, iDvrStreamStore, dvrManifestEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postNotifyChunkPurged(IDvrStreamStore iDvrStreamStore, DvrManifestEntry dvrManifestEntry) {
        ArrayList<IDvrStoreListener> arrayList = null;
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            arrayList = new ArrayList<IDvrStoreListener>(this.dvrStoreListeners);
        }
        for (IDvrStoreListener iDvrStoreListener : arrayList) {
            iDvrStoreListener.postChunkPurged(this, iDvrStreamStore, dvrManifestEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preNotifyStorageInitialized(IDvrStreamStore iDvrStreamStore) {
        ArrayList<IDvrStoreListener> arrayList = null;
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            arrayList = new ArrayList<IDvrStoreListener>(this.dvrStoreListeners);
        }
        for (IDvrStoreListener iDvrStoreListener : arrayList) {
            iDvrStoreListener.preStreamStorageInitialized(this, iDvrStreamStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postNotifyStorageInitialized(IDvrStreamStore iDvrStreamStore) {
        ArrayList<IDvrStoreListener> arrayList = null;
        List<IDvrStoreListener> list = this.dvrStoreListeners;
        synchronized (list) {
            arrayList = new ArrayList<IDvrStoreListener>(this.dvrStoreListeners);
        }
        for (IDvrStoreListener iDvrStoreListener : arrayList) {
            iDvrStoreListener.postStreamStorageInitialized(this, iDvrStreamStore);
        }
    }

    @Override
    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setDvrStorageWindowSeconds(int n) {
        this.dvrWindowSeconds = n;
    }

    @Override
    public int getDvrStorageWindowSeconds() {
        return this.dvrWindowSeconds;
    }

    @Override
    public int getMinimumAvailableChunks() {
        return this.dvrMinimumAvailableChunks;
    }

    @Override
    public String getDvrBasePath() {
        return this.dvrBaseDirectory;
    }

    @Override
    public void setDvrBasePath(String string) {
        this.dvrBaseDirectory = string;
    }

    @Override
    public String getDvrStoreName() {
        return this.storeName;
    }

    public String toString() {
        return String.format("[%s store=%s props=%s]", CLASSNAME, this.storeName, this.properties);
    }
}

