/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.dvr.DefaultDvrPersistentStorageHandler;
import com.wowza.wms.dvr.DvrArtifactChunker;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkArtifact;
import com.wowza.wms.dvr.DvrManifestChannelsGroup;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrPacketHolder;
import com.wowza.wms.dvr.DvrStoreBase;
import com.wowza.wms.dvr.DvrTimeController;
import com.wowza.wms.dvr.IDvrChunker;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrPacketConverter;
import com.wowza.wms.dvr.IDvrPersistentStorageHandler;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.IDvrTimeController;
import com.wowza.wms.dvr.io.DvrChunkReaderUtils;
import com.wowza.wms.dvr.io.DvrChunkWriterUtils;
import com.wowza.wms.dvr.io.DvrFileSystemFactory;
import com.wowza.wms.dvr.io.DvrManifestWriterFactory;
import com.wowza.wms.dvr.io.IDvrFileSystem;
import com.wowza.wms.dvr.io.IDvrManifestPersister;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DvrStreamStoreBase
implements IDvrStreamStore {
    private static final Class<DvrStreamStoreBase> CLASS = DvrStreamStoreBase.class;
    private static final String CLASSNAME = "DvrStreamStoreBase";
    private static final boolean debugAddRemoves = false;
    private static final boolean debugDvrContents = false;
    private static final boolean debugRetrievals = false;
    protected IDvrPacketConverter packetConverter;
    protected int dvrWindowSizeSeconds = 0;
    protected int purgeFrequencySeconds = 10;
    protected WMSProperties properties = new WMSProperties();
    protected String streamName;
    protected DvrStoreBase dvrStore;
    protected IDvrPersistentStorageHandler persistentStorageHandler = new DefaultDvrPersistentStorageHandler();
    protected String dvrStorageStrategy = "delete";
    private boolean storageSystemInitialized;
    protected IDvrManifest manifest;
    protected int chunkGroupingSeconds = 600;
    protected DvrTimeController timeController;
    protected DvrArtifactChunker chunker;
    protected IDvrFileSystem fileSystem;
    protected String chunkReaderClass = "com.wowza.wms.dvr.impl.io.DvrFileChunkReader";
    protected String chunkWriterClass = "com.wowza.wms.dvr.impl.io.DvrFileChunkWriter";
    protected String dvrFileSystemClass = "com.wowza.wms.dvr.impl.io.DvrDefaultFileSystem";
    protected String manifestPersisterClass = "com.wowza.wms.dvr.impl.DvrManifestPersister";
    protected String manifestWriterClass = "com.wowza.wms.dvr.impl.DvrManifestPersister";
    protected String manifestReaderClass = "com.wowza.wms.dvr.impl.DvrManifestPersister";
    protected IDvrManifestPersister manifestWriter;
    private boolean needToHandlePreviousStorage = false;

    public DvrStreamStoreBase(DvrStoreBase dvrStoreBase, String string) {
        this.dvrStore = dvrStoreBase;
        this.streamName = string;
    }

    @Override
    public void init() {
        this.initProperties();
        this.initializeStorageSystem();
        this.packetConverter = this.initPacketConverter();
        this.timeController = new DvrTimeController(this);
        this.chunker = new DvrArtifactChunker(this, this.chunkGroupingSeconds);
        this.manifest = this.initManifest();
        if (this.needToHandlePreviousStorage) {
            this.managePreviousStorage();
            this.needToHandlePreviousStorage = false;
        }
        if (!this.fileSystem.doesFileSystemExist() && !this.fileSystem.createFileSystem()) {
            String string = String.format("%s.initializeStorageSystem: Unable to create file system %s", CLASSNAME, this.fileSystem);
            WMSLoggerFactory.getLogger(CLASS).error(string);
        }
        this.manifest.initialize();
    }

    protected void managePreviousStorage() {
        if ("versionByNumber".equals(this.dvrStorageStrategy) || "versionByDate".equals(this.dvrStorageStrategy)) {
            boolean bl = this.persistentStorageHandler.backupPreviousStore(this.dvrStorageStrategy, this.fileSystem, this);
        } else if ("delete".equals(this.dvrStorageStrategy)) {
            boolean bl = this.persistentStorageHandler.deletePreviousStore(this, this.fileSystem);
            if (!bl) {
                bl = this.persistentStorageHandler.backupPreviousStore("versionByNumber", this.fileSystem, this);
            }
        } else if ("append".equals(this.dvrStorageStrategy)) {
            boolean bl = this.persistentStorageHandler.reloadPreviousStore(this, this.fileSystem);
            if (!bl) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.managePreviousStorage: Unable to reload previous persistent storage from fileSystem='%s'.", CLASSNAME, this.fileSystem));
            }
        } else {
            WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.managePreviousStorage: Unknown persistent storage strategy '%s'.", CLASSNAME, this.dvrStorageStrategy));
        }
    }

    protected abstract IDvrManifest initManifest();

    protected abstract IDvrPacketConverter initPacketConverter();

    protected void initProperties() {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        if (this.dvrStore != null) {
            wMSLogger.info("DvrStreamStoreBase.initProperties DVR Store props:" + this.dvrStore.getProperties());
            this.properties.putAll(this.dvrStore.getProperties());
        }
        this.dvrStorageStrategy = this.properties.getPropertyStr("dvrStorageStrategy", "versionByNumber");
        this.dvrWindowSizeSeconds = this.properties.getPropertyInt("dvrWindowDuration", 0);
        this.chunkGroupingSeconds = this.properties.getPropertyInt("dvrChunkGroupingSeconds", 600);
        this.purgeFrequencySeconds = this.properties.getPropertyInt("dvrPurgeFrequencySeconds", 10);
        this.chunkReaderClass = this.properties.getPropertyStr("dvrChunkReaderClass", "com.wowza.wms.dvr.impl.io.DvrFileChunkReader");
        this.chunkWriterClass = this.properties.getPropertyStr("dvrChunkWriterClass", "com.wowza.wms.dvr.impl.io.DvrFileChunkWriter");
        this.dvrFileSystemClass = this.properties.getPropertyStr("dvrFileSystemClass", "com.wowza.wms.dvr.impl.io.DvrDefaultFileSystem");
        this.manifestPersisterClass = this.properties.getPropertyStr("dvrManifestPersisterClass", "com.wowza.wms.dvr.impl.DvrManifestPersister");
        this.manifestWriterClass = this.properties.getPropertyStr("dvrTextWriterClass", "com.wowza.wms.dvr.impl.io.DvrTextFileWriter");
        this.manifestReaderClass = this.properties.getPropertyStr("dvrTextReaderClass", "com.wowza.wms.dvr.impl.io.DvrTextFileReader");
        wMSLogger.info(String.format("%s.initProperties chunkReaderClass=%s", CLASSNAME, this.chunkReaderClass));
        wMSLogger.info(String.format("%s.initProperties chunkWriterClass=%s", CLASSNAME, this.chunkWriterClass));
        wMSLogger.info(String.format("%s.initProperties dvrFileSystemClass=%s", CLASSNAME, this.dvrFileSystemClass));
        wMSLogger.info(String.format("%s.initProperties manifestPersisterClass=%s", CLASSNAME, this.manifestPersisterClass));
    }

    @Override
    public long calculateClosestTime(int n, long l) {
        return this.manifest.calculateClosestTime(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeChunks(int n, DvrPacketHolder dvrPacketHolder, int n2, DvrPacketHolder dvrPacketHolder2, int n3, DvrPacketHolder dvrPacketHolder3) {
        long l = -1L;
        DvrStreamStoreBase dvrStreamStoreBase = this;
        synchronized (dvrStreamStoreBase) {
            DvrManifestEntry dvrManifestEntry;
            int n4 = this.manifest.getNextIndex();
            if (dvrPacketHolder != null && (dvrManifestEntry = this.storeVideoChunk(n4, n, dvrPacketHolder)) != null) {
                l = this.calcLatestDvrTime(l, dvrManifestEntry);
            }
            if (dvrPacketHolder2 != null && (dvrManifestEntry = this.storeAudioChunk(n4, n2, dvrPacketHolder2)) != null) {
                l = this.calcLatestDvrTime(l, dvrManifestEntry);
            }
            if (dvrPacketHolder3 != null) {
                if (dvrPacketHolder != null && n > 0) {
                    n3 = n;
                } else if (dvrPacketHolder2 != null && n2 > 0) {
                    n3 = n2;
                }
                dvrManifestEntry = this.storeDataChunk(n4, n3, dvrPacketHolder3);
                if (dvrManifestEntry != null) {
                    l = this.calcLatestDvrTime(l, dvrManifestEntry);
                }
            }
            this.changeCurrentTime(l);
        }
    }

    private long calcLatestDvrTime(long l, DvrManifestEntry dvrManifestEntry) {
        long l2;
        if (dvrManifestEntry != null && (l2 = dvrManifestEntry.getStartTimecode()) > l) {
            l = l2;
        }
        return l;
    }

    protected DvrManifestEntry storeAudioChunk(int n, int n2, DvrPacketHolder dvrPacketHolder) {
        String string = "storeAudioChunk";
        DvrChunk dvrChunk = null;
        if (dvrPacketHolder == null || dvrPacketHolder.getPacketCount() <= 0) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: empty or null DvrPacketHolder for %s/dur=%d.", CLASSNAME, "storeAudioChunk", this.streamName, n2));
            return null;
        }
        if (n2 <= 0) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Duration must be positive.  Duration=%d.", CLASSNAME, "storeAudioChunk", n2));
            return null;
        }
        long l = this.manifest.getDvrTime(dvrPacketHolder.getType());
        if (l < 0L) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Time must be positive.  dvrTime=%d.", CLASSNAME, "storeAudioChunk", l));
            return null;
        }
        if (this.packetConverter != null) {
            dvrChunk = this.packetConverter.createDvrAudioChunk(l, n2, dvrPacketHolder);
        }
        if (dvrChunk == null) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: chunk conversion failure for %s/pet=%d/dur=%d.", CLASSNAME, "storeAudioChunk", this.streamName, l, n2));
            return null;
        }
        return this.addChunk(dvrPacketHolder.getType(), l, n2, n, dvrChunk);
    }

    protected DvrManifestEntry storeVideoChunk(int n, int n2, DvrPacketHolder dvrPacketHolder) {
        String string = "storeVideoChunk";
        DvrChunk dvrChunk = null;
        if (dvrPacketHolder == null || dvrPacketHolder.getPacketCount() <= 0) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: empty or null DvrPacketHolder for %s/dur=%d.", CLASSNAME, "storeVideoChunk", this.streamName, n2));
            return null;
        }
        if (n2 <= 0) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Duration must be positive.  Duration=%d.", CLASSNAME, "storeVideoChunk", n2));
            return null;
        }
        long l = this.manifest.getDvrTime(dvrPacketHolder.getType());
        if (l < 0L) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Time must be positive.  dvrTime=%d.", CLASSNAME, "storeVideoChunk", l));
            return null;
        }
        if (this.packetConverter != null) {
            dvrChunk = this.packetConverter.createDvrVideoChunk(l, n2, dvrPacketHolder);
        }
        if (dvrChunk == null) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: chunk conversion failure for %s/pet=%d/dur=%d.", CLASSNAME, "storeVideoChunk", this.streamName, l, n2));
            return null;
        }
        return this.addChunk(dvrPacketHolder.getType(), l, n2, n, dvrChunk);
    }

    protected DvrManifestEntry storeDataChunk(int n, int n2, DvrPacketHolder dvrPacketHolder) {
        String string = "storeDataChunk";
        DvrChunk dvrChunk = null;
        if (dvrPacketHolder == null || dvrPacketHolder.getPacketCount() <= 0) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: empty or null DvrPacketHolder for %s/dur=%d.", CLASSNAME, "storeDataChunk", this.streamName, n2));
            return null;
        }
        if (n2 < 0) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Duration must be positive.  Duration=%d.", CLASSNAME, "storeDataChunk", n2));
            return null;
        }
        long l = this.manifest.getDvrTime(dvrPacketHolder.getType());
        if (l < 0L) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Time must be positive.  dvrTime=%d.", CLASSNAME, "storeDataChunk", l));
            return null;
        }
        if (this.packetConverter != null) {
            dvrChunk = this.packetConverter.createDvrDataChunk(l, n2, dvrPacketHolder);
        }
        if (dvrChunk == null) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: chunk conversion failure for %s/pet=%d/dur=%d.", CLASSNAME, "storeDataChunk", this.streamName, l, n2));
            return null;
        }
        return this.addChunk(dvrPacketHolder.getType(), l, n2, n, dvrChunk);
    }

    @Override
    public void storeOnMetadata(long l, AMFPacket aMFPacket) {
        String string = "storeOnMetadata";
        DvrChunk dvrChunk = null;
        if (aMFPacket == null) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: null metaPacket for %s/pet=%d.", CLASSNAME, "storeOnMetadata", this.streamName, l));
            return;
        }
        long l2 = this.manifest.getDvrTime(9);
        if (l2 < 0L) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.error(String.format("%s.%s: Time must be positive.  dvrTime=%d.", CLASSNAME, "storeOnMetadata", l2));
            return;
        }
        if (this.packetConverter != null) {
            dvrChunk = this.packetConverter.createDvrOnMetadataChunk(l2, l, aMFPacket);
        }
        if (dvrChunk == null) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
            wMSLogger.warn(String.format("%s.%s: chunk conversion failure for %s/pet=%d.", CLASSNAME, "storeOnMetadata", this.streamName, l));
            return;
        }
        int n = this.manifest.getNextMetadataIndex();
        this.addOnMetadataChunk(l2, n, dvrChunk);
    }

    protected DvrChunkArtifact createChunkArtifact(int n, long l, DvrChunk dvrChunk) {
        boolean bl;
        String string = this.chunker.determineChunkGroupIdentifier(l);
        if (!this.fileSystem.exists(string) && !this.fileSystem.createContainer(string)) {
            String string2 = String.format("%s.createChunkArtifact: Unable to create directory %s", CLASSNAME, string);
            WMSLoggerFactory.getLogger(CLASS).error(string2);
            return null;
        }
        String string3 = this.determineArtifactName(n, l, dvrChunk);
        String string4 = string + IDvrFileSystem.separator + string3;
        if (this.fileSystem.exists(string4) && !(bl = this.fileSystem.delete(string4))) {
            WMSLoggerFactory.getLogger(CLASS).warn("Failed to delete " + string4);
        }
        try {
            DvrChunkWriterUtils.persistChunk(this, this.dvrStore.getAppInstance(), string4, dvrChunk);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("Error creating DVR file " + string4, exception);
            string4 = null;
        }
        long l2 = this.fileSystem.getSize(string4);
        return new DvrChunkArtifact(string, string3, (int)l2);
    }

    private String determineArtifactName(int n, long l, DvrChunk dvrChunk) {
        long l2 = l / 3600000L;
        long l3 = l % 3600000L;
        long l4 = l3 / 60000L;
        long l5 = (l3 %= 60000L) / 1000L;
        long l6 = l3 % 1000L;
        String string = "D-%04d_%02d_%02d_%03d.ismd";
        switch (n) {
            case 8: {
                string = "A-%04d_%02d_%02d_%03d.isma";
                break;
            }
            case 9: {
                string = "V-%04d_%02d_%02d_%03d.ismv";
                break;
            }
            case 18: {
                string = "D-%04d_%02d_%02d_%03d.ismd";
                break;
            }
            case 0: {
                string = "M-%04d_%02d_%02d_%03d.ismm";
                break;
            }
        }
        String string2 = String.format(string, l2, l4, l5, l6);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DvrChunk getDvrChunkAtTime(int n, long l) {
        DvrChunk dvrChunk = null;
        DvrStreamStoreBase dvrStreamStoreBase = this;
        synchronized (dvrStreamStoreBase) {
            DvrManifestEntry dvrManifestEntry = this.manifest.getDvrEntryAtTime(n, l);
            dvrChunk = this.retrieveDvrChunkByEntry(dvrManifestEntry);
        }
        return dvrChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DvrChunk getDvrChunkByIndex(int n, int n2) {
        DvrChunk dvrChunk = null;
        DvrStreamStoreBase dvrStreamStoreBase = this;
        synchronized (dvrStreamStoreBase) {
            DvrManifestEntry dvrManifestEntry = this.manifest.getDvrEntryByIndex(n, n2);
            dvrChunk = this.retrieveDvrChunkByEntry(dvrManifestEntry);
        }
        return dvrChunk;
    }

    protected DvrChunk retrieveDvrChunkByEntry(DvrManifestEntry dvrManifestEntry) {
        DvrChunk dvrChunk = null;
        if (dvrManifestEntry != null) {
            DvrChunkArtifact dvrChunkArtifact = dvrManifestEntry.getDvrArtifact();
            dvrChunk = DvrChunkReaderUtils.retrieveChunk(this, this.dvrStore.getAppInstance(), dvrChunkArtifact.getPath());
        }
        return dvrChunk;
    }

    @Override
    public DvrManifestEntry getDvrEntryByIndex(int n, int n2) {
        DvrManifestEntry dvrManifestEntry = null;
        dvrManifestEntry = this.manifest.getDvrEntryByIndex(n, n2);
        return dvrManifestEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DvrManifestEntry> getDvrEntriesAtTime(int n, long l, int n2) {
        List<DvrManifestEntry> list = null;
        DvrStreamStoreBase dvrStreamStoreBase = this;
        synchronized (dvrStreamStoreBase) {
            list = this.manifest.getDvrEntriesAtTime(n, l, n2);
        }
        return list;
    }

    protected DvrManifestEntry addChunk(int n, long l, int n2, int n3, DvrChunk dvrChunk) {
        this.dvrStore.preNotifyChunkAdded(this);
        DvrChunkArtifact dvrChunkArtifact = this.createChunkArtifact(n, l, dvrChunk);
        DvrManifestEntry dvrManifestEntry = new DvrManifestEntry(dvrChunkArtifact, l, l + (long)n2, n3, n);
        this.manifest.addToManifest(dvrManifestEntry);
        this.dvrStore.postNotifyChunkAdded(this);
        return dvrManifestEntry;
    }

    protected void addOnMetadataChunk(long l, int n, DvrChunk dvrChunk) {
        this.dvrStore.preNotifyChunkAdded(this);
        DvrChunkArtifact dvrChunkArtifact = this.createChunkArtifact(0, l, dvrChunk);
        DvrManifestEntry dvrManifestEntry = new DvrManifestEntry(dvrChunkArtifact, l, l, n, 0);
        this.manifest.addToManifest(dvrManifestEntry);
        this.dvrStore.postNotifyChunkAdded(this);
    }

    protected void changeCurrentTime(long l) {
        if (l < this.timeController.getCurrentTime()) {
            String string = String.format("Current DVR time tried to move backwards.  Ignored new time.  Old time=%d.  New time=%d.", this.timeController.getCurrentTime(), l);
            WMSLoggerFactory.getLogger(CLASS).warn(string);
            return;
        }
        this.timeController.setCurrentDvrTime(l);
        if (this.timeController.shouldPurge()) {
            long l2 = this.timeController.getNextPurgeTime();
            this.purgeChunksBeforeTime(l2);
            this.timeController.setLastPurgeTime(l);
        }
    }

    @Override
    public void purgeChunksBeforeTime(long l) {
        DvrManifestChannelsGroup dvrManifestChannelsGroup = this.manifest.getEntriesToPurge(l);
        this.manifest.purgeChunks(dvrManifestChannelsGroup);
        this.purgeDvrArtifacts(dvrManifestChannelsGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeChunksAfterTime(long l) {
        DvrManifestChannelsGroup dvrManifestChannelsGroup;
        DvrStreamStoreBase dvrStreamStoreBase = this;
        synchronized (dvrStreamStoreBase) {
            dvrManifestChannelsGroup = this.manifest.getDvrEntriesStartingAfterTime(l);
            this.manifest.purgeChunks(dvrManifestChannelsGroup);
        }
        this.purgeDvrArtifacts(dvrManifestChannelsGroup);
    }

    protected void purgeDvrArtifacts(DvrManifestChannelsGroup dvrManifestChannelsGroup) {
        this.purgeDvrArtifacts(dvrManifestChannelsGroup.vEntries);
        this.purgeDvrArtifacts(dvrManifestChannelsGroup.aEntries);
        this.purgeDvrArtifacts(dvrManifestChannelsGroup.dEntries);
        this.purgeDvrArtifacts(dvrManifestChannelsGroup.mEntries);
        this.manifestWriter.purgeIndividualManifests(dvrManifestChannelsGroup);
    }

    protected void purgeDvrArtifacts(List<DvrManifestEntry> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (DvrManifestEntry dvrManifestEntry : list) {
            DvrChunkArtifact dvrChunkArtifact = dvrManifestEntry.getDvrArtifact();
            this.fileSystem.delete(dvrChunkArtifact.getPath());
        }
    }

    private void logDvrContents() {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrStreamStoreBase.class);
        wMSLogger.info("Video:");
        List<DvrManifestEntry> list = this.manifest.getDvrEntriesAtTime(9, 0L);
        for (DvrManifestEntry dvrManifestEntry : list) {
            wMSLogger.info(dvrManifestEntry.toString());
        }
        wMSLogger.info("Audio:");
        list = this.manifest.getDvrEntriesAtTime(8, 0L);
        for (DvrManifestEntry dvrManifestEntry : list) {
            wMSLogger.info(dvrManifestEntry.toString());
        }
        wMSLogger.info("Data:");
        list = this.manifest.getDvrEntriesAtTime(18, 0L);
        for (DvrManifestEntry dvrManifestEntry : list) {
            wMSLogger.info(dvrManifestEntry.toString());
        }
        wMSLogger.info("Meta:");
        list = this.manifest.getDvrEntriesAtTime(0, 0L);
        for (DvrManifestEntry dvrManifestEntry : list) {
            wMSLogger.info(dvrManifestEntry.toString());
        }
    }

    protected void initializeStorageSystem() {
        if (!this.storageSystemInitialized) {
            this.dvrStore.preNotifyStorageInitialized(this);
            IApplicationInstance iApplicationInstance = this.dvrStore.getAppInstance();
            String string = iApplicationInstance.getContextStr() + IDvrFileSystem.separator + this.streamName;
            this.fileSystem = DvrFileSystemFactory.createInstance(iApplicationInstance, this.dvrFileSystemClass, this, this.dvrStore.getDvrBasePath(), string);
            this.manifestWriter = DvrManifestWriterFactory.createInstance(iApplicationInstance, this.manifestPersisterClass, this.fileSystem, this);
            if (this.fileSystem.doesFileSystemExist()) {
                this.needToHandlePreviousStorage = true;
            }
            if (!this.fileSystem.doesFileSystemExist() && !this.fileSystem.createFileSystem()) {
                String string2 = String.format("%s.initializeStorageSystem: Unable to create file system %s", CLASSNAME, this.fileSystem);
                WMSLoggerFactory.getLogger(CLASS).error(string2);
            }
            this.dvrStore.postNotifyStorageInitialized(this);
            this.storageSystemInitialized = true;
        }
    }

    @Override
    public IDvrPersistentStorageHandler getPersistentStorageHandler() {
        return this.persistentStorageHandler;
    }

    @Override
    public void setPersistentStorageHandler(IDvrPersistentStorageHandler iDvrPersistentStorageHandler) {
        this.persistentStorageHandler = iDvrPersistentStorageHandler;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int getDvrStorageWindowSeconds() {
        return this.dvrWindowSizeSeconds;
    }

    @Override
    public void setDvrStorageWindowSeconds(int n) {
        this.dvrWindowSizeSeconds = n;
        if (this.timeController != null) {
            this.timeController.setDvrStorageWindowSeconds(n);
        }
    }

    public int getPurgeFrequencySeconds() {
        return this.purgeFrequencySeconds;
    }

    public void setPurgeFrequencySeconds(int n) {
        this.purgeFrequencySeconds = n;
        if (this.timeController != null) {
            this.timeController.setPurgeFrequencySeconds(n);
        }
    }

    @Override
    public IDvrTimeController getTimeController() {
        return this.timeController;
    }

    @Override
    public IDvrChunker getChunker() {
        return this.chunker;
    }

    @Override
    public IDvrFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public long getTotalChunksSize() {
        return this.manifest.getTotalChunksSize();
    }

    public IDvrManifestPersister getManifestWriter() {
        return this.manifestWriter;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    public int getChunkGroupingSeconds() {
        return this.chunkGroupingSeconds;
    }

    public void setChunkGroupingSeconds(int n) {
        this.chunkGroupingSeconds = n;
    }

    @Override
    public IApplicationInstance getAppInstance() {
        return this.dvrStore.getAppInstance();
    }

    @Override
    public IDvrManifest getManifest() {
        return this.manifest;
    }

    public String toString() {
        return String.format("[%s store=%s props=%s]", CLASSNAME, this.streamName, this.properties);
    }
}

