/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.dvr.DvrStreamStoreBase;
import com.wowza.wms.dvr.IDvrTimeController;

public class DvrTimeController
implements IDvrTimeController {
    private static final Object CLASSNAME = "DvrTimeController";
    protected int purgeFrequencySeconds = 10;
    protected int dvrWindowSizeSeconds = 0;
    protected float extraDvrStoragePercentage = 0.9f;
    protected int dvrActualSizeSeconds = 0;
    protected long currentTimeMs = -1L;
    protected long nextPurgeTimeMs = -1L;
    protected long lastPurgeTimeMs = -1L;

    public DvrTimeController(DvrStreamStoreBase dvrStreamStoreBase) {
        this.setDvrStorageWindowSeconds(dvrStreamStoreBase.getDvrStorageWindowSeconds());
        this.purgeFrequencySeconds = dvrStreamStoreBase.getPurgeFrequencySeconds();
    }

    public void setCurrentDvrTime(long l) {
        this.currentTimeMs = l;
        this.recalculateNextDvrPurgeTime();
    }

    private void recalculateNextDvrPurgeTime() {
        if (this.dvrWindowSizeSeconds > 0) {
            this.nextPurgeTimeMs = this.currentTimeMs - (long)(this.dvrActualSizeSeconds * 1000);
        }
    }

    public boolean shouldPurge() {
        if (this.dvrWindowSizeSeconds <= 0) {
            return false;
        }
        return this.lastPurgeTimeMs == -1L || Math.abs(this.currentTimeMs - this.lastPurgeTimeMs) > (long)(this.purgeFrequencySeconds * 1000);
    }

    public void setLastPurgeTime(long l) {
        this.lastPurgeTimeMs = l;
    }

    public void setDvrStorageWindowSeconds(int n) {
        this.dvrWindowSizeSeconds = n;
        this.dvrActualSizeSeconds = Math.round((float)n * (1.0f + this.extraDvrStoragePercentage));
    }

    public void setPurgeFrequencySeconds(int n) {
        this.purgeFrequencySeconds = n;
    }

    public long getNextPurgeTime() {
        return this.nextPurgeTimeMs;
    }

    public long getLastPurgeTime() {
        return this.lastPurgeTimeMs;
    }

    public long getCurrentTime() {
        return this.currentTimeMs;
    }

    public String toString() {
        return String.format("[%s window=%d extra=%f windowPlus=%d freq=%d current=%d lastPurge=%d nextPurge=%d", CLASSNAME, this.dvrWindowSizeSeconds, Float.valueOf(this.extraDvrStoragePercentage), this.dvrActualSizeSeconds, this.purgeFrequencySeconds, this.currentTimeMs, this.lastPurgeTimeMs, this.nextPurgeTimeMs);
    }
}

