/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.io.manifest;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.IDvrTextReader;
import com.wowza.wms.dvr.io.DvrTextReaderFactory;
import com.wowza.wms.dvr.io.manifest.DvrManifestHolder;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DvrPrimaryManifestParser {
    private static final Class<DvrPrimaryManifestParser> CLASS = DvrPrimaryManifestParser.class;
    private static final String CLASSNAME = "DvrPrimaryManifestParser";
    protected IDvrStreamStore store;
    protected IApplicationInstance appInstance;
    protected String readerClass = "com.wowza.wms.dvr.impl.io.DvrTextFileReader";
    protected String contextStr = "";

    public DvrPrimaryManifestParser(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance) {
        this.store = iDvrStreamStore;
        this.appInstance = iApplicationInstance;
        if (iApplicationInstance != null) {
            this.contextStr = iApplicationInstance.getContextStr();
        }
    }

    private char[] readManifest(String string) {
        char[] cArray = null;
        try {
            this.readerClass = this.store.getProperties().getPropertyStr("dvrTextReaderClass", this.readerClass);
            IDvrTextReader iDvrTextReader = DvrTextReaderFactory.createInstance(this.appInstance, this.readerClass, this.store.getFileSystem(), string, null);
            if (iDvrTextReader == null) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readManifest[%s]: Reader class '%s' not found.", CLASSNAME, this.contextStr, this.readerClass));
                return null;
            }
            if (!iDvrTextReader.exists()) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readManifest[%s]: File '%s' does not exist.", CLASSNAME, this.contextStr, string));
                return null;
            }
            iDvrTextReader.open();
            cArray = new char[(int)iDvrTextReader.length()];
            int n = iDvrTextReader.read(cArray, 0, cArray.length);
            if (n != cArray.length) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readManifest[%s]: Error reading file: %d != %d ", CLASSNAME, this.contextStr, n, cArray.length));
                return null;
            }
            try {
                iDvrTextReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iDvrTextReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.readManifest: Error reading Manifest file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return cArray;
    }

    public DvrManifestHolder retrieveManifest() {
        DvrManifestHolder dvrManifestHolder = null;
        try {
            char[] cArray = this.readManifest("manifest.txt");
            if (cArray == null) {
                WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveManifest: Error reading Manifest.", CLASSNAME));
                return null;
            }
            dvrManifestHolder = this.parseMainManifest(cArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading Manifest file.", CLASSNAME), exception);
            exception.printStackTrace();
        }
        return dvrManifestHolder;
    }

    protected DvrManifestHolder parseMainManifest(char[] cArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DvrManifestHolder dvrManifestHolder = null;
        String string = "<Root>\n" + new String(cArray) + "\n</Root>\n";
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            NodeList nodeList = document.getElementsByTagName("dvrManifest");
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = Integer.decode(namedNodeMap.getNamedItem("chunkGrouping").getTextContent());
                int n2 = Integer.decode(namedNodeMap.getNamedItem("purgeTime").getTextContent());
                dvrManifestHolder = new DvrManifestHolder(n, n2);
            }
        }
        catch (Exception exception) {
            dvrManifestHolder = null;
        }
        return dvrManifestHolder;
    }
}

