/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.util.SystemUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.HashMap;

public class HTTPClientAccessPolicyHandler {
    public static final int CLIENTACCESSPOLICY_READ_FREQUENCY = 10000;
    private IVHost vhost = null;
    private String clientAccessPolicyPath = "${com.wowza.wms.context.VHostConfigHome}/conf/clientaccesspolicy.xml";
    private boolean clientAccessPolicyResolved = false;
    private long lastclientAccessPolicy = -1L;
    private String clientAccessPolicyStr = null;
    private int readFrequency = 10000;

    public void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public File getClientAccessPolicyFile() {
        if (!this.clientAccessPolicyResolved && this.vhost != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", this.vhost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.vhost.getHomePath());
            this.clientAccessPolicyPath = SystemUtils.expandEnvironmentVariables(this.clientAccessPolicyPath, hashMap);
            this.clientAccessPolicyResolved = true;
        }
        return new File(this.clientAccessPolicyPath);
    }

    public void setProperties(WMSProperties wMSProperties) {
        if (wMSProperties != null) {
            this.clientAccessPolicyPath = wMSProperties.getPropertyStr("ClientAccessPolicyPath", this.clientAccessPolicyPath);
        }
    }

    public boolean isClientAccessPolicyRequest(IVHost iVHost, IHTTPRequest iHTTPRequest) {
        String string = iHTTPRequest.getHeader("context");
        if (string == null) {
            string = "";
        }
        return string.indexOf("clientaccesspolicy.xml") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleClientAccessPolicyRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        if ((this.clientAccessPolicyStr == null || l - this.lastclientAccessPolicy > 10000L) && ((File)(object2 = this.getClientAccessPolicyFile())).exists()) {
            object = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                object = new BufferedReader(new FileReader((File)object2));
                String string = null;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    stringBuffer.append(string + "\n");
                }
                this.clientAccessPolicyStr = stringBuffer.toString();
            }
            catch (Exception exception) {
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.lastclientAccessPolicy = l;
        }
        if (this.clientAccessPolicyStr == null) {
            this.clientAccessPolicyStr = "";
            this.clientAccessPolicyStr = this.clientAccessPolicyStr + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
            this.clientAccessPolicyStr = this.clientAccessPolicyStr + "<access-policy>";
            this.clientAccessPolicyStr = this.clientAccessPolicyStr + "</access-policy>";
        }
        if (this.clientAccessPolicyStr.length() == 0) {
            return false;
        }
        try {
            iHTTPResponse.setHeader("Content-Type", "text/xml");
            iHTTPResponse.setHeader("Cache-Control", "no-cache");
            iHTTPResponse.setHeader("Connection", "Keep-Alive");
            object2 = iHTTPResponse.getOutputStream();
            object = this.clientAccessPolicyStr.getBytes();
            ((OutputStream)object2).write((byte[])object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPClientAccessPolicyHandler.class).error("HTTPClientAccessPolicyHandler.handleClientAccessPolicyRequest: " + exception.toString());
        }
        return true;
    }

    public int getReadFrequency() {
        return this.readFrequency;
    }

    public void setReadFrequency(int n) {
        this.readFrequency = n;
    }
}

