/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.util.SystemUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.HashMap;

public class HTTPCrossdomainHandler {
    public static final int CROSSDOMAIN_READ_FREQUENCY = 10000;
    private IVHost vhost = null;
    private String crossDomainPath = "${com.wowza.wms.context.VHostConfigHome}/conf/crossdomain.xml";
    private boolean crossDomainResolved = false;
    private long lastCrossDomainRead = -1L;
    private String crossDomainStr = null;
    private int readFrequency = 10000;

    public void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public File getCrossdomainFile() {
        if (!this.crossDomainResolved && this.vhost != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", this.vhost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.vhost.getHomePath());
            this.crossDomainPath = SystemUtils.expandEnvironmentVariables(this.crossDomainPath, hashMap);
            this.crossDomainResolved = true;
        }
        return new File(this.crossDomainPath);
    }

    public void setProperties(WMSProperties wMSProperties) {
        if (wMSProperties != null) {
            this.crossDomainPath = wMSProperties.getPropertyStr("crossDomainPath", this.crossDomainPath);
        }
    }

    public boolean isCrossdomainRequest(IVHost iVHost, IHTTPRequest iHTTPRequest) {
        String string = iHTTPRequest.getHeader("context");
        if (string == null) {
            string = "";
        }
        return string.indexOf("crossdomain.xml") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleCrossdomainRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        if ((this.crossDomainStr == null || l - this.lastCrossDomainRead > 10000L) && ((File)(object2 = this.getCrossdomainFile())).exists()) {
            object = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                object = new BufferedReader(new FileReader((File)object2));
                String string = null;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    stringBuffer.append(string + "\n");
                }
                this.crossDomainStr = stringBuffer.toString();
            }
            catch (Exception exception) {
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.lastCrossDomainRead = l;
        }
        if (this.crossDomainStr == null) {
            this.crossDomainStr = "";
            this.crossDomainStr = this.crossDomainStr + "<?xml version=\"1.0\"?>\n";
            this.crossDomainStr = this.crossDomainStr + "<!DOCTYPE cross-domain-policy SYSTEM \"http://www.adobe.com/xml/dtds/cross-domain-policy.dtd\">\n";
            this.crossDomainStr = this.crossDomainStr + "<cross-domain-policy>\n";
            this.crossDomainStr = this.crossDomainStr + "</cross-domain-policy>\n";
        }
        if (this.crossDomainStr.length() == 0) {
            return false;
        }
        try {
            iHTTPResponse.setHeader("Content-Type", "text/xml");
            iHTTPResponse.setHeader("Cache-Control", "no-cache");
            iHTTPResponse.setHeader("Connection", "Keep-Alive");
            object2 = iHTTPResponse.getOutputStream();
            object = this.crossDomainStr.getBytes();
            ((OutputStream)object2).write((byte[])object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPCrossdomainHandler.class).error("HTTPCrossdomainHandler.handleCrossdomainRequest: " + exception.toString());
        }
        return true;
    }

    public int getReadFrequency() {
        return this.readFrequency;
    }

    public void setReadFrequency(int n) {
        this.readFrequency = n;
    }
}

