/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.AuthenticationFactory;
import com.wowza.wms.authentication.IAuthenticate;
import com.wowza.wms.authentication.IAuthenticateHTTPProvider;
import com.wowza.wms.http.IHTTPProvider2;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.List;

public abstract class HTTProvider2Base
implements IHTTPProvider2 {
    protected WMSProperties properties = new WMSProperties();
    protected List<QuickFilter> filters = new ArrayList<QuickFilter>();
    protected String requestFilters = "*";
    protected IAuthenticate authenticateHandler = null;
    protected IAuthenticateHTTPProvider authenticateHTTPProviderHandler = null;
    protected String authenticationMethod = "none";

    public void init() {
        this.initFilters();
    }

    private void initFilters() {
        if (this.requestFilters != null) {
            String[] stringArray = this.requestFilters.split("[|]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (string.length() <= 0) continue;
                this.filters.add(new QuickFilter(string));
            }
        }
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        for (QuickFilter quickFilter : this.filters) {
            if (!quickFilter.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    public String getPath(IHTTPRequest iHTTPRequest, boolean bl) {
        String string = iHTTPRequest.getHeader("context");
        if (string == null) {
            string = "";
        }
        if (bl) {
            for (QuickFilter quickFilter : this.filters) {
                if (!quickFilter.isMatch(string)) continue;
                string = quickFilter.removeFilter(string);
                break;
            }
        }
        return string;
    }

    public void setRequestFilters(String string) {
        this.requestFilters = string;
    }

    public String getRequestFilters() {
        return this.requestFilters;
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.properties.putAll(wMSProperties);
    }

    public void onBind(IVHost iVHost, HostPort hostPort) {
        IAuthenticate iAuthenticate = AuthenticationFactory.createInstance(iVHost, this.authenticationMethod);
        if (iAuthenticate instanceof IAuthenticateHTTPProvider) {
            this.authenticateHTTPProviderHandler = (IAuthenticateHTTPProvider)((Object)iAuthenticate);
        }
    }

    public void onUnbind(IVHost iVHost, HostPort hostPort) {
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String string) {
        this.authenticationMethod = string;
    }

    public boolean doHTTPAuthentication(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        if (this.authenticateHTTPProviderHandler != null) {
            return this.authenticateHTTPProviderHandler.authenticateHTTPProvider(iVHost, iHTTPRequest, iHTTPResponse);
        }
        return true;
    }

    class QuickFilter {
        public static final int FILTER_UNKNOWN = -1;
        public static final int FILTER_STARTSWITH = 1;
        public static final int FILTER_ENDSWITH = 2;
        public static final int FILTER_REGEX = 3;
        public static final int FILTER_MATCHALL = 4;
        private String filter = null;
        private String testStr = null;
        private int filterType = -1;

        public QuickFilter(String string) {
            this.filter = string;
            if (string.equals("*")) {
                this.filterType = 4;
            } else if (string.startsWith("*")) {
                this.filterType = 2;
                this.testStr = this.filter.substring(1);
            } else if (string.endsWith("*")) {
                this.filterType = 1;
                this.testStr = this.filter.substring(0, this.filter.length() - 1);
            } else {
                WMSLoggerFactory.getLogger(HTTProvider2Base.class).warn("HTTProvider2Base.QuickFilter: Cannot handle this filter: " + string);
            }
        }

        boolean isMatch(String string) {
            switch (this.filterType) {
                case 4: {
                    return true;
                }
                case 1: {
                    return string.startsWith(this.testStr);
                }
                case 2: {
                    return string.endsWith(this.testStr);
                }
            }
            return false;
        }

        String removeFilter(String string) {
            switch (this.filterType) {
                case 4: {
                    return string;
                }
                case 1: {
                    return string.substring(this.testStr.length());
                }
                case 2: {
                    return string.substring(0, string.length() - this.testStr.length());
                }
            }
            return string;
        }
    }
}

