/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.model;

import com.wowza.util.BufferUtils;
import com.wowza.wms.media.model.MediaCodecInfoBase;

public class MediaCodecInfoVideo
extends MediaCodecInfoBase {
    protected int videoWidth = 0;
    protected int videoHeight = 0;
    protected int displayWidth = 0;
    protected int displayHeight = 0;
    protected int videoProfile = 0;
    protected int videoLevel = 0;

    public MediaCodecInfoVideo() {
        this.type = 9;
    }

    public void deepCopy(MediaCodecInfoVideo mediaCodecInfoVideo) {
        super.deepCopy(mediaCodecInfoVideo);
        this.videoWidth = mediaCodecInfoVideo.videoWidth;
        this.videoHeight = mediaCodecInfoVideo.videoHeight;
        this.displayWidth = mediaCodecInfoVideo.displayWidth;
        this.displayHeight = mediaCodecInfoVideo.displayHeight;
        this.videoProfile = mediaCodecInfoVideo.videoProfile;
        this.videoLevel = mediaCodecInfoVideo.videoLevel;
    }

    public boolean equals(MediaCodecInfoVideo mediaCodecInfoVideo) {
        return super.equals(mediaCodecInfoVideo) && this.videoWidth == mediaCodecInfoVideo.videoWidth && this.videoHeight == mediaCodecInfoVideo.videoHeight && this.displayWidth == mediaCodecInfoVideo.displayWidth && this.displayHeight == mediaCodecInfoVideo.displayHeight && this.videoProfile == mediaCodecInfoVideo.videoProfile && this.videoLevel == mediaCodecInfoVideo.videoLevel;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.videoWidth;
        n = 31 * n + this.videoHeight;
        n = 31 * n + this.displayWidth;
        n = 31 * n + this.displayHeight;
        n = 31 * n + this.videoProfile;
        n = 31 * n + this.videoLevel;
        return n;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public void setVideoWidth(int n) {
        this.videoWidth = n;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public void setVideoHeight(int n) {
        this.videoHeight = n;
    }

    public int getVideoProfile() {
        return this.videoProfile;
    }

    public void setVideoProfile(int n) {
        this.videoProfile = n;
    }

    public int getVideoLevel() {
        return this.videoLevel;
    }

    public void setVideoLevel(int n) {
        this.videoLevel = n;
    }

    public int getSerializeSize() {
        return super.getSerializeSize() + 24;
    }

    public int serialize(byte[] byArray, int n) {
        n = super.serialize(byArray, n);
        BufferUtils.intToByteArray(this.videoWidth, byArray, n, 4);
        BufferUtils.intToByteArray(this.videoHeight, byArray, n += 4, 4);
        BufferUtils.intToByteArray(this.displayWidth, byArray, n += 4, 4);
        BufferUtils.intToByteArray(this.displayHeight, byArray, n += 4, 4);
        BufferUtils.intToByteArray(this.videoProfile, byArray, n += 4, 4);
        BufferUtils.intToByteArray(this.videoLevel, byArray, n += 4, 4);
        return n += 4;
    }

    public int deserialize(byte[] byArray, int n, int n2) {
        n = super.deserialize(byArray, n, n2);
        this.videoWidth = BufferUtils.byteArrayToInt(byArray, n, 4);
        this.videoHeight = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        this.displayWidth = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        this.displayHeight = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        this.videoProfile = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        this.videoLevel = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
        return n += 4;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int n) {
        this.displayWidth = n;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int n) {
        this.displayHeight = n;
    }

    public String toString() {
        return String.format("[MediaCodecInfoVideo codec=%d vid:%dx%d disp:%dx%d profile=%d level=%d]", this.codecId, this.videoWidth, this.videoHeight, this.displayWidth, this.displayHeight, this.videoProfile, this.videoLevel);
    }
}

