/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.parsers.atom;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.wms.parsers.atom.IAtom;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomBase
implements IAtom {
    private String id;
    private List<IAtom> atoms = new ArrayList<IAtom>();
    private byte[] data;

    public AtomBase(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getDataLen() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public int getChildrenAtomLength() {
        int n = 0;
        for (IAtom iAtom : this.atoms) {
            n += iAtom.getAtomLength();
        }
        return n;
    }

    @Override
    public List<IAtom> getAtoms() {
        return this.atoms;
    }

    @Override
    public void addAtom(IAtom iAtom) {
        this.atoms.add(iAtom);
    }

    @Override
    public IAtom getAtom(String string) {
        for (IAtom iAtom : this.atoms) {
            if (!string.equals(iAtom.getId())) continue;
            return iAtom;
        }
        return null;
    }

    @Override
    public IAtom getAtom(String string, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n == 0) {
            return this.getAtom(string);
        }
        for (IAtom iAtom : this.atoms) {
            if (!string.equals(iAtom.getId()) || n > iAtom.getDataLen() || !BufferUtils.startsWith(iAtom.getData(), byArray)) continue;
            return iAtom;
        }
        return null;
    }

    @Override
    public void removeAtom(String string) {
        int n = -1;
        for (int i = 0; i < this.atoms.size(); ++i) {
            IAtom iAtom = this.atoms.get(i);
            if (!string.equals(iAtom.getId())) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.atoms.remove(n);
        }
    }

    @Override
    public void removeAtom(String string, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        if (n == 0) {
            this.removeAtom(string);
            return;
        }
        int n2 = -1;
        for (int i = 0; i < this.atoms.size(); ++i) {
            IAtom iAtom = this.atoms.get(i);
            if (!string.equals(iAtom.getId()) || n > iAtom.getDataLen() || !BufferUtils.startsWith(iAtom.getData(), byArray)) continue;
            n2 = i;
            break;
        }
        if (n2 != -1) {
            this.atoms.remove(n2);
        }
    }

    public String toString() {
        return String.format("%s (len=%d) data: %s", this.getId(), this.getDataLen(), this.getDebugAtomBytes(this.data));
    }

    protected String getDebugAtomBytes(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        String string = DebugUtils.formatBytes(byArray, 0, Math.min(byArray.length, 16));
        String string2 = string.replaceAll("\n", "");
        return string2;
    }
}

