/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BitWriter;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h263.H263Frame;
import com.wowza.wms.media.h263.H263Utils;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;

public class RTPDePacketizerRFC2190H263
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTPSequence seq = new RTPSequence();
    private RTPPacket workingPacket = null;
    private byte[] workingBuffer = null;
    private BitWriter workingWriter = null;
    private long workingTimecode = -1L;
    private int workingHeaderBits = 0;
    private int workingPictStartCount = 0;
    private H263Frame workingFrame = null;
    private byte[] payloadDescription = null;
    private byte[] avccData = null;
    private Object payloadLock = new Object();
    private long lastTimecode = -1L;
    private long lastSeq = -1L;
    private boolean waitForEnd = false;
    private int waitForDropped = 0;
    private boolean isSendReady = false;
    private int fragmentSize = 0;
    private byte[] fragmentBuffer = null;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RolloverLong timecode = new RolloverLong(32);
    private boolean isCodecConfig = false;
    private long lastSentTimecode = -1L;
    private RTPPacket saveSendPacket = null;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerRFC2190H263.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isVideo() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("h263");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    private RTPPacket getWorkingPacket(long l) {
        if (this.workingPacket == null) {
            this.workingPacket = new RTPPacket();
            this.workingPacket.setType(9);
            this.workingPacket.setCodec(2);
            this.workingPacket.setFrameType(2);
            this.workingPacket.setTimecode(l);
        }
        return this.workingPacket;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        int n4 = rTPTrack.getTimescale();
        this.setVideoCodecId(rTPTrack, 2);
        try {
            int n5 = this.skipRTPExtensions(byArray, n, n2, 12);
            int n6 = 0;
            boolean bl = (byArray[n + n5 + n6] >> 1 & 1) == 1;
            boolean bl2 = (byArray[n + n5 + n6] >> 2 & 1) == 1;
            int n7 = byArray[n + n5 + n6] & 1;
            n7 <<= 5;
            n7 += byArray[n + n5 + ++n6] >> 3 & 0x1F;
            int n8 = byArray[n + n5 + n6] & 7;
            ++n6;
            if (bl) {
                ++n6;
            }
            System.out.println("tc:" + this.timecode.get() + " plen: " + n7 + " peBits:" + n8 + " pictStart:" + bl2 + " len:" + n2 + " seq:" + this.seq.longValue());
            if (this.workingTimecode >= 0L && this.workingTimecode != this.timecode.get()) {
                if (this.workingPacket != null) {
                    boolean bl3 = this.rtcpHandler.isTimeSyncReady(rTPTrack, this.workingPacket.getTimecode());
                    if (!bl3) {
                        if (!bl3) {
                            this.checkRTCPMissingWarning();
                        }
                    } else {
                        long l2 = this.rtcpHandler.convertTimeSyncTimecode(this.workingPacket.getTimecode(), n4);
                        if (this.debugLog) {
                            this.workingPacket.setDebugLog(true);
                        }
                        int n9 = this.workingWriter.count() / 8 + (this.workingWriter.count() % 8 > 0 ? 1 : 0);
                        Object object = new byte[n9 * 2];
                        BitWriter bitWriter = new BitWriter((byte[])object);
                        BitReader bitReader = new BitReader(this.workingBuffer, n9);
                        System.out.println("--------------- SEARCH GOP");
                        do {
                            int n10;
                            int n11 = bitReader.peekInt(17);
                            boolean bl4 = true;
                            if (n11 == 1) {
                                System.out.println("hitGOB: " + bitReader.count());
                                if (bitReader.count() > 0) {
                                    bitReader.skip(17);
                                    n10 = bitReader.getInt(5);
                                    int n12 = bitReader.getInt(2);
                                    int n13 = bitReader.getInt(5);
                                    System.out.println(n10 + ":" + n12 + ":" + n13);
                                    this.workingFrame.qscale = n13;
                                    bl4 = false;
                                }
                            }
                            if (!bl4) continue;
                            n10 = bitReader.getInt(1);
                            bitWriter.putInt(1, n10);
                        } while (bitReader.remaining() > 0);
                        n9 = bitWriter.count() / 8 + (bitWriter.count() % 8 > 0 ? 1 : 0);
                        this.workingBuffer = object;
                        object = new RTPPacketFragment(this.workingBuffer, 0, n9);
                        this.workingPacket.addFragment((RTPPacketFragment)object);
                        System.out.println("send: " + l2 + ":" + this.workingPacket.getSize() + ":" + this.workingPacket.getFrameType());
                        this.workingPacket.write(rTPTrack, l2);
                    }
                }
                this.workingPacket = null;
                this.workingBuffer = null;
                this.workingWriter = null;
            }
            if (this.workingBuffer == null) {
                this.workingBuffer = new byte[65536];
                this.workingWriter = new BitWriter(this.workingBuffer);
                this.workingPacket = this.getWorkingPacket(this.timecode.get());
                this.workingTimecode = this.timecode.get();
                this.workingHeaderBits = 0;
                this.workingPictStartCount = 0;
                this.workingFrame = null;
            }
            BitReader bitReader = new BitReader(byArray, n2 + n);
            bitReader.skip((n + n5 + n6) * 8);
            if (n7 == 0) {
                if (bl2) {
                    ++this.workingPictStartCount;
                    System.out.println(DebugUtils.formatBytes(byArray, n, Math.min(n2, 128)));
                    int n14 = bitReader.count();
                    this.workingFrame = H263Utils.decodeH263Header(bitReader);
                    System.out.println("decodeBits.count: " + (bitReader.count() - (n + n5 + n6) * 8) + ":" + (bitReader.count() - (n + n5 + n6) * 8) % 8);
                    this.workingHeaderBits = bitReader.count() - n14;
                    H263Utils.encodeSorensonSparkHeader(this.workingWriter, this.workingFrame);
                    if (this.workingFrame.frameType == 0) {
                        this.workingPacket.setFrameType(1);
                    }
                    System.out.println("encodeBits.count: " + this.workingWriter.count() + ":" + this.workingWriter.count() % 8);
                }
            } else {
                int n15 = n7 * 8;
                bitReader.skip(n15);
            }
            while (bitReader.remaining() > 0) {
                int n16 = 32;
                if (n16 > bitReader.remaining()) {
                    n16 = bitReader.remaining();
                }
                this.workingWriter.putInt(n16, bitReader.getInt(n16));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("RTPDePacketizerRFC2190H263.handleRTPPacket: " + exception.toString());
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

