/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.module.IModuleOnApp;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.rtp.module.RTPSAPListener;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleRTPManager
extends ModuleBase
implements IModuleOnApp {
    private IApplicationInstance appInstance = null;
    private RTPSAPListener sapListener = null;
    private Map<String, String> rtpSessionNameToSessionId = new HashMap<String, String>();
    private Map<Integer, String> rtpClientIdToSessionName = new HashMap<Integer, String>();
    private Map<String, Integer> rtpSessionNameToClientId = new HashMap<String, Integer>();
    Object rtpLock = new Object();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        ModuleRTPManager.getLogger().info("ModuleRTPManager.onAppStart");
        this.appInstance = iApplicationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        ModuleRTPManager.getLogger().info("ModuleRTPManager.onAppStop");
        if (this.sapListener != null) {
            this.sapListener.quit();
        }
        this.sapListener = null;
        Object object = this.rtpLock;
        synchronized (object) {
            for (String string : this.rtpSessionNameToSessionId.keySet()) {
                this.killRTPSession(string);
            }
            this.rtpSessionNameToSessionId.clear();
        }
    }

    public void startSAPListener(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.sapListener == null) {
            this.sapListener = new RTPSAPListener();
            this.sapListener.setDaemon(true);
            this.sapListener.start();
        } else {
            ModuleRTPManager.getLogger().info("ModuleRTPManager.startMulticast: SAPListener already running.");
        }
    }

    public void stopSAPListener(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.sapListener != null) {
            this.sapListener.quit();
        }
        this.sapListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect(IClient iClient) {
        Object object = this.rtpLock;
        synchronized (object) {
            Integer n = new Integer(iClient.getClientId());
            if (this.rtpClientIdToSessionName.containsKey(n)) {
                String string = this.rtpClientIdToSessionName.get(n);
                this.killRTPSession(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killRTPSession(String string) {
        WMSLogger wMSLogger = ModuleRTPManager.getLogger();
        Object object = this.rtpLock;
        synchronized (object) {
            try {
                String string2 = this.rtpSessionNameToSessionId.remove(string);
                Integer n = this.rtpSessionNameToClientId.remove(string);
                if (n != null) {
                    this.rtpClientIdToSessionName.remove(n);
                }
                if (string2 == null) {
                    wMSLogger.warn("killRTPSession: sessionId not found: sessionName:" + string);
                } else {
                    IVHost iVHost = this.appInstance.getVHost();
                    RTPContext rTPContext = iVHost.getRTPContext();
                    RTPSessions rTPSessions = rTPContext.getSessions();
                    RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
                    RTPSession rTPSession = rTPSessions.getSession(string2);
                    rTPSessions.notifySessionDestroy(rTPSession.getAppInstance(), rTPSession);
                    rTPSessions.removeSession(string2);
                    if (rTPSession == null) {
                        wMSLogger.warn("killRTPSession: Session not found: sessionName:" + string + " sessionId:" + string2);
                    } else {
                        wMSLogger.info("killRTPSession: Shutdown: sessionName:" + string + " sessionId:" + string2);
                        rTPSession.shutdown(rTPRequestStatus);
                    }
                }
            }
            catch (Exception exception) {
                wMSLogger.error("ModuleRTPManager.killRTPSession: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRTPSession(IClient iClient, String string, AMFDataObj aMFDataObj) {
        WMSLogger wMSLogger = ModuleRTPManager.getLogger();
        Object object = this.rtpLock;
        synchronized (object) {
            try {
                Object object2;
                IVHost iVHost = iClient.getVHost();
                RTPContext rTPContext = iVHost.getRTPContext();
                RTPSessions rTPSessions = rTPContext.getSessions();
                String string2 = rTPSessions.getNextSessionId();
                RTPSession rTPSession = new RTPSession(string2);
                rTPSessions.addSession(rTPSession);
                aMFDataObj.put("sessionId", string2);
                String string3 = aMFDataObj.getString("url");
                RTPUrl rTPUrl = new RTPUrl(string3);
                String string4 = rTPUrl.getUrlId();
                String string5 = aMFDataObj.getString("sdp");
                RTPStream rTPStream = RTPUtils.decodeStreamInfo(rTPContext, string4, string5);
                rTPStream.setMode(2);
                rTPSession.addRTSPStream(rTPStream);
                if (rTPStream.getHost() == null) {
                    rTPStream.setHost(rTPUrl.getHost());
                }
                rTPStream.setAppName(rTPUrl.getAppName());
                rTPStream.setAppInstanceName(rTPUrl.getAppInstanceName());
                String string6 = rTPUrl.getQueryStr();
                String string7 = rTPUrl.getStreamName();
                String string8 = "mp4";
                String[] stringArray = ModuleUtils.decodeStreamExtension(string7, string8);
                string7 = stringArray[0];
                string8 = stringArray[1];
                rTPStream.setStreamName(string7);
                rTPStream.setStreamNameLogging(string7);
                rTPStream.setStreamExt(string8);
                rTPStream.setStreamQueryStr(string6);
                rTPSessions.notifySessionCreate(iClient.getAppInstance(), rTPSession);
                RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
                rTPStream.announce(rTPRequestStatus);
                if (aMFDataObj.containsKey("resyncAudioVideoOnSR")) {
                    object2 = aMFDataObj.getString("resyncAudioVideoOnSR");
                    rTPStream.setResyncAudioVideoOnSR(Boolean.parseBoolean((String)object2));
                }
                if (aMFDataObj.containsKey("tracks")) {
                    object2 = (AMFDataMixedArray)aMFDataObj.get("tracks");
                    List list = ((AMFDataObj)object2).getKeys();
                    for (String string9 : list) {
                        String string10;
                        AMFDataObj aMFDataObj2 = ((AMFDataObj)object2).getObject(string9);
                        RTPTrack rTPTrack = rTPStream.getTrack(string9);
                        if (rTPTrack == null) continue;
                        if (!rTPStream.streamExists()) {
                            rTPStream.createStream(rTPRequestStatus);
                        }
                        if (aMFDataObj2.containsKey("samplesPerFrame")) {
                            string10 = aMFDataObj2.getString("samplesPerFrame");
                            rTPTrack.setSamplesPerFrame(Integer.parseInt(string10));
                        }
                        if (aMFDataObj2.containsKey("waitForFirstEnd")) {
                            string10 = aMFDataObj2.getString("waitForFirstEnd");
                            rTPTrack.setWaitForFirstEnd(Boolean.parseBoolean(string10));
                        }
                        string10 = null;
                        if (aMFDataObj2.containsKey("transport")) {
                            string10 = aMFDataObj2.getString("transport");
                        } else {
                            int n = -1;
                            if (aMFDataObj2.containsKey("port")) {
                                n = aMFDataObj2.getInt("port");
                            }
                            if (n >= 0) {
                                n = rTPContext.acquireUDPPortPair(n);
                            }
                            if (n < 0) {
                                n = rTPContext.acquireUDPPortPair();
                            }
                            rTPTrack.setRTPInPortNum(n);
                            rTPTrack.setRTCPInPortNum(n + 1);
                        }
                        rTPTrack.setup(rTPRequestStatus, string10);
                        rTPTrack.play(rTPRequestStatus, false);
                        aMFDataObj2.put("rtpPort", rTPTrack.getRTPInPortNum());
                        aMFDataObj2.put("rtcpPort", rTPTrack.getRTCPInPortNum());
                    }
                }
                rTPStream.record(rTPRequestStatus);
                aMFDataObj.put("responseCode", rTPRequestStatus.getResponseCode());
                aMFDataObj.put("responseMessage", rTPRequestStatus.getResponseMessage());
                wMSLogger.info("addRTPSession: Setup: sessionName:" + string + " sessionId:" + string2);
                object2 = new Integer(iClient.getClientId());
                this.rtpSessionNameToSessionId.put(string, string2);
                this.rtpClientIdToSessionName.put((Integer)object2, string);
                this.rtpSessionNameToClientId.put(string, (Integer)object2);
            }
            catch (Exception exception) {
                wMSLogger.error("ModuleRTPManager.addRTPSession: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupRTPChannel(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        AMFDataObj aMFDataObj = aMFDataList.getObject(4);
        WMSLogger wMSLogger = ModuleRTPManager.getLogger();
        Object object = this.rtpLock;
        synchronized (object) {
            if (this.rtpSessionNameToSessionId.containsKey(string)) {
                this.killRTPSession(string);
            }
            this.addRTPSession(iClient, string, aMFDataObj);
        }
        ModuleRTPManager.sendResult(iClient, aMFDataList, aMFDataObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void teardownRTPChannel(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        WMSLogger wMSLogger = ModuleRTPManager.getLogger();
        Object object = this.rtpLock;
        synchronized (object) {
            if (this.rtpSessionNameToSessionId.containsKey(string)) {
                this.killRTPSession(string);
            }
        }
    }
}

