/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.module;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;

public class RTPSAPListener
extends Thread {
    private int port = 9875;
    private String group = "224.2.127.254";
    private boolean running = true;
    private boolean quit = false;
    private int timeout = 100;
    private int receiveBufferSize = 65000;
    private boolean reuseAddress = false;
    private MulticastSocket multicastSocket = null;
    private DatagramPacket multicastPacket = null;

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void quit() {
        this.quit = true;
        if (this.multicastSocket == null) {
            this.multicastSocket.close();
        }
    }

    private void init() {
        try {
            byte[] byArray = new byte[this.receiveBufferSize];
            this.multicastPacket = new DatagramPacket(byArray, byArray.length);
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.setSoTimeout(this.timeout);
            this.multicastSocket.setReceiveBufferSize(this.receiveBufferSize);
            this.multicastSocket.setReuseAddress(this.reuseAddress);
            this.multicastSocket.joinGroup(InetAddress.getByName(this.group));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSAPListener.class).error("RTPSAPListener.run: create MulticastSocket: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        WMSLoggerFactory.getLogger(RTPSAPListener.class).info("RTPSAPListener.run(start): " + this.group + ":" + this.port);
        this.init();
        while (true) {
            Object object;
            if (this.multicastSocket == null) {
                object = this;
                synchronized (object) {
                    this.running = false;
                    break;
                }
            }
            try {
                this.multicastSocket.receive(this.multicastPacket);
                if (this.multicastPacket.getLength() > 0) {
                    object = this.multicastPacket.getData();
                    int n = this.multicastPacket.getLength();
                    System.out.println("sap[" + n + "]\n" + DebugUtils.formatBytes((byte[])object, 0, n));
                    if (n > 8) {
                        int n2 = BufferUtils.byteArrayToInt((byte[])object, 1, 2);
                        int n3 = 8 + n2;
                        byte[] byArray = new byte[n - n3];
                        System.arraycopy(object, n3, byArray, 0, byArray.length);
                        String string = new String(byArray, "UTF-8");
                        System.out.println(string);
                    }
                }
                object = this;
                synchronized (object) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                    continue;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                RTPSAPListener rTPSAPListener = this;
                synchronized (rTPSAPListener) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPSAPListener.class).error("RTPSAPListener.run: " + exception.toString());
                this.running = false;
            }
            break;
        }
        WMSLoggerFactory.getLogger(RTPSAPListener.class).info("RTPSAPListener.run(stop)");
    }
}

