/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.IRTPPacketizerRTCPSender;
import com.wowza.wms.rtp.packetizer.RTPPacketizerRTCPSenderFactory;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class RTPPacketizerBase
implements IRTPPacketizer {
    public static final int RTPHEADERSIZE = 12;
    public static final int UDPOVERHEAD = 28;
    protected List<PendingBlock> pendingBlocks = new ArrayList<PendingBlock>();
    protected long sequence = 0L;
    protected IRTPPacketizerRTCPSender rtcpSender = null;
    protected AtomicLong packetCount = new AtomicLong();
    protected AtomicLong byteCount = new AtomicLong();
    protected boolean isRTPWrapped = false;
    protected String baseType = "ukn";
    protected int sdpTypeId = 0;

    public void init(IApplicationInstance iApplicationInstance, RTPSession rTPSession) {
        this.rtcpSender = RTPPacketizerRTCPSenderFactory.getInstance(iApplicationInstance, rTPSession, this);
    }

    protected void addPendingBlock(PendingBlock pendingBlock) {
        this.pendingBlocks.add(pendingBlock);
    }

    protected void fillHeader(byte[] byArray, boolean bl, long l, long l2, long l3, int n) {
        byArray[0] = -128;
        byArray[1] = (byte)((bl ? 128 : 0) + n);
        BufferUtils.longToByteArray(l, byArray, 2, 2);
        BufferUtils.longToByteArray(l2, byArray, 4, 4);
        BufferUtils.longToByteArray(l3, byArray, 8, 4);
    }

    public long getPacketCount() {
        return this.packetCount.get();
    }

    public long getByteCount() {
        return this.byteCount.get();
    }

    public long getRTCPOctetCount() {
        return this.byteCount.get() - this.packetCount.get() * 12L;
    }

    protected int writePendingBlocks(OutputStream outputStream, RTPTrack rTPTrack, int n) {
        int n2;
        block1: {
            n2 = 0;
            int n3 = this.pendingBlocks.size();
            long l = rTPTrack.getSSRC();
            if (n3 <= 0) break block1;
            for (int i = 0; i < n3; ++i) {
                PendingBlock pendingBlock = this.pendingBlocks.get(i);
                ++this.sequence;
                this.fillHeader(pendingBlock.block, i == n3 - 1, this.sequence, pendingBlock.timecode, l, n);
                rTPTrack.sendRTPMessage(outputStream, pendingBlock.block, 0, pendingBlock.size);
                n2 += pendingBlock.size;
                this.packetCount.incrementAndGet();
                this.byteCount.addAndGet(pendingBlock.size);
            }
            this.pendingBlocks.clear();
        }
        return n2;
    }

    public boolean isRTPWrapped() {
        return this.isRTPWrapped;
    }

    public void setRTPWrapped(boolean bl) {
        this.isRTPWrapped = bl;
    }

    public void resetSequence() {
        this.sequence = 0L;
    }

    public int getNextSequence() {
        return (int)(this.sequence + 1L & 0xFFFFL);
    }

    public void extractStreamInfo(RTPTrack rTPTrack, AMFPacket aMFPacket, AMFPacket aMFPacket2) {
    }

    public int getSDPTypeId() {
        return this.sdpTypeId;
    }

    public void setSDPTypeId(int n) {
        this.sdpTypeId = n;
    }

    protected class PendingBlock {
        byte[] block = null;
        int size = 0;
        long timecode = 0L;

        public PendingBlock(byte[] byArray, int n, long l) {
            this.block = byArray;
            this.size = n;
            this.timecode = l;
        }
    }
}

