/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerMPEG4AAC
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    protected int maxPacketSize = 1360;
    protected List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    protected int maxAudioGroupSize = 4;
    protected int pendingCount = 0;
    protected int pendingSize = 0;
    protected long pendingTimecode = -1L;
    protected int timescale = -1;
    protected int channels = -1;
    protected int sampleCount = 1024;
    protected long lastTimecode = -1L;
    protected int lastAACSampleRate = -1;
    protected long lastAACTimecode = -1L;

    public RTPPacketizerMPEG4AAC() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 96;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 4) {
                int n2 = aMFPacket.getFirstByte();
                int n3 = aMFPacket.getSecondByte();
                int n4 = FLVUtils.getAudioCodec(n2);
                if (!FLVUtils.isAudioCodecConfig(aMFPacket)) {
                    AACFrame aACFrame;
                    AMFPacket aMFPacket2;
                    if (this.timescale < 0 && (aMFPacket2 = iMediaStream.getAudioCodecConfigPacket(l)) != null && aMFPacket2.getSize() >= 4 && (aACFrame = AACUtils.decodeAACCodecConfig(aMFPacket2.getData(), 2)) != null) {
                        this.timescale = aACFrame.getSampleRate();
                        this.channels = aACFrame.getChannels();
                        this.sampleCount = aACFrame.getSampleCount();
                    }
                    if (this.timescale > 0) {
                        int n5;
                        long l2 = Math.round((double)(l * (long)this.timescale) / 1000.0);
                        if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.timescale) {
                            this.lastAACSampleRate = this.timescale;
                            this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                        } else {
                            long l3 = this.lastAACTimecode + (long)this.sampleCount;
                            long l4 = Math.round((double)l3 * 1000.0 / (double)this.lastAACSampleRate);
                            n5 = (int)Math.abs(l4 - l);
                            if (n5 <= 1) {
                                l2 = l3;
                                this.lastAACTimecode = l3;
                            } else {
                                this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                            }
                        }
                        byte[] byArray = aMFPacket.getData();
                        int n6 = 2;
                        int n7 = aMFPacket.getSize() - n6;
                        int n8 = n7 << 3;
                        n5 = 4 + n7;
                        if (n5 > this.maxPacketSize) {
                            int n9;
                            this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
                            n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                            this.pendingCount = 0;
                            this.pendingSize = 0;
                            this.pendingTimecode = -1L;
                            int n10 = this.maxPacketSize - 2 - 2;
                            int n11 = n7 / n10 + (n7 % n10 > 0 ? 1 : 0);
                            int n12 = n7 / n11 + (n7 % n11 > 0 ? 1 : 0);
                            int n13 = 0;
                            int n14 = 0;
                            do {
                                if (n13 + (n9 = n12) > n7) {
                                    n9 = n7 - n13;
                                }
                                int n15 = 16 + n9;
                                byte[] byArray2 = new byte[n15];
                                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n15, l * (long)this.timescale / 1000L));
                                BufferUtils.intToByteArray(16, byArray2, 12, 2);
                                BufferUtils.intToByteArray(n8, byArray2, 14, 2);
                                System.arraycopy(byArray, n6 + n13, byArray2, 16, n9);
                                ++n14;
                            } while ((n13 += n9) < n7);
                            n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                        } else {
                            int n16 = 2 + 2 * (this.pendingCount + 1) + (this.pendingSize + n7);
                            if (this.pendingCount >= this.maxAudioGroupSize || n16 > this.maxPacketSize) {
                                this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
                                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                                this.pendingCount = 0;
                                this.pendingSize = 0;
                                this.pendingTimecode = -1L;
                            }
                            this.pendingFragments.add(new RTPPacketFragment(byArray, n6, n7));
                            ++this.pendingCount;
                            this.pendingSize += n7;
                            if (this.pendingTimecode < 0L) {
                                this.pendingTimecode = l2;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    private void flushPending(OutputStream outputStream, int n, int n2, long l) {
        block2: {
            RTPPacketFragment rTPPacketFragment;
            int n3;
            int n4 = this.pendingFragments.size();
            if (n4 <= 0) break block2;
            int n5 = 14 + 2 * n + n2;
            byte[] byArray = new byte[n5];
            this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n5, l));
            int n6 = 0;
            BufferUtils.intToByteArray(2 * n * 8, byArray, 12 + n6, 2);
            n6 += 2;
            for (n3 = 0; n3 < n4; ++n3) {
                rTPPacketFragment = this.pendingFragments.get(n3);
                int n7 = rTPPacketFragment.getLen() << 3;
                BufferUtils.intToByteArray(n7, byArray, 12 + n6, 2);
                n6 += 2;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                rTPPacketFragment = this.pendingFragments.get(n3);
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12 + n6, rTPPacketFragment.getLen());
                n6 += rTPPacketFragment.getLen();
            }
            this.pendingFragments.clear();
        }
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        int n = 0;
        if (this.pendingCount > 0) {
            this.flushPending(outputStream, this.pendingCount, this.pendingSize, this.pendingTimecode);
            n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
            this.pendingCount = 0;
            this.pendingSize = 0;
            this.pendingTimecode = -1L;
        }
        return n;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 0;
        this.timescale = n2;
        try {
            long l = aMFPacket == null ? 0L : aMFPacket.getAbsTimecode();
            byte[] byArray = new byte[1];
            if (aMFPacket2 != null && aMFPacket2.getSize() >= 4) {
                byArray = new byte[aMFPacket2.getSize() - 2];
                System.arraycopy(aMFPacket2.getData(), 2, byArray, 0, byArray.length);
                AACFrame aACFrame = AACUtils.decodeAACCodecConfig(byArray, 0);
                if (aACFrame != null) {
                    if (this.timescale <= 0) {
                        this.timescale = aACFrame.getSampleRate();
                    }
                    this.channels = aACFrame.getChannels();
                }
            }
            stringBuffer.append("a=rtpmap:" + this.sdpTypeId + " mpeg4-generic/" + this.timescale + "/" + this.channels + "\r\n");
            stringBuffer.append("a=fmtp:" + this.sdpTypeId + " profile-level-id=1;mode=AAC-hbr;sizelength=13;indexlength=3;indexdeltalength=3;config=" + BufferUtils.encodeHexString(byArray) + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(this.timescale);
        rTPDescribeInfo.setChannels(this.channels);
        rTPDescribeInfo.setSDPTypeId(this.sdpTypeId);
        return rTPDescribeInfo;
    }

    public int getMaxAudioGroupSize() {
        return this.maxAudioGroupSize;
    }

    public void setMaxAudioGroupSize(int n) {
        this.maxAudioGroupSize = n;
    }
}

