/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class RTPPacketizerRFC2250MP3
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    protected int maxPacketSize = 1360;
    protected List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    protected int timescale = -1;
    protected int channels = -1;

    public RTPPacketizerRFC2250MP3() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 14;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            int n2;
            int n3;
            if (aMFPacket.getSize() >= 2 && (n3 = FLVUtils.getAudioCodec(n2 = aMFPacket.getFirstByte())) == 2) {
                int n4;
                byte[] byArray = aMFPacket.getData();
                int n5 = 1;
                int n6 = aMFPacket.getSize() - n5;
                int n7 = rTPTrack.getTimescale();
                int n8 = 0;
                do {
                    if ((n4 = this.maxPacketSize - 4) > n6 - n8) {
                        n4 = n6 - n8;
                    }
                    int n9 = 16 + n4;
                    byte[] byArray2 = new byte[n9];
                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n9, l * (long)n7 / 1000L));
                    BufferUtils.intToByteArray(n8, byArray2, 2, 2);
                    System.arraycopy(byArray, n5 + n8, byArray2, 16, n4);
                } while ((n8 += n4) < n6);
                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerRFC2250MP3.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 0;
        this.timescale = n2;
        try {
            if (aMFPacket != null) {
                object = aMFPacket.getData();
                int n3 = 1;
                int n4 = aMFPacket.getSize() - n3;
                byte[] byArray = new byte[4];
                System.arraycopy(object, n3, byArray, 0, byArray.length);
                MP3HeaderData mP3HeaderData = new MP3HeaderData();
                int n5 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])byArray, (MP3HeaderData)mP3HeaderData);
                if (n5 != 0) {
                    MP3BufferedDecoder.decodeHeader((int)n5, (int)0, (MP3HeaderData)mP3HeaderData);
                    if (this.timescale <= 0) {
                        this.timescale = MP3BufferedDecoder.frequency((MP3HeaderData)mP3HeaderData);
                    }
                    this.channels = 0;
                    switch (mP3HeaderData.h_mode) {
                        case 0: {
                            this.channels = 2;
                            break;
                        }
                        case 1: {
                            this.channels = 2;
                            break;
                        }
                        case 2: {
                            this.channels = 2;
                            break;
                        }
                        case 3: {
                            this.channels = 1;
                        }
                    }
                }
            }
            stringBuffer.append("a=rtpmap:" + this.sdpTypeId + " MPA/" + this.timescale + "/" + this.channels + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC2250MP3.class).error("RTPPacketizerRFC2250MP3.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(this.timescale);
        ((RTPDescribeInfo)object).setChannels(this.channels);
        ((RTPDescribeInfo)object).setSDPTypeId(this.sdpTypeId);
        return object;
    }
}

