/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerRFC3984H264
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    protected int maxPacketSize = 1360;
    protected List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    protected boolean isBalanced = true;
    protected int pendingCount = 0;
    protected int pendingSize = 0;
    protected long lastTimecode = -1L;
    protected boolean singleOptimization = true;
    protected boolean inited = false;

    public RTPPacketizerRFC3984H264() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 97;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        if (!this.inited) {
            WMSProperties wMSProperties;
            if (iMediaStream != null && (wMSProperties = iMediaStream.getProperties()) != null) {
                this.singleOptimization = wMSProperties.getPropertyBoolean("rfc3984H264SingleOptimization", this.singleOptimization);
            }
            this.inited = true;
        }
        if (this.singleOptimization) {
            return this.handleAMFPacketSingleOptimization(outputStream, iMediaStream, rTPTrack, aMFPacket, l);
        }
        return this.handleAMFPacketMultiOptimization(outputStream, iMediaStream, rTPTrack, aMFPacket, l);
    }

    public int handleAMFPacketMultiOptimization(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 9) {
                int n2 = aMFPacket.getFirstByte();
                int n3 = aMFPacket.getSecondByte();
                int n4 = FLVUtils.getVideoCodec(n2);
                if (!FLVUtils.isVideoCodecConfig(aMFPacket)) {
                    long l2;
                    byte[] byArray = aMFPacket.getData();
                    int n5 = aMFPacket.getSize();
                    int n6 = rTPTrack.getTimescale();
                    int n7 = BufferUtils.byteArrayToInt(byArray, 2, 3);
                    if ((n7 & 0x800000) == 0x800000) {
                        n7 |= 0xFF000000;
                    }
                    this.lastTimecode = l2 = (l + (long)n7) * (long)n6 / 1000L;
                    int n8 = 5;
                    while (n8 + 4 <= n5) {
                        int n9;
                        int n10 = BufferUtils.byteArrayToInt(byArray, n8, 4);
                        if (n10 <= 0 || (n8 += 4) + n10 > n5) break;
                        if (n10 > this.maxPacketSize) {
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            if (this.pendingCount > 0) {
                                this.flushPending(outputStream, this.pendingCount, this.pendingSize, l2);
                                this.pendingCount = 0;
                                this.pendingSize = 0;
                            }
                            if (this.isBalanced) {
                                int n15;
                                n9 = (n10 - 1) / (this.maxPacketSize - 2) + ((n10 - 1) % (this.maxPacketSize - 2) > 0 ? 1 : 0);
                                n14 = (n10 - 1) / n9 + ((n10 - 1) % n9 > 0 ? 1 : 0);
                                n13 = 1;
                                n12 = byArray[n8];
                                n11 = 0;
                                do {
                                    if (n13 + (n15 = n14) > n10) {
                                        n15 = n10 - n13;
                                    }
                                    int n16 = 14 + n15;
                                    byte[] byArray2 = new byte[n16];
                                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n16, l2));
                                    byArray2[12] = (byte)((n12 & 0xE0) + 28);
                                    byArray2[13] = (byte)((n11 == 0 ? 128 : 0) + (n13 + n15 == n10 ? 64 : 0) + (n12 & 0x1F));
                                    System.arraycopy(byArray, n8 + n13, byArray2, 14, n15);
                                    ++n11;
                                } while ((n13 += n15) < n10);
                            } else {
                                n9 = 1;
                                n14 = byArray[n8];
                                n13 = 0;
                                do {
                                    if (n9 + (n12 = this.maxPacketSize - 2) > n10) {
                                        n12 = n10 - n9;
                                    }
                                    n11 = 14 + n12;
                                    byte[] byArray3 = new byte[n11];
                                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n11, l2));
                                    byArray3[12] = (byte)((n14 & 0xE0) + 28);
                                    byArray3[13] = (byte)((n13 == 0 ? 128 : 0) + (n9 + n12 == n10 ? 64 : 0) + (n14 & 0x1F));
                                    System.arraycopy(byArray, n8 + n9, byArray3, 14, n12);
                                    ++n13;
                                } while ((n9 += n12) < n10);
                            }
                        } else {
                            n9 = 1 + 2 * (this.pendingCount + 1) + (this.pendingSize + n10);
                            if (n9 > this.maxPacketSize) {
                                this.flushPending(outputStream, this.pendingCount, this.pendingSize, l2);
                                this.pendingCount = 0;
                                this.pendingSize = 0;
                            }
                            this.pendingFragments.add(new RTPPacketFragment(byArray, n8, n10));
                            ++this.pendingCount;
                            this.pendingSize += n10;
                        }
                        if ((n8 += n10) < n5) continue;
                        break;
                    }
                    if (this.pendingCount > 0) {
                        this.flushPending(outputStream, this.pendingCount, this.pendingSize, l2);
                        this.pendingCount = 0;
                        this.pendingSize = 0;
                    }
                    n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC3984H264.class).error("RTPPacketizerRFC3984H264.handleAMFPacketMultiOptimization: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    private void flushPending(OutputStream outputStream, int n, int n2, long l) {
        int n3 = this.pendingFragments.size();
        if (n3 > 0) {
            if (n3 == 1) {
                RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                int n4 = 12 + rTPPacketFragment.getLen();
                byte[] byArray = new byte[n4];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n4, l));
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12, rTPPacketFragment.getLen());
            } else {
                int n5 = 13 + 2 * n + n2;
                byte[] byArray = new byte[n5];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n5, l));
                byArray[12] = 24;
                int n6 = 1;
                while (n3 > 0) {
                    RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                    BufferUtils.intToByteArray(rTPPacketFragment.getLen(), byArray, 12 + n6, 2);
                    System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12 + (n6 += 2), rTPPacketFragment.getLen());
                    n6 += rTPPacketFragment.getLen();
                    --n3;
                }
            }
        }
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 <= 0) {
            n2 = 90000;
        }
        try {
            RTPStream rTPStream;
            Object object2;
            Object object3;
            int n3;
            long l;
            IApplicationInstance iApplicationInstance;
            RTPStream rTPStream2;
            object = "packetization-mode=1";
            String string = null;
            Object object4 = null;
            double d = 0.0;
            boolean bl = false;
            if (rTPTrack != null && (rTPStream2 = rTPTrack.getRTPStream()) != null && (iApplicationInstance = rTPStream2.getAppInstance()) != null) {
                bl = iApplicationInstance.getRTPProperties().getPropertyBoolean("rtpUseDisplaySize", bl);
            }
            long l2 = l = aMFPacket == null ? 0L : aMFPacket.getAbsTimecode();
            if (aMFPacket2 != null && aMFPacket2.getSize() >= 7) {
                n3 = 5;
                object3 = H264Utils.breakApartAVCC(aMFPacket2.getData(), n3, aMFPacket2.getSize() - n3);
                if (object3 != null) {
                    String string2;
                    try {
                        object2 = H264Utils.decodeAVCC(aMFPacket2.getData(), n3);
                        if (object2 != null) {
                            d = ((H264CodecConfigInfo)object2).frameRate;
                            if (bl) {
                                string = ((H264CodecConfigInfo)object2).displayWidth + "-" + ((H264CodecConfigInfo)object2).displayHeight;
                                object4 = "0,0," + ((H264CodecConfigInfo)object2).displayHeight + "," + ((H264CodecConfigInfo)object2).displayWidth;
                            } else {
                                string = ((H264CodecConfigInfo)object2).width + "-" + ((H264CodecConfigInfo)object2).height;
                                object4 = "0,0," + ((H264CodecConfigInfo)object2).height + "," + ((H264CodecConfigInfo)object2).width;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object2 = ((H264CodecConfigParts)object3).getProfileLevelIdStr();
                    if (((String)object2).length() > 0) {
                        object = (String)object + ";profile-level-id=" + ((String)object2).toUpperCase();
                    }
                    if ((string2 = ((H264CodecConfigParts)object3).getSpropParameterSetsStr()).length() > 0) {
                        object = (String)object + ";sprop-parameter-sets=" + string2;
                    }
                }
            }
            if ((object4 == null || string == null) && iMediaStream != null && (rTPStream = iMediaStream.getRTPStream()) != null && (object3 = rTPStream.getVideoTrack()) != null) {
                if (object4 == null && (object2 = ((RTPTrack)object3).getTrackInfo("cliprect")) != null) {
                    object4 = object2;
                }
                if (string == null) {
                    int n4 = ((RTPTrack)object3).getFrameWidth();
                    int n5 = ((RTPTrack)object3).getFrameHeight();
                    if (bl) {
                        n4 = ((RTPTrack)object3).getDisplayWidth();
                        n5 = ((RTPTrack)object3).getDisplayHeight();
                    }
                    if (n4 > 0 && n5 > 0) {
                        string = n4 + "-" + n5;
                    }
                }
            }
            n3 = this.sdpTypeId;
            stringBuffer.append("a=rtpmap:" + n3 + " H264/" + n2 + "\r\n");
            stringBuffer.append("a=fmtp:" + n3 + " " + (String)object + "\r\n");
            if (object4 != null) {
                stringBuffer.append("a=cliprect:" + (String)object4 + "\r\n");
            }
            if (string != null) {
                stringBuffer.append("a=framesize:" + n3 + " " + string + "\r\n");
            }
            if (d > 0.0) {
                stringBuffer.append("a=framerate:" + d + "\r\n");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(n2);
        ((RTPDescribeInfo)object).setSDPTypeId(this.sdpTypeId);
        return object;
    }

    public int handleAMFPacketSingleOptimization(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n;
        block13: {
            n = 0;
            n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
            try {
                int n2;
                long l2;
                if (aMFPacket.getSize() < 9 || FLVUtils.isVideoCodecConfig(aMFPacket)) break block13;
                byte[] byArray = aMFPacket.getData();
                int n3 = aMFPacket.getSize();
                int n4 = rTPTrack.getTimescale();
                int n5 = BufferUtils.byteArrayToInt(byArray, 2, 3);
                if ((n5 & 0x800000) == 0x800000) {
                    n5 |= 0xFF000000;
                }
                this.lastTimecode = l2 = (l + (long)n5) * (long)n4 / 1000L;
                int n6 = 0;
                int n7 = 0;
                boolean bl = false;
                int n8 = 5;
                while (n8 + 4 <= n3) {
                    n2 = BufferUtils.byteArrayToInt(byArray, n8, 4);
                    if (n2 <= 0 || (n8 += 4) + n2 > n3) break;
                    ++n6;
                    n7 += 2 + n2;
                    if (n2 > this.maxPacketSize) {
                        bl = true;
                    }
                    if ((n8 += n2) < n3) continue;
                    break;
                }
                if (!bl && n6 > 1 && ++n7 <= this.maxPacketSize) {
                    n2 = 12 + n7;
                    byte[] byArray2 = new byte[n2];
                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n2, l2));
                    int n9 = 0;
                    byArray2[12 + n9] = 24;
                    ++n9;
                    n8 = 5;
                    while (n8 + 4 <= n3) {
                        int n10 = BufferUtils.byteArrayToInt(byArray, n8, 4);
                        if (n10 <= 0 || (n8 += 4) + n10 > n3) break;
                        BufferUtils.intToByteArray(n10, byArray2, 12 + n9, 2);
                        System.arraycopy(byArray, n8, byArray2, 12 + (n9 += 2), n10);
                        n9 += n10;
                        if ((n8 += n10) < n3) continue;
                        break;
                    }
                } else {
                    n8 = 5;
                    while (n8 + 4 <= n3) {
                        int n11;
                        n2 = BufferUtils.byteArrayToInt(byArray, n8, 4);
                        if (n2 <= 0 || (n8 += 4) + n2 > n3) break;
                        if (n2 <= this.maxPacketSize) {
                            n11 = 12 + n2;
                            byte[] byArray3 = new byte[n11];
                            this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n11, l2));
                            System.arraycopy(byArray, n8, byArray3, 12, n2);
                        } else {
                            int n12;
                            n11 = 1;
                            byte by = byArray[n8];
                            int n13 = 0;
                            do {
                                if (n11 + (n12 = this.maxPacketSize - 2) > n2) {
                                    n12 = n2 - n11;
                                }
                                int n14 = 14 + n12;
                                byte[] byArray4 = new byte[n14];
                                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray4, n14, l2));
                                byArray4[12] = (byte)(by & 0xE0 | 0x1C);
                                byArray4[13] = (byte)((n13 == 0 ? 128 : 0) | (n11 + n12 >= n2 ? 64 : 0) | by & 0x1F);
                                System.arraycopy(byArray, n8 + n11, byArray4, 14, n12);
                                ++n13;
                            } while ((n11 += n12) < n2);
                        }
                        if ((n8 += n2) < n3) continue;
                        break;
                    }
                }
                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPPacketizerRFC3984H264.class).error("RTPPacketizerRFC3984H264.handleAMFPacketSingleOptimization: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return n;
    }
}

