/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransportSession;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.RTPUDPTransportMinaSession;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPUDPHandler
extends IoHandlerAdapter {
    public static final String TRANSPORTSESSION = "RTPTRANSPORTSESSION";
    private IUDPMessageHandler handler = null;
    private AtomicLong packetCount = new AtomicLong();
    private InetSocketAddress bindAddress = null;
    private Object lock = new Object();
    private boolean debugLog = false;
    private IoSession session = null;
    private boolean isActive = true;
    private RTPContext rtpContext = null;
    private List<IoSession> activeSessions = new ArrayList<IoSession>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPUDPHandler(IUDPMessageHandler iUDPMessageHandler, InetSocketAddress inetSocketAddress, RTPContext rTPContext) {
        this.debugLog = WMSLoggerFactory.getLogger(RTPUDPHandler.class).isDebugEnabled();
        Object object = this.lock;
        synchronized (object) {
            this.handler = iUDPMessageHandler;
        }
        this.bindAddress = inetSocketAddress;
        this.rtpContext = rTPContext;
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(RTPUDPHandler.class).info("IN: UDPHandler: create: " + iUDPMessageHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession getSession() {
        IoSession ioSession = null;
        Object object = this.lock;
        synchronized (object) {
            ioSession = this.session;
        }
        return ioSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(IoSession ioSession) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.isActive) {
                this.session = ioSession;
            } else {
                bl = true;
            }
            this.activeSessions.add(ioSession);
        }
        if (bl && this.rtpContext != null) {
            this.rtpContext.getUDPTransportManager().killSession(ioSession);
        }
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(RTPUDPHandler.class).info("IN: UDPHandler: sessionCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionOpened(IoSession ioSession) {
        IUDPMessageHandler iUDPMessageHandler = null;
        Object object = this.lock;
        synchronized (object) {
            iUDPMessageHandler = this.handler;
        }
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(RTPUDPHandler.class).info("IN: UDPHandler: sessionOpened: " + iUDPMessageHandler);
        }
        if (iUDPMessageHandler != null) {
            object = new RTPUDPTransportMinaSession();
            ((RTPUDPTransportMinaSession)object).init(ioSession);
            ioSession.setAttribute(TRANSPORTSESSION, object);
            iUDPMessageHandler.sessionOpened((IUDPTransportSession)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession ioSession) throws Exception {
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(RTPUDPHandler.class).info("IN: UDPHandler: sessionClosed");
        }
        IUDPMessageHandler iUDPMessageHandler = null;
        Object object = this.lock;
        synchronized (object) {
            iUDPMessageHandler = this.handler;
            this.isActive = false;
            this.session = null;
            this.activeSessions.remove(ioSession);
        }
        if (iUDPMessageHandler != null && (object = (RTPUDPTransportMinaSession)ioSession.getAttribute(TRANSPORTSESSION)) != null) {
            iUDPMessageHandler.sessionClosed((IUDPTransportSession)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IoSession> getActiveSessions() {
        ArrayList<IoSession> arrayList = new ArrayList<IoSession>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.activeSessions);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession unbind() {
        IoSession ioSession = null;
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(RTPUDPHandler.class).info("IN: UDPHandler: unbind");
        }
        Object object = this.lock;
        synchronized (object) {
            ioSession = this.session;
            this.handler = null;
            this.isActive = false;
            this.session = null;
        }
        return ioSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession ioSession, Object object) {
        IUDPMessageHandler iUDPMessageHandler = null;
        Object object2 = this.lock;
        synchronized (object2) {
            iUDPMessageHandler = this.handler;
        }
        if (iUDPMessageHandler != null) {
            object2 = null;
            if (ioSession instanceof DatagramSessionImpl) {
                object2 = ((DatagramSessionImpl)ioSession).getRemoteAddress();
            }
            iUDPMessageHandler.handleMessage((SocketAddress)object2, object);
            long l = this.packetCount.incrementAndGet();
            if (l == 1L) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("UDPTransport.firstPacket: bind:" + this.bindAddress + " msg:" + (object2 == null ? "null" : object2.toString()));
            }
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(RTPUDPHandler.class).debug("IN: UDPHandler: exceptionCaught: " + throwable.toString() + ": " + (throwable.getCause() != null ? throwable.getCause().toString() : "unknown"));
        }
    }
}

