/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.server.CommandInterfaceResponseMessage;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.mina.util.CharsetUtil;

public class CommandInterfaceRequestEncoder
implements MessageEncoder {
    private static final Set TYPES;
    private static final byte[] CRLF;

    public Set getMessageTypes() {
        return TYPES;
    }

    public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        CharsetEncoder charsetEncoder = CharsetUtil.getDefaultCharset().newEncoder();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)1024);
        byteBuffer.setAutoExpand(true);
        CommandInterfaceResponseMessage commandInterfaceResponseMessage = (CommandInterfaceResponseMessage)object;
        byteBuffer.putString((CharSequence)(commandInterfaceResponseMessage.getProtocolStr() + " "), charsetEncoder);
        byteBuffer.putString((CharSequence)String.valueOf(commandInterfaceResponseMessage.getResponseCode()), charsetEncoder);
        byteBuffer.putString((CharSequence)(" " + HTTPUtils.statusCodeToStr(commandInterfaceResponseMessage.getResponseCode())), charsetEncoder);
        byteBuffer.put(CRLF);
        Set<String> set = commandInterfaceResponseMessage.getHeaderNames();
        for (String object22 : set) {
            String n = commandInterfaceResponseMessage.getHeader(object22);
            byteBuffer.putString((CharSequence)object22, charsetEncoder);
            byteBuffer.putString((CharSequence)": ", charsetEncoder);
            byteBuffer.putString((CharSequence)n, charsetEncoder);
            byteBuffer.put(CRLF);
        }
        byte[] byArray = commandInterfaceResponseMessage.getBody();
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        if (n > 0) {
            byteBuffer.putString((CharSequence)"Content-Length", charsetEncoder);
            byteBuffer.putString((CharSequence)": ", charsetEncoder);
            byteBuffer.putString((CharSequence)(n + ""), charsetEncoder);
            byteBuffer.put(CRLF);
        }
        byteBuffer.put(CRLF);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byteBuffer.flip();
        protocolEncoderOutput.write(byteBuffer);
    }

    static {
        HashSet<Class<CommandInterfaceResponseMessage>> hashSet = new HashSet<Class<CommandInterfaceResponseMessage>>();
        hashSet.add(CommandInterfaceResponseMessage.class);
        TYPES = Collections.unmodifiableSet(hashSet);
        CRLF = new byte[]{13, 10};
    }
}

