/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.Base64;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.NoMBean;
import com.wowza.util.RandomIdGenerator;
import com.wowza.util.SystemUtils;
import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.admin.AdminServerNotifier;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionCounterSimple;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.commandinterface.CommandInterfaceCommandFactory;
import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.logging.ILogNotify;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.request.RequestConnectHandshake;
import com.wowza.wms.request.RequestConnectHandshakeCryptoSingleton;
import com.wowza.wms.server.CommandInterface;
import com.wowza.wms.server.CommandInterfaceCommandHandler;
import com.wowza.wms.server.CommandInterfaceProtocolCodecFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.server.JMXRemoteConfig;
import com.wowza.wms.server.PLims;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.server.RtmpServerProtocolCodecFactory;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.server.ServerHandlerThreaded;
import com.wowza.wms.server.ServerShutdownHook;
import com.wowza.wms.server.ServerWatchdog;
import com.wowza.wms.server.SubCL;
import com.wowza.wms.stream.MediaIndexCacheSingleton;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.transport.udp.UDPPortManager;
import com.wowza.wms.transport.udp.UDPPortSharingManager;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.ServerUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.ThreadPool;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostItem;
import com.wowza.wms.vhost.VHostList;
import com.wowza.wms.vhost.VHostSingleton;
import com.wowza.wms.vhost.WowzaSSLContextFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorExecutor;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IServer {
    private static Server instance = null;
    public static ILogNotify logNotifier = null;
    private ServerShutdownHook shutdownHook = null;
    private AdminAgent adminAgent = null;
    private List<VHost> vhosts = new ArrayList<VHost>();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private IOPerformanceCounter[] ioPerformanceCounters = new IOPerformanceCounter[6];
    private ServerWatchdog serverWatchdog = null;
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionCounterSimple[] connectionCounters = new ConnectionCounterSimple[6];
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private HostPort commandInterfaceHostPort = null;
    private Object commandInterface = null;
    private VHostList vhostList = new VHostList();
    private int coreTransportPoolSize = 16;
    private int coreHandlerPoolSize = 16;
    private ThreadPool transportThreadPool = null;
    private ThreadPool handlerThreadPool = null;
    private String clusterClassName = null;
    private String[] userAgents = new String[]{"Shockwave Flash", "CFNetwork"};
    private List serverListeners = new ArrayList();
    private JMXRemoteConfig jmxRemoteConfig = new JMXRemoteConfig();
    private List adminInterfaceObjectList = new ArrayList();
    private String vhostConfigurationUrl = null;
    private WMSProperties properties = new WMSProperties();
    private RandomIdGenerator clientIdGenerator = new RandomIdGenerator();
    private Properties dynamicLogProperties = null;
    private Set<String> dynamicLogContext = new HashSet<String>();
    private String guid = null;
    private String sessionGuid = null;
    private UDPPortManager udpPortManager = new UDPPortManager();
    private CommandInterfaceCommandHandler commandInterfaceCommandHandler = new CommandInterfaceCommandHandler();

    public Server() {
        for (int i = 0; i < this.ioPerformanceCounters.length; ++i) {
            this.ioPerformanceCounters[i] = new IOPerformanceCounter();
            this.connectionCounters[i] = new ConnectionCounterSimple();
        }
        this.adminInterfaceObjectList.add("Server".toLowerCase());
        this.adminInterfaceObjectList.add("VHost".toLowerCase());
        this.adminInterfaceObjectList.add("VHostItem".toLowerCase());
        this.adminInterfaceObjectList.add("Application".toLowerCase());
        this.adminInterfaceObjectList.add("ApplicationInstance".toLowerCase());
        this.adminInterfaceObjectList.add("Module".toLowerCase());
        this.adminInterfaceObjectList.add("MediaCaster".toLowerCase());
        this.sessionGuid = UUID.randomUUID().toString();
    }

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public AdminAgent getAdminAgent() {
        return this.adminAgent;
    }

    public static void main(String[] stringArray) {
        Server.start();
    }

    private void loadConfig() {
        String string = Bootstrap.getServerXMLURL();
        if (string != null) {
            ServerUtils.loadConfigFile(this, string);
        } else {
            System.out.println("ERROR: Server.xml missing.");
        }
    }

    @NoMBean
    public static void start() {
        Server server = Server.getInstance();
        server.initLogging();
        server.loadConfig();
        CommandInterfaceCommandFactory.loadCommands(server.commandInterfaceCommandHandler);
        server.notifyConfigLoaded();
        server.transportThreadPool = new ThreadPool(null, "ServerTransport");
        server.transportThreadPool.init(server.getCoreTransportPoolSize());
        server.handlerThreadPool = new ThreadPool(null, "ServerHandler");
        server.handlerThreadPool.init(server.getCoreHandlerPoolSize());
        server.clientIdGenerator.init(server.properties);
        server.udpPortManager.init(server);
        server.createAdminAgent();
        server.vhostList.loadConfig();
        server.notifyServerCreate();
        server.startMediaIndexCache();
        server.startServer();
        server.startAdminAgent(server.getJmxRemoteConfig());
        server.startCommandInterface();
        server.startVHosts();
        server.startShutdownHook();
        server.notifyServerInit();
        WMSLoggerFactory.getLogger(Server.class).info("Wowza Media Server is started!");
    }

    private void initLogging() {
        String string = Bootstrap.getServerLog4jPropertiesURL();
        if (string != null) {
            String string2 = System.getProperty("com.wowza.wms.logging.LogNotify");
            if (string2 != null) {
                System.out.println("Setup LogNotify class: " + string2);
                try {
                    Class<?> clazz = Class.forName(string2);
                    if (clazz != null) {
                        logNotifier = (ILogNotify)clazz.newInstance();
                        System.out.println("Setup LogNotify successful");
                    } else {
                        System.out.println("ERROR: Error creating com.wowza.wms.logging.LogNotify (" + string2 + "): Can't find class.");
                    }
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Error creating com.wowza.wms.logging.LogNotify (" + string2 + "): " + exception.toString());
                }
            }
            WMSLoggerFactory.initializeLogging(string);
        } else {
            System.out.println("ERROR: log4j.properties not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void stopServer() {
        this.notifyServerShutdownStart();
        this.stopShutdownHook();
        this.stopVHosts();
        this.stopCommandInterface();
        this.stopAdminAgent(false);
        this.stopMediaIndexCache();
        try {
            this.udpPortManager.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.transportThreadPool != null) {
            try {
                this.transportThreadPool.terminate();
            }
            catch (Exception exception) {
            }
            finally {
                this.transportThreadPool = null;
            }
        }
        if (this.handlerThreadPool != null) {
            try {
                this.handlerThreadPool.terminate();
            }
            catch (Exception exception) {
            }
            finally {
                this.handlerThreadPool = null;
            }
        }
        this.notifyServerShutdownComplete();
        WMSLoggerFactory.getLogger(Application.class).info(null, null, "server", "server-stop", 200, null);
    }

    private void startMediaIndexCache() {
        MediaIndexCacheSingleton.getInstance().start();
    }

    private void stopMediaIndexCache() {
        MediaIndexCacheSingleton.getInstance().shutdown();
    }

    private void startShutdownHook() {
        this.shutdownHook = new ServerShutdownHook(this);
        this.shutdownHook.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.serverWatchdog = new ServerWatchdog(this, 500);
        this.serverWatchdog.setDaemon(true);
        this.serverWatchdog.start();
    }

    private void stopShutdownHook() {
        try {
            if (this.serverWatchdog != null) {
                this.serverWatchdog.halt();
            }
            this.serverWatchdog = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.shutdownHook = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getHeapSize() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        Long l3 = new Long((l - l2) / 1024L);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l3);
        stringBuffer.append(" KB");
        return stringBuffer.toString();
    }

    private void createAdminAgent() {
        this.adminAgent = new AdminAgent(this, this.vhostList);
    }

    private void startAdminAgent(JMXRemoteConfig jMXRemoteConfig) {
        if (this.adminAgent != null) {
            this.adminAgent.start(jMXRemoteConfig);
        }
    }

    @Override
    public void stopAdminAgent() {
        this.stopAdminAgent(true);
    }

    private void stopAdminAgent(boolean bl) {
        if (bl) {
            AgentShutdown agentShutdown = new AgentShutdown();
            agentShutdown.setDaemon(true);
            agentShutdown.start();
        } else {
            if (this.adminAgent != null) {
                this.adminAgent.shutdown();
            }
            this.adminAgent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVHost(VHost vHost) {
        List<VHost> list = this.vhosts;
        synchronized (list) {
            this.vhosts.add(vHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVHost(VHost vHost) {
        List<VHost> list = this.vhosts;
        synchronized (list) {
            this.vhosts.remove(vHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IVHost> getVHosts() {
        List<VHost> list = this.vhosts;
        synchronized (list) {
            return new ArrayList<IVHost>(this.vhosts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVHostRunning(String string) {
        boolean bl = false;
        List<VHost> list = this.vhosts;
        synchronized (list) {
            for (VHost vHost : this.vhosts) {
                if (!vHost.getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void suspendCommandInterface() {
        try {
            IoAcceptor ioAcceptor = (IoAcceptor)this.getCommandInterface();
            if (ioAcceptor != null) {
                Set set = ioAcceptor.getManagedServiceAddresses();
                for (SocketAddress socketAddress : set) {
                    WMSLoggerFactory.getLogger(VHost.class).info("Server.suspendCommandInterface: " + socketAddress);
                    try {
                        if (!(ioAcceptor instanceof SocketAcceptor)) continue;
                        ((SocketAcceptor)ioAcceptor).suspend(socketAddress);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(VHost.class).error("Server.suspendCommandInterface: " + socketAddress + ": " + exception.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("Server.suspendCommandInterface: " + exception.toString(), "server", "comment");
        }
    }

    @Override
    public void startCommandInterface() {
        try {
            HostPort hostPort = this.getCommandInterfaceHostPort();
            if (hostPort != null) {
                InetAddress inetAddress = hostPort.getAddress();
                int n = hostPort.getPort();
                InetSocketAddress inetSocketAddress = inetAddress == null ? new InetSocketAddress(n) : new InetSocketAddress(inetAddress, n);
                SocketAcceptor socketAcceptor = new SocketAcceptor();
                SocketAcceptorConfig socketAcceptorConfig = new SocketAcceptorConfig();
                hostPort.configureSocketAcceptor(socketAcceptorConfig);
                socketAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
                socketAcceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(this.transportThreadPool.getExecutor())));
                socketAcceptorConfig.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new CommandInterfaceProtocolCodecFactory()));
                WMSLoggerFactory.getLogger(Server.class).info("CMDInterface now listening: " + hostPort.toString(), "server", "comment");
                socketAcceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)new CommandInterface(this), (IoServiceConfig)socketAcceptorConfig);
                this.setCommandInterface(socketAcceptor);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + exception.toString(), "server", "comment");
            exception.printStackTrace();
            Server.doWait();
        }
    }

    @Override
    public void stopCommandInterface() {
        try {
            IoAcceptor ioAcceptor = (IoAcceptor)this.getCommandInterface();
            if (ioAcceptor != null) {
                WMSLoggerFactory.getLogger(Server.class).debug("Close CMDInterface", "server", "comment");
                ioAcceptor.unbindAll();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + exception.toString(), "server", "comment");
            exception.printStackTrace();
            Server.doWait();
        }
    }

    private byte[] httpRequestToByteArray(String string, String string2, String string3, Map<String, String> map, Map<String, List<String>> map2, long l) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            Object object;
            Object object2;
            DataOutputStream dataOutputStream = null;
            DataInputStream dataInputStream = null;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            if (map != null) {
                for (String string4 : map.keySet()) {
                    object2 = map.get(string4);
                    uRLConnection.setRequestProperty(string4, (String)object2);
                }
            }
            if (string3 != null) {
                object = string3.getBytes("UTF-8");
                dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                dataOutputStream.write((byte[])object);
                dataOutputStream.flush();
                dataOutputStream.close();
                dataOutputStream = null;
            }
            dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new DataOutputStream(byteArrayOutputStream);
            int n2 = 65536;
            object2 = new byte[n2];
            long l2 = 0L;
            while ((n = dataInputStream.read((byte[])object2, 0, n2)) != -1) {
                ((DataOutputStream)object).write((byte[])object2, 0, n);
                Thread.sleep(1L);
                if (l <= 0L || (l2 += (long)n) < l) continue;
                break;
            }
            if (map2 != null && uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                map2.putAll(httpURLConnection.getHeaderFields());
            }
            dataInputStream.close();
            dataInputStream = null;
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    @NoMBean
    public void startServer() {
        Object object;
        Object object22;
        Object object32;
        Object object4;
        Object object52;
        Object object6;
        Object object7;
        try {
            object7 = Bootstrap.getServerHome((int)2);
            object7 = (String)object7 + File.separatorChar + "conf" + File.separatorChar + RTMPRequestAdapter.fN(ModuleConnect.getN(0));
            object6 = new File((String)object7);
            while (true) {
                object52 = "";
                if (((File)object6).exists()) {
                    object4 = new BufferedReader(new FileReader((File)object6));
                    boolean bl = true;
                    while (true) {
                        String string = ((BufferedReader)object4).readLine();
                        object32 = string;
                        if (string == null) break;
                        if (((String)(object32 = ((String)object32).trim())).length() == 0 || ((String)object32).charAt(0) == '-') continue;
                        if (((String)object52).length() == 0) {
                            object52 = (String)object52 + (String)object32;
                            continue;
                        }
                        if (bl) {
                            object52 = (String)object52 + "-";
                        }
                        bl = false;
                        object52 = (String)object52 + (String)object32;
                    }
                    ((BufferedReader)object4).close();
                    object52 = ((String)object52).toUpperCase();
                    object52 = ((String)object52).replace(" ", "");
                    if (((String)object52).length() >= 25) {
                        Client.decodeS((String)object52);
                    }
                }
                if (!ApplicationUtils.isGood()) {
                    ApplicationUtils.gs((String)object52);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object7 = (Map)MediaStreamBase.sinfo.get("sl");
            if (object7 != null) {
                block16: for (Object object52 : object7.keySet()) {
                    if (!((String)object52).equals(RTMPRequestAdapter.fN(ModuleConnect.getN(16))) || (object32 = this.httpRequestToByteArray((String)(object4 = RTMPRequestAdapter.fN(ModuleConnect.getN(15))), "GET", null, null, null, 0L)) == null) continue;
                    String string = new String((byte[])object32);
                    List list = (List)object7.get(object52);
                    for (Object object22 : list) {
                        if (!((String)object22).equals(string)) continue;
                        MediaStreamBase.sinfo.put("slp", "1");
                        MediaStreamBase.sinfo.put("l", new Integer(-1));
                        MediaStreamBase.sinfo.put("b", new Integer(-1));
                        continue block16;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RequestConnectHandshake.serverHandshakeResponseKey = Base64.decode(RTMPRequestAdapter.fN(ModuleConnect.getN(17)));
        RequestConnectHandshake.clientHandshakeSignKey = Base64.decode(RTMPRequestAdapter.fN(ModuleConnect.getN(103)));
        RequestConnectHandshake.clientHandshakeResponseKey = Base64.decode(RTMPRequestAdapter.fN(ModuleConnect.getN(104)));
        RequestConnectHandshake.magicStrServer = RTMPRequestAdapter.fN(ModuleConnect.getN(24));
        RequestConnectHandshake.magicStrPlayer = RTMPRequestAdapter.fN(ModuleConnect.getN(25));
        RequestConnectHandshake.dhpKeyStr = RTMPRequestAdapter.fN(ModuleConnect.getN(26));
        RequestConnectHandshake.initHandshake();
        try {
            object7 = null;
            object6 = null;
            object52 = "_defaultVHost_";
            object4 = WMSLoggerFactory.getLogger(Server.class);
            ((WMSLogger)((Object)object4)).info(null, null, "server", "server-start", 200, MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber());
            object32 = (String)MediaStreamBase.sinfo.get("ss");
            ((WMSLogger)((Object)object4)).info(RTMPRequestAdapter.fN(ModuleConnect.getN(3)) + ": " + RTMPRequestAdapter.fN(ModuleConnect.getN(6)) + ((String)object32).substring(((String)object32).length() - 5, ((String)object32).length()), "server", "comment");
            String string = "";
            int n = (Integer)MediaStreamBase.sinfo.get("l");
            int n2 = (Integer)MediaStreamBase.sinfo.get("b");
            if (n >= 0) {
                string = n + "";
                if (n != n2) {
                    string = n + " (" + n2 + " burst)";
                }
            }
            ((WMSLogger)((Object)object4)).info(RTMPRequestAdapter.fN(ModuleConnect.getN(4)) + ": " + (ApplicationUtils.isGood() ? ((Integer)MediaStreamBase.sinfo.get("l") == -1 ? RTMPRequestAdapter.fN(ModuleConnect.getN(5)) : string) : "0"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Hardware Available Processors: " + Runtime.getRuntime().availableProcessors(), "server", "comment");
            if (AdminAgent.isMBeanServerRunning()) {
                long l = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "TotalPhysicalMemorySize", -1L);
                long l2 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "TotalSwapSpaceSize", -1L);
                long l3 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "FreePhysicalMemorySize", -1L);
                long l4 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "FreeSwapSpaceSize", -1L);
                if (l > 0L && l3 > 0L) {
                    ((WMSLogger)((Object)object4)).info("Hardware Physical Memory: " + l3 / 0x100000L + "MB" + "/" + l / 0x100000L + "MB", "server", "comment");
                }
                if (l2 > 0L && l4 > 0L) {
                    ((WMSLogger)((Object)object4)).info("Hardware Swap Space: " + l4 / 0x100000L + "MB" + "/" + l2 / 0x100000L + "MB", "server", "comment");
                }
                long l5 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "MaxFileDescriptorCount", -1L);
                ((WMSLogger)((Object)object4)).info("Max File Descriptor Count: " + (l5 <= 0L ? "Unlimited" : Long.valueOf(l5)), "server", "comment");
                if (l5 > 0L) {
                    long l6 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "OpenFileDescriptorCount", -1L);
                    ((WMSLogger)((Object)object4)).info("Open File Descriptor Count: " + l6, "server", "comment");
                }
            }
            ((WMSLogger)((Object)object4)).info("OS Name: " + System.getProperty("os.name"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("OS Version: " + System.getProperty("os.version"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("OS Architecture: " + System.getProperty("os.arch"), "server", "comment");
            if (System.getProperty("sun.cpu.isalist") != null) {
                try {
                    String string2 = System.getProperty("sun.cpu.isalist");
                    if (string2.length() > 0) {
                        ((WMSLogger)((Object)object4)).info("OS CPU: " + string2, "server", "comment");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((WMSLogger)((Object)object4)).info("Java Name: " + System.getProperty("java.vm.name"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Vendor: " + System.getProperty("java.vm.vendor"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Version: " + System.getProperty("java.version"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java VM Version: " + System.getProperty("java.vm.version"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Spec Version: " + System.getProperty("java.specification.version"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Home: " + System.getProperty("java.home"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Max Heap Size: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB", "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Architecture: " + System.getProperty("sun.arch.data.model"), "server", "comment");
            ((WMSLogger)((Object)object4)).info("Java Encoding[file.encoding]: " + System.getProperty("file.encoding"), "server", "comment");
            object22 = null;
            try {
                object22 = ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object22 != null) {
                int n3 = 0;
                String string3 = "";
                Iterator<String> iterator = object22.iterator();
                while (iterator.hasNext()) {
                    String string4 = iterator.next();
                    if (string3.length() > 0) {
                        string3 = string3 + " ";
                    }
                    ((WMSLogger)((Object)object4)).info("Java Args[" + n3 + "]: " + string4, "server", "comment");
                    ++n3;
                }
            }
            try {
                object = ManagementFactory.getGarbageCollectorMXBeans();
                if (object != null) {
                    Iterator iterator = object.iterator();
                    int n4 = 0;
                    while (iterator.hasNext()) {
                        GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)iterator.next();
                        if (garbageCollectorMXBean == null) continue;
                        ((WMSLogger)((Object)object4)).info("Java GC[" + n4 + "]: " + garbageCollectorMXBean.getName(), "server", "comment");
                        ++n4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((WMSLogger)((Object)object4)).info("Server threads[h/t]: " + this.getCoreHandlerPoolSize() + "/" + this.getCoreTransportPoolSize(), "server", "comment");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + exception.toString());
            exception.printStackTrace();
            Server.doWait();
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            object52 = (String)MediaStreamBase.sinfo.get("s");
            object4 = (BigInteger)MediaStreamBase.sinfo.get("k");
            object32 = RTMPRequestAdapter.fS(((BigInteger)object4).toByteArray(), (String)object52);
            bl = ((String)object32).indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(125))) < 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object52 = (Map)MediaStreamBase.sinfo.get("sl");
        if (bl && object52 != null) {
            for (Object object32 : object52.keySet()) {
                if (!((String)object32).equals(RTMPRequestAdapter.fN(ModuleConnect.getN(115)))) continue;
                bl2 = true;
                byte[] byArray = new byte[ModuleConnect.lc.length];
                System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
                BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
                BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
                object22 = bigInteger.toByteArray();
                object = bigInteger2.toByteArray();
                for (int i = 0; i < byArray.length; ++i) {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] ^ object22[(i + 11) % ((Object)object22).length]);
                }
                SubCL subCL = new SubCL();
                subCL.cs(byArray);
                byte[] byArray2 = new byte[ModuleConnect.lc.length];
                System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
                for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                    int n = i;
                    byArray2[n] = (byte)(byArray2[n] ^ object22[(i + 11) % ((Object)object22).length]);
                    int n5 = i;
                    byArray2[n5] = (byte)(byArray2[n5] ^ object[(i + 8) % ((byte[])object).length]);
                    if (byArray2[i] == byArray[i]) continue;
                    WMSLoggerFactory.getLogger(null).error("system.exit");
                    System.exit(1);
                }
            }
        }
        if (bl != bl2) {
            WMSLoggerFactory.getLogger(null).error("system.exit");
            System.exit(1);
        }
        PLims.getInstance();
    }

    @Override
    public String getVersion() {
        return MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber();
    }

    @Override
    public void reloadVHostConfig() {
        try {
            this.vhostList.reloadConfig();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("reloadVHostConfig: " + exception.toString());
        }
    }

    @Override
    public void stopVHost(String string) {
        try {
            Map map2;
            VHost vHost = (VHost)VHostSingleton.getInstance(string, false);
            if (vHost == null) {
                WMSLoggerFactory.getLogger(Server.class).error("vhost not found: " + string, "server", "comment");
                return;
            }
            WMSLoggerFactory.getLogger(Server.class).debug("Shutdown vhost: " + string, "vhost", "comment");
            vHost.setShuttingDown(true);
            List list = vHost.getSessions();
            WMSLoggerFactory.getLogger(Server.class).debug("Close sessions: " + list.size(), "server", "comment");
            for (Map map2 : list) {
                map2.close();
            }
            map2 = vHost.getAcceptors();
            WMSLoggerFactory.getLogger(Server.class).debug("Close acceptors: " + map2.size(), "server", "comment");
            for (HostPort hostPort : map2.keySet()) {
                Map map3 = (Map)map2.get(hostPort);
                IoAcceptor ioAcceptor = (IoAcceptor)map3.get("acceptor");
                ioAcceptor.unbindAll();
                vHost.removeAcceptor(hostPort);
                List<IHTTPProvider> list2 = hostPort.getHttpProviders();
                if (list2 == null) continue;
                for (IHTTPProvider iHTTPProvider : list2) {
                    if (iHTTPProvider == null) continue;
                    iHTTPProvider.onUnbind(vHost, hostPort);
                }
            }
            vHost.stopWinMedia();
            VHostSingleton.shutdown(string);
            this.removeVHost(vHost);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("Problem shutting down: " + exception.toString());
            exception.printStackTrace();
            Server.doWait();
        }
    }

    @Override
    public void stopVHosts() {
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            this.stopVHost(string);
        }
    }

    public String decodeStorageDir(IVHost iVHost, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (iVHost != null) {
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
        }
        String string2 = SystemUtils.expandEnvironmentVariables(string, hashMap);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void startVHost(String var1_1) {
        var2_2 = this.isVHostRunning(var1_1);
        if (var2_2) {
            WMSLoggerFactory.getLogger(Server.class).error("Server.startVHost: Virtual host is already running: " + var1_1);
            return;
        }
        var3_3 = null;
        var4_4 = null;
        try {
            var5_5 = this.vhostList.getVHostMap().get(var1_1);
            if (var5_5 == null) {
                WMSLoggerFactory.getLogger(Server.class).error("vhost not found: " + var1_1, "server", "comment");
                return;
            }
            var6_7 = var5_5.getConfigDir();
            VHostSingleton.setServer(this);
            var7_8 = (VHost)VHostSingleton.getInstance(var1_1, true);
            var7_8.setServer(this);
            var7_8.setConnectionLimit(var5_5.getConnectionLimit());
            VHostSingleton.init(var1_1, var6_7);
            WMSLoggerFactory.getLogger(Server.class).info(var7_8.getName() + " threads[h/t]:" + var7_8.getCoreHandlerPoolSize() + "/" + var7_8.getCoreTransportPoolSize() + " home:" + var6_7, "server", "comment");
            var8_9 = var7_8.getHostPortsList();
            var9_10 = 0;
            var10_11 = 0;
            try {
                var11_12 = (String)MediaStreamBase.sinfo.get("s");
                var12_14 = (BigInteger)MediaStreamBase.sinfo.get("k");
                var13_15 = RTMPRequestAdapter.fS(var12_14.toByteArray(), (String)var11_12);
                var9_10 = var13_15.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(125))) < 0 ? 1 : 0;
            }
            catch (Exception var11_13) {
                // empty catch block
            }
            var11_12 = (Map)MediaStreamBase.sinfo.get("sl");
            if (var9_10 != 0 && var11_12 != null) {
                for (Object var13_15 : var11_12.keySet()) {
                    if (!var13_15.equals(RTMPRequestAdapter.fN(ModuleConnect.getN(115)))) continue;
                    var10_11 = 1;
                    var14_16 = (List)var11_12.get(var13_15);
                    var15_18 = null;
                    var16_23 = var14_16;
                    synchronized (var16_23) {
                        var15_18 = (byte[])var14_16.get(0);
                    }
                    var16_23 = (BigInteger)MediaStreamBase.sinfo.get("r1");
                    var17_25 = (BigInteger)MediaStreamBase.sinfo.get("r2");
                    var18_27 = var16_23.toByteArray();
                    var19_30 /* !! */  = var17_25.toByteArray();
                    var20_32 /* !! */  = new byte[ModuleConnect.lc.length];
                    System.arraycopy(ModuleConnect.lc, 0, var20_32 /* !! */ , 0, ModuleConnect.lc.length);
                    for (var21_36 = 0; var21_36 < ModuleConnect.lc.length; ++var21_36) {
                        v0 = var20_32 /* !! */ ;
                        v1 = var21_36;
                        v0[v1] = (byte)(v0[v1] ^ var18_27[(var21_36 + 11) % ((Object)var18_27).length]);
                        v2 = var20_32 /* !! */ ;
                        v3 = var21_36;
                        v2[v3] = (byte)(v2[v3] ^ var19_30 /* !! */ [(var21_36 + 8) % var19_30 /* !! */ .length]);
                        if (var20_32 /* !! */ [var21_36] == var15_18[var21_36]) continue;
                        WMSLoggerFactory.getLogger(null).error("system.exit");
                        System.exit(1);
                    }
                }
            }
            if (var9_10 != var10_11) {
                WMSLoggerFactory.getLogger(null).error("system.exit");
                System.exit(1);
            }
            var9_10 = var8_9.size();
            for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
                block57: {
                    block59: {
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        block58: {
                                            var11_12 = var8_9.get(var10_11);
                                            if (var11_12 == null) continue;
                                            var12_14 = var11_12.getAddress();
                                            var13_15 = (List)MediaStreamBase.sinfo.get("maf");
                                            if (var13_15 != null) {
                                                block55: {
                                                    var14_17 = false;
                                                    var15_20 = var12_14;
                                                    try {
                                                        if (var15_20 == null) {
                                                            var15_20 = InetAddress.getLocalHost();
                                                        }
                                                        if ((var16_23 = NetworkInterface.getByInetAddress((InetAddress)var15_20)) == null) {
                                                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(18)));
                                                            System.exit(1);
                                                            break block55;
                                                        }
                                                        var17_25 = var16_23.getClass();
                                                        if (var17_25 == null) {
                                                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(19)));
                                                            System.exit(1);
                                                            break block55;
                                                        }
                                                        var18_27 = var17_25.getMethod("getHardwareAddress", new Class[0]);
                                                        if (var18_27 == null) {
                                                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(20)));
                                                            System.exit(1);
                                                            break block55;
                                                        }
                                                        var19_30 /* !! */  = (byte[])var18_27.invoke(var16_23, new Object[0]);
                                                        if (var19_30 /* !! */  == null) {
                                                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(21)));
                                                            System.exit(1);
                                                            break block55;
                                                        }
                                                        var20_32 /* !! */  = (byte[])var13_15.iterator();
                                                        while (var20_32 /* !! */ .hasNext()) {
                                                            var21_38 = (List)var20_32 /* !! */ .next();
                                                            var22_42 = var21_38.iterator();
                                                            var23_44 = true;
                                                            var24_48 = 0;
                                                            while (var22_42.hasNext()) {
                                                                var25_50 = (String)var22_42.next();
                                                                if (var25_50.equals("*")) {
                                                                    ++var24_48;
                                                                    continue;
                                                                }
                                                                var26_51 = Integer.parseInt((String)var25_50, 16);
                                                                if (var26_51 != (var19_30 /* !! */ [var24_48] & 255)) {
                                                                    var23_44 = false;
                                                                }
                                                                ++var24_48;
                                                            }
                                                            if (var24_48 != var19_30 /* !! */ .length) {
                                                                WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(22)));
                                                                System.exit(1);
                                                                var23_44 = false;
                                                            } else {
                                                                if (!var23_44) continue;
                                                                var14_17 = true;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    catch (Exception var16_24) {
                                                        var14_17 = false;
                                                    }
                                                    if (!var14_17) {
                                                        WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(22)));
                                                        System.exit(1);
                                                    }
                                                }
                                                if (!var14_17) {
                                                    var16_23 = null;
                                                    var16_23.substring(0);
                                                }
                                            }
                                            if ((var14_16 = (List)MediaStreamBase.sinfo.get("i")) == null) break block57;
                                            var15_21 = false;
                                            if (var12_14 != null) break block58;
                                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(7)));
                                            System.exit(1);
                                            break block59;
                                        }
                                        var16_23 = var12_14.getAddress();
                                        if (var16_23 != null) break block60;
                                        WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(7)));
                                        System.exit(1);
                                        break block59;
                                    }
                                    if (!var12_14.isAnyLocalAddress()) break block61;
                                    WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(8)));
                                    System.exit(1);
                                    break block59;
                                }
                                if (!var12_14.isLinkLocalAddress()) break block62;
                                WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(9)));
                                System.exit(1);
                                break block59;
                            }
                            if (!var12_14.isLoopbackAddress()) break block63;
                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(10)));
                            System.exit(1);
                            break block59;
                        }
                        var17_25 = (Class<?>)new int[((Object)var16_23).length];
                        for (var18_28 = 0; var18_28 < ((Object)var16_23).length; ++var18_28) {
                            var17_25[var18_28] = var16_23[var18_28] & 255;
                        }
                        if (((Object)var16_23).length != 4) ** GOTO lbl-1000
                        if (var17_25[0] == 10) {
                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(11)));
                            System.exit(1);
                        } else if (var17_25[0] == 172 && var17_25[1] >= 16 && var17_25[1] <= 31) {
                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(11)));
                            System.exit(1);
                        } else if (var17_25[0] == 192 && var17_25[1] == 168) {
                            WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(11)));
                            System.exit(1);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var18_29 = var14_16.iterator();
                            while (var18_29.hasNext()) {
                                var19_30 /* !! */  = (byte[])((int[])var18_29.next());
                                if (var19_30 /* !! */ .length == ((Object)var16_23).length * 2) {
                                    var15_21 = true;
                                    for (var20_33 = 0; var20_33 < ((Object)var16_23).length; ++var20_33) {
                                        if (var17_25[var20_33] >= var19_30 /* !! */ [var20_33] && var17_25[var20_33] <= var19_30 /* !! */ [((Object)var16_23).length + var20_33]) continue;
                                        var15_21 = false;
                                        break;
                                    }
                                    if (!var15_21) continue;
                                    break;
                                }
                                WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(12)));
                                System.exit(1);
                                break;
                            }
                            if (!var15_21) {
                                WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(13)));
                                System.exit(1);
                            }
                        }
                    }
                    if (!var15_21) {
                        var16_23 = null;
                        var16_23.substring(0);
                    }
                }
                var15_22 = var11_12.getPort();
                var16_23 = var12_14 == null ? new InetSocketAddress(var15_22) : new InetSocketAddress((InetAddress)var12_14, var15_22);
                var3_3 = new SocketAcceptor(var11_12.getProcessorCount());
                var4_4 = new SocketAcceptorConfig();
                var11_12.configureSocketAcceptor(var4_4);
                var17_25 = var11_12.getSslFactoryClass();
                var18_27 = var11_12.getSSLConfig();
                v4 = var19_31 = var17_25.length() > 0 || var18_27 != null;
                if (var17_25.length() > 0) {
                    WMSLoggerFactory.getLogger(Server.class).info("SSL (" + var11_12.toString() + "): " + (String)var17_25, "vhost", "comment", 200, var1_1);
                    this.addSSLSupport(var4_4.getFilterChain(), (String)var17_25);
                } else if (var18_27 != null) {
                    try {
                        var20_34 = this.decodeStorageDir(var7_8, var18_27.getKeyStorePath());
                        WMSLoggerFactory.getLogger(Server.class).info("SSL (" + var11_12.toString() + "): " + var20_34, "vhost", "comment", 200, var1_1);
                        var21_39 = WowzaSSLContextFactory.createServerContext(var20_34, var18_27.getKeyStorePass(), var18_27.getKeyStoreType(), var18_27.getSSLProtocol(), var18_27.getAlgorithm());
                        var22_42 = new SSLFilter(var21_39);
                        var4_4.getFilterChain().addLast("sslFilter", (IoFilter)var22_42);
                    }
                    catch (Exception var20_35) {
                        WMSLoggerFactory.getLogger(Server.class).info("SSLConfiguration problem: " + var20_35.toString());
                        var19_31 = false;
                    }
                }
                var4_4.setThreadModel(ThreadModel.MANUAL);
                var4_4.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(var7_8.getTransportThreadPool().getExecutor())));
                var4_4.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RtmpServerProtocolCodecFactory()));
                WMSLoggerFactory.getLogger(Server.class).info("Bind attempt (" + var11_12.toString() + ":" + var11_12.getProcessorCount() + ")", "vhost", "comment", 200, var1_1);
                var20_32 /* !! */  = new ServerHandler(var1_1, var19_31, (HostPort)var11_12, this);
                var21_40 = new ServerHandlerThreaded((ServerHandler)var20_32 /* !! */ , var7_8.getHandlerThreadPool().getExecutor());
                var22_41 = false;
                while (true) {
                    try {
                        var3_3.bind((SocketAddress)var16_23, (IoHandler)var21_40, (IoServiceConfig)var4_4);
                        WMSLoggerFactory.getLogger(Server.class).info("Bind successful (" + var11_12.toString() + ")", "vhost", "comment", 200, var1_1);
                        break;
                    }
                    catch (BindException var23_45) {
                        WMSLoggerFactory.getLogger(Server.class).warn("Bind failed, try again (" + var11_12.toString() + "): " + var23_45.toString(), "vhost", "comment", 200, var1_1);
                    }
                    catch (Exception var23_46) {
                        WMSLoggerFactory.getLogger(Server.class).warn("Bind failed: (" + var11_12.toString() + "): " + var23_46.toString(), "vhost", "comment", 200, var1_1);
                        break;
                    }
                    var22_41 = true;
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (Exception var23_47) {}
                }
                var7_8.addAcceptor((HostPort)var11_12, (IoAcceptor)var3_3, var21_40);
                var23_43 = var11_12.getHttpProviders();
                if (var23_43 == null) continue;
                for (Object var25_50 : var23_43) {
                    if (var25_50 == null) continue;
                    var25_50.onBind(var7_8, (HostPort)var11_12);
                }
            }
            this.addVHost(var7_8);
            var7_8.startWinMedia();
            if (var7_8.isStartStarupStreams()) {
                var7_8.startStartupStreams();
            }
        }
        catch (Exception var5_6) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + var5_6.toString());
            var5_6.printStackTrace();
            Server.doWait();
        }
    }

    @Override
    public boolean isSuspended() {
        boolean bl = true;
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            IVHost iVHost = VHostSingleton.getInstance(string);
            if (iVHost.isSuspended()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public void suspendServer() {
        this.suspendCommandInterface();
        this.suspendAllVHosts();
    }

    @Override
    public void suspendAllVHosts() {
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            IVHost iVHost = VHostSingleton.getInstance(string);
            WMSLoggerFactory.getLogger(VHost.class).info("Server.suspendAllVHosts: vhost: " + iVHost.getName());
            iVHost.suspendAllHostPorts();
        }
    }

    @Override
    public void unbindAllVHosts() {
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            IVHost iVHost = VHostSingleton.getInstance(string);
            WMSLoggerFactory.getLogger(VHost.class).info("Server.unbindAllVHosts: vhost: " + iVHost.getName());
            iVHost.unbindAllHostPorts();
        }
    }

    @Override
    public void startVHosts() {
        List<VHostItem> list = this.vhostList.getVHostItems();
        for (VHostItem vHostItem : list) {
            String string = vHostItem.getName();
            this.startVHost(string);
        }
    }

    private void addSSLSupport(DefaultIoFilterChainBuilder defaultIoFilterChainBuilder, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = clazz.getMethod("getInstance", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{new Boolean(true)};
                    SSLContext sSLContext = (SSLContext)method.invoke(null, objectArray);
                    SSLFilter sSLFilter = new SSLFilter(sSLContext);
                    defaultIoFilterChainBuilder.addLast("sslFilter", (IoFilter)sSLFilter);
                } else {
                    WMSLoggerFactory.getLogger(Server.class).error("addSSLSupport: factory class missing getInstance(boolean) method: " + string);
                }
            } else {
                WMSLoggerFactory.getLogger(Server.class).error("addSSLSupport: missing factory class: " + string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("addSSLSupport: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void doWait() {
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void doWatchdog() {
        this.updateIOPerformance();
        MediaIndexCacheSingleton.getInstance().doWatchdog();
        Map map = (Map)MediaStreamBase.sinfo.get("sl");
        if (map != null) {
            for (String string : map.keySet()) {
                if (!string.equals(RTMPRequestAdapter.fN(ModuleConnect.getN(115)))) continue;
                List list = (List)map.get(string);
                SubCL subCL = null;
                List list2 = list;
                synchronized (list2) {
                    if (list.size() > 1) {
                        subCL = (SubCL)list.get(1);
                    }
                }
                if (subCL == null) continue;
                subCL.pg();
            }
        }
        try {
            this.clientIdGenerator.doIdle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NoMBean
    public IOPerformanceCounter updateIOPerformance() {
        int n;
        List<IVHost> list = this.getVHosts();
        Iterator<IVHost> iterator = list.iterator();
        IOPerformanceCounter iOPerformanceCounter = new IOPerformanceCounter();
        IOPerformanceCounter[] iOPerformanceCounterArray = new IOPerformanceCounter[6];
        for (n = 0; n < iOPerformanceCounterArray.length; ++n) {
            iOPerformanceCounterArray[n] = new IOPerformanceCounter();
        }
        while (iterator.hasNext()) {
            VHost vHost = (VHost)iterator.next();
            iOPerformanceCounter.add(vHost.updateIOPerformance());
            for (int i = 0; i < iOPerformanceCounterArray.length; ++i) {
                iOPerformanceCounterArray[i].add(vHost.updateIOPerformance(i));
            }
        }
        this.ioPerformanceCounter.doSet(iOPerformanceCounter);
        for (n = 0; n < iOPerformanceCounterArray.length; ++n) {
            this.ioPerformanceCounters[n].doSet(iOPerformanceCounterArray[n]);
        }
        return this.ioPerformanceCounter;
    }

    @Override
    @NoMBean
    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    @Override
    @NoMBean
    public IOPerformanceCounter getIoPerformanceCounter(int n) {
        return this.ioPerformanceCounters[n];
    }

    @NoMBean
    public void setIoPerformanceCounter(IOPerformanceCounter iOPerformanceCounter) {
        this.ioPerformanceCounter = iOPerformanceCounter;
    }

    @Override
    @NoMBean
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    @Override
    @NoMBean
    public ConnectionCounterSimple getConnectionCounter(int n) {
        return this.connectionCounters[n];
    }

    @NoMBean
    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    @NoMBean
    public void onNewVHost(IVHost iVHost) {
        ConnectionNotifier connectionNotifier = new ConnectionNotifier(this);
        iVHost.getConnectionCounter().addConnectionListener(connectionNotifier);
    }

    @Override
    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    @Override
    @NoMBean
    public HostPort getCommandInterfaceHostPort() {
        return this.commandInterfaceHostPort;
    }

    @Override
    @NoMBean
    public void setCommandInterfaceHostPort(HostPort hostPort) {
        this.commandInterfaceHostPort = hostPort;
    }

    @NoMBean
    public Object getCommandInterface() {
        return this.commandInterface;
    }

    @NoMBean
    public void setCommandInterface(Object object) {
        this.commandInterface = object;
    }

    @Override
    public String[] getUserAgents() {
        return this.userAgents;
    }

    @Override
    public void setUserAgents(String[] stringArray) {
        this.userAgents = stringArray;
    }

    @NoMBean
    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void addServerListener(IServerNotify iServerNotify) {
        List list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.add(iServerNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void removeServerListener(IServerNotify iServerNotify) {
        List list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.remove(iServerNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyConfigLoaded() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            if (!(iServerNotify instanceof IServerNotify2)) continue;
            ((IServerNotify2)iServerNotify).onServerConfigLoaded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerCreate() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerCreate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerInit() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerInit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerShutdownStart() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerShutdownStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerShutdownComplete() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerShutdownComplete(this);
        }
    }

    @NoMBean
    public JMXRemoteConfig getJmxRemoteConfig() {
        return this.jmxRemoteConfig;
    }

    @Override
    @NoMBean
    public List getAdminInterfaceObjectList() {
        return this.adminInterfaceObjectList;
    }

    @Override
    public int getCoreTransportPoolSize() {
        return this.coreTransportPoolSize;
    }

    @Override
    public void setCoreTransportPoolSize(int n) {
        this.coreTransportPoolSize = n;
    }

    @Override
    public int getCoreHandlerPoolSize() {
        return this.coreHandlerPoolSize;
    }

    @Override
    public void setCoreHandlerPoolSize(int n) {
        this.coreHandlerPoolSize = n;
    }

    @Override
    @NoMBean
    public ThreadPool getThreadPool() {
        return this.getHandlerThreadPool();
    }

    @Override
    @NoMBean
    public ThreadPool getTransportThreadPool() {
        return this.transportThreadPool;
    }

    @Override
    @NoMBean
    public ThreadPool getHandlerThreadPool() {
        return this.handlerThreadPool;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public RandomIdGenerator getClientIdGenerator() {
        return this.clientIdGenerator;
    }

    @Override
    public Properties getDynamicLogProperties() {
        return this.dynamicLogProperties;
    }

    @Override
    public void setDynamicLogProperties(Properties properties) {
        this.dynamicLogProperties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDynamicLogContextLoaded(String string) {
        boolean bl = false;
        Set<String> set = this.dynamicLogContext;
        synchronized (set) {
            bl = !this.dynamicLogContext.add(string);
        }
        return bl;
    }

    @Override
    public VHostList getVHostList() {
        return this.vhostList;
    }

    public String getSessionGUID() {
        return this.sessionGuid;
    }

    public String getGUID() {
        String string = this.guid;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        if (string == null) {
            String string2 = Bootstrap.getServerHome((int)2);
            string2 = string2 + File.separatorChar + "conf" + File.separatorChar + RTMPRequestAdapter.fN(ModuleConnect.getN(114));
            try {
                File file = new File(string2);
                if (file.exists()) {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
                        string = string3;
                    }
                }
                if (string == null) {
                    string = UUID.randomUUID().toString();
                    printWriter = new PrintWriter(new FileOutputStream(file, false));
                    printWriter.println(string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("Server.getGUID: File error[" + string2 + "]: " + exception.toString());
            }
            if (string != null) {
                this.guid = string;
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
            if (printWriter != null) {
                printWriter.close();
            }
            printWriter = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("Server.getGUID: Close error: " + exception.toString());
        }
        return string;
    }

    @Override
    public UDPPortSharingManager getUDPPortSharingManager() {
        return this.udpPortManager.getUDPPortSharingManager();
    }

    @Override
    public UDPPortManager getUDPPortManager() {
        return this.udpPortManager;
    }

    public int getCryptoPoolMaxSize() {
        return RequestConnectHandshakeCryptoSingleton.getCryptoPoolMaxSize();
    }

    public int getCryptoPoolActiveCount() {
        return RequestConnectHandshakeCryptoSingleton.getCryptoPoolActiveCount();
    }

    public long getLiveThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getThreadCount();
    }

    public long getPeakThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getPeakThreadCount();
    }

    public long getCurrentHeapSize() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        return memoryUsage.getUsed();
    }

    public long getMaxHeapSize() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        return memoryUsage.getMax();
    }

    public long getCommittedVirtuallMemory() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        return memoryUsage.getCommitted();
    }

    @Override
    public String readConfig(String string) {
        String string2 = Bootstrap.getServerHome((int)2) + "/conf/" + string;
        return Server.readXMLConfig(string2);
    }

    @Override
    public boolean writeConfig(String string, String string2) {
        String string3 = Bootstrap.getServerHome((int)2) + "/conf/" + string;
        return Server.writeXMLConfig(string3, string2);
    }

    public static String readXMLConfig(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(fileInputStream);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).warn("Server.readConfig: exception processing[" + string + "]");
            WMSLoggerFactory.getLogger(Server.class).warn("Server.readConfig: file not found[" + string + "]");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeXMLConfig(String string, String string2) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        File file2 = new File(string);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file2));
            writer.write(string2);
        }
        catch (IOException iOException) {
            WMSLoggerFactory.getLogger(Server.class).warn("Server.writeConfig: exception processing[" + string + "]");
        }
        finally {
            try {
                writer.close();
                bl = true;
            }
            catch (IOException iOException) {
                WMSLoggerFactory.getLogger(Server.class).warn("Server.writeConfig: exception processing[" + string + "]");
            }
        }
        return bl;
    }

    public long getClientIdGeneratorTimeout() {
        return this.clientIdGenerator.getRandomIdGeneratorTimeout();
    }

    public int getClientIdGeneratorRecycleSize() {
        return this.clientIdGenerator.getRecycleSize();
    }

    public int getClientIdGeneratorRecycleDelaySize() {
        return this.clientIdGenerator.getRecycleDelaySize();
    }

    @Override
    public CommandInterfaceCommandHandler getCommandInterfaceCommandHandler() {
        return this.commandInterfaceCommandHandler;
    }

    class AgentShutdown
    extends Thread
    implements Runnable {
        AgentShutdown() {
        }

        public void run() {
            WMSLoggerFactory.getLogger(null).info("Server.AgentShutdown.run: Shutdown admin agent");
            Server.this.stopAdminAgent(false);
        }
    }

    class ConnectionNotifier
    implements IConnectionNotify {
        private Server server = null;
        private byte[] control = null;

        public ConnectionNotifier(Server server2) {
            this.server = server2;
            this.control = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, this.control, 0, ModuleConnect.lc.length);
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray = bigInteger.toByteArray();
            for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                int n = i;
                this.control[n] = (byte)(this.control[n] ^ byArray[(i + 11) % byArray.length]);
            }
        }

        private void checkLicense(byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
                if (byArray[i] == this.control[i]) continue;
                WMSLoggerFactory.getLogger(null).error("Server checkLicense exit:" + byArray[i] + ":" + this.control[i]);
                System.exit(1);
            }
        }

        public void onAcceptConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.server.connectionCounter.incrementAccept(connectionHolder, date, l, byArray);
            Server.this.connectionCounters[connectionHolder.getConnectionType()].incrementAccept(connectionHolder, date, l);
            this.checkLicense(byArray);
        }

        public void onRejectConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, int n, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.server.connectionCounter.incrementReject(connectionHolder, n, date, l, byArray);
            Server.this.connectionCounters[connectionHolder.getConnectionType()].incrementReject(connectionHolder, n, date, l);
            this.checkLicense(byArray);
        }

        public void onDisconnect(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.server.connectionCounter.decrement(connectionHolder, bl, date, l, byArray);
            Server.this.connectionCounters[connectionHolder.getConnectionType()].decrement(connectionHolder, bl, date, l);
            this.checkLicense(byArray);
        }
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private IServer server = null;
        private long burstTime = -1L;
        private static final long BURSTTIMEOUT = 1200000L;

        public ConnectionValidator(IServer iServer) {
            this.server = iServer;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            boolean bl;
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 1) % byArray2.length]);
            }
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger2.toByteArray(), string);
            String string3 = (String)MediaStreamBase.sinfo.get("slp");
            long l = 0L;
            long l2 = 0L;
            String[] stringArray = string2.split("[|]");
            for (bl = false; bl < stringArray.length; bl += 1) {
                String[] stringArray2 = stringArray[bl].split("[=]");
                if (stringArray2.length != 2) continue;
                try {
                    if (stringArray2[0].equals("c" + string3)) {
                        l = Long.parseLong(stringArray2[1]);
                        continue;
                    }
                    if (!stringArray2[0].equals("b" + string3)) continue;
                    l2 = Long.parseLong(stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error(exception.toString());
                }
            }
            if (l == 0L || l2 == 0L) {
                WMSLoggerFactory.getLogger(null).error("system.exit");
                System.exit(1);
            }
            bl = l == -1L;
            boolean bl2 = false;
            long l3 = 0L;
            if (!bl) {
                l3 = this.server.getConnectionCounter().getCurrent();
                if (l3 < l) {
                    bl = true;
                    this.burstTime = -1L;
                } else if (l3 >= l2) {
                    bl = false;
                } else {
                    long l4 = System.currentTimeMillis();
                    bl2 = true;
                    bl = true;
                    if (this.burstTime == -1L) {
                        this.burstTime = l4;
                    } else {
                        long l5 = l4 - this.burstTime;
                        if (l5 > 1200000L) {
                            bl = false;
                        }
                    }
                }
            }
            if (!bl) {
                AdminServerNotifier.sendConnectionLicenseLimit(connectionHolder.getClient(), "com.wowza.wms.connect.ErrorServerLicenseLimit");
            } else if (bl2) {
                AdminServerNotifier.sendConnectionLicenseLimit(connectionHolder.getClient(), "com.wowza.wms.connect.WarningServerLicenseLimit");
                WMSLoggerFactory.getLogger(null).warn(l3 + 1L + " of " + l2, "server", "connect-burst");
            }
            return bl;
        }
    }
}

