/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.server.ServerHandlerEvent;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

public class ServerHandlerThreadedSession
implements Runnable {
    private IoSession session = null;
    private ServerHandler handler = null;
    private Executor executor = null;
    private boolean running = false;
    private Object lock = new Object();
    private int protocol = 0;
    private LinkedList<ServerHandlerEvent> eventQueue = new LinkedList();

    public boolean isThreaded() {
        return this.protocol == 1 || this.protocol == 16 || this.protocol == 17;
    }

    public boolean isProtocolUnknown() {
        return this.protocol == 0;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public ServerHandlerThreadedSession(IoSession ioSession, ServerHandler serverHandler, Executor executor) {
        this.session = ioSession;
        this.handler = serverHandler;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(int n, Object object, IdleStatus idleStatus, Throwable throwable) {
        Object object2 = this.lock;
        synchronized (object2) {
            ServerHandlerEvent serverHandlerEvent;
            boolean bl = false;
            if (n == 5 && this.eventQueue.size() > 0) {
                serverHandlerEvent = this.eventQueue.getLast();
                boolean bl2 = bl = serverHandlerEvent.getType() == 5;
            }
            if (!bl) {
                serverHandlerEvent = new ServerHandlerEvent(n, object, idleStatus, throwable);
                this.eventQueue.add(serverHandlerEvent);
                if (!this.running) {
                    this.running = true;
                    this.executor.execute(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            ServerHandlerEvent serverHandlerEvent = null;
            Object object = this.lock;
            synchronized (object) {
                serverHandlerEvent = this.eventQueue.poll();
                if (serverHandlerEvent == null) {
                    this.running = false;
                    break;
                }
            }
            try {
                switch (serverHandlerEvent.getType()) {
                    case 1: {
                        this.handler.sessionCreated(this.session);
                        break;
                    }
                    case 2: {
                        this.handler.sessionOpened(this.session);
                        break;
                    }
                    case 3: {
                        this.handler.sessionClosed(this.session);
                        break;
                    }
                    case 4: {
                        this.handler.messageReceived(this.session, serverHandlerEvent.getMessage());
                        break;
                    }
                    case 5: {
                        this.handler.sessionIdle(this.session, serverHandlerEvent.getStatus());
                        break;
                    }
                    case 6: {
                        this.handler.exceptionCaught(this.session, serverHandlerEvent.getCause());
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ServerHandlerThreadedSession.class).debug("ServerHandlerThreadedSession.run: " + exception.toString());
            }
        }
    }
}

