/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.sharedobject;

import com.wowza.util.FileUtils;
import com.wowza.util.IFileProcess;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.sharedobject.ISharedObject;
import com.wowza.wms.sharedobject.ISharedObjectNotify;
import com.wowza.wms.sharedobject.ISharedObjects;
import com.wowza.wms.sharedobject.SharedObject;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjects
implements ISharedObjects {
    private Map objects = new HashMap();
    private boolean isPersistent = false;
    private List sharedObjectListeners = new ArrayList();
    private String storageDir = null;
    private WMSReadWriteLock lock = new WMSReentrantReadWriteLock();

    public SharedObjects() {
    }

    public SharedObjects(boolean bl) {
        this.isPersistent = bl;
    }

    public WMSReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int n = 0;
        this.lock.readLock().lock();
        try {
            n = this.objects.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.size: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISharedObject get(String string) {
        ISharedObject iSharedObject = null;
        this.lock.readLock().lock();
        try {
            iSharedObject = (ISharedObject)this.objects.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.get: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return iSharedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISharedObject getOrCreate(String string) {
        ISharedObject iSharedObject = null;
        this.lock.writeLock().lock();
        try {
            iSharedObject = (ISharedObject)this.objects.get(string);
            if (iSharedObject == null) {
                iSharedObject = new SharedObject(string, this.isPersistent, this.storageDir);
                this.objects.put(string, iSharedObject);
                ((SharedObject)iSharedObject).setParent(this);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.getOrCreate: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return iSharedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getObjectNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.lock.readLock().lock();
        try {
            arrayList.addAll(this.objects.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.getObjectNames: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String string, ISharedObject iSharedObject) {
        this.lock.writeLock().lock();
        try {
            this.objects.put(string, iSharedObject);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.put: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        ((SharedObject)iSharedObject).setParent(this);
        this.notifySharedObjectCreate(iSharedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISharedObject removeInternal(String string) {
        ISharedObject iSharedObject = null;
        this.lock.writeLock().lock();
        try {
            iSharedObject = (ISharedObject)this.objects.get(string);
            this.objects.remove(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.remove: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return iSharedObject;
    }

    @Override
    public void remove(String string) {
        ISharedObject iSharedObject = this.removeInternal(string);
        if (iSharedObject != null) {
            this.notifySharedObjectDestroy(iSharedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String string) {
        boolean bl = false;
        this.lock.readLock().lock();
        try {
            bl = this.objects.containsKey(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.exists: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(ISharedObject iSharedObject) {
        boolean bl = false;
        this.lock.readLock().lock();
        try {
            bl = this.objects.containsValue(iSharedObject);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.exists: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return bl;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }

    @Override
    public void setPersistent(boolean bl) {
        this.isPersistent = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ISharedObject> getListCopy() {
        ArrayList<ISharedObject> arrayList = new ArrayList<ISharedObject>();
        this.lock.readLock().lock();
        try {
            arrayList.addAll(this.objects.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObjects.class).error("SharedObjects.getListCopy: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    @Override
    public void removeClient(IClient iClient) {
        List<ISharedObject> list = this.getListCopy();
        for (ISharedObject iSharedObject : list) {
            iSharedObject.removeClient(iClient);
        }
    }

    @Override
    public void flush() {
        List<ISharedObject> list = this.getListCopy();
        for (ISharedObject iSharedObject : list) {
            iSharedObject.flush();
        }
    }

    public void getClientUpdates(IClient iClient) {
        List<ISharedObject> list = this.getListCopy();
        for (SharedObject sharedObject : list) {
            sharedObject.getClientUpdates(iClient);
        }
    }

    @Override
    public void disconnect(IClient iClient) {
        List<ISharedObject> list = this.getListCopy();
        for (ISharedObject iSharedObject : list) {
            iSharedObject.disconnect(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSharedObjectListener(ISharedObjectNotify iSharedObjectNotify) {
        List list = this.sharedObjectListeners;
        synchronized (list) {
            this.sharedObjectListeners.add(iSharedObjectNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSharedObjectListener(ISharedObjectNotify iSharedObjectNotify) {
        List list = this.sharedObjectListeners;
        synchronized (list) {
            this.sharedObjectListeners.remove(iSharedObjectNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySharedObjectCreate(ISharedObject iSharedObject) {
        ArrayList arrayList = null;
        List list = this.sharedObjectListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.sharedObjectListeners);
        }
        for (ISharedObjectNotify iSharedObjectNotify : arrayList) {
            iSharedObjectNotify.onSharedObjectCreate(iSharedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySharedObjectDestroy(ISharedObject iSharedObject) {
        ArrayList arrayList = null;
        List list = this.sharedObjectListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.sharedObjectListeners);
        }
        for (ISharedObjectNotify iSharedObjectNotify : arrayList) {
            iSharedObjectNotify.onSharedObjectDestroy(iSharedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySharedObjectConnect(ISharedObject iSharedObject, IClient iClient) {
        ArrayList arrayList = null;
        List list = this.sharedObjectListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.sharedObjectListeners);
        }
        for (ISharedObjectNotify iSharedObjectNotify : arrayList) {
            iSharedObjectNotify.onSharedObjectConnect(iSharedObject, iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySharedObjectDisconnect(ISharedObject iSharedObject, IClient iClient) {
        ArrayList arrayList = null;
        List list = this.sharedObjectListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.sharedObjectListeners);
        }
        for (ISharedObjectNotify iSharedObjectNotify : arrayList) {
            iSharedObjectNotify.onSharedObjectDisconnect(iSharedObject, iClient);
        }
    }

    @Override
    public String getStorageDir() {
        return this.storageDir;
    }

    @Override
    public void setStorageDir(String string) {
        this.storageDir = string;
    }

    @Override
    public void load() {
        if (!this.isPersistent) {
            return;
        }
        FileProcessor fileProcessor = new FileProcessor(this);
        FileUtils.traverseDirectory(new File(this.storageDir), fileProcessor);
    }

    class FileProcessor
    implements IFileProcess {
        SharedObjects sharedObjects = null;
        String basePath = "";
        int basePathLen = 0;

        public FileProcessor(SharedObjects sharedObjects2) {
            this.sharedObjects = sharedObjects2;
            this.basePath = new File(this.sharedObjects.getStorageDir()).getPath();
            this.basePathLen = this.basePath.length();
        }

        public void onFile(File file) {
            String string;
            if (file.isFile() && (string = file.getPath()).endsWith(".rso")) {
                try {
                    String string2 = string.substring(this.basePathLen + 1);
                    string2 = string2.replace("\\", "/");
                    string2 = string2.substring(0, string2.length() - 4);
                    if (!this.sharedObjects.exists(string2)) {
                        try {
                            SharedObject sharedObject = new SharedObject(string2, this.sharedObjects.isPersistent, this.sharedObjects.getStorageDir());
                            this.sharedObjects.put(string2, sharedObject);
                            sharedObject.setParent(this.sharedObjects);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObjects FileProcessor: " + exception.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObjects FileProcessor: " + exception.toString());
                }
            }
        }
    }
}

