/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.dvr.model.DvrStoreItem;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.dvrpacketizer.DvrPacketizerItem;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DvrUtils {
    public static DvrStoreItem loadDvrStoreItem(Element element) {
        DvrStoreItem dvrStoreItem = null;
        try {
            Element element2 = element;
            Node node = XMLUtils.getNodeByTagName(element2, "Name");
            Node node2 = XMLUtils.getNodeByTagName(element2, "Description");
            Node node3 = XMLUtils.getNodeByTagName(element2, "BaseClass");
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "Properties/Property";
            XPathExpression xPathExpression = xPath.compile(string);
            if (node != null && node3 != null) {
                String string2 = XMLUtils.getNodeValue(node);
                String string3 = XMLUtils.getNodeValue(node2);
                String string4 = XMLUtils.getNodeValue(node3);
                dvrStoreItem = new DvrStoreItem(string2, string4);
                if (string3 != null) {
                    dvrStoreItem.setDescription(string3);
                }
                WMSProperties wMSProperties = dvrStoreItem.getProperties();
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                if (nodeList != null) {
                    XMLUtils.loadConfigProperies(nodeList, wMSProperties);
                }
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).debug(dvrStoreItem.toString());
            } else {
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("DVRUtils.loadDvrItem: Error parsing server properties: Name, BaseClass and StreamType required.");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("DVRUtils.loadDvrItem: Error parsing properties: " + exception.toString());
            exception.printStackTrace();
        }
        return dvrStoreItem;
    }

    public static DvrPacketizerItem loadDvrPacketizerItem(Element element) {
        DvrPacketizerItem dvrPacketizerItem = null;
        try {
            Element element2 = element;
            Node node = XMLUtils.getNodeByTagName(element2, "Name");
            Node node2 = XMLUtils.getNodeByTagName(element2, "Description");
            Node node3 = XMLUtils.getNodeByTagName(element2, "BaseClass");
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "Properties/Property";
            XPathExpression xPathExpression = xPath.compile(string);
            if (node != null && node3 != null) {
                String string2 = XMLUtils.getNodeValue(node);
                String string3 = XMLUtils.getNodeValue(node2);
                String string4 = XMLUtils.getNodeValue(node3);
                dvrPacketizerItem = new DvrPacketizerItem(string2, string4);
                if (string3 != null) {
                    dvrPacketizerItem.setDescription(string3);
                }
                WMSProperties wMSProperties = dvrPacketizerItem.getProperties();
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                if (nodeList != null) {
                    XMLUtils.loadConfigProperies(nodeList, wMSProperties);
                }
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).debug(dvrPacketizerItem.toString());
            } else {
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("DvrUtils.loadDvrPacketizerItem: Error parsing server properties: Name, BaseClass and StreamType required.");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("DvrUtils.loadDvrPacketizerItem: Error parsing properties: " + exception.toString());
            exception.printStackTrace();
        }
        return dvrPacketizerItem;
    }

    public static void loadDvrPacketizerList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    DvrPacketizerItem dvrPacketizerItem = DvrUtils.loadDvrPacketizerItem(element2);
                    iVHost.getDvrPacketizerList().getDvrPacketizerDefs().put(dvrPacketizerItem.getName(), dvrPacketizerItem);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("DVRUtils.loadDvrPacketizerList: Error load DVRPacketizerList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadDVRStoreList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    DvrStoreItem dvrStoreItem = DvrUtils.loadDvrStoreItem(element2);
                    iVHost.getDvrStoreList().getDvrStoreDefs().put(dvrStoreItem.getName(), dvrStoreItem);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("loadDVRStoreList: Error load DVRList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string2 = "/Root/DVRPacketizers/DVRPacketizer";
                DvrUtils.loadDvrPacketizerList(element, string2, iVHost);
                String string3 = "/Root/DVRStores/DVRStore";
                DvrUtils.loadDVRStoreList(element, string3, iVHost);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("DVRUtils.loadConfigFile: Error parsing DVR config file (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }
}

