/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaWriterItem;
import com.wowza.wms.stream.MediaWriterList;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.StreamUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MediaWriterUtils {
    public static String getPropertyString(IMediaStream iMediaStream, String string, String string2) {
        return MediaWriterUtils.getPropertyString(null, iMediaStream, string, string2);
    }

    public static String getPropertyString(MediaWriterItem mediaWriterItem, IMediaStream iMediaStream, String string, String string2) {
        String string3 = string2;
        if (mediaWriterItem != null) {
            string3 = mediaWriterItem.getProperties().getPropertyStr(string, string3);
        }
        if (iMediaStream != null) {
            string3 = iMediaStream.getStreams().getAppInstance().getMediaWriterProperties().getPropertyStr(string, string3);
        }
        return string3;
    }

    public static void loadConfigFile(MediaWriterList mediaWriterList, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading MediaWriters.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "/Root/MediaWriters/MediaWriter";
            String string3 = "Properties/Property";
            if (document != null) {
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile(string2);
                XPathExpression xPathExpression2 = xPath.compile(string3);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element2;
                        Node node = nodeList.item(i);
                        Element element3 = (Element)node;
                        Node node2 = XMLUtils.getNodeByTagName(element3, "Name");
                        Node node3 = XMLUtils.getNodeByTagName(element3, "ClassBase");
                        if (node2 == null || node3 == null) continue;
                        String string4 = XMLUtils.getNodeValue(node2);
                        String string5 = XMLUtils.getNodeValue(node3);
                        MediaWriterItem mediaWriterItem = new MediaWriterItem(string4, string5);
                        mediaWriterList.getMediaWriterDefs().put(string4, mediaWriterItem);
                        Element element4 = (Element)XMLUtils.getNodeByTagName(element3, "Description");
                        if (element4 != null) {
                            mediaWriterItem.setDescription(XMLUtils.getNodeValue(element4));
                        }
                        if ((element2 = (Element)XMLUtils.getNodeByTagName(element3, "FileExtension")) != null) {
                            mediaWriterItem.setFileExtension(XMLUtils.getNodeValue(element2));
                        }
                        WMSProperties wMSProperties = mediaWriterItem.getProperties();
                        NodeList nodeList2 = (NodeList)xPathExpression2.evaluate(node, XPathConstants.NODESET);
                        if (nodeList2 != null) {
                            XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                        }
                        WMSLoggerFactory.getLogger(MediaWriterUtils.class).debug(mediaWriterItem.toString());
                    }
                } else {
                    WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing mediawriters config file: (" + string + ") error: XPath " + string2 + " missing");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing mediawriters config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

