/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPDestination;
import com.wowza.wms.rtp.model.RTPIdleHandler;
import com.wowza.wms.rtp.model.RTPPushPublishSession;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.util.IdleWorkersUtil;
import com.wowza.wms.util.MediaWriterUtils;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPUtils {
    public static String updateSDPDestination(RTPDestination rTPDestination, String string) {
        String string2 = string;
        try {
            if (string != null) {
                String[] stringArray = string.split("\r\n");
                StringBuffer stringBuffer = new StringBuffer();
                int n = rTPDestination.isStream() ? rTPDestination.getStreamPort() : rTPDestination.getVideoPort();
                int n2 = rTPDestination.getAudioPort();
                boolean bl = rTPDestination.isMulticast();
                String string3 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if ((string4 = string4.trim()).length() <= 0) continue;
                    boolean bl2 = true;
                    if (string4.startsWith("c=")) {
                        bl2 = false;
                    } else if (string4.startsWith("m=")) {
                        boolean bl3 = string4.startsWith("m=audio");
                        int n3 = bl3 ? n2 : n;
                        int n4 = string4.indexOf(" 0 ");
                        if (n4 >= 0) {
                            string4 = string4.substring(0, n4) + " " + n3 + " " + string4.substring(n4 + 3);
                        }
                        string3 = bl3 ? "c=IN " + rTPDestination.getHostType() + " " + rTPDestination.getAudioHost() + (bl ? "/" + rTPDestination.getTTL() : "") : "c=IN " + rTPDestination.getHostType() + " " + rTPDestination.getVideoHost() + (bl ? "/" + rTPDestination.getTTL() : "");
                    }
                    if (!bl2) continue;
                    stringBuffer.append(string4 + "\r\n");
                    if (string3 == null) continue;
                    stringBuffer.append(string3 + "\r\n");
                    string3 = null;
                }
                string2 = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("RTPUtils.injectSDPDataWithRTPDestination: " + exception.toString());
        }
        return string2;
    }

    public static double[] decodeRangeHeader(String string) {
        double[] dArray = new double[]{-1.0, -1.0};
        if (string != null) {
            if (string.startsWith("npt")) {
                String string2 = string.substring(4).trim();
                int n = string2.indexOf("-");
                String string3 = string2;
                String string4 = null;
                if (n >= 0) {
                    string4 = string2.substring(n + 1).trim();
                    string3 = string2.substring(0, n).trim();
                    if (string4.length() <= 0) {
                        string4 = null;
                    }
                }
                if (!string3.startsWith("now")) {
                    try {
                        dArray[0] = Double.parseDouble(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string4 != null) {
                        try {
                            dArray[1] = Double.parseDouble(string4);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.decodeRangeHeader: Range format not supported: " + string);
            }
        }
        return dArray;
    }

    public static void stopRTPPull(RTPPushPublishSession rTPPushPublishSession) {
        try {
            IApplicationInstance iApplicationInstance;
            RTPSession rTPSession = rTPPushPublishSession.getRTPSession();
            if (rTPSession != null && (iApplicationInstance = rTPSession.getAppInstance()) != null) {
                Object object;
                IVHost iVHost = iApplicationInstance.getVHost();
                RTPIdleHandler rTPIdleHandler = rTPSession.getIdleHandler();
                if (rTPIdleHandler != null) {
                    object = iVHost.getIdleWorkers();
                    ((IdleWorkersUtil)object).unregisterIdleClient(rTPIdleHandler);
                }
                object = new RTPRequestStatus();
                if (rTPSession != null) {
                    rTPSession.shutdown((RTPRequestStatus)object);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.stopRTPPull: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n, boolean bl2) {
        return RTPUtils.startRTPPull(iApplicationInstance, string, bl, string2, n, -1, bl2);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n) {
        return RTPUtils.startRTPPull(iApplicationInstance, string, bl, string2, n, -1, true);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n, int n2) {
        return RTPUtils.startRTPPull(iApplicationInstance, string, bl, string2, n, n2, true);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n, int n2, boolean bl2) {
        RTPDestination rTPDestination = new RTPDestination();
        rTPDestination.setHost(string2);
        if (bl) {
            rTPDestination.setStreamPort(n);
        } else {
            rTPDestination.setAudioPort(n);
            rTPDestination.setVideoPort(n2);
        }
        rTPDestination.setRTPWrapped(bl2);
        return RTPUtils.startRTPPull(iApplicationInstance, string, rTPDestination);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, RTPDestination rTPDestination) {
        RTPPushPublishSession rTPPushPublishSession = null;
        int n = rTPDestination.getStreamPort();
        int n2 = rTPDestination.getAudioPort();
        int n3 = rTPDestination.getVideoPort();
        String string2 = rTPDestination.getHost();
        String string3 = rTPDestination.getAudioHost();
        String string4 = rTPDestination.getVideoHost();
        int n4 = rTPDestination.isStream() ? 1 : -1;
        boolean bl = rTPDestination.isRTPWrapped();
        boolean bl2 = rTPDestination.isMulticast();
        int n5 = rTPDestination.getTTL();
        if (string2 == null) {
            string2 = string4;
        }
        if (string2 == null) {
            string2 = string3;
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (string4 == null) {
            string4 = string2;
        }
        RTPSession rTPSession = null;
        String string5 = null;
        try {
            IVHost iVHost = iApplicationInstance.getVHost();
            RTPContext rTPContext = iVHost.getRTPContext();
            RTPSessions rTPSessions = rTPContext.getSessions();
            String string6 = rTPSessions.getNextSessionId();
            rTPSession = new RTPSession(string6);
            rTPSessions.addSession(rTPSession);
            String string7 = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + string;
            RTPStream rTPStream = new RTPStream(rTPContext, string7);
            rTPStream.setRTSP(true);
            rTPStream.setMode(1);
            rTPStream.setOutHost(string2);
            rTPSession.addRTSPStream(rTPStream);
            rTPSession.setAppInstance(iApplicationInstance);
            rTPStream.setAppName(iApplicationInstance.getApplication().getName());
            rTPStream.setAppInstanceName(iApplicationInstance.getName());
            String string8 = "mp4";
            String[] stringArray = ModuleUtils.decodeStreamExtension(string, string8);
            string = stringArray[0];
            string8 = stringArray[1];
            rTPStream.setStreamName(string);
            rTPStream.setStreamNameLogging(string);
            rTPStream.setStreamExt(string8);
            rTPStream.setCheckSSRC(false);
            rTPStream.setCheckIpAddr(true);
            rTPSessions.notifySessionCreate(iApplicationInstance, rTPSession);
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            rTPSession.setDescribe(true);
            string5 = rTPStream.describe(rTPSession, n4, rTPRequestStatus);
            if (!rTPStream.streamExists()) {
                rTPStream.createStream(rTPRequestStatus);
            }
            if (rTPStream.streamExists()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                RTPTrack rTPTrack = rTPStream.getStreamTrack();
                String string9 = (rTPTrack != null ? "MP2T/AVP/UDP" : "RTP/AVP/UDP") + ";" + (bl2 ? "multicast" : "unicast") + ";";
                if (rTPTrack != null) {
                    object4 = string9 + "client_port=" + n + "-" + (n + 1);
                    rTPTrack.setup(rTPRequestStatus, (String)object4);
                    rTPTrack.setRTPWrapped(bl);
                    if (bl2) {
                        rTPTrack.setOutHost(string2);
                        rTPTrack.setRTPTTL(n5);
                        rTPTrack.setRTCPTTL(n5);
                    }
                } else {
                    object4 = rTPStream.getVideoTrack();
                    if (object4 != null) {
                        object3 = string9 + "client_port=" + n3 + "-" + (n3 + 1);
                        ((RTPTrack)object4).setup(rTPRequestStatus, (String)object3);
                        ((RTPTrack)object4).setRTPWrapped(bl);
                        if (bl2) {
                            ((RTPTrack)object4).setOutHost(string4);
                            ((RTPTrack)object4).setRTPTTL(n5);
                            ((RTPTrack)object4).setRTCPTTL(n5);
                        }
                    }
                    if ((object3 = rTPStream.getAudioTrack()) != null) {
                        object2 = string9 + "client_port=" + n2 + "-" + (n2 + 1);
                        ((RTPTrack)object3).setup(rTPRequestStatus, (String)object2);
                        ((RTPTrack)object3).setRTPWrapped(bl);
                        if (bl2) {
                            ((RTPTrack)object3).setOutHost(string3);
                            ((RTPTrack)object3).setRTPTTL(n5);
                            ((RTPTrack)object3).setRTCPTTL(n5);
                        }
                    }
                }
                object4 = rTPStream.getTrackNames();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = rTPStream.getTrack((String)object2);
                    ((RTPTrack)object).play(rTPRequestStatus, false);
                }
                rTPStream.play(rTPRequestStatus);
                rTPStream.getMetadataPacket();
                object2 = new RTPIdleHandler(rTPSession);
                rTPSession.setIdleHandler((RTPIdleHandler)object2);
                object = iVHost.getIdleWorkers();
                ((IdleWorkersUtil)object).registerIdleClient((IIdleNotify)object2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.startRTPPull: " + exception.toString());
            exception.printStackTrace();
        }
        if (rTPSession != null) {
            rTPPushPublishSession = new RTPPushPublishSession();
            rTPPushPublishSession.setRTPSession(rTPSession);
            rTPPushPublishSession.setSDPData(string5);
        }
        return rTPPushPublishSession;
    }

    public static void writeCodecConfig(RTPTrack rTPTrack, long l, byte[] byArray) {
        try {
            byte[] byArray2 = null;
            byArray2 = rTPTrack.isAudio() ? new byte[]{-81, 0} : new byte[]{23, 0, 0, 0, 0};
            int n = byArray.length + byArray2.length;
            IMediaStream iMediaStream = rTPTrack.getRTPStream().getStream();
            if (iMediaStream != null) {
                if (rTPTrack.isAudio()) {
                    iMediaStream.setAudioTC(l, true);
                    iMediaStream.setAudioSize(n);
                    iMediaStream.startAudioPacket();
                    iMediaStream.addAudioData(byArray2, 0, byArray2.length);
                    iMediaStream.addAudioData(byArray, 0, byArray.length);
                } else {
                    iMediaStream.setVideoTC(l, true);
                    iMediaStream.setVideoSize(n);
                    iMediaStream.startVideoPacket();
                    iMediaStream.addVideoData(byArray2, 0, byArray2.length);
                    iMediaStream.addVideoData(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.writeCodecConfig: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void loadDePacketizers(RTPContext rTPContext, Element element) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "/Root/RTP/DePacketizers/DePacketizer";
            XPathExpression xPathExpression = xPath.compile(string);
            String string2 = "Properties/Property";
            XPathExpression xPathExpression2 = xPath.compile(string2);
            String string3 = "../Properties/Property";
            XPathExpression xPathExpression3 = xPath.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object object;
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element2, "Class");
                    Node node4 = XMLUtils.getNodeByTagName(element2, "Description");
                    RTPDePacketizerList rTPDePacketizerList = rTPContext.getDePacketizerList();
                    if (node2 == null || node3 == null) continue;
                    Object object2 = XMLUtils.getNodeValue(node2);
                    String string4 = XMLUtils.getNodeValue(node3);
                    String string5 = null;
                    if (node4 != null) {
                        string5 = XMLUtils.getNodeValue(node4);
                    }
                    if (rTPDePacketizerList.exists((String)object2)) {
                        int n = 1;
                        while (rTPDePacketizerList.exists((String)(object = (String)object2 + "[" + n + "]"))) {
                            ++n;
                        }
                        object2 = object;
                    }
                    object = new RTPDePacketizerItem((String)object2, string4);
                    if (string5 != null) {
                        ((RTPDePacketizerItem)object).setDescription(string5);
                    }
                    WMSProperties wMSProperties = ((RTPDePacketizerItem)object).getProperties();
                    NodeList nodeList2 = (NodeList)xPathExpression3.evaluate(element2, XPathConstants.NODESET);
                    if (nodeList2 != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    if ((nodeList2 = (NodeList)xPathExpression2.evaluate(element2, XPathConstants.NODESET)) != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    IRTPDePacketizer iRTPDePacketizer = RTPDePacketizerFactory.createInstance(rTPContext, (RTPDePacketizerItem)object);
                    ((RTPDePacketizerItem)object).setInstance(iRTPDePacketizer);
                    if (iRTPDePacketizer == null) continue;
                    rTPDePacketizerList.put((String)object2, (RTPDePacketizerItem)object);
                    if (!WMSLoggerFactory.getLogger(MediaWriterUtils.class).isDebugEnabled()) continue;
                    WMSLoggerFactory.getLogger(MediaWriterUtils.class).debug(((RTPDePacketizerItem)object).toString());
                }
            } else {
                WMSLoggerFactory.getLogger(RTPUtils.class).error("loadConfigFile: error parsing RTP config file: XPath " + string + " missing");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(RTPContext rTPContext, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                RTPUtils.loadDePacketizers(rTPContext, element);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static RTPStream decodeStreamInfo(RTPContext rTPContext, String string, String string2) {
        RTPStream rTPStream = new RTPStream(rTPContext, string);
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTSPRequestMessage.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        RTPTrack rTPTrack = null;
        String string3 = "";
        int n = -1;
        string2 = string2.replace("\r\n", "\n").replace("\r", "\n");
        String[] stringArray = string2.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            int n2;
            Object object;
            String string5 = stringArray[i].trim();
            if (wMSLogger != null) {
                wMSLogger.debug("sdp: " + string5);
            }
            if (string5.startsWith("m=")) {
                String string6;
                if (rTPTrack != null) {
                    rTPTrack.setAnnounceData(string3);
                    if (rTPTrack.getTrackId().equals("unknown")) {
                        if (rTPTrack.isVideo()) {
                            rTPTrack.setTrackId("video");
                        }
                        if (rTPTrack.isAudio()) {
                            rTPTrack.setTrackId("audio");
                        }
                    }
                    rTPStream.addTrack(rTPTrack);
                    string3 = "";
                }
                rTPTrack = null;
                rTPTrack = new RTPTrack("unknown");
                rTPTrack.setStream(rTPStream);
                if (n > 0) {
                    rTPTrack.setRTPTTL(n);
                    rTPTrack.setRTCPTTL(n);
                }
                if ((string6 = (object = string5.substring(2).split("[ ]"))[0].trim().toLowerCase()).startsWith("audio")) {
                    rTPTrack.setTrackType(8);
                } else if (string6.startsWith("video")) {
                    rTPTrack.setTrackType(9);
                } else if (string6.startsWith("mpegts-transport")) {
                    rTPTrack.setRTCP(false);
                }
                if (((String[])object).length > 1) {
                    try {
                        String string7 = object[1];
                        String[] stringArray2 = string7.split("/");
                        n2 = Integer.parseInt(stringArray2[0]);
                        if (n2 > 0) {
                            rTPTrack.setRTPInPortNum(n2);
                            rTPTrack.setRTCPInPortNum(n2 + 1);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (string5.startsWith("a=videoPID") || string5.startsWith("a=audioPID")) {
                int n3 = -1;
                int n4 = string5.indexOf(":");
                if (n4 >= 0) {
                    String string8 = string5.substring(n4 + 1).trim();
                    int n5 = 10;
                    if (string8.startsWith("0x")) {
                        n5 = 16;
                        string8 = string8.substring(2);
                    }
                    try {
                        n3 = Integer.parseInt(string8, n5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n3 >= 0) {
                    if (string5.startsWith("a=videoPID")) {
                        rTPStream.setMPEGTSVideoPID(n3);
                    }
                    if (string5.startsWith("a=audioPID")) {
                        rTPStream.setMPEGTSAudioPID(n3);
                    }
                }
            } else if (string5.startsWith("a=rtpmap")) {
                if (rTPTrack != null) {
                    String[] stringArray3;
                    int n6 = string5.indexOf(":");
                    if (n6 >= 0) {
                        string5 = string5.substring(n6 + 1);
                    }
                    if ((stringArray3 = string5.split(" ")).length > 0) {
                        int n7 = -1;
                        try {
                            n7 = Integer.parseInt(stringArray3[0].trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPTrack.setRTPMapType(n7);
                    }
                    if (stringArray3.length > 1) {
                        String string9 = stringArray3[stringArray3.length - 1].trim();
                        String[] stringArray4 = string9.split("[/]");
                        if (stringArray4.length > 0) {
                            rTPTrack.addTrackInfo("sample-type", stringArray4[0]);
                            rTPTrack.setSampleType(stringArray4[0]);
                            if (stringArray4[0].startsWith("MP2T")) {
                                rTPTrack.setRTCP(false);
                            }
                        }
                        if (stringArray4.length > 1) {
                            rTPTrack.addTrackInfo("timescale", stringArray4[1]);
                            try {
                                rTPTrack.setTimescale(Integer.parseInt(stringArray4[1]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (rTPTrack.isAudio() && stringArray4.length > 2) {
                            rTPTrack.addTrackInfo("channel-count", stringArray4[2]);
                            try {
                                rTPTrack.setChannelCount(Integer.parseInt(stringArray4[2]));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            } else if (string5.startsWith("a=fmtp")) {
                int n8;
                if (rTPTrack != null && (n8 = string5.indexOf(" ")) >= 0) {
                    String string10 = string5.substring(n8 + 1).trim();
                    String[] stringArray5 = string10.split("[;]");
                    for (int j = 0; j < stringArray5.length; ++j) {
                        int n9;
                        String string11 = stringArray5[j].trim();
                        if (string11.length() == 0 || (n9 = string11.indexOf("=")) < 0) continue;
                        String string12 = string11.substring(0, n9).trim().toLowerCase();
                        string4 = string11.substring(n9 + 1).trim();
                        rTPTrack.addTrackInfo(string12, string4);
                    }
                }
            } else if (string5.startsWith("a=control")) {
                int n10;
                if (rTPTrack != null && (n10 = string5.indexOf(":")) >= 0) {
                    String string13 = string5.substring(n10 + 1);
                    rTPTrack.setTrackId(string13);
                }
            } else if (string5.startsWith("a=cliprect")) {
                int n11;
                if (rTPTrack != null && (n11 = string5.indexOf(":")) >= 0) {
                    String string14 = string5.substring(n11 + 1).trim();
                    rTPTrack.addTrackInfo("cliprect", string14);
                }
            } else if (string5.startsWith("a=framesize")) {
                String[] stringArray6;
                String string15;
                String[] stringArray7;
                int n12;
                if (rTPTrack != null && (n12 = string5.indexOf(":")) >= 0 && (stringArray7 = (string15 = string5.substring(n12 + 1).trim()).split("[ ]")).length >= 2 && (stringArray6 = stringArray7[1].split("[-]")).length >= 2) {
                    try {
                        rTPTrack.setFrameWidth(Integer.parseInt(stringArray6[0]));
                        rTPTrack.setFrameHeight(Integer.parseInt(stringArray6[1]));
                    }
                    catch (Exception exception) {}
                }
            } else if (string5.startsWith("a=ssrc-high")) {
                String string16;
                String[] stringArray8;
                long l = 0L;
                int n13 = string5.indexOf(":");
                if (n13 >= 0 && (stringArray8 = (string16 = string5.substring(n13 + 1).trim()).split("[ ]")).length > 0) {
                    int n14 = 10;
                    if (stringArray8[0].startsWith("0x")) {
                        n14 = 16;
                        stringArray8[0] = stringArray8[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray8[0], n14);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        long l2 = rTPTrack.getSSRC();
                        l2 = (l2 & 0xFFFFFFFFL) + (l << 32);
                        rTPTrack.setSSRC(l2);
                    }
                }
            } else if (string5.startsWith("a=ssrc-low")) {
                String string17;
                String[] stringArray9;
                long l = 0L;
                int n15 = string5.indexOf(":");
                if (n15 >= 0 && (stringArray9 = (string17 = string5.substring(n15 + 1).trim()).split("[ ]")).length > 0) {
                    int n16 = 10;
                    if (stringArray9[0].startsWith("0x")) {
                        n16 = 16;
                        stringArray9[0] = stringArray9[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray9[0], n16);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        long l3 = rTPTrack.getSSRC();
                        l3 = (l3 & 0xFFFFFFFF00000000L) + l;
                        rTPTrack.setSSRC(l3);
                    }
                }
            } else if (string5.startsWith("a=ssrc")) {
                String string18;
                String[] stringArray10;
                long l = 0L;
                int n17 = string5.indexOf(":");
                if (n17 >= 0 && (stringArray10 = (string18 = string5.substring(n17 + 1).trim()).split("[ ]")).length > 0) {
                    int n18 = 10;
                    if (stringArray10[0].startsWith("0x")) {
                        n18 = 16;
                        stringArray10[0] = stringArray10[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray10[0], n18);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        rTPTrack.setSSRC(l);
                    }
                }
            } else if (rTPTrack == null && string5.startsWith("v=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("protocolversion", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("o=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("origin", (String)object);
                    String[] stringArray11 = ((String)object).split("[ ]");
                    if (stringArray11.length > 1) {
                        long l = -1L;
                        try {
                            l = Long.parseLong(stringArray11[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPStream.setStreamSessionId(l);
                    }
                    if (stringArray11.length > 2) {
                        long l = -1L;
                        try {
                            l = Long.parseLong(stringArray11[2]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPStream.setStreamSessionVersion(l);
                    }
                    if (stringArray11.length > 5) {
                        rTPStream.setStreamSessionIp(stringArray11[5]);
                    }
                }
            } else if (rTPTrack == null && string5.startsWith("s=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("name", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("i=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("information", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("u=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("uri", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("e=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("emailaddress", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("p=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("phonenumber", (String)object);
                }
            } else if (string5.startsWith("c=")) {
                object = string5.substring(2).trim();
                if (rTPTrack == null) {
                    if (((String)object).length() > 0) {
                        rTPStream.addStreamInfo("connectiondata", (String)object);
                        String[] stringArray12 = ((String)object).split("[ ]");
                        if (stringArray12.length >= 3) {
                            String string19 = stringArray12[2].trim();
                            int n19 = string19.indexOf("/");
                            String string20 = null;
                            if (n19 >= 0) {
                                string20 = string19.substring(n19 + 1);
                                string19 = string19.substring(0, n19);
                            }
                            if (string20 != null) {
                                int n20 = -1;
                                try {
                                    n20 = Integer.parseInt(string20);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (n20 > 0) {
                                    n = n20;
                                }
                            }
                            rTPStream.setHost(string19);
                        }
                    }
                } else {
                    String[] stringArray13 = ((String)object).split("[ ]");
                    if (stringArray13.length >= 3) {
                        String string21 = stringArray13[2].trim();
                        int n21 = string21.indexOf("/");
                        String string22 = null;
                        if (n21 >= 0) {
                            string22 = string21.substring(n21 + 1);
                            string21 = string21.substring(0, n21);
                        }
                        if (string22 != null) {
                            int n22 = -1;
                            try {
                                n22 = Integer.parseInt(string22);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (n22 > 0) {
                                rTPTrack.setRTPTTL(n22);
                                rTPTrack.setRTCPTTL(n22);
                            }
                        }
                        rTPTrack.setHost(string21);
                    }
                    if (((String)object).length() > 0) {
                        rTPTrack.addTrackInfo("connectiondata", (String)object);
                    }
                }
            } else if (string5.startsWith("b=AS")) {
                if (rTPTrack != null) {
                    int n23 = string5.indexOf(":");
                    if (n23 >= 0) {
                        string5 = string5.substring(n23 + 1).trim();
                    }
                    try {
                        int n24 = Integer.parseInt(string5);
                        rTPTrack.setBitrate(n24 *= 1024);
                    }
                    catch (Exception exception) {}
                }
            } else if (string5.startsWith("b=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    if (rTPTrack == null) {
                        rTPStream.addStreamInfo("bandwidth", (String)object);
                    } else {
                        rTPTrack.addTrackInfo("bandwidth", (String)object);
                    }
                }
            } else if (rTPTrack == null && string5.startsWith("t=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("timing", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("r=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("repeattimes", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("z=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("timezones", (String)object);
                }
            } else if (string5.startsWith("a=proto")) {
                String string23;
                String[] stringArray14;
                int n25;
                if (rTPTrack != null && (n25 = ((String)(object = string5.substring(2).trim())).indexOf(":")) >= 0 && (stringArray14 = (string23 = ((String)object).substring(n25 + 1).trim()).split("[;]"))[0].endsWith("/TCP")) {
                    rTPTrack.setInterleaved(true);
                    for (n2 = 1; n2 < stringArray14.length; ++n2) {
                        int n26;
                        String string24 = stringArray14[n2].trim();
                        if (!string24.startsWith("interleaved=") || (n26 = string24.indexOf("=")) < 0) continue;
                        string4 = string24.substring(n26 + 1);
                        int n27 = string4.indexOf("-");
                        if (n27 > 0) {
                            try {
                                int n28 = Integer.parseInt(string4.substring(0, n27));
                                int n29 = Integer.parseInt(string4.substring(n27 + 1));
                                rTPTrack.setRTPInPortNum(n28);
                                rTPTrack.setRTCPInPortNum(n29);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        try {
                            int n30 = Integer.parseInt(string4.substring(0, n27));
                            rTPTrack.setRTPInPortNum(n30);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else if (string5.startsWith("a=") && ((String)(object = string5.substring(2).trim())).length() != 0) {
                int n31 = ((String)object).indexOf(":");
                Object object2 = null;
                String string25 = null;
                if (n31 >= 0) {
                    object2 = ((String)object).substring(0, n31).trim();
                    string25 = ((String)object).substring(n31 + 1).trim();
                } else {
                    object2 = object;
                }
                if (rTPTrack != null) {
                    rTPTrack.addTrackInfo((String)object2, string25);
                } else {
                    rTPStream.addStreamAttribute((String)object2, string25);
                }
            }
            string3 = string3 + string5 + "\n";
        }
        if (rTPTrack != null) {
            rTPTrack.setAnnounceData(string3);
            if (rTPTrack.getTrackId().equals("unknown")) {
                if (rTPTrack.isVideo()) {
                    rTPTrack.setTrackId("video");
                }
                if (rTPTrack.isAudio()) {
                    rTPTrack.setTrackId("audio");
                }
            }
            rTPStream.addTrack(rTPTrack);
        }
        rTPTrack = null;
        rTPStream.extractCodecConfigFromTrackInfo();
        return rTPStream;
    }

    public static byte[] formatH264CodecConfigPacket(byte[] byArray, List<byte[]> list, byte[] byArray2) {
        byte[] byArray3 = null;
        byte[] byArray4 = RTPUtils.formatH264CodecConfig(byArray, list, byArray2);
        if (byArray4 != null) {
            byArray3 = new byte[5 + byArray4.length];
            int n = 7;
            int n2 = 1;
            byArray3[0] = (byte)(n + (n2 << 4));
            byArray3[1] = 1;
            byArray3[2] = 0;
            byArray3[3] = 0;
            byArray3[4] = 0;
            System.arraycopy(byArray4, 0, byArray3, 5, byArray4.length);
        }
        return byArray3;
    }

    public static byte[] formatH264CodecConfig(byte[] byArray, List<byte[]> list, byte[] byArray2) {
        byte[] byArray3 = null;
        int n = 8 + byArray.length + 1;
        for (byte[] byArray4 : list) {
            n += 2 + byArray4.length;
        }
        byArray3 = new byte[n];
        byArray3[0] = 1;
        boolean bl = false;
        if (byArray2 != null && byArray2.length >= 3) {
            byArray3[1] = byArray2[0];
            byArray3[2] = byArray2[1];
            byArray3[3] = byArray2[2];
            bl = true;
        }
        if (!bl) {
            byArray3[1] = byArray[1];
            byArray3[2] = byArray[2];
            byArray3[3] = byArray[3];
        }
        byArray3[4] = -1;
        byArray3[5] = -31;
        byArray3[6] = (byte)(byArray.length >> 8 & 0xFF);
        byArray3[7] = (byte)(byArray.length >> 0 & 0xFF);
        System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
        byArray3[8 + byArray.length] = (byte)(list.size() & 0xFF);
        Iterator<byte[]> iterator = list.iterator();
        int n2 = 9 + byArray.length;
        while (iterator.hasNext()) {
            byte[] byArray5 = iterator.next();
            byArray3[n2 + 0] = (byte)(byArray5.length >> 8 & 0xFF);
            byArray3[n2 + 1] = (byte)(byArray5.length >> 0 & 0xFF);
            System.arraycopy(byArray5, 0, byArray3, n2 + 2, byArray5.length);
            n2 += 2 + byArray5.length;
        }
        return byArray3;
    }
}

