/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.SystemUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify;
import com.wowza.wms.server.JMXRemoteConfig;
import com.wowza.wms.server.Server;
import com.wowza.wms.transport.udp.UDPPortManager;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.VHostUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHostNotify;
import com.wowza.wms.vhost.VHostSingleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerUtils {
    public static void loadServerListener(IServer iServer, Element element) {
        block8: {
            try {
                Node node = XMLUtils.getNodeByTagName(element, "BaseClass");
                if (node != null) {
                    String string = XMLUtils.getNodeValue(node);
                    string = string.trim();
                    try {
                        Class<?> clazz = Class.forName(string);
                        if (clazz != null) {
                            IServerNotify iServerNotify = (IServerNotify)clazz.newInstance();
                            if (iServerNotify != null) {
                                iServer.addServerListener(iServerNotify);
                            } else {
                                WMSLoggerFactory.getLogger(ServerUtils.class).error("loadServerListener: Error creating serverNotify (" + string + "): Instance null");
                            }
                            break block8;
                        }
                        WMSLoggerFactory.getLogger(ServerUtils.class).error("loadServerListener: Error creating serverNotify (" + string + "): Class null");
                    }
                    catch (Exception exception) {}
                    break block8;
                }
                WMSLoggerFactory.getLogger(ServerUtils.class).error("loadServerListener: error parsing server config file: BaseClass element required.");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ServerUtils.class).error("loadServerListener: error parsing server config file: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void loadVHostListener(Element element) {
        block8: {
            try {
                Node node = XMLUtils.getNodeByTagName(element, "BaseClass");
                if (node != null) {
                    String string = XMLUtils.getNodeValue(node);
                    string = string.trim();
                    try {
                        Class<?> clazz = Class.forName(string);
                        if (clazz != null) {
                            IVHostNotify iVHostNotify = (IVHostNotify)clazz.newInstance();
                            if (iVHostNotify != null) {
                                VHostSingleton.addVHostListener(iVHostNotify);
                            } else {
                                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadVHostListener: Error creating serverNotify (" + string + "): Instance null");
                            }
                            break block8;
                        }
                        WMSLoggerFactory.getLogger(VHostUtils.class).error("loadVHostListener: Error creating serverNotify (" + string + "): Class null");
                    }
                    catch (Exception exception) {}
                    break block8;
                }
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadVHostListener: error parsing server config file: BaseClass element required.");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadVHostListener: error parsing server config file: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void loadJMXRemoteConfiguration(JMXRemoteConfig jMXRemoteConfig, Element element) {
        try {
            String string;
            Node node = XMLUtils.getNodeByTagName(element, "Enable");
            Node node2 = XMLUtils.getNodeByTagName(element, "IpAddress");
            Node node3 = XMLUtils.getNodeByTagName(element, "RMIConnectionPort");
            Node node4 = XMLUtils.getNodeByTagName(element, "RMIRegistryPort");
            Node node5 = XMLUtils.getNodeByTagName(element, "RMIServerHostName");
            Node node6 = XMLUtils.getNodeByTagName(element, "Authenticate");
            Node node7 = XMLUtils.getNodeByTagName(element, "PasswordFile");
            Node node8 = XMLUtils.getNodeByTagName(element, "AccessFile");
            Node node9 = XMLUtils.getNodeByTagName(element, "SSLSecure");
            if (node != null) {
                string = XMLUtils.getNodeValue(node);
                boolean n = string.toLowerCase().contains("true");
                jMXRemoteConfig.setEnabled(n);
            }
            if (node9 != null) {
                string = XMLUtils.getNodeValue(node9);
                boolean bl = string.toLowerCase().contains("true");
                jMXRemoteConfig.setSSL(bl);
            }
            if (node6 != null) {
                string = XMLUtils.getNodeValue(node6);
                boolean bl = string.toLowerCase().contains("true");
                jMXRemoteConfig.setAuthenticate(bl);
            }
            if (node3 != null) {
                int n;
                string = XMLUtils.getNodeValue(node3);
                int n2 = jMXRemoteConfig.getRmiConnectionPort();
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ServerUtils.class).error("loadJMXRemoteConfiguration: invalid port number: " + string);
                }
                jMXRemoteConfig.setRmiConnectionPort(n);
            }
            if (node4 != null) {
                int n;
                string = XMLUtils.getNodeValue(node4);
                int n3 = jMXRemoteConfig.getRmiRegistryPort();
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ServerUtils.class).error("loadJMXRemoteConfiguration: invalid port number: " + string);
                }
                jMXRemoteConfig.setRmiRegistryPort(n);
            }
            if (node7 != null) {
                string = XMLUtils.getNodeValue(node7);
                jMXRemoteConfig.setPasswordFile(SystemUtils.expandEnvironmentVariables(string));
            }
            if (node8 != null) {
                string = XMLUtils.getNodeValue(node8);
                jMXRemoteConfig.setAccessFile(SystemUtils.expandEnvironmentVariables(string));
            }
            if (node2 != null) {
                string = XMLUtils.getNodeValue(node2);
                if (string != null) {
                    string = SystemUtils.expandEnvironmentVariables(string);
                }
                jMXRemoteConfig.setIpAddress(string);
            }
            if (node5 != null && (string = XMLUtils.getNodeValue(node5)) != null && (string = SystemUtils.expandEnvironmentVariables(string)).length() > 0) {
                jMXRemoteConfig.setRmiServerHostName(string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ServerUtils.class).error("loadJMXRemoteConfiguration: error parsing server config file: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IServer iServer, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading Server.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                String string2;
                Object object;
                Object object2;
                Object object3;
                String[] stringArray;
                Object object4;
                String string3;
                Element element = document.getDocumentElement();
                if (XMLUtils.getXMLPropertyExists(xPath, "/Root/Server/ThreadPool/PoolSize", element)) {
                    int n = XMLUtils.getXMLPropertyInt(xPath, "/Root/Server/ThreadPool/PoolSize", element, 0);
                    iServer.setCoreHandlerPoolSize(n / 2);
                    iServer.setCoreTransportPoolSize(n / 2);
                } else {
                    iServer.setCoreTransportPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/Server/TransportThreadPool/PoolSize", element, iServer.getCoreTransportPoolSize()));
                    iServer.setCoreHandlerPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/Server/HandlerThreadPool/PoolSize", element, iServer.getCoreHandlerPoolSize()));
                }
                String string4 = "/Root/Server/CommandInterface/HostPort";
                HostPort hostPort = VHostUtils.loadHostPort(element, null, string4);
                iServer.setCommandInterfaceHostPort(hostPort);
                String string5 = "/Root/Server/JMXRemoteConfiguration";
                XPathExpression xPathExpression = xPath.compile(string5);
                Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (node != null) {
                    ServerUtils.loadJMXRemoteConfiguration(((Server)iServer).getJmxRemoteConfig(), (Element)node);
                }
                if ((string3 = XMLUtils.getXMLPropertyStr(xPath, "/Root/Server/UserAgents", element, null)) != null) {
                    object4 = string3.split("[|]");
                    iServer.setUserAgents((String[])object4);
                }
                if ((object4 = XMLUtils.getXMLPropertyStr(xPath, "/Root/Server/AdminInterface/ObjectList", element, null)) != null) {
                    stringArray = ((String)object4).split("[,]");
                    object3 = iServer.getAdminInterfaceObjectList();
                    object3.clear();
                    for (int i = 0; i < stringArray.length; ++i) {
                        object2 = stringArray[i].trim().toLowerCase();
                        if (((String)object2).length() <= 0) continue;
                        object3.add(object2);
                    }
                }
                stringArray = "/Root/Server/Properties/Property";
                object3 = iServer.getProperties();
                XMLUtils.loadConfigProperies(element, (String)stringArray, (WMSProperties)object3);
                String string6 = "/Root/Server/ServerListeners/ServerListener";
                object2 = xPath.compile(string6);
                NodeList nodeList = (NodeList)object2.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object = nodeList.item(i);
                        Element element2 = (Element)object;
                        ServerUtils.loadServerListener(iServer, element2);
                    }
                }
                if ((nodeList = (NodeList)(object = xPath.compile(string2 = "/Root/Server/VHostListeners/VHostListener")).evaluate(element, XPathConstants.NODESET)) != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node2 = nodeList.item(i);
                        Element element3 = (Element)node2;
                        ServerUtils.loadVHostListener(element3);
                    }
                }
                UDPPortManager uDPPortManager = iServer.getUDPPortManager();
                uDPPortManager.setDatagramStaringPort(XMLUtils.getXMLPropertyInt(xPath, "/Root/Server/RTP/DatagramStartingPort", element, uDPPortManager.getDatagramStartingPort()));
                uDPPortManager.setDatagramPortSharing(XMLUtils.getXMLPropertyBool(xPath, "/Root/Server/RTP/DatagramPortSharing", element, uDPPortManager.isDatagramPortSharing()));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ServerUtils.class).error("loadConfigFile: error parsing server config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

