/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;

public class HostPortConfig
extends SocketSessionConfigImpl {
    int acceptorBackLog = 100;
    int connectionTimeout = 10000;

    private void configureSessionConfig(SocketSessionConfig socketSessionConfig) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HostPortConfig.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        try {
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setReuseAddress: from:" + socketSessionConfig.isReuseAddress() + " to:" + this.isReuseAddress());
            }
            socketSessionConfig.setReuseAddress(this.isReuseAddress());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setReceiveBufferSize: from:" + socketSessionConfig.getReceiveBufferSize() + " to:" + this.getReceiveBufferSize());
            }
            socketSessionConfig.setReceiveBufferSize(this.getReceiveBufferSize());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setSendBufferSize: from:" + socketSessionConfig.getSendBufferSize() + " to:" + this.getSendBufferSize());
            }
            socketSessionConfig.setSendBufferSize(this.getSendBufferSize());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setTrafficClass: from:" + socketSessionConfig.getTrafficClass() + " to:" + this.getTrafficClass());
            }
            socketSessionConfig.setTrafficClass(this.getTrafficClass());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setKeepAlive: from:" + socketSessionConfig.isKeepAlive() + " to:" + this.isKeepAlive());
            }
            socketSessionConfig.setKeepAlive(this.isKeepAlive());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setOobInline: from:" + socketSessionConfig.isOobInline() + " to:" + this.isOobInline());
            }
            socketSessionConfig.setOobInline(this.isOobInline());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setSoLinger: from:" + socketSessionConfig.getSoLinger() + " to:" + this.getSoLinger());
            }
            socketSessionConfig.setSoLinger(this.getSoLinger());
            if (wMSLogger != null) {
                wMSLogger.debug("config: session: setTcpNoDelay: from:" + socketSessionConfig.isTcpNoDelay() + " to:" + this.isTcpNoDelay());
            }
            socketSessionConfig.setTcpNoDelay(this.isTcpNoDelay());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPortConfig.class).error("configureSessionConfig: " + exception.toString());
        }
    }

    public void configureSocketConnector(SocketConnectorConfig socketConnectorConfig) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HostPortConfig.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        try {
            SocketSessionConfig socketSessionConfig = (SocketSessionConfig)socketConnectorConfig.getSessionConfig();
            if (socketSessionConfig != null) {
                this.configureSessionConfig(socketSessionConfig);
            }
            int n = this.getConnectionTimeout();
            if ((n /= 1000) < 1) {
                n = 1;
            }
            if (wMSLogger != null) {
                wMSLogger.debug("config: connection: setConnectTimeout: from:" + socketConnectorConfig.getConnectTimeout() + " to:" + n);
            }
            socketConnectorConfig.setConnectTimeout(n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPortConfig.class).error("configureSocketConnector: " + exception.toString());
        }
    }

    public void configureSocketAcceptor(SocketAcceptorConfig socketAcceptorConfig) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HostPortConfig.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        try {
            if (wMSLogger != null) {
                wMSLogger.debug("config: socket: setReuseAddress: from:" + socketAcceptorConfig.isReuseAddress() + " to:" + this.isReuseAddress());
            }
            socketAcceptorConfig.setReuseAddress(this.isReuseAddress());
            socketAcceptorConfig.setBacklog(this.getAcceptorBackLog());
            SocketSessionConfig socketSessionConfig = (SocketSessionConfig)socketAcceptorConfig.getSessionConfig();
            if (socketSessionConfig != null) {
                this.configureSessionConfig(socketSessionConfig);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPortConfig.class).error("configureSocketAcceptor: " + exception.toString());
        }
    }

    public int getAcceptorBackLog() {
        return this.acceptorBackLog;
    }

    public void setAcceptorBackLog(int n) {
        this.acceptorBackLog = n;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }
}

