/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSessionHolder;
import com.wowza.wms.vhost.VHostSessionIdleBase;
import com.wowza.wms.vhost.VHostSessionIdleHTTP;
import com.wowza.wms.vhost.VHostSessionIdleHTTPStreamer;
import com.wowza.wms.vhost.VHostSessionIdleMediaCaster;
import com.wowza.wms.vhost.VHostSessionIdleNetConnection;
import com.wowza.wms.vhost.VHostSessionIdleRTMP;
import com.wowza.wms.vhost.VHostSessionIdleRTSP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VHostSessionMap {
    private IVHost vhost = null;
    private Map<Object, VHostSessionHolder> sessionMap = new HashMap<Object, VHostSessionHolder>();

    public VHostSessionMap(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public synchronized void addSession(Object object) {
        VHostSessionHolder vHostSessionHolder = new VHostSessionHolder();
        vHostSessionHolder.session = (BaseIoSession)object;
        vHostSessionHolder.vhost = this.vhost;
        this.sessionMap.put(object, vHostSessionHolder);
    }

    public synchronized void removeSession(Object object) {
        VHostSessionHolder vHostSessionHolder = this.sessionMap.remove(object);
        if (vHostSessionHolder != null && vHostSessionHolder.idleNotify != null) {
            this.vhost.getIdleWorkers().unregisterIdleClient(vHostSessionHolder.idleNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifySessionOpen(Object object, int n, IClient iClient) {
        VHostSessionHolder vHostSessionHolder = this.sessionMap.get(object);
        if (vHostSessionHolder != null && vHostSessionHolder.idleNotify == null) {
            VHostSessionIdleBase vHostSessionIdleBase = null;
            switch (n) {
                case 1: {
                    vHostSessionIdleBase = new VHostSessionIdleRTMP(vHostSessionHolder);
                    break;
                }
                case 37: {
                    vHostSessionIdleBase = new VHostSessionIdleHTTPStreamer(vHostSessionHolder);
                    break;
                }
                case 3: 
                case 32: 
                case 33: {
                    vHostSessionIdleBase = new VHostSessionIdleHTTP(vHostSessionHolder);
                    break;
                }
                case 34: 
                case 38: {
                    vHostSessionIdleBase = new VHostSessionIdleRTSP(vHostSessionHolder);
                    break;
                }
                case 16: {
                    vHostSessionIdleBase = new VHostSessionIdleMediaCaster(vHostSessionHolder);
                    break;
                }
                case 17: {
                    vHostSessionIdleBase = new VHostSessionIdleNetConnection(vHostSessionHolder);
                }
            }
            VHostSessionHolder vHostSessionHolder2 = vHostSessionHolder;
            synchronized (vHostSessionHolder2) {
                vHostSessionHolder.client = (Client)iClient;
                vHostSessionHolder.protocol = n;
                vHostSessionHolder.idleNotify = vHostSessionIdleBase;
            }
            if (vHostSessionIdleBase != null) {
                this.vhost.getIdleWorkers().registerIdleClient((IIdleNotify)((Object)vHostSessionIdleBase));
            }
        }
    }

    public synchronized List<Object> getSessions() {
        return new ArrayList<Object>(this.sessionMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledWriteMaxSessionBytes() {
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                int n = ioSession.getScheduledWriteBytes();
                if ((long)n <= l) continue;
                l = n;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteMaxSessionClientId() {
        int n = 0;
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                int n2 = ioSession.getScheduledWriteBytes();
                if ((long)n2 <= l) continue;
                RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
                n = rtmpSessionInfo != null ? rtmpSessionInfo.getClientId() : 0;
                l = n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledReadMaxSessionBytes() {
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                long l2 = ioSession.getMessageBytesWaiting();
                if (l2 <= l) continue;
                l = l2;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledWriteSessions() {
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                if (ioSession.getScheduledWriteRequests() <= 0) continue;
                ++l;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledWriteRequests() {
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                l += (long)ioSession.getScheduledWriteRequests();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledWriteBytes() {
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                l += (long)ioSession.getScheduledWriteBytes();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitingReadBytes() {
        long l = 0L;
        ArrayList<Object> arrayList = null;
        VHostSessionMap vHostSessionMap = this;
        synchronized (vHostSessionMap) {
            arrayList = new ArrayList<Object>(this.sessionMap.keySet());
        }
        if (arrayList != null) {
            for (IoSession ioSession : arrayList) {
                l += ioSession.getMessageBytesWaiting();
            }
        }
        return l;
    }
}

