/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayWriteControl;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264Cursor;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264ReadAheadRequest;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.IQTDataDataToAMF;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderH264
implements IMediaReader,
IQTDataDataToAMF {
    protected MediaReaderItem mediaReaderItem = null;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = Base64.endsWith((String)"ui.", (int)(30 + -6));
    protected String mediaReaderExt = FileChunk.lastIndexOf((int)(29 * 21), (String)",2w");
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = Base64.endsWith((String)"0.k", (int)(106 + 19));
    protected QTMediaContainer container = null;
    protected H264Cursor cursor = null;
    protected H264Cursor cursorReadAhead = null;
    protected H264ReadAheadRequest currReadAhead = null;
    protected H264ReadAheadRequest nextReadAhead = null;
    protected boolean cacheReadAhead = false;
    protected List<H264ReadAheadRequest> readAheadCache = new ArrayList<H264ReadAheadRequest>();
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected int indexBufferSize = 16384;
    protected boolean useDisplaySize = true;
    protected IRandomAccessReader videoFileStream = null;
    protected IRandomAccessReader metaFileStream = null;
    protected List metaData = null;
    protected long duration = -1L;
    protected long length = 0L;
    protected long videoSampleCount = -1L;
    protected long audioSampleCount = -1L;
    protected long dataSampleCount = -1L;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean doSendVideoTrakInfo = false;
    protected boolean doSendAudioTrakInfo = false;
    protected boolean doSendEnhanceSeek = false;
    protected boolean errorReported = false;
    protected int audioType = 175;
    protected int audioExtraSize = 2;
    protected String randomAccessReaderClass = FileChunk.lastIndexOf((int)(69 + -20), (String)"r}~:by`bx4rs3Zv2$!7\u0016$(#'$\u000b(/(=<\u00024371'");
    protected IApplicationInstance appInstance = null;
    protected int videoCodec = 7;
    protected int audioCodec = 10;
    protected boolean openAudioTrack = true;
    protected boolean openVideoTrack = true;
    protected int trackIndexVideo = 0;
    protected int trackIndexAudio = 0;
    protected int trackIndexData = 0;
    protected String trackDataCharSet = Base64.endsWith((String)"]]L&4", (int)(116 + -76));
    protected long onMetadataSample = -1L;
    protected IQTDataDataToAMF dataDataToAMFHandler = this;
    static long a = -1L;

    public MediaReaderH264() {
        this.chunkHeaderValues = new int[5];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.readAheadSize = wMSProperties.getPropertyInt(Base64.endsWith((String)"1-j\re`fBl`gc[`pn", (int)(126 + -2)), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(FileChunk.lastIndexOf((int)(439 / 70), (String)"kw<[ojhLfjquFa}rqrj"), this.readAheadTrigger);
        this.indexBufferSize = wMSProperties.getPropertyInt(FileChunk.lastIndexOf((int)(807 / 175), (String)"iu2NfmosNxhiucAznp"), this.indexBufferSize);
        this.cacheReadAhead = wMSProperties.getPropertyBoolean(FileChunk.lastIndexOf((int)(56 - -54), (String)"#?d\u001230<0\u000429=\u001b39<:"), this.cacheReadAhead);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(FileChunk.lastIndexOf((int)(57 * 53), (String)"?/!4>?\u0012763$+\u000b?:88,\u001c, 10"), this.randomAccessReaderClass);
        this.useDisplaySize = wMSProperties.getPropertyBoolean(FileChunk.lastIndexOf((int)(45 * 27), (String)"r0u\u00170!\u0001/48%+2\u001f$4*"), this.useDisplaySize);
        if (!WMSLoggerFactory.getLogger(MediaReaderH264.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.endsWith((String)"Kbl`kYiljjbY % ;{g,K\u007fzx\\vzaeQj~`<'", (int)(941 / 147)) + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(-53 - -64), (String)"FiignBtswqg^%.-4vl)LzaeCkadbSz`mli\u007f4/") + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(916 / 140), (String)"Kbl`kYiljjbY % ;{g,Pt\u007fye\\jfggqWl|b2)") + this.indexBufferSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(938 / 171), (String)"HccahXnmik}X#$':gwy|vwZ\u007f~{lsSgb``tDdhyx6-") + this.randomAccessReaderClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.metaFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        this.videoFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            block16: {
                block14: {
                    Exception exception3;
                    block15: {
                        block12: {
                            QTParseContext qTParseContext;
                            block13: {
                                block10: {
                                    block11: {
                                        if (this.metaFileStream.isOpen()) {
                                            this.close();
                                        }
                                        try {
                                            this.metaFileStream.open();
                                            this.videoFileStream.open();
                                            this.errorReported = false;
                                            break block10;
                                        }
                                        catch (Exception exception2) {
                                            if (this.errorReported) break block11;
                                        }
                                        WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, FileChunk.lastIndexOf((int)(833 / 201), (String)"I`bni[ojhh|G\"'&={esyC(G!<") + exception2.toString(), null, Base64.endsWith((String)">+=&4 ", (int)(16 + 61)), "comment", 404, this.mediaName);
                                    }
                                    this.errorReported = true;
                                }
                                if (this.metaFileStream == null) return;
                                if (!this.metaFileStream.isOpen()) return;
                                try {
                                    this.length = this.metaFileStream.length();
                                    qTParseContext = new QTParseContext();
                                    qTParseContext.setClientId(this.stream.getClientId());
                                    qTParseContext.setIndexBufferSize(this.indexBufferSize);
                                    qTParseContext.setParseAudioTrack(this.openAudioTrack);
                                    qTParseContext.setParseVideoTrack(this.openVideoTrack);
                                    IRandomAccessReader iRandomAccessReader = this.metaFileStream;
                                    this.container = QTUtils.parseQTMediaContainer(iRandomAccessReader, iRandomAccessReader.length(), qTParseContext);
                                    if (this.container == null) break block12;
                                    MediaReaderH264 mediaReaderH264 = this;
                                    this.appInstance.notifyMediaReaderOpen((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
                                    QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                    QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                    QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                    this.cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 2);
                                    if (this.cursor == null) break block13;
                                }
                                catch (Exception exception3) {
                                    if (this.errorReported) break block14;
                                    break block15;
                                }
                                this.videoSampleCount = this.cursor.getVideoSampleCount();
                                this.audioSampleCount = this.cursor.getAudioSampleCount();
                                this.dataSampleCount = this.cursor.getDataSampleCount();
                            }
                            this.readMetadata();
                            MediaReaderH264 mediaReaderH264 = this;
                            this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
                            if (qTParseContext.getIndexRefCount() <= 0) {
                                this.metaFileStream.close();
                                this.metaFileStream = null;
                            }
                        }
                        if (this.container != null) return;
                        if (!this.errorReported) {
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.endsWith((String)"I`bni[ojhh|G\"'&=:zfrv#:^noqm qcqwlh`(ocgi-h`b|sg4N[G,D", (int)(920 / 229)), null, Base64.endsWith((String)"pawpbz", (int)(483 / 129)), "comment", 500, this.mediaName);
                        }
                        this.errorReported = true;
                        break block16;
                    }
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.endsWith((String)"I`bni[ojhh|G\"'&={esyC+G!<", (int)(347 / 80)) + exception3.toString(), null, FileChunk.lastIndexOf((int)(350 / 96), (String)"pawpbz"), "comment", 404, this.mediaName);
                }
                this.errorReported = true;
                this.container = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.container == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.container = null;
        try {
            if (this.videoFileStream != null) {
                this.videoFileStream.close();
            }
            if (this.metaFileStream != null) {
                this.metaFileStream.close();
            }
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.endsWith((String)"@kkyp@vuqseP+,/2rnzn;\"", (int)(100 + 41)) + exception.toString());
        }
        this.metaData = null;
        this.duration = -1L;
        this.videoSampleCount = -1L;
        this.dataSampleCount = -1L;
        this.audioSampleCount = -1L;
        this.cursor = null;
        this.length = 0L;
        this.onMetadataSample = -1L;
        MediaReaderH264 mediaReaderH264 = this;
        this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
    }

    /*
     * Unable to fully structure code
     */
    protected void readMetadata() {
        block77: {
            block66: {
                block50: {
                    block49: {
                        block81: {
                            block71: {
                                block70: {
                                    block86: {
                                        block54: {
                                            block53: {
                                                block65: {
                                                    block48: {
                                                        block72: {
                                                            block60: {
                                                                block59: {
                                                                    block80: {
                                                                        block58: {
                                                                            block68: {
                                                                                block57: {
                                                                                    block52: {
                                                                                        block79: {
                                                                                            block78: {
                                                                                                block64: {
                                                                                                    block67: {
                                                                                                        block69: {
                                                                                                            block62: {
                                                                                                                block51: {
                                                                                                                    block61: {
                                                                                                                        block55: {
                                                                                                                            block63: {
                                                                                                                                block56: {
                                                                                                                                    if (this.container != null) break block78;
                                                                                                                                    break block79;
lbl3:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        var13_17 = var3_2.getMdiaAtom().getTimescale();
                                                                                                                                        var15_23 = var3_2.getMdiaAtom().getDuration();
                                                                                                                                        var11_11 = (double)var15_23 / (double)var13_17;
                                                                                                                                        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(5 * 51), (String)")iegl@ptf|`ee6") + var11_11 + ":" + var13_17 + ":" + var15_23);
                                                                                                                                        break block48;
                                                                                                                                        break;
                                                                                                                                    }
lbl9:
                                                                                                                                    // 2 sources

                                                                                                                                    while (true) {
                                                                                                                                        ++var9_5;
                                                                                                                                        break block49;
                                                                                                                                        break;
                                                                                                                                    }
lbl12:
                                                                                                                                    // 2 sources

                                                                                                                                    while (true) {
                                                                                                                                        var1_1.put(FileChunk.lastIndexOf((int)(2 - 28), (String)"'&+(%?"), (AMFData)new AMFDataItem(2.0));
                                                                                                                                        if (var4_29 == null) break block50;
                                                                                                                                        break block51;
                                                                                                                                        break;
                                                                                                                                    }
lbl16:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        var1_1.put(Base64.endsWith((String)":'+$9", (int)(5 * 41)), (AMFData)new AMFDataItem(var4_29.getDisplayWidth()));
                                                                                                                                        var1_1.put(Base64.endsWith((String)"=3>?1.", (int)(15 * 59)), (AMFData)new AMFDataItem(var4_29.getDisplayHeight()));
                                                                                                                                        break block52;
                                                                                                                                        break;
                                                                                                                                    }
lbl20:
                                                                                                                                    // 2 sources

                                                                                                                                    while (true) {
                                                                                                                                        if (var4_29 == null) break block53;
                                                                                                                                        break block54;
                                                                                                                                        break;
                                                                                                                                    }
lbl23:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        this.cursor.moveNextSample();
                                                                                                                                        if (!this.cursor.isAtEnd()) break block55;
                                                                                                                                        break block56;
                                                                                                                                        break;
                                                                                                                                    }
lbl28:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        v0 = var3_2.getMdiaAtom().getMinfAtom().getStblAtom();
                                                                                                                                        break block57;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    while (true) {
                                                                                                                                        var11_14.put(FileChunk.lastIndexOf((int)(11 - -47), (String)"izqmrz$$1 6,63!&$"), (AMFData)var12_38);
                                                                                                                                        var7_31.add((AMFData)var11_14);
                                                                                                                                        ** GOTO lbl9
                                                                                                                                        break;
                                                                                                                                    }
lbl35:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        if (!this.useDisplaySize) break block58;
                                                                                                                                        ** continue;
                                                                                                                                        break;
                                                                                                                                    }
lbl38:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        var1_1.put(Base64.endsWith((String)":=129::39", (int)(50 - -28)), (AMFData)var7_31);
                                                                                                                                        if (var6_3 == null) break block59;
                                                                                                                                        break block60;
                                                                                                                                        break;
                                                                                                                                    }
lbl42:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        var7_32 = this.cursor.getDataSampleCount();
                                                                                                                                        if (var7_32 <= 0L) break block61;
                                                                                                                                        break block62;
                                                                                                                                        break;
                                                                                                                                    }
lbl46:
                                                                                                                                    // 1 sources

                                                                                                                                    while (true) {
                                                                                                                                        if (var18_27 != null) break block63;
                                                                                                                                        break block64;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                }
lbl50:
                                                                                                                                // 4 sources

                                                                                                                                while (true) {
                                                                                                                                    this.setStreamPosition(var9_7);
                                                                                                                                    break block61;
                                                                                                                                    break;
                                                                                                                                }
lbl53:
                                                                                                                                // 1 sources

                                                                                                                                while (true) {
                                                                                                                                    v0 = null;
                                                                                                                                    break block57;
                                                                                                                                    break;
                                                                                                                                }
lbl56:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    var1_1.put(Base64.endsWith((String)"+7;%.$1%(#5)=/", (int)(6 - 41)), (AMFData)new AMFDataItem(var11_15));
                                                                                                                                    ** GOTO lbl12
                                                                                                                                    break;
                                                                                                                                }
lbl59:
                                                                                                                                // 1 sources

                                                                                                                                while (true) {
                                                                                                                                    var9_8 = var3_2.getMdiaAtom().getTimescale();
                                                                                                                                    var11_15 = 0.0;
                                                                                                                                    if (var4_29.getTimeToSample() == null) ** GOTO lbl56
                                                                                                                                    break block65;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                            }
lbl65:
                                                                                                                            // 4 sources

                                                                                                                            return;
                                                                                                                        }
                                                                                                                        ++var10_35;
                                                                                                                        break block80;
lbl70:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            var15_22 = new AMFDataObj();
                                                                                                                            var16_25 = var14_40.next();
                                                                                                                            var15_22.put(FileChunk.lastIndexOf((int)(39 * 9), (String)",!,2/!1?7-"), (AMFData)new AMFDataItem((String)var16_25));
                                                                                                                            var12_38.add((AMFData)var15_22);
                                                                                                                            break block66;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        var7_31 = new AMFDataArray();
                                                                                                                        var8_33 = var2_28.getTrakCount();
                                                                                                                        var9_5 = 0;
                                                                                                                        break block49;
                                                                                                                        break;
                                                                                                                    }
lbl82:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        v1 = var5_30.getMdiaAtom().getMinfAtom().getStblAtom();
                                                                                                                        break block67;
                                                                                                                        break;
                                                                                                                    }
lbl85:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        if (var11_13 == 18) break block68;
                                                                                                                        break block69;
                                                                                                                        break;
                                                                                                                    }
lbl88:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        var1_1.put(FileChunk.lastIndexOf((int)(35 + 47), (String)"3%793!=5"), (AMFData)new AMFDataItem(var9_9.getAvcLevel()));
                                                                                                                        var1_1.put(FileChunk.lastIndexOf((int)(47 - 50), (String)"<(<psmemic"), (AMFData)new AMFDataItem(var9_9.getAvcProfile()));
                                                                                                                        break block50;
                                                                                                                        break;
                                                                                                                    }
lbl92:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        var17_51 = var6_3.getDataTypes();
                                                                                                                        var18_27 = this.getAudioCodecConfig(0L);
                                                                                                                        if (var17_51.contains(Base64.endsWith((String)")ey9", (int)(97 + 38)))) break block64;
                                                                                                                        break block70;
                                                                                                                        break;
                                                                                                                    }
lbl97:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        var11_11 = 0.0;
                                                                                                                        if (var3_2 != null) {
                                                                                                                            ** continue;
                                                                                                                        }
                                                                                                                        break block48;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                var9_9 = var4_29.getAVCCData();
                                                                                                                if (var9_9 == null) break block50;
                                                                                                                ** while (true)
lbl106:
                                                                                                                // 1 sources

                                                                                                                while (true) {
                                                                                                                    var1_1.put(Base64.endsWith((String)"-8*&?2=716?3", (int)(98 + 106)), (AMFData)new AMFDataItem(var6_3.getDataTypes().get(0)));
                                                                                                                    ** GOTO lbl20
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            var9_7 = this.getStreamPosition();
                                                                                                            var10_35 = 0;
                                                                                                            break block80;
                                                                                                        }
                                                                                                        if (var11_13 != 15) break block72;
                                                                                                        break block68;
lbl116:
                                                                                                        // 3 sources

                                                                                                        while (true) {
                                                                                                            var1_1.put(FileChunk.lastIndexOf((int)(47 * 25), (String)"zwvlksnwkinl"), (AMFData)new AMFDataItem(this.container.getMoovAtom().getOffset() + 8L));
                                                                                                            var9_4 = 0.0;
                                                                                                            if (var5_30 == null) ** GOTO lbl97
                                                                                                            break block71;
                                                                                                            break;
                                                                                                        }
lbl121:
                                                                                                        // 1 sources

                                                                                                        while (true) {
                                                                                                            var1_1.put(FileChunk.lastIndexOf((int)(41 + 11), (String)"rgwz}k{oy"), (AMFData)new AMFDataItem(var9_10));
                                                                                                            ** GOTO lbl116
                                                                                                            break;
                                                                                                        }
                                                                                                    }
lbl125:
                                                                                                    // 2 sources

                                                                                                    while (true) {
                                                                                                        var6_3 = v1;
                                                                                                        if (this.cursor == null) ** continue;
                                                                                                        ** continue;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                this.audioType = 47;
                                                                                                this.audioExtraSize = 1;
                                                                                                this.audioCodec = 2;
                                                                                                ** GOTO lbl65
                                                                                            }
                                                                                            this.metaData = new ArrayList<E>();
                                                                                            var1_1 = new AMFDataMixedArray();
                                                                                            ** while ((var3_2 = (var2_28 = this.container.getMoovAtom()).getVideoTrack((int)this.trackIndexVideo)) != null)
lbl138:
                                                                                            // 1 sources

                                                                                            ** while (true)
                                                                                        }
                                                                                        this.metaData = null;
                                                                                        return;
                                                                                    }
lbl143:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var1_1.put(FileChunk.lastIndexOf((int)(855 / 146), (String)"ctfel]bhyf"), (AMFData)new AMFDataItem(var4_29.getFrameWidth()));
                                                                                        var1_1.put(FileChunk.lastIndexOf((int)(1471 / 223), (String)"`uidoCidigd"), (AMFData)new AMFDataItem(var4_29.getFrameHeight()));
                                                                                        var1_1.put(Base64.endsWith((String)"?5..3axUj`qn", (int)(23 * 61)), (AMFData)new AMFDataItem(var4_29.getDisplayWidth()));
                                                                                        var1_1.put(FileChunk.lastIndexOf((int)(1 + 32), (String)"ekptig~@lcldy"), (AMFData)new AMFDataItem(var4_29.getDisplayHeight()));
                                                                                        var9_10 = var4_29.getFrameRate();
                                                                                        if (!(var9_10 > 0.0)) ** GOTO lbl116
                                                                                        ** continue;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                var4_29 = v0;
                                                                                ** while ((var5_30 = var2_28.getAudioTrack((int)this.trackIndexAudio)) != null)
lbl154:
                                                                                // 1 sources

                                                                                break block81;
                                                                            }
                                                                            try {
                                                                                block84: {
                                                                                    block85: {
                                                                                        block73: {
                                                                                            block83: {
                                                                                                block76: {
                                                                                                    block75: {
                                                                                                        block74: {
                                                                                                            block82: {
                                                                                                                var14_39 = this.cursor.getFileLoc();
                                                                                                                var16_26 = this.cursor.getSize();
                                                                                                                if (var16_26 > 0L) break block82;
                                                                                                                break block72;
lbl161:
                                                                                                                // 1 sources

                                                                                                                while (!(var21_44 = var20_43.getString(0)).equalsIgnoreCase(Base64.endsWith((String)"`~\\wguQwcy", (int)(51 * 21)))) {
                                                                                                                    break block72;
                                                                                                                }
                                                                                                                break block83;
lbl164:
                                                                                                                // 3 sources

                                                                                                                while (true) {
                                                                                                                    this.onMetadataSample = this.cursor.getSample();
                                                                                                                    break block72;
                                                                                                                    break;
                                                                                                                }
                                                                                                                while (true) {
                                                                                                                    if (var22_45 != 8) ** GOTO lbl164
                                                                                                                    break block73;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            var18_27 = new byte[(int)var16_26];
                                                                                                            this.videoFileStream.seek(var14_39);
                                                                                                            var19_42 = this.videoFileStream.read(var18_27, 0, (int)var16_26);
                                                                                                            if ((long)var19_42 == var16_26) break block84;
                                                                                                            break block72;
lbl176:
                                                                                                            // 1 sources

                                                                                                            while (var20_43.get(0).getType() != 2) {
                                                                                                                break block72;
                                                                                                            }
                                                                                                            ** GOTO lbl161
                                                                                                            while (true) {
                                                                                                                if (var20_43.size() > 1) break block74;
                                                                                                                break block72;
                                                                                                                break;
                                                                                                            }
lbl182:
                                                                                                            // 2 sources

                                                                                                            while (true) {
                                                                                                                if (!var25_48.hasNext()) ** GOTO lbl164
                                                                                                                break block75;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (var20_43.get(0).getType() == 2) break block85;
                                                                                                        break block72;
lbl188:
                                                                                                        // 1 sources

                                                                                                        while (true) {
                                                                                                            var20_43.remove(0);
                                                                                                            break block76;
                                                                                                            break;
                                                                                                        }
lbl192:
                                                                                                        // 1 sources

                                                                                                        while (true) {
                                                                                                            var23_46 = (AMFDataObj)var20_43.get(1);
                                                                                                            var24_47 = var23_46.getKeys();
                                                                                                            var25_48 = var24_47.iterator();
                                                                                                            if (true) ** GOTO lbl213
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    var26_49 = (String)var25_48.next();
                                                                                                    var27_50 = var23_46.get(var26_49);
                                                                                                    var1_1.put(var26_49, var27_50);
                                                                                                    ** GOTO lbl182
lbl202:
                                                                                                    // 2 sources

                                                                                                    while (true) {
                                                                                                        if (var22_45 != 3) ** continue;
                                                                                                        ** continue;
                                                                                                        break;
                                                                                                    }
                                                                                                }
lbl206:
                                                                                                // 2 sources

                                                                                                while (var20_43.size() <= 1) {
                                                                                                    break block72;
                                                                                                }
                                                                                                ** GOTO lbl176
                                                                                                while (true) {
                                                                                                    var26_49 = (String)var25_48.next();
                                                                                                    var27_50 = var23_46.get(var26_49);
                                                                                                    var1_1.put(var26_49, var27_50);
lbl213:
                                                                                                    // 2 sources

                                                                                                    if (var25_48.hasNext()) ** break;
                                                                                                    ** continue;
                                                                                                }
                                                                                            }
                                                                                            var22_45 = var20_43.get(1).getType();
                                                                                            if (var22_45 == 3) ** GOTO lbl202
                                                                                            if (var22_45 != 8) ** break;
                                                                                            ** continue;
                                                                                            break block72;
                                                                                        }
                                                                                        var23_46 = (AMFDataMixedArray)var20_43.get(1);
                                                                                        var24_47 = var23_46.getKeys();
                                                                                        var25_48 = var24_47.iterator();
                                                                                        ** continue;
                                                                                    }
                                                                                    var21_44 = var20_43.getString(0);
                                                                                    if (!var21_44.equals(Base64.endsWith((String)"Cw`rCi}kM~lcj", (int)(446 / 148)))) ** GOTO lbl206
                                                                                    ** continue;
                                                                                }
                                                                                if ((var20_43 = new AMFDataList(var18_27)) != null) ** continue;
                                                                            }
                                                                            catch (Exception var14_41) {}
                                                                        }
                                                                        var1_1.put(FileChunk.lastIndexOf((int)(420 / 111), (String)"tmaro"), (AMFData)new AMFDataItem(var4_29.getFrameWidth()));
                                                                        var1_1.put(Base64.endsWith((String)"\u007f}p}sh", (int)(27 * 21)), (AMFData)new AMFDataItem(var4_29.getFrameHeight()));
                                                                        ** while (true)
                                                                        break block72;
                                                                    }
                                                                    if (var10_35 >= 10) ** GOTO lbl50
                                                                    break block86;
                                                                }
lbl244:
                                                                // 2 sources

                                                                while (true) {
                                                                    if (var4_29 != null) ** break;
                                                                    ** continue;
                                                                    ** continue;
                                                                    break;
                                                                }
                                                            }
                                                            var1_1.put(Base64.endsWith((String)"k~hdalxp|}qye", (int)(46 - 4)), (AMFData)new AMFDataItem(var6_3.getAudioChannels()));
                                                            var1_1.put(FileChunk.lastIndexOf((int)(21 * 21), (String)"xo\u007furm~-1.&6$2\""), (AMFData)new AMFDataItem(var5_30.getMdiaAtom().getTimescale()));
                                                            ** while (true)
                                                        }
                                                        ** while (this.onMetadataSample < 0L)
lbl254:
                                                        // 1 sources

                                                        ** GOTO lbl50
                                                    }
                                                    WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(67 + 114), (String)"qceymstr'") + Math.max(var9_4, var11_11));
                                                    var13_19 = Math.max(var9_4, var11_11);
                                                    this.duration = Math.round(var13_19 * 1000.0);
                                                    var1_1.put(FileChunk.lastIndexOf((int)(45 + 96), (String)"i{}qe{|z"), (AMFData)new AMFDataItem(var13_19));
                                                    var15_24 = new AMFDataList();
                                                    var15_24.add((AMFData)new AMFDataItem(FileChunk.lastIndexOf((int)(43 * 5), (String)"86\u0014?/=\u0019?+!")));
                                                    var15_24.add((AMFData)var1_1);
                                                    var16_25 = var15_24.serialize();
                                                    this.metaData.add(ByteBuffer.wrap((byte[])var16_25));
                                                    if (var6_3 == null) ** GOTO lbl65
                                                    ** while (true)
                                                }
                                                var13_20 = var4_29.getTimeToSample().get(0, 1);
                                                var11_15 = (double)var9_8 / (double)var13_20;
                                                ** while (true)
lbl272:
                                                // 1 sources

                                                while (true) {
                                                    var10_34 = var2_28.getTrak(var9_5);
                                                    if (var10_34 == null) {
                                                        ** continue;
                                                    }
                                                    break block77;
                                                    break;
                                                }
                                            }
lbl278:
                                            // 2 sources

                                            while (true) {
                                                if (var4_29 != null) ** break;
                                                ** continue;
                                                ** continue;
                                                break;
                                            }
                                        }
                                        var1_1.put(FileChunk.lastIndexOf((int)(71 + -3), (String)"2,\"\"'*%/).'+"), (AMFData)new AMFDataItem(var4_29.getDataTypes().get(0)));
                                        ** while (true)
                                    }
                                    var11_13 = this.cursor.getCurrentType();
                                    ** while ((var12_37 = this.cursor.getTimeMillis()) <= 0L)
lbl288:
                                    // 1 sources

                                    ** while (true)
                                }
                                if (var17_51.contains(FileChunk.lastIndexOf((int)(9 * 13), (String)"8&c9"))) ** break;
                                ** while (true)
                                ** while (true)
                            }
                            var11_16 = var5_30.getMdiaAtom().getTimescale();
                            var13_21 = var5_30.getMdiaAtom().getDuration();
                            var9_4 = (double)var13_21 / (double)var11_16;
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(-52 - -14), (String)";.841\u001b53#7-*(}") + var9_4 + ":" + var11_16 + ":" + var13_21);
                            ** while (true)
                        }
                        v1 = null;
                        ** while (true)
                    }
                    ** while (var9_5 >= var8_33)
lbl304:
                    // 1 sources

                    ** while (true)
                }
                if (var6_3 != null) ** break;
                ** while (true)
                ** while (true)
            }
lbl310:
            // 2 sources

            while (true) {
                if (!var14_40.hasNext()) ** continue;
                ** continue;
                break;
            }
        }
        var11_14 = new AMFDataObj();
        var11_14.put(FileChunk.lastIndexOf((int)(41 * 7), (String)"kilgpgdjb"), (AMFData)new AMFDataItem(var10_34.getMdiaAtom().getTimescale()));
        var11_14.put(FileChunk.lastIndexOf((int)(1093 / 187), (String)"icio}b"), (AMFData)new AMFDataItem(var10_34.getMdiaAtom().getDuration()));
        var11_14.put(FileChunk.lastIndexOf((int)(43 - -62), (String)"%+%+8/(5"), (AMFData)new AMFDataItem(Base64.endsWith((String)"mgm", (int)(4 - -4))));
        var12_38 = new AMFDataArray();
        var13_18 = var10_34.getMdiaAtom().getMinfAtom().getStblAtom().getDataTypes();
        var14_40 = var13_18.iterator();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        if (this.duration >= 0L) {
            return this.duration;
        }
        double d = 0.0;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            long l;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            QTParseContext qTParseContext = new QTParseContext();
            qTParseContext.setClientId(this.stream.getClientId());
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            QTMediaContainer qTMediaContainer = QTUtils.parseQTMediaContainer(iRandomAccessReader2, iRandomAccessReader2.length(), qTParseContext);
            QTAtomtrak qTAtomtrak = qTMediaContainer.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = qTMediaContainer.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            double d2 = 0.0;
            if (qTAtomtrak2 != null) {
                long l2 = qTAtomtrak2.getMdiaAtom().getTimescale();
                l = qTAtomtrak2.getMdiaAtom().getDuration();
                d2 = (double)l / (double)l2;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.endsWith((String)"grl`eOy\u007fo{y~|)", (int)(669 / 109)) + d2 + ":" + l2 + ":" + l);
            }
            double d3 = 0.0;
            if (qTAtomtrak != null) {
                l = qTAtomtrak.getMdiaAtom().getTimescale();
                long l3 = qTAtomtrak.getMdiaAtom().getDuration();
                d3 = (double)l3 / (double)l;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.lastIndexOf((int)(48 - 55), (String)"/3?92\u001a*r`vjkk<") + d3 + ":" + l + ":" + l3);
            }
            d = Math.max(d2, d3);
        }
        catch (Exception exception) {}
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return Math.round(d * 1000.0);
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        if (this.container != null) {
            return new H264StreamPosition(this.cursor.getAudioSample(), this.cursor.getVideoSample(), !this.cursor.isAtDataEnd() ? this.cursor.getDataSample() : -1L);
        }
        return new H264StreamPosition();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        if (this.container == null) {
            return;
        }
        H264StreamPosition h264StreamPosition = (H264StreamPosition)iMediaReaderStreamPosition;
        long l = h264StreamPosition.getAudioSample();
        long l2 = h264StreamPosition.getVideoSample();
        long l3 = h264StreamPosition.getDataSample();
        if (l >= 0L) {
            this.cursor.setAudioSample(l);
        }
        if (l2 >= 0L) {
            this.cursor.setVideoSample(l2);
        }
        if (l3 < 0L) {
            this.cursor.setDataAtEnd();
            return;
        }
        this.cursor.setDataSample(l3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.videoFileStream == null) return 0L;
        long l = this.videoFileStream.length();
        return l;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public List getMetadata() {
        return this.metaData;
    }

    public String getPath() {
        return this.basePath;
    }

    public void rewind() {
        if (this.container != null) {
            this.cursor.setAudioSample(0L);
            this.cursor.setVideoSample(0L);
            this.cursor.setDataSample(0L);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlaylistSeekResult seek(long l, int n) {
        if (l > 0L) {
            return this.internalSeek(l, n);
        }
        l = 0L;
        return this.internalSeek(l, n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected PlaylistSeekResult internalSeek(long var1_1, int var3_2) {
        block20: {
            block19: {
                block18: {
                    var4_3 = new PlaylistSeekResult(var1_1);
                    if (this.container == null) {
                        return var4_3;
                    }
                    var5_5 = -1L;
                    var7_6 = -1L;
                    var9_7 = -1L;
                    var11_8 = -1L;
                    if (this.cursor.containsAudio()) {
                        v0 = this.cursor;
                        var5_5 = v0.audioTimecodeToSample(v0.audioTimeMillisToTimecode(var1_1));
                    }
                    if (!this.cursor.containsData()) ** GOTO lbl18
                    v1 = this.cursor;
                    var11_8 = v1.dataTimecodeToSample(v1.dataTimeMillisToTimecode(var1_1));
                    if (var11_8 < 0L) ** GOTO lbl18
                    var13_9 = 0;
lbl16:
                    // 2 sources

                    while (true) {
                        if (var13_9 < 10 && (var16_4 = this.cursor.dataTimecodeToTimeMillis(var14_13 = this.cursor.dataSampleToTimecode(var11_8))) < var1_1) break block18;
lbl18:
                        // 4 sources

                        while (true) {
                            block22: {
                                block21: {
                                    if (!this.cursor.containsVideo()) ** GOTO lbl37
                                    v2 = this.cursor;
                                    var9_7 = v2.videoTimecodeToSample(v2.videoTimeMillisToTimecode(var1_1));
                                    switch (var3_2) {
                                        case 4: {
                                            ** break;
                                        }
                                        case 3: {
                                            var7_6 = this.cursor.videoFindKeySample(var9_7, 3);
                                            ** break;
                                        }
                                        case 1: {
                                            var7_6 = this.cursor.videoFindKeySample(var9_7, 1);
                                            ** break;
                                        }
                                        case 2: {
                                            var7_6 = this.cursor.videoFindKeySample(var9_7, 2);
                                            ** break;
                                        }
                                        default: {
                                            if (var7_6 >= 0L) break block21;
                                            break block22;
                                        }
                                    }
lbl37:
                                    // 5 sources

                                    if (var7_6 >= 0L) break block21;
                                }
                                var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(-1L, -1L, -1L));
                                ** GOTO lbl72
                            }
                            var13_10 = this.cursor.videoSampleToTimecode(var7_6);
                            var15_14 = this.cursor.videoTimecodeToTimeMillis(var13_10);
                            var17_15 = this.cursor.audioTimeMillisToTimecode(var15_14);
                            var19_16 = this.cursor.audioTimecodeToSample(var17_15);
                            var21_17 = this.cursor.dataTimeMillisToTimecode(var15_14);
                            var23_18 = this.cursor.dataTimecodeToSample(var21_17);
                            if (var23_18 < 0L) break block19;
                            var25_19 = 0;
                            if (true) ** GOTO lbl108
                            break;
                        }
lbl51:
                        // 1 sources

                        while (true) {
                            var11_8 = -1L;
                            ** continue;
                            break;
                        }
lbl54:
                        // 4 sources

                        while (var11_8 >= 0L) {
                            this.cursor.resetDataAtEnd();
                            break block20;
                        }
                        break block20;
                        break;
                    }
                    while (true) {
                        var23_18 = -1L;
                        break block19;
                        while (true) {
                            var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                            var17_15 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                            var19_16 = this.cursor.videoSampleToTimecode(var9_7);
                            var21_17 = this.cursor.videoTimecodeToTimeMillis(var19_16);
                            var13_11 = Math.min(var17_15, var21_17);
                            this.cursor.resetAudioAtEnd();
                            this.cursor.resetVideoAtEnd();
                            ** GOTO lbl54
                            break;
                        }
lbl70:
                        // 2 sources

                        while (true) {
                            block23: {
                                this.cursor.resetVideoAtEnd();
lbl72:
                                // 2 sources

                                var13_11 = 0L;
                                if (var5_5 >= 0L && var9_7 >= 0L) ** continue;
                                if (var9_7 < 0L) break block23;
                                var15_14 = this.cursor.videoSampleToTimecode(var9_7);
                                var13_11 = this.cursor.videoTimecodeToTimeMillis(var15_14);
                                this.cursor.resetVideoAtEnd();
                                ** GOTO lbl54
                            }
                            if (var5_5 < 0L) ** GOTO lbl54
                            var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                            var13_11 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                            this.cursor.resetAudioAtEnd();
                            ** GOTO lbl54
                            break;
                        }
                        break;
                    }
                }
                ** while (!this.cursor.getDataSampleValid((long)(var11_8 + 1L)))
lbl87:
                // 1 sources

                ++var11_8;
                ++var13_9;
                ** while (true)
            }
lbl91:
            // 2 sources

            while (true) {
                block24: {
                    var17_15 = this.cursor.audioSampleToTimecode(var19_16);
                    var25_20 = this.cursor.audioTimecodeToTimeMillis(var17_15);
                    if (var25_20 < var15_14 && this.cursor.getAudioSampleValid(var19_16 + 1L)) {
                        var17_15 = this.cursor.audioSampleToTimecode(++var19_16);
                    }
                    var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(var19_16, var7_6, var23_18));
                    if (var5_5 < 0L) break block24;
                    var27_21 = this.cursor.audioTimecodeToTimeMillis(var17_15);
                    var4_3.setResultVideoTimecode(Math.min(var27_21, var15_14));
                    ** GOTO lbl70
                }
                var4_3.setResultVideoTimecode(var15_14);
                ** continue;
                break;
            }
            do {
                if (!this.cursor.getDataSampleValid(var23_18 + 1L)) ** continue;
                ++var23_18;
                ++var25_19;
lbl108:
                // 2 sources

            } while (var25_19 < 10 && (var28_23 = this.cursor.dataTimecodeToTimeMillis(var26_22 = this.cursor.dataSampleToTimecode(var23_18))) < var15_14);
            ** while (true)
        }
        var4_3.setResults((IMediaReaderStreamPosition)new H264StreamPosition(var5_5, var9_7, var11_8), var13_11, 8, 1);
        var4_3.setResultTimecode(var13_11);
        var4_3.setSearchTimecode(var1_1);
        return var4_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.chunkWorkBuffer = new byte[n];
    }

    public void startPlayback() {
        this.doSendVideoTrakInfo = true;
        this.doSendAudioTrakInfo = true;
        this.doSendEnhanceSeek = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getSampleDesc(H264Cursor h264Cursor, long l, int n) {
        long l2 = 0L;
        H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
        if (h264ReadAheadPacket == null) return h264Cursor.getSampleDesc();
        return h264ReadAheadPacket.getSampleDesc();
    }

    /*
     * Exception decompiling
     */
    public int writeGeneratedKeyFrame(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 711->734)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte getFirstByte(H264Cursor h264Cursor) {
        byte by = 0;
        int n = h264Cursor.getCurrentType();
        switch (n) {
            case 9: {
                if (!h264Cursor.isKeyFrame()) return 39;
                return 23;
            }
            case 15: 
            case 18: {
                by = 0;
            }
            default: {
                return by;
            }
            case 8: 
        }
        return (byte)this.audioType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int writeEnhancedCmd(int n, int n2, int n3, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, long[] lArray, int n4) {
        int n5 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) {
            return 0;
        }
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), true, n2 != 0 ? 2 : 1, null);
            }
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n3;
            nArray[0] = 9;
            byte[] byArray = new byte[]{(byte)n, (byte)(0xFF & n2)};
            nArray[1] = 2;
            int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
            lArray[2] = lArray[2] + (long)n6;
            lArray[3] = lArray[3] + 1L;
            if (iFasterByteArrayWriteControl == null) return n5;
            iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), false, n2 != 0 ? 2 : 1, null);
            return n5 += n6;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.lastIndexOf((int)(15 * 11), (String)"HccahXnmik}X#$':px\u007fywy~x^s{za") + exception.toString());
            return n5;
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     */
    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        Object object;
        Object object2;
        int n3;
        block9: {
            QTAtommdia qTAtommdia;
            QTAtommoov qTAtommoov;
            byte[] byArray;
            QTAtomstbl qTAtomstbl;
            block8: {
                n3 = 0;
                switch (n) {
                    case 9: {
                        qTAtomstbl = null;
                        byArray = null;
                        qTAtommoov = this.container.getMoovAtom();
                        if (qTAtommoov == null) {
                            break;
                        }
                        break block8;
                    }
                    case 8: {
                        return n3;
                    }
                }
                break block9;
            }
            object2 = qTAtommoov.getVideoTrack(this.trackIndexVideo);
            if (object2 != null && (qTAtommdia = ((QTAtomtrak)object2).getMdiaAtom()) != null && (object = qTAtommdia.getMinfAtom()) != null && (qTAtomstbl = ((QTAtomminf)object).getStblAtom()) != null) {
                AVCCData aVCCData;
                long l = playlistCursor.getVideoSampleDesc();
                if (l < 0L) {
                    l = 0L;
                }
                if ((aVCCData = qTAtomstbl.getAVCCData((int)l)) != null) {
                    byArray = aVCCData.getAvccBytes();
                }
            }
        }
        int n4 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n4);
        object2 = new byte[5];
        int n5 = 0;
        object = new int[5];
        object[1] = false;
        object[2] = n2;
        object[0] = 9;
        object2[0] = 23;
        object2[1] = true;
        object2[2] = false;
        object2[3] = false;
        object2[4] = false;
        object[1] = 5;
        n5 = this.directOutputBuf((int[])object, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, (byte[])object2);
        lArray[2] = lArray[2] + (long)n5;
        lArray[3] = lArray[3] + 1L;
        return n3 += n5;
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getVideoCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        Object var5_4 = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) return byArray;
        AVCCData aVCCData = qTAtomstbl.getAVCCData((int)l);
        if (aVCCData == null) return byArray;
        return aVCCData.getAvccBytes();
    }

    /*
     * Unable to fully structure code
     */
    public int sendVideoTrakData(int var1_1, boolean var2_2, IMediaStream var3_3, OutputStream var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10, byte[] var11_11) {
        block11: {
            block7: {
                block9: {
                    block10: {
                        block6: {
                            block8: {
                                var12_12 = 0;
                                var13_13 = false;
                                var14_14 = var6_6.getWriteControl().getChunkSize();
                                this.checkWorkBuffer(var14_14);
                                if (var11_11 != null) break block8;
                                break block9;
lbl7:
                                // 2 sources

                                return var12_12;
lbl9:
                                // 1 sources

                                while (true) {
                                    var16_16 = this.directOutputBuf(var17_17, var2_2, var3_3.getSrc(), var4_4, var5_5, this.chunkWorkBuffer, var14_14, var15_15);
                                    var12_12 += var16_16;
                                    var9_9[2] = var9_9[2] + (long)var16_16;
                                    var9_9[3] = var9_9[3] + 1L;
                                    ++var18_18;
                                    break block6;
                                    break;
                                }
lbl16:
                                // 2 sources

                                while (true) {
                                    if (var18_18 >= v0) ** GOTO lbl7
                                    ** continue;
                                    break;
                                }
lbl19:
                                // 1 sources

                                while (true) {
                                    v0 = 2;
                                    ** GOTO lbl16
                                    break;
                                }
                            }
                            v1 = var11_11.length;
                            break block10;
                        }
lbl26:
                        // 2 sources

                        while (var13_13) {
                            ** continue;
lbl28:
                            // 1 sources

                            ** GOTO lbl19
                        }
                        break block11;
                    }
lbl31:
                    // 2 sources

                    while (true) {
                        var15_15 = new byte[v1 + 5];
                        var16_16 = 0;
                        var17_17 = new int[5];
                        var17_17[1] = 0;
                        var17_17[2] = var1_1;
                        var17_17[0] = 9;
                        if (var11_11 != null) ** break;
                        ** continue;
                        break block7;
                        break;
                    }
                }
                v1 = 0;
                ** while (true)
            }
            var15_15[0] = 23;
            var15_15[1] = 0;
            var15_15[2] = 0;
            var15_15[3] = 0;
            var15_15[4] = 0;
            System.arraycopy(var11_11, 0, var15_15, 5, var11_11.length);
            var17_17[1] = var11_11.length + 5;
            var17_17[2] = 0;
            var2_2 = false;
            var18_18 = 0;
            ** GOTO lbl26
        }
        v0 = 1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getAudioCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        ESDSData eSDSData = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(this.trackIndexAudio);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) {
            return byArray;
        }
        eSDSData = qTAtomstbl.getESDSData((int)l);
        if (eSDSData != null) return eSDSData.specData;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        if (byArray == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = 0;
        nArray[2] = n;
        nArray[0] = 8;
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = -81;
        byArray2[1] = 0;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        nArray[1] = byArray.length + 2;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
        n2 += n4;
        lArray[0] = lArray[0] + (long)n4;
        lArray[1] = lArray[1] + 1L;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (fastPlaySettings == null) return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
        if (fastPlaySettings.getDirection() >= 0) return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        block39: {
            var11_11 = 0;
            var12_12 = false;
            var13_13 = false;
            var14_14 = false;
            var15_15 = 0;
            var16_16 = var7_7.getMaxTC();
            this.videoFileStream.setDirecton(1);
            var18_17 = var6_6.getWriteControl().getChunkSize();
            this.checkWorkBuffer(var18_17);
            var19_18 = 0L;
            var21_19 = 0L;
            ** GOTO lbl189
lbl-1000:
            // 1 sources

            {
                block42: {
                    block43: {
                        block40: {
                            block41: {
                                block50: {
                                    block44: {
                                        while (var27_23 >= var16_16) {
                                            // MONITOREXIT : var23_20
                                            break block39;
                                        }
                                        break block43;
                                        while (true) {
                                            this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastVideoTC() & 0xFFFFFFFFL);
                                            ** GOTO lbl94
                                            break;
                                        }
                                        while (true) {
                                            var6_6.setSendAbsBroadcastTC(false);
                                            ** GOTO lbl109
                                            break;
                                        }
lbl23:
                                        // 2 sources

                                        while (true) {
                                            var11_11 += var33_33;
                                            ** GOTO lbl51
lbl26:
                                            // 1 sources

                                            while (this.videoCodec == 7) {
                                                v0 = true;
                                                ** GOTO lbl69
                                            }
                                            ** GOTO lbl63
                                            break;
                                        }
lbl30:
                                        // 1 sources

                                        while (this.videoCodec != 7) {
                                            break block40;
                                        }
                                        break block44;
                                        while (true) {
                                            this.chunkHeaderValues[2] = 0;
                                            ** GOTO lbl131
                                            break;
                                        }
lbl36:
                                        // 1 sources

                                        while (true) {
                                            var9_9[6] = var9_9[6] + (long)this.chunkHeaderValues[1];
                                            var9_9[7] = var9_9[7] + 1L;
                                            ** break;
                                            break;
                                        }
                                        while (true) {
                                            this.chunkHeaderValues[2] = (int)(var30_26 + var6_6.getStartTCOffset());
                                            var27_23 = var30_26;
                                            ** GOTO lbl91
                                            break;
                                        }
                                        while (true) {
                                            block48: {
                                                block47: {
                                                    block45: {
                                                        block46: {
                                                            if (var10_10) {
                                                                this.chunkHeaderValues[2] = 0;
                                                            }
                                                            if (var21_19 == var6_6.getVideoSampleDesc()) break block45;
                                                            var31_28 = this.getVideoCodecConfig(var21_19);
                                                            var32_30 = var6_6.compareAndSetVideoCodecConfig(var31_28);
                                                            if (var32_30 == 0) break block46;
lbl51:
                                                            // 2 sources

                                                            var6_6.setVideoSampleDesc(var21_19);
                                                            break block45;
                                                        }
                                                        v1 = this;
                                                        var33_33 = v1.sendVideoTrakData(v1.chunkHeaderValues[2], (boolean)var29_24, var1_1, var2_2, var4_4, var6_6, var7_7, var8_8, var9_9, var10_10, var31_28);
                                                        if (var33_33 <= 0) ** GOTO lbl23
                                                        break block47;
                                                    }
                                                    var6_6.setLastVideoTC(var27_23);
                                                    var6_6.incVideoPacketCount();
                                                    var25_22 = var27_23;
                                                    if (!var1_1.isReceiveVideo()) ** GOTO lbl26
lbl63:
                                                    // 2 sources

                                                    v0 = false;
                                                    break block48;
                                                }
                                                var29_24 = 0;
                                                this.chunkHeaderValues[2] = 0;
                                                ** continue;
                                            }
                                            var31_27 = v0;
                                            v2 = this;
                                            var32_30 = v2.directOutput(v2.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, var31_27);
                                            var11_11 += var32_30;
                                            var24_21 = true;
                                            var8_8.incVideoPackets();
                                            if (this.videoSampleCount > 0L && var19_18 == this.videoSampleCount - 1L) {
                                                v3 = this;
                                                var33_33 = v3.directOutput(v3.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, true);
                                                var11_11 += var33_33;
                                                var8_8.incVideoPackets();
                                            }
                                            var12_12 = true;
                                            var13_13 = true;
                                            var9_9[2] = var9_9[2] + (long)var32_30;
                                            var9_9[3] = var9_9[3] + 1L;
                                            break block40;
                                            break;
                                        }
lbl86:
                                        // 2 sources

                                        while (true) {
                                            var29_24 = var6_6.isSendAbsVideoTC();
                                            if (!var6_6.isSendAbsVideoTC()) ** continue;
                                            if ((var30_26 = var6_6.getForceVideoTC()) >= 0L) ** continue;
                                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
lbl91:
                                            // 2 sources

                                            if (this.chunkHeaderValues[2] < 0) break block40;
                                            var6_6.setForceVideoTC(-1L);
                                            var6_6.setSendAbsVideoTC(false);
lbl94:
                                            // 2 sources

                                            var30_25 = var7_7.testVideoFrame(this.chunkHeaderValues[3]);
                                            if (this.chunkHeaderValues[2] >= 0 && var30_25) ** continue;
                                            if (var30_25) ** break;
                                            ** continue;
                                            break;
                                        }
                                        while (true) {
                                            var31_27 = false;
                                            this.chunkHeaderValues[2] = 0;
                                            ** GOTO lbl137
                                            break;
                                        }
lbl102:
                                        // 2 sources

                                        while (true) {
                                            var32_30 = var6_6.isSendAbsBroadcastTC();
                                            if (var6_6.isSendAbsBroadcastTC()) {
                                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                if (this.chunkHeaderValues[2] >= 0) ** continue;
                                                break block40;
                                            } else {
                                                this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastBroadcastTC() & 0xFFFFFFFFL);
lbl109:
                                                // 2 sources

                                                var6_6.setLastBroadcastTC(var27_23);
                                                var6_6.incDataPacketCount();
                                                var25_22 = var27_23;
                                                if (var10_10) {
                                                    this.chunkHeaderValues[2] = 0;
                                                }
                                                v4 = this;
                                                var33_33 = v4.directOutput(v4.chunkHeaderValues, var19_18, (boolean)var32_30, var1_1.getSrc(), var2_2, var5_5, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                                var11_11 += var33_33;
                                                var9_9[4] = var9_9[4] + (long)var33_33;
                                                var9_9[5] = var9_9[5] + 1L;
                                                var24_21 = true;
                                            }
                                            break block40;
                                            break;
                                        }
lbl121:
                                        // 1 sources

                                        while (!var7_7.isAudioFilter()) {
                                            block49: {
                                                var31_27 = var6_6.isSendAbsAudioTC();
                                                if (var6_6.isSendAbsAudioTC()) {
                                                    this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                    if (this.chunkHeaderValues[2] < 0) break block40;
                                                    var6_6.setSendAbsAudioTC(false);
                                                } else {
                                                    this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastAudioTC() & 0xFFFFFFFFL);
                                                }
                                                if (this.chunkHeaderValues[2] < 0) ** break;
                                                if (var10_10) ** continue;
lbl131:
                                                // 2 sources

                                                if (var21_19 == var6_6.getAudioSampleDesc()) break block49;
                                                var32_31 = this.getAudioCodecConfig(var21_19);
                                                var33_33 = var6_6.compareAndSetAudioCodecConfig(var32_31);
                                                if (var33_33 == 0) {
                                                    v5 = this;
                                                    if ((var34_34 = v5.sendAudioTrakData(v5.chunkHeaderValues[2], var31_27, var1_1, var2_2, var3_3, var6_6, var7_7, var8_8, var9_9, var10_10, var32_31)) > 0) ** continue;
                                                }
lbl137:
                                                // 4 sources

                                                var6_6.setAudioSampleDesc(var21_19);
                                            }
                                            var6_6.setLastAudioTC(var27_23);
                                            var6_6.incAudioPacketCount();
                                            var25_22 = var27_23;
                                            v6 = this;
                                            var32_30 = v6.directOutput(v6.chunkHeaderValues, var19_18, var31_27, var1_1.getSrc(), var2_2, var3_3, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                            var11_11 += var32_30;
                                            var24_21 = true;
                                            var8_8.incAudioPackets();
                                            var12_12 = true;
                                            var14_14 = true;
                                            var9_9[0] = var9_9[0] + (long)var32_30;
                                            var9_9[1] = var9_9[1] + 1L;
                                            break block40;
                                        }
                                        break block40;
                                        block24: while (true) {
                                            switch (this.chunkHeaderValues[0]) {
                                                case 8: {
                                                    if (var1_1.isReceiveAudio()) break;
                                                    break block40;
                                                }
                                                case 9: {
                                                    if (var1_1.isReceiveVideo()) break block24;
                                                    ** GOTO lbl30
                                                }
                                                case 15: 
                                                case 18: {
                                                    if (this.onMetadataSample < 0L) ** GOTO lbl102
                                                    break block41;
                                                }
                                            }
                                            if (!var7_7.isSkipAudio()) ** GOTO lbl121
                                            break block40;
                                            break;
                                        }
                                    }
                                    if (!var6_6.isWaitForKeyFrame()) ** GOTO lbl86
                                    var29_24 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                                    if (var29_24) break block50;
                                    break block40;
                                }
                                var6_6.setWaitForKeyFrame(false);
                                ** continue;
                            }
                            if (var19_18 == this.onMetadataSample) ** break;
                            ** continue;
                        }
                        var8_8.setLastTC(var27_23);
                        ++var15_15;
                        this.cursor.moveNextSample();
                        if (var16_16 != 0L) ** GOTO lbl-1000
                        if (var13_13 || var15_15 > 20) {
                            // MONITOREXIT : var23_20
                            break block39;
                        }
                    }
                    // MONITOREXIT : var23_20
lbl189:
                    // 2 sources

                    var23_20 = this.lock;
                    // MONITORENTER : var23_20
                    if (var6_6.isBreakLoop()) {
                        // MONITOREXIT : var23_20
                        break block39;
                    }
                    if (!this.cursor.isAtEnd()) break block42;
                    var8_8.setHitEnd(true);
                    // MONITOREXIT : var23_20
                    break block39;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.getCurrentType();
                v7 = this;
                this.chunkHeaderValues[3] = v7.getFirstByte(v7.cursor);
                var19_18 = this.cursor.getSample();
                v8 = this;
                var21_19 = v8.getSampleDesc(v8.cursor, var19_18, this.chunkHeaderValues[0]);
                var24_21 = false;
                var25_22 = 0L;
                var27_23 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (var16_16 <= 0L || var27_23 < var16_16) ** continue;
                // MONITOREXIT : var23_20
            }
        }
        var8_8.setTotalSize(var11_11);
        return var11_11;
        catch (Throwable var35_35) {
            // MONITOREXIT : var23_20
            throw var35_35;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePacketsFastPlay(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [41[UNCONDITIONALDOLOOP], 42[UNCONDITIONALDOLOOP]], but top level block is 4[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected int directOutput(int[] var1_1, long var2_2, boolean var4_3, int var5_4, OutputStream var6_5, AMFObj var7_6, byte[] var8_7, int var9_8, H264Cursor var10_9, boolean var11_10) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [0 : 1394->1567)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutputBuf(int[] var1_1, boolean var2_2, int var3_3, OutputStream var4_4, AMFObj var5_5, byte[] var6_6, int var7_7, byte[] var8_8) {
        block35: {
            var9_9 = 0;
            try {
                block37: {
                    block36: {
                        var10_11 = (long)var1_1[2] & 0xFFFFFFFFL;
                        var12_12 = var1_1[1];
                        var13_13 = var1_1[0];
                        var14_14 = var5_5.getId();
                        var15_15 = var5_5.isNew();
                        var16_16 = var15_15 | var2_2;
                        var5_5.setNew(false);
                        var17_17 = 1;
                        var6_6[0] = (byte)(255 & var14_14);
                        if (var16_16 || var5_5.getSrc() != var3_3) {
                            var6_6[8] = (byte)(255 & var3_3);
                            var6_6[9] = (byte)(255 & var3_3 >> 8);
                            var6_6[10] = (byte)(255 & var3_3 >> 16);
                            var6_6[11] = (byte)(255 & var3_3 >> 24);
                            var5_5.setSrc(var3_3);
                            var17_17 += 4;
                            var16_16 = true;
                        }
                        if (var16_16 || var5_5.getSize() != var12_12 || var5_5.getType() == var13_13) {
                            // empty if block
                        }
                        var6_6[4] = (byte)(255 & var12_12 >> 16);
                        var6_6[5] = (byte)(255 & var12_12 >> 8);
                        var6_6[6] = (byte)(255 & var12_12);
                        var6_6[7] = (byte)var13_13;
                        var5_5.setSize(var12_12);
                        var5_5.setType(var13_13);
                        var17_17 += 4;
                        var16_16 = true;
                        var18_18 = false;
                        if (var16_16 || var5_5.getTimecode() != var10_11) {
                            if (var10_11 >= 0xFFFFFFL) {
                                var6_6[1] = -1;
                                var6_6[2] = -1;
                                var6_6[3] = -1;
                                var18_18 = true;
                            } else {
                                var6_6[1] = (byte)(255L & var10_11 >> 16);
                                var6_6[2] = (byte)(255L & var10_11 >> 8);
                                var6_6[3] = (byte)(255L & var10_11);
                            }
                            var5_5.setTimecode(var10_11);
                            var17_17 += 3;
                            var16_16 = true;
                        }
                        if (AMFObj.AMFDEBUGHEADERSIZE) {
                            var19_21 = Base64.endsWith((String)"N]WVVV@Q_]X^^NNWE\u0005\u001a\u000f& ,'\u0015-(..>\u0005|ydkj<2dd\nby", (int)(25 * 7)) + var17_17;
                            if (var17_17 > 4) {
                                WMSLoggerFactory.getLogger(null).info(var19_21);
                            } else {
                                WMSLoggerFactory.getLogger(null).error(var19_21);
                            }
                        }
                        if (var14_14 < 64) break block36;
                    }
                    switch (var17_17) {
                        case 1: {
                            var6_6[0] = (byte)(var6_6[0] | 192);
                            break;
                        }
                        case 8: {
                            var6_6[0] = (byte)(var6_6[0] | 64);
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 4: {
                            var6_6[0] = (byte)(var6_6[0] | 128);
                            break;
                        }
                    }
                    var4_4.write(var6_6, 0, var17_17);
                    var9_9 += var17_17;
                    break block37;
                    var19_20 = var14_14 - 64;
                    var20_22 = var19_20 <= 255 ? 2 : 3;
                    var21_24 = new byte[var20_22];
                    switch (var17_17) {
                        case 12: {
                            var21_24[0] = (byte)(0 + (var20_22 - 2));
                            break;
                        }
                        case 8: {
                            var21_24[0] = (byte)(64 + (var20_22 - 2));
                            break;
                        }
                        case 1: {
                            var21_24[0] = (byte)(192 + (var20_22 - 2));
                            break;
                        }
                        case 4: {
                            var21_24[0] = (byte)(128 + (var20_22 - 2));
                            break;
                        }
                    }
                    var21_24[1] = (byte)(255 & var19_20);
                    if (var20_22 == 3) {
                        var21_24[2] = (byte)(255 & var19_20 >> 8);
                    }
                    var4_4.write(var21_24, 0, var20_22);
                    var4_4.write(var6_6, 1, var17_17 - 1);
                    var9_9 += var17_17 + 1;
                }
                if (var18_18) {
                    var6_6[0] = (byte)(255L & var10_11 >> 24);
                    var6_6[1] = (byte)(255L & var10_11 >> 16);
                    var6_6[2] = (byte)(255L & var10_11 >> 8);
                    var6_6[3] = (byte)(255L & var10_11);
                    var4_4.write(var6_6, 0, 4);
                    var9_9 = 4;
                }
                if (var12_12 <= 0) return var9_9;
                var19_19 = var12_12;
                var20_22 = 0;
                var21_23 = 0;
                ** GOTO lbl-1000
            }
            catch (Exception var10_10) {
                WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.endsWith((String)"Buu{rFpws}kR)*)0{)3' 0\n338<>\t9+to", (int)(51 * 21)) + var10_10.toString());
                var10_10.printStackTrace();
                return var9_9;
            }
lbl106:
            // 2 sources

            while (true) {
                var23_27 = v0;
                var6_6[0] = (byte)(192 + (var23_27 - 2));
                var6_6[1] = (byte)(255 & var22_25);
                if (var23_27 == 3) {
                    var6_6[2] = (byte)(255 & var22_25 >> 8);
                }
                var4_4.write(var6_6, 0, var23_27);
                var9_9 += var23_27;
                break block35;
                break;
            }
lbl115:
            // 1 sources

            while (true) {
                v0 = 3;
                ** GOTO lbl106
                break;
            }
        }
lbl119:
        // 2 sources

        while (true) {
            if (!var18_18) ** GOTO lbl139
            var6_6[0] = (byte)(255L & var10_11 >> 24);
            var6_6[1] = (byte)(255L & var10_11 >> 16);
            var6_6[2] = (byte)(255L & var10_11 >> 8);
            var6_6[3] = (byte)(255L & var10_11);
            var4_4.write(var6_6, 0, 4);
            var9_9 = 4;
            ** if (true) goto lbl132
            break;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                var9_9 += var21_23;
                if ((var20_22 += var21_23) == var19_19) {
                    return var9_9;
                } else {
                    ** GOTO lbl-1000
                }
                break;
            }
        }
lbl132:
        // 1 sources

        ** GOTO lbl139
lbl-1000:
        // 3 sources

        {
            block40: {
                block39: {
                    block38: {
                        if (var20_22 <= 0) break block38;
                        if (var14_14 < 64) break block39;
                        var22_25 = var14_14 - 64;
                        if (var22_25 > 255) {
                            ** continue;
                        }
                        break block40;
                    }
                    if ((var21_23 = var7_7) > var19_19 - var20_22) {
                        var21_23 = var19_19 - var20_22;
                    }
                    ** GOTO lbl-1000
                }
                var6_6[0] = (byte)(255 & var14_14 | 192);
                var4_4.write(var6_6, 0, 1);
                ++var9_9;
                ** continue;
            }
            v0 = 2;
            ** continue;
lbl-1000:
            // 1 sources

            {
                var4_4.write(var8_8, var20_22, var21_23);
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void debugPackets(int n) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
        QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
        H264Cursor h264Cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 1);
        int n2 = 0;
        while (true) {
            int n3 = (int)h264Cursor.getSize();
            long l = h264Cursor.getTimeMillis();
            if (n3 <= 0 || n3 >= n) {
                wMSLogger.info(FileChunk.lastIndexOf((int)(55 * 33), (String)"gyzq~h'>") + n3 + ":" + n);
            }
            h264Cursor.moveNextSample();
            if (h264Cursor.isAtEnd()) {
                wMSLogger.info(FileChunk.lastIndexOf((int)(69 + -48), (String)"?<=kxwkpx}puov9$") + n2);
                return;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected H264ReadAheadRequest tiggerNextReadAhead(H264ReadAheadRequest var1_1) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        block13: {
                            block11: {
                                block12: {
                                    block10: {
                                        var2_2 = null;
                                        var3_3 = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                        var4_4 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                        var5_5 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                        if (this.cursorReadAhead != null) break block15;
                                        break block16;
lbl7:
                                        // 2 sources

                                        while (this.cursorReadAhead.isAtEnd()) {
                                            break block10;
                                        }
                                        break block17;
lbl10:
                                        // 1 sources

                                        while (true) {
                                            var2_2 = this.readAheadCache.remove(0);
                                            var2_2.clear();
                                            break block11;
                                            while (true) {
                                                if (!this.cursorReadAhead.isAtEnd()) break block12;
                                                break block13;
                                                break;
                                            }
lbl17:
                                            // 1 sources

                                            while (true) {
                                                var2_2.setCursorPosition(this.cursorReadAhead.getCurrentPosition());
                                                if (this.stream == null) break block10;
                                                break block14;
                                                break;
                                            }
                                            break;
                                        }
lbl21:
                                        // 1 sources

                                        while (true) {
                                            this.cursorReadAhead.setCurrentPosition(var1_1.getCursorPosition());
                                            ** GOTO lbl7
                                            break;
                                        }
                                    }
lbl25:
                                    // 3 sources

                                    return var2_2;
                                }
lbl28:
                                // 2 sources

                                while (true) {
                                    var8_7 = this.cursorReadAhead.getSize();
                                    var10_8 = this.cursorReadAhead.getCurrentType();
                                    var11_9 = this.cursorReadAhead.getSample();
                                    var13_10 = this.cursorReadAhead.getSampleDesc();
                                    var2_2.addPacket(var10_8, var11_9, this.cursorReadAhead.getFileLoc(), var8_7, var13_10);
                                    this.cursorReadAhead.moveNextSample();
                                    if ((var6_6 += var8_7) <= (long)this.readAheadSize) ** continue;
                                    break block13;
                                    break;
                                }
lbl38:
                                // 1 sources

                                while (true) {
                                    this.cursorReadAhead.setCurrentPosition(this.cursor.getCurrentPosition());
                                    ** GOTO lbl7
                                    break;
                                }
                            }
lbl42:
                            // 2 sources

                            while (true) {
                                var2_2.setFileStream(this.videoFileStream);
                                var2_2.setReadAheadTrigger(this.readAheadTrigger);
                                var6_6 = 0L;
                                ** continue;
                                break;
                            }
                        }
                        if (var2_2 == null) ** GOTO lbl25
                        ** while (true)
                    }
                    this.stream.getStreams().getVHost().getIOScheduler().executeRaw((Runnable)var2_2);
                    ** while (true)
lbl53:
                    // 1 sources

                    while (true) {
                        var2_2 = new H264ReadAheadRequest();
                        var2_2.setDataTrack(var5_5);
                        var2_2.setDataDataToAMFHandler(this.dataDataToAMFHandler);
                        ** continue;
                        break;
                    }
                }
                this.cursorReadAhead = new H264Cursor(var3_3, var4_4, var5_5);
                break block15;
            }
            ** while (this.readAheadCache.size() <= 0)
lbl63:
            // 1 sources

            ** while (true)
        }
        ** while (var1_1 == null)
lbl66:
        // 1 sources

        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        block9: {
            block10: {
                block8: {
                    h264ReadAheadPacket = null;
                    if (this.currReadAhead == null) break block8;
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket != null) break block9;
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
                this.currReadAhead = this.nextReadAhead;
                this.nextReadAhead = null;
                if (this.currReadAhead == null) break block10;
                this.currReadAhead.waitForComplete();
                h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                if (h264ReadAheadPacket != null) break block9;
                if (this.cacheReadAhead) {
                    this.readAheadCache.add(this.currReadAhead);
                }
                this.currReadAhead = null;
            }
            this.currReadAhead = this.tiggerNextReadAhead(null);
            if (this.currReadAhead != null) {
                this.currReadAhead.waitForComplete();
                h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                if (h264ReadAheadPacket == null) {
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
            }
        }
        if (h264ReadAheadPacket == null) return h264ReadAheadPacket;
        if (this.nextReadAhead != null) return h264ReadAheadPacket;
        if (!h264ReadAheadPacket.isAfterTrigger) return h264ReadAheadPacket;
        MediaReaderH264 mediaReaderH264 = this;
        mediaReaderH264.nextReadAhead = mediaReaderH264.tiggerNextReadAhead(mediaReaderH264.currReadAhead);
        return h264ReadAheadPacket;
    }

    /*
     * Exception decompiling
     */
    public int writePackets(List<AMFPacket> var1_1, PlaylistCursor var2_2, PlaylistWriteControl var3_3, PlaylistReaderWriteResults var4_4, long[] var5_5, FastPlaySettings var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 191->1048)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket a(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = 23;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        aMFPacket.addDataEx(byArray, 0, 5, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket b(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = -81;
        byArray2[1] = 0;
        aMFPacket.addDataEx(byArray, 0, 2, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket getFramePacket(int[] nArray, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        int n;
        int n2;
        AMFPacket aMFPacket = null;
        try {
            n2 = nArray[0];
            n = 0;
            h264ReadAheadPacket = this.getReadAheadPacket(n2, l);
            if (h264ReadAheadPacket != null) {
                n = (int)h264ReadAheadPacket.getSize();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.lastIndexOf((int)(746 / 142), (String)"HccahXnmik}X#$':rsc^k{vyM\u007f|kdv9$") + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
        if (n <= 0) return aMFPacket;
        int n3 = 5;
        if (n2 != 8) {
            if (n2 == 18 || n2 == 15) {
                n3 = 0;
            }
        } else {
            n3 = this.audioExtraSize;
        }
        aMFPacket = new AMFPacket(nArray[0], 0, n + n3);
        byte[] byArray = aMFPacket.getData();
        byArray[0] = (byte)this.chunkHeaderValues[3];
        if (n3 > 1) {
            byArray[1] = 1;
        }
        if (n3 == 5) {
            int n4 = this.cursor.getCTTSMillis();
            byArray[2] = (byte)(n4 >> 16 & 0xFF);
            byArray[3] = (byte)(n4 >> 8 & 0xFF);
            byArray[4] = (byte)(n4 & 0xFF);
        }
        byte[] byArray2 = null;
        int n5 = 0;
        if (h264ReadAheadPacket != null) {
            byArray2 = h264ReadAheadPacket.getBuffer();
            n5 = h264ReadAheadPacket.boffset;
        }
        aMFPacket.addDataEx(byArray2, n5, n3, n);
        return aMFPacket;
    }

    public int getTrackIndexVideo() {
        return this.trackIndexVideo;
    }

    public void setTrackIndexVideo(int n) {
        this.trackIndexVideo = n;
    }

    public int getTrackIndexAudio() {
        return this.trackIndexAudio;
    }

    public void setTrackIndexAudio(int n) {
        this.trackIndexAudio = n;
    }

    public int getTrackIndexData() {
        return this.trackIndexData;
    }

    public void setTrackIndexData(int n) {
        this.trackIndexData = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountVideo() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getVideoTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountAudio() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getAudioTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountData() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getDataTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageAudio(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getAudioTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageData(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getDataTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackDataTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackAudioTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackDataAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackAudioAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackVideoAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoTrackId(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoWidth(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackWidth();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoHeight(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackHeight();
        return l;
    }

    public String getTrackDataCharSet() {
        return this.trackDataCharSet;
    }

    public void setTrackDataCharSet(String string) {
        this.trackDataCharSet = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] dataDataToAMF(QTAtomtrak qTAtomtrak, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = null;
        AMFDataList aMFDataList = null;
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl != null && (n3 = qTAtomstbl.getDataTrackType()) == 2) {
            aMFDataList = new AMFDataList();
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataList.add((AMFData)new AMFDataItem(Base64.endsWith((String)"dbYkwdUsgu", (int)(19 * 41))));
            aMFDataList.add((AMFData)aMFDataObj);
            String string = qTAtomtrak.getLanguageStr();
            aMFDataObj.put(Base64.endsWith((String)"rbp}", (int)(246 / 40)), (AMFData)new AMFDataItem(""));
            MediaReaderH264 mediaReaderH264 = this;
            aMFDataObj.put(FileChunk.lastIndexOf((int)(-32 - 5), (String)"/.<=4)%"), (AMFData)new AMFDataItem(mediaReaderH264.getTrackDataTrackId(mediaReaderH264.trackIndexData)));
            aMFDataObj.put(Base64.endsWith((String)"$($,9,)*", (int)(-60 - -4)), (AMFData)new AMFDataItem(string));
            if (n2 >= 2) {
                int n4 = 0;
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n, (int)2);
                if (n5 > 0 && n5 <= n2 - (n4 += 2)) {
                    String string2 = "";
                    try {
                        string2 = new String(byArray, n + n4, n2 - n4, this.trackDataCharSet);
                    }
                    catch (Exception exception) {}
                    aMFDataObj.put(Base64.endsWith((String)"qc\u007f|", (int)(684 / 130)), (AMFData)new AMFDataItem(string2));
                }
            }
        }
        if (aMFDataList == null) return byArray2;
        return aMFDataList.serialize(0);
    }
}

