/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerSanJoseUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String SESSIONIDPLACHOLDER = "{session-id}";
    public static final String BITRATEPLACHOLDER = "{bitrate}";
    public static final String KBITRATEPLACHOLDER = "{kbitrate}";
    public static final String BOOTSTRAPIDPLACEHOLDER = "{bootstrapId}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String PLAYLISTPLACHOLDER = "playlist_b{bitrate}_w{session-id}.abst{query}";
    public static final String PLAYSTARTPLACHOLDER = "{playStart}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDuration}";
    public static final String MEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}.abst/";
    public static final String VODMEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}{playStart}{playDuration}.abst/";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String FILENAMEPATTERN = "media_{index}{ext}";
    public static final String URLPATTERN = "http://{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = Base64.endsWith((String)"m06", (int)(32 - 61));
        switch (n) {
            case 2: {
                string = Base64.endsWith((String)"u1-m", (int)(76 + 47));
            }
            default: {
                return string;
            }
            case 3: 
        }
        return FileChunk.lastIndexOf((int)(37 * 51), (String)"q! !");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseEncInfo sanJoseEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingSanJoseBlock> arrayList;
        List<LiveStreamingSanJoseBlock> list;
        Cipher cipher;
        if (sanJoseEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info(FileChunk.lastIndexOf((int)(-17 - 48), (String)"S)7'\u001007#&%\u0019+('(:&*4 \u00005;\u001c8+<t=0(-7\u0010 !(!15}h(./\u000e\";!3(\u00112'!:2\u000b<9..4*&Psmumacu2)") + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(sanJoseEncInfo.getEncKeyBytes(), FileChunk.lastIndexOf((int)(45 * 55), (String)"JI^"));
            long l = liveStreamPacketizerSanJoseChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(FileChunk.lastIndexOf((int)(7 * 33), (String)"\u0006\r\u001ae\b\u000e\u000ea\u001f\u001b\u0012\u0001d\u000442317="), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerSanJoseChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingSanJoseBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error(Base64.endsWith((String)"Fbzh]{bts~Dtu|}msayoM~nKmpaPrndz$nbn|v`eQ{a{}-8X_H1,,'`$, 6<63!&$ql", (int)(39 + -29)) + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerSanJoseChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = list.get(n);
            n4 += liveStreamingSanJoseBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen()) : cipher.update(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingSanJoseBlock liveStreamingSanJoseBlock2 = new LiveStreamingSanJoseBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingSanJoseBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SanJoseEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.endsWith((String)"w1>%", (int)(32 + 89)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(Base64.endsWith((String)"qwj", (int)(-55 - -59)));
            if (string3 != null || (string3 = (String)object.get(Base64.endsWith((String)"sua", (int)(727 / 106)))) != null || (string3 = (String)object.get(Base64.endsWith((String)" 15#5< $$?9<*1<;=3x72+hhcq(,3", (int)(122 + 105)))) != null || (string3 = (String)object.get(Base64.endsWith((String)"&37-;>\"\"\"=;\"43>=;1z9<)jnes*rh", (int)(32 - 59)))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.endsWith((String)"v{f", (int)(13 + 16)))) != null || (string2 = (String)object.get(FileChunk.lastIndexOf((int)(473 / 68), (String)"erxlx\u007feca|dcwry|xp5x\u007fh-/&2kd{"))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() != 32) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(FileChunk.lastIndexOf((int)(-62 - 10), (String)"Tpl~Oilz!,\u0012\"'.#3!3/9\u000f8>*\"%;=;{?91-`{\u00178'\u007f,$,$0-f.&*%9>(-;~q\u001f&'!v5=ykm|?'+er\"+77&d`hxjoyk}c82\u007f{{q7C") + file + FileChunk.lastIndexOf((int)(64 + -16), (String)"M+2") + string2.length());
                } else {
                    byArray = BufferUtils.decodeHexString((String)string2);
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new SanJoseEncInfo(string2, byArray, string3);
    }
}

