/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;

public class TranscoderSessionBitrateCalculator {
    protected boolean calculating = true;
    protected long startTimecode = -1L;
    protected int bitrateCalculatorDuration = 3000;
    protected int bitrateCalculatorDefaultAudioDuration = 30;
    protected int bitrateCalculatorDefaultVideoDuration = 30;
    protected int bitrateCalculatorMaxAudioDuration = 1000;
    protected int bitrateCalculatorMaxVideoDuration = 1000;
    protected CalculatorValues audioValues = new CalculatorValues();
    protected CalculatorValues videoValues = new CalculatorValues();

    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        WMSProperties wMSProperties = liveStreamTranscoder.getProperties();
        this.bitrateCalculatorDuration = wMSProperties.getPropertyInt(Base64.endsWith((String)"=iupbp`Efdj\u007fgmya}Td`r`|yy", (int)(-60 - -59)), this.bitrateCalculatorDuration);
        this.bitrateCalculatorDefaultAudioDuration = wMSProperties.getPropertyInt(Base64.endsWith((String)"28&!5!3\u0014959.0<*02\u0005'%%0*3\t<.\"#\t;=1%;<:", (int)(101 + -21)), this.bitrateCalculatorDefaultAudioDuration);
        this.bitrateCalculatorDefaultVideoDuration = wMSProperties.getPropertyInt(Base64.endsWith((String)"~tjmaug@eierdh~d~Ikiqd~gB|rrw]oi}iwp.", (int)(26 - -2)), this.bitrateCalculatorDefaultVideoDuration);
        this.bitrateCalculatorMaxAudioDuration = wMSProperties.getPropertyInt(FileChunk.lastIndexOf((int)(215 / 58), (String)"amqtf|lIj`n{cqe}aYtnVm}stXhl~thmm"), this.bitrateCalculatorMaxAudioDuration);
        this.bitrateCalculatorMaxVideoDuration = wMSProperties.getPropertyInt(Base64.endsWith((String)"goszh~nOlble}sg{g[v`Os\u007fyrZj2 6*++", (int)(52 - 15)), this.bitrateCalculatorMaxVideoDuration);
        String string = liveStreamTranscoder.getAppInstance().getContextStr() + ":" + liveStreamTranscoder.getStreamName();
        this.audioValues.f = this.bitrateCalculatorDefaultAudioDuration;
        this.audioValues.g = this.bitrateCalculatorMaxAudioDuration;
        this.audioValues.h = string + Base64.endsWith((String)"9epbng", (int)(244 / 73));
        this.videoValues.f = this.bitrateCalculatorDefaultVideoDuration;
        this.videoValues.g = this.bitrateCalculatorMaxVideoDuration;
        this.videoValues.h = string + FileChunk.lastIndexOf((int)(49 - 50), (String)"evhffk");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        if (this.startTimecode < 0L) {
            this.startTimecode = l;
        }
        int n = aMFPacket.getType();
        switch (n) {
            case 8: {
                if (FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket)) break;
                this.audioValues.handlePacket(iMediaStream, aMFPacket);
                break;
            }
            default: {
                break;
            }
            case 9: {
                if (FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket)) break;
                this.videoValues.handlePacket(iMediaStream, aMFPacket);
            }
        }
        if (l - this.startTimecode <= (long)this.bitrateCalculatorDuration) return;
        this.calculating = false;
    }

    public boolean isCalculating() {
        return this.calculating;
    }

    public void setCalculating(boolean bl) {
        this.calculating = bl;
    }

    public long getVideoBitrate() {
        return this.videoValues.getBitrate();
    }

    public long getAudioBitrate() {
        return this.audioValues.getBitrate();
    }

    class CalculatorValues {
        long a = -1L;
        long b = -1L;
        int c = -1;
        long d = -1L;
        long e = -1L;
        int f = 30;
        int g = 1000;
        String h = "";

        CalculatorValues() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            long l = aMFPacket.getAbsTimecode();
            int n = aMFPacket.getSize();
            if (this.a < 0L) {
                this.a = l;
            } else {
                long l2 = l - this.b;
                if (l2 < 0L) {
                    l2 = this.f;
                } else if (l2 > (long)this.g) {
                    l2 = this.f;
                }
                this.e += l2;
                this.d += (long)this.c;
            }
            this.b = l;
            this.c = n;
        }

        public long getBitrate() {
            if (this.e <= 0L) {
                return 0L;
            }
            return this.d * 8L * 1000L / this.e;
        }
    }
}

