/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CallingFormat;
import com.amazon.thirdparty.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Utils {
    static final String METADATA_PREFIX = "x-amz-meta-";
    static final String AMAZON_HEADER_PREFIX = "x-amz-";
    static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
    public static final String DEFAULT_HOST = "s3.amazonaws.com";
    public static final int SECURE_PORT = 443;
    public static final int INSECURE_PORT = 80;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    static String makeCanonicalString(String string, String string2, String string3, Map map, Map map2) {
        return Utils.makeCanonicalString(string, string2, string3, map, map2, null);
    }

    static String makeCanonicalString(String string, String string2, String string3, Map map, Map map2, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "\n");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (map2 != null) {
            for (String string5 : map2.keySet()) {
                String string6;
                if (string5 == null || !(string6 = string5.toLowerCase()).equals("content-type") && !string6.equals("content-md5") && !string6.equals("date") && !string6.startsWith(AMAZON_HEADER_PREFIX)) continue;
                List list = (List)map2.get(string5);
                treeMap.put(string6, Utils.concatenateList(list));
            }
        }
        if (treeMap.containsKey(ALTERNATIVE_DATE_HEADER)) {
            treeMap.put("date", "");
        }
        if (string4 != null) {
            treeMap.put("date", string4);
        }
        if (!treeMap.containsKey("content-type")) {
            treeMap.put("content-type", "");
        }
        if (!treeMap.containsKey("content-md5")) {
            treeMap.put("content-md5", "");
        }
        for (String string5 : treeMap.keySet()) {
            if (string5.startsWith(AMAZON_HEADER_PREFIX)) {
                stringBuffer.append(string5).append(':').append(treeMap.get(string5));
            } else {
                stringBuffer.append(treeMap.get(string5));
            }
            stringBuffer.append("\n");
        }
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append("/" + string2);
        }
        stringBuffer.append("/");
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        if (map != null) {
            if (map.containsKey("acl")) {
                stringBuffer.append("?acl");
            } else if (map.containsKey("torrent")) {
                stringBuffer.append("?torrent");
            } else if (map.containsKey("logging")) {
                stringBuffer.append("?logging");
            } else if (map.containsKey("location")) {
                stringBuffer.append("?location");
            }
        }
        return stringBuffer.toString();
    }

    static String encode(String string, String string2, boolean bl) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Could not find sha1 algorithm", noSuchAlgorithmException);
        }
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Could not initialize the MAC algorithm", invalidKeyException);
        }
        String string3 = Base64.encodeBytes(mac.doFinal(string2.getBytes()));
        if (bl) {
            return Utils.urlencode(string3);
        }
        return string3;
    }

    static Map paramsForListOptions(String string, String string2, Integer n) {
        return Utils.paramsForListOptions(string, string2, n, null);
    }

    static Map paramsForListOptions(String string, String string2, Integer n, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            hashMap.put("prefix", Utils.urlencode(string));
        }
        if (string2 != null) {
            hashMap.put("marker", Utils.urlencode(string2));
        }
        if (string3 != null) {
            hashMap.put("delimiter", Utils.urlencode(string3));
        }
        if (n != null) {
            hashMap.put("max-keys", Integer.toString(n));
        }
        return hashMap;
    }

    public static String convertPathArgsHashToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (map != null) {
            for (String string : map.keySet()) {
                if (bl) {
                    bl = false;
                    stringBuffer.append("?");
                } else {
                    stringBuffer.append("&");
                }
                String string2 = (String)map.get(string);
                stringBuffer.append(string);
                if (string2 == null) continue;
                stringBuffer.append("=");
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    static String urlencode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Could not url encode to UTF-8", unsupportedEncodingException);
        }
    }

    static XMLReader createXMLReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException2) {
                throw new RuntimeException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    private static String concatenateList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((String)list.get(i)).replaceAll("\n", "").trim());
            if (i == n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    static boolean validateBucketName(String string, CallingFormat callingFormat, boolean bl) {
        if (callingFormat == CallingFormat.getPathCallingFormat()) {
            int n = 3;
            int n2 = 255;
            String string2 = "^[0-9A-Za-z\\.\\-_]*$";
            return null != string && string.length() >= 3 && string.length() <= 255 && string.matches("^[0-9A-Za-z\\.\\-_]*$");
        }
        return Utils.isValidSubdomainBucketName(string);
    }

    static boolean isValidSubdomainBucketName(String string) {
        int n = 3;
        int n2 = 63;
        String string2 = "^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$";
        String string3 = "^[a-z0-9]([a-z0-9\\-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-]*[a-z0-9])?)*$";
        return null != string && string.length() >= 3 && string.length() <= 63 && !string.matches("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$") && string.matches("^[a-z0-9]([a-z0-9\\-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-]*[a-z0-9])?)*$");
    }

    static CallingFormat getCallingFormatForBucket(CallingFormat callingFormat, String string) {
        CallingFormat callingFormat2 = callingFormat;
        if (callingFormat2 == CallingFormat.getSubdomainCallingFormat() && !Utils.isValidSubdomainBucketName(string)) {
            callingFormat2 = CallingFormat.getPathCallingFormat();
        }
        return callingFormat2;
    }
}

