/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.drm.playready.PlayReadySampleData;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterMedia;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterUtils;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.util.Iterator;
import java.util.List;

public class SmoothStreamingFragmentWriter {
    public static final String DURATION_GUID = "6d1d9b0542d544e680e2141daff757b2";
    public static final byte[] DURATION_GUID_BYTES = BufferUtils.decodeHexString((String)FileChunk.lastIndexOf((int)(96 + 4), (String)"r!w#q+z~x\u007f*zde7ele3eimk?=;8h56`1"));
    public static final String READ_AHEAD_GUID = "d4807ef2ca3946958e5426cb9e46a79f";
    public static final byte[] READ_AHEAD_GUID_BYTES = BufferUtils.decodeHexString((String)FileChunk.lastIndexOf((int)(645 / 106), (String)"b309=nj?mn#(&%- .r--(-\u007f\u007f'z47c4=c"));
    public static final int ATOMHEADERSIZE = 8;
    public static final int VERSIONFLAGSSIZE = 4;
    public static final int GUIDESIZE = 16;
    public static final int MP4_TRUN_DATA_OFFSET = 1;
    public static final int MP4_TRUN_FIRST_FLAGS = 4;
    public static final int MP4_TRUN_SAMPLE_DURATION = 256;
    public static final int MP4_TRUN_SAMPLE_SIZE = 512;
    public static final int MP4_TRUN_SAMPLE_FLAGS = 1024;
    public static final int MP4_TRUN_SAMPLE_TIME_OFFSET = 2048;

    public static int getMediaSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 0;
        Iterator<SmoothStreamingMediaPacket> iterator = smoothStreamingFragmentWriterMedia.packets.iterator();
        while (iterator.hasNext()) {
            SmoothStreamingMediaPacket smoothStreamingMediaPacket = iterator.next();
            n += smoothStreamingMediaPacket.getSize();
        }
        return n;
    }

    public static int getFragmentSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, true, false);
    }

    public static int getFragmentSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia, boolean bl) {
        return SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getFragmentSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = smoothStreamingFragmentWriterMedia.packets.size();
        int n3 = 0;
        if (bl) {
            for (SmoothStreamingMediaPacket smoothStreamingMediaPacket : smoothStreamingFragmentWriterMedia.packets) {
                n3 += smoothStreamingMediaPacket.getSize();
            }
        }
        if (bl2) {
            n += SmoothStreamingFragmentWriter.getSTYPSize(smoothStreamingFragmentWriterMedia);
            n += SmoothStreamingFragmentWriter.getSIDXSize(smoothStreamingFragmentWriterMedia);
        }
        n += 8;
        n += 16;
        n += 8;
        n += 16;
        n += 16 + 12 * n2;
        n += 12 + n2;
        if (smoothStreamingFragmentWriterMedia.writeUUID) {
            n += 44;
            n += 29 + (smoothStreamingFragmentWriterMedia.readAheadDurations.length << 4);
        }
        n += SmoothStreamingFragmentWriter.getPlayReadySize(smoothStreamingFragmentWriterMedia.playReadySampleData);
        return n += 8 + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getFragmentSizeDASH(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = smoothStreamingFragmentWriterMedia.packets.size();
        int n3 = 0;
        if (bl) {
            for (SmoothStreamingMediaPacket smoothStreamingMediaPacket : smoothStreamingFragmentWriterMedia.packets) {
                n3 += smoothStreamingMediaPacket.getSize();
            }
        }
        if (bl2) {
            n += SmoothStreamingFragmentWriter.getSTYPSize(smoothStreamingFragmentWriterMedia);
            n += SmoothStreamingFragmentWriter.getSIDXSize(smoothStreamingFragmentWriterMedia);
        }
        n += 8;
        n += 16;
        n += 8;
        n += 16;
        n += SmoothStreamingFragmentWriter.getTRUNSize(smoothStreamingFragmentWriterMedia);
        n += 12 + n2;
        if (smoothStreamingFragmentWriterMedia.writeUUID) {
            n += 44;
            n += 29 + (smoothStreamingFragmentWriterMedia.readAheadDurations.length << 4);
        }
        n += SmoothStreamingFragmentWriter.getPlayReadySize(smoothStreamingFragmentWriterMedia.playReadySampleData);
        return n += 8 + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getPlayReadySize(PlayReadySampleData playReadySampleData) {
        int n = 0;
        if (playReadySampleData == null) return n;
        int n2 = 0;
        if (playReadySampleData.getKeyId() != null) {
            n2 = 20;
        }
        return n += 28 + n2 + 4 + playReadySampleData.getSize();
    }

    public static int startAtom(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        return n + 8;
    }

    public static void stopAtom(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, String string, int n2) {
        int n3 = n - n2;
        int n4 = n - n3 - 8;
        BufferUtils.intToByteArray((int)(n3 + 8), (byte[])byArray, (int)n4, (int)4);
        System.arraycopy(string.getBytes(), 0, byArray, n4 + 4, 4);
    }

    public static void stopAtom(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, String string, int n2, int n3) {
        int n4 = n3;
        int n5 = n - 8;
        BufferUtils.intToByteArray((int)(n4 + 8), (byte[])byArray, (int)n5, (int)4);
        System.arraycopy(string.getBytes(), 0, byArray, n5 + 4, 4);
    }

    public static int writeStartMOOF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMOOF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"nkj`", (int)(43 * 9)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMOOV(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMOOV(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"\"?>$", (int)(-61 - -44)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartTRAK(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopTRAK(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(3 * 29), (String)"#*81"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMDAT(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMDIA(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(49 - 45), (String)"iaof"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMDIA(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMVEX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(29 + 126), (String)"vjxf"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMVEX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"),(!", (int)(9 - 37)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopDINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(800 / 243), (String)"gmk`"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartSTBL(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopSTBL(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"su`o", (int)(97 + 63)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartDINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMDAT(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(293 / 59), (String)"iags"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStopMDAT(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, int n2) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)">04\"", (int)(23 * 5)), smoothStreamingFragmentWriterContext.popStartLoc(), n2);
        return n;
    }

    public static int writeStartTRAF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopTRAF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"wvd`", (int)(7 * 5)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int getSTYPSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 12;
        byte[] byArray = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
        n += byArray.length;
        int n2 = 0;
        while (n2 < smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.compatibleBrands[n2].getBytes();
            n += byArray2.length;
            ++n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTYP(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.majorBrandVersion, (byte[])byArray, (int)(n += byArray2.length), (int)4);
            n += 4;
            int n3 = 0;
            while (true) {
                if (n3 >= smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(71 + 15), (String)"%#!)"), n2);
                    return n;
                }
                byte[] byArray3 = smoothStreamingFragmentWriterMedia.compatibleBrands[n3].getBytes();
                System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
                n += byArray3.length;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(1589 / 232), (String)"WS_{c\u007fi\u007f[{y}a=cg\u007fc}XntqNJFP;\"") + exception.toString());
            return n;
        }
    }

    public static int getFTYPSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 12;
        byte[] byArray = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
        n += byArray.length;
        int n2 = 0;
        while (n2 < smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.compatibleBrands[n2].getBytes();
            n += byArray2.length;
            ++n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomFTYP(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.majorBrandVersion, (byte[])byArray, (int)(n += byArray2.length), (int)4);
            n += 4;
            int n3 = 0;
            while (true) {
                if (n3 >= smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"#2>8", (int)(88 + 109)), n2);
                    return n;
                }
                byte[] byArray3 = smoothStreamingFragmentWriterMedia.compatibleBrands[n3].getBytes();
                System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
                n += byArray3.length;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"\u0010\u0016\u00146,2\":\u001c>\" >`8\"8&6\u0015!9:\u001e\r\u0003\u000bf}", (int)(7 + 58)) + exception.toString());
            return n;
        }
    }

    public static int getSIDXSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 44;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSIDX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, int n2, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n3 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n4 = 0;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.a, (byte[])byArray, (int)(n += 3), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.timescale, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.startTimecode, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.b, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
            int n5 = 1;
            BufferUtils.intToByteArray((int)n5, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)(n += 2), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)Integer.MIN_VALUE, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"g|ro", (int)(11 - -9)), n3);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(184 / 45), (String)"UQQua}oyYygcc?ea}asVlvwHUYF% ") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomMFHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.sequenceNumber, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(47 * 49), (String)"2fif"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"JHJlv4$0\u00160,*4f>8\"8(\u000f;?<\u001f\u0015\u001c\u0011lw", (int)(21 * 15)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomTFHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(101 + 18), (String)"#>1>"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"DB@jpn~nHjvlr,tvlrbI}efXKFK*1", (int)(-35 - -56)) + exception.toString());
            return n;
        }
    }

    public static int getSTTSEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTTSEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"njk3", (int)(64 + -3)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"RPRtn|lx^xdb|>f`z`pWcwtIOHN[rpu{9$", (int)(409 / 126)) + exception.toString());
            return n;
        }
    }

    public static int getSTSCEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTSCEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"53;*", (int)(33 - 59)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"MIImiugqQqok{'}yeykNd~\u007f@@FURuinb&=", (int)(36 + 120)) + exception.toString());
            return n;
        }
    }

    public static int getSTSZEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 20;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTSZEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(19 * 53), (String)"<$\"("), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"UQQua}oyYygcc?ea}asVlvwHHNDZmqvz>%", (int)(1213 / 251)) + exception.toString());
            return n;
        }
    }

    public static int getSTCOEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTCOEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(3 * 47), (String)"~zl\u007f"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"ZXZ|fdt`F`|zd6nhrhx_k/,\u0011\u0017\u0007\n\u0003*8=3ql", (int)(47 - 4)) + exception.toString());
            return n;
        }
    }

    public static int getIODSSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 19;
        return n += SmoothStreamingFragmentWriter.a(16, 7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomIODS(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            n = SmoothStreamingFragmentWriter.a(byArray, n, 16, 7);
            BufferUtils.intToByteArray((int)79, (byte[])byArray, (int)n, (int)2);
            byArray[n += 2] = -1;
            byArray[++n] = -1;
            byArray[++n] = (byte)(smoothStreamingFragmentWriterMedia.trackType == 8 ? 254 : 255);
            byArray[++n] = (byte)(smoothStreamingFragmentWriterMedia.trackType == 9 ? 254 : 255);
            byArray[++n] = -1;
            SmoothStreamingFragmentWriter.stopAtom(byArray, ++n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(1504 / 238), (String)"ohlz"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(47 * 31), (String)"@FDf|brjLnrpn0h2(6&\u00051)*\u0001\u0006\u000e\u0018vm") + exception.toString());
            return n;
        }
    }

    public static int getTREXSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 32;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTREX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)(n += 3), (int)4);
            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)4);
            int n4 = smoothStreamingFragmentWriterMedia.trackType == 9 ? 0x2000000 : 0x1010000;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(450 / 103), (String)"pwc\u007f"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"\\ZXbxfvf@b~tj4lntjzAumnPWC_2)", (int)(15 * 35)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTRUNSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        int n2 = smoothStreamingFragmentWriterMedia.trunFlags;
        if ((n2 & 1) == 1) {
            n += 4;
        }
        if ((n2 & 4) == 4) {
            n += 4;
        }
        int n3 = smoothStreamingFragmentWriterMedia.packets.size();
        if ((n2 & 0x100) == 256) {
            n += 4 * n3;
        }
        if ((n2 & 0x200) == 512) {
            n += 4 * n3;
        }
        if ((n2 & 0x400) == 1024) {
            n += 4 * n3;
        }
        if ((n2 & 0x800) != 2048) return n;
        return n += 4 * n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMVHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return 12 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 16 : 8) + 4 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 8 : 4) + 4 + 2 + 2 + 4 + 4 + 36 + 24 + 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomMVHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = (byte)smoothStreamingFragmentWriterMedia.mvhdVersion;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            if (smoothStreamingFragmentWriterMedia.mvhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.timescale, (byte[])byArray, (int)n, (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.mvhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)n, (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)n, (int)4);
            BufferUtils.longToByteArray((long)256L, (byte[])byArray, (int)(n += 4), (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0x40000000L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(1443 / 236), (String)"kq`m"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"WS_{c\u007fi\u007f[{y}a=cg\u007fc}XntqPHWD;\"", (int)(568 / 83)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTKHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return 12 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 16 : 8) + 4 + 4 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 8 : 4) + 4 + 4 + 4 + 2 + 2 + 36 + 4 + 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTKHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = (byte)smoothStreamingFragmentWriterMedia.tkhdVersion;
            ++n;
            int n3 = 1;
            if (smoothStreamingFragmentWriterMedia.trackType == 9 || smoothStreamingFragmentWriterMedia.trackType == 8) {
                n3 |= 6;
            }
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)n, (int)3);
            n += 3;
            if (smoothStreamingFragmentWriterMedia.tkhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)n, (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.tkhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)n, (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)256L, (byte[])byArray, (int)(n += 4), (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 2), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0x40000000L, (byte[])byArray, (int)(n += 4), (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.trackType == 9) {
                BufferUtils.longToByteArray((long)(smoothStreamingFragmentWriterMedia.trackWidth << 16), (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)(smoothStreamingFragmentWriterMedia.trackHeight << 16), (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            } else {
                BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(-51 - -4), (String)"%9;0"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"TRPz`~n~Xzf|b<df|brYmuvHVV[:!", (int)(264 / 47)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMDHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return 12 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 16 : 8) + 4 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 8 : 4) + 2 + 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomMDHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = (byte)smoothStreamingFragmentWriterMedia.mdhdVersion;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            if (smoothStreamingFragmentWriterMedia.mdhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackTimescale, (byte[])byArray, (int)n, (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.mdhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)5575L, (byte[])byArray, (int)n, (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)2);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(5 * 45), (String)",&+ "), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(325 / 78), (String)"UQQua}oyYygcc?ea}asVlvwVXUZ% ") + exception.toString());
            return n;
        }
    }

    public static int getHDLRSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 32;
        byte[] byArray = smoothStreamingFragmentWriterMedia.componentName.getBytes();
        return n += byArray.length + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomHDLR(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            byte[] byArray2 = null;
            switch (smoothStreamingFragmentWriterMedia.trackType) {
                default: {
                    byArray2 = FileChunk.lastIndexOf((int)(38 - -58), (String)"-$6\"").getBytes();
                    break;
                }
                case 9: {
                    byArray2 = Base64.endsWith((String)";'+5", (int)(-6 - 45)).getBytes();
                    break;
                }
                case 8: {
                    byArray2 = Base64.endsWith((String)">!:>", (int)(14 - -63)).getBytes();
                }
            }
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += byArray2.length), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
            byte[] byArray3 = smoothStreamingFragmentWriterMedia.componentName.getBytes();
            System.arraycopy(byArray3, 0, byArray, n += 4, byArray3.length);
            byArray[n += byArray3.length] = 0;
            SmoothStreamingFragmentWriter.stopAtom(byArray, ++n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(75 + 23), (String)"*'(7"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"@FDf|brjLnrpn0h2(6&\u00051)*\u0000\r\u0006\u0019vm", (int)(27 * 35)) + exception.toString());
            return n;
        }
    }

    public static int getVMHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 20;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomVMHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 1;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"g\u007f{p", (int)(59 * 3)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(108 + -64), (String)"]YY}yewaAa\u007f{k7miui{^4./\u0015\t\r\u0002}h") + exception.toString());
            return n;
        }
    }

    public static int getSMHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSMHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(711 / 230), (String)"pimb"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"IMMiui{m\u00155+/7k15!=/\n8\"#\u001c\u001d\u0019\u0016it", (int)(2 - -54)) + exception.toString());
            return n;
        }
    }

    public static int getDREFSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 28;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomDREF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            int n4 = 1;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            int n5 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl2 = false;
            byArray[n] = (byte)(bl2 ? 1 : 0);
            int n6 = 1;
            BufferUtils.intToByteArray((int)n6, (byte[])byArray, (int)(++n), (int)3);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 3, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(33 + 75), (String)"9?\"o"), n5);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(-32 - -50), (String)"vaqs"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"RPRtn|lx^xdb|>f`z`pWcwt^IY[$?", (int)(733 / 198)) + exception.toString());
            return n;
        }
    }

    static int a(int n) {
        int n2 = 1;
        while (n >> 7 * n2 > 0) {
            ++n2;
        }
        return n + 1 + n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int a(int n, int n2) {
        int n3 = 2;
        try {
            int n4 = SmoothStreamingFragmentWriter.a(n2) - n2 - 2;
            while (n4 > 0) {
                ++n3;
                --n4;
            }
            return n3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(FileChunk.lastIndexOf((int)(247 / 52), (String)"UQQua}oyYygcc?bf`Qsd{kV~r'>") + exception.toString());
            return n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int a(byte[] byArray, int n, int n2, int n3) {
        try {
            int n4 = SmoothStreamingFragmentWriter.a(n3) - n3 - 2;
            byArray[n] = (byte)n2;
            ++n;
            while (true) {
                if (n4 <= 0) {
                    byArray[n] = (byte)(n3 & 0x7F);
                    ++n;
                    return n;
                }
                byArray[n] = (byte)(n3 >> 7 * n4 | 0x80);
                ++n;
                --n4;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(FileChunk.lastIndexOf((int)(43 * 7), (String)"\\ZXbxfvf@b~tj4kiiZz3\"0yd") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getSTSDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        if (smoothStreamingFragmentWriterMedia.trackType == 9 && smoothStreamingFragmentWriterMedia.trackCodec == 7) {
            n += 86;
            if (smoothStreamingFragmentWriterMedia.trackAVCCBytes == null) return n;
            return n += 8 + smoothStreamingFragmentWriterMedia.trackAVCCBytes.length;
        }
        if (smoothStreamingFragmentWriterMedia.trackType != 8 || smoothStreamingFragmentWriterMedia.trackCodec != 10) {
            if (smoothStreamingFragmentWriterMedia.trackType != 8) return n;
            if (smoothStreamingFragmentWriterMedia.trackCodec != 2) return n;
            return n += 36;
        }
        n += 36;
        n += 12;
        byte[] byArray = smoothStreamingFragmentWriterMedia.trackAACConfigBytes;
        int n2 = byArray == null ? 0 : SmoothStreamingFragmentWriter.a(byArray.length);
        n += SmoothStreamingFragmentWriter.a(3, 3 + SmoothStreamingFragmentWriter.a(13 + n2) + SmoothStreamingFragmentWriter.a(1));
        n += 2;
        ++n;
        n += SmoothStreamingFragmentWriter.a(4, 13 + n2);
        ++n;
        ++n;
        n += 3;
        n += 4;
        n += 4;
        if (byArray != null) {
            n += SmoothStreamingFragmentWriter.a(5, byArray.length);
            n += byArray.length;
        }
        n += SmoothStreamingFragmentWriter.a(6, 1);
        return ++n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomSTSD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2;
            block7: {
                block6: {
                    block4: {
                        block5: {
                            n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                            boolean bl = false;
                            byArray[n] = (byte)(bl ? 1 : 0);
                            int n3 = 0;
                            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
                            n += 3;
                            if (smoothStreamingFragmentWriterMedia.trackType == 9 && smoothStreamingFragmentWriterMedia.trackCodec == 7) break block4;
                            if (smoothStreamingFragmentWriterMedia.trackType == 8 && smoothStreamingFragmentWriterMedia.trackCodec == 10) break block5;
                            if (smoothStreamingFragmentWriterMedia.trackType != 8 || smoothStreamingFragmentWriterMedia.trackCodec != 2) break block6;
                            int n4 = 1;
                            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)n, (int)4);
                            n += 4;
                            String string = Base64.endsWith((String)"(jx:", (int)(558 / 92));
                            int n5 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
                            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)4);
                            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioChannelCount, (byte[])byArray, (int)(n += 4), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioSampleRate, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, string, n5);
                            break block7;
                        }
                        int n6 = 1;
                        BufferUtils.intToByteArray((int)n6, (byte[])byArray, (int)n, (int)4);
                        n += 4;
                        String string = FileChunk.lastIndexOf((int)(49 * 21), (String)"hv3i");
                        int n7 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
                        BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)4);
                        BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioChannelCount, (byte[])byArray, (int)(n += 4), (int)2);
                        BufferUtils.intToByteArray((int)16, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioSampleRate, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackTimescale, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        n += 2;
                        int n8 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                        n += 4;
                        byte[] byArray2 = smoothStreamingFragmentWriterMedia.trackAACConfigBytes;
                        int n9 = byArray2 == null ? 0 : SmoothStreamingFragmentWriter.a(byArray2.length);
                        n = SmoothStreamingFragmentWriter.a(byArray, n, 3, 3 + SmoothStreamingFragmentWriter.a(13 + n9) + SmoothStreamingFragmentWriter.a(1));
                        BufferUtils.intToByteArray((int)(smoothStreamingFragmentWriterMedia.trackId + 1), (byte[])byArray, (int)n, (int)2);
                        byArray[n += 2] = 0;
                        ++n;
                        n = SmoothStreamingFragmentWriter.a(byArray, n, 4, 13 + n9);
                        byArray[n] = 64;
                        byArray[++n] = 21;
                        int n10 = 0;
                        int n11 = 0;
                        int n12 = 0;
                        BufferUtils.intToByteArray((int)n10, (byte[])byArray, (int)(++n), (int)3);
                        BufferUtils.intToByteArray((int)n11, (byte[])byArray, (int)(n += 3), (int)4);
                        BufferUtils.intToByteArray((int)n12, (byte[])byArray, (int)(n += 4), (int)4);
                        n += 4;
                        if (byArray2 != null) {
                            n = SmoothStreamingFragmentWriter.a(byArray, n, 5, byArray2.length);
                            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                            n += byArray2.length;
                        }
                        n = SmoothStreamingFragmentWriter.a(byArray, n, 6, 1);
                        byArray[n] = 2;
                        SmoothStreamingFragmentWriter.stopAtom(byArray, ++n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(1 + 47), (String)"ubv`"), n8);
                        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, string, n7);
                        break block7;
                    }
                    int n13 = 1;
                    BufferUtils.intToByteArray((int)n13, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                    String string = Base64.endsWith((String)"wa{(", (int)(38 - 16));
                    int n14 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
                    BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackWidth, (byte[])byArray, (int)(n += 4), (int)2);
                    BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackHeight, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0x480000, (byte[])byArray, (int)(n += 2), (int)4);
                    BufferUtils.intToByteArray((int)0x480000, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)2);
                    String string2 = smoothStreamingFragmentWriterMedia.componentName;
                    byte[] byArray3 = string2.getBytes();
                    byArray[n += 2] = (byte)(byArray3.length & 0xFF);
                    System.arraycopy(byArray3, 0, byArray, ++n, byArray3.length);
                    BufferUtils.intToByteArray((int)24, (byte[])byArray, (int)(n += 31), (int)2);
                    BufferUtils.intToByteArray((int)65535, (byte[])byArray, (int)(n += 2), (int)2);
                    n += 2;
                    if (smoothStreamingFragmentWriterMedia.trackAVCCBytes != null) {
                        int n15 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                        System.arraycopy(smoothStreamingFragmentWriterMedia.trackAVCCBytes, 0, byArray, n, smoothStreamingFragmentWriterMedia.trackAVCCBytes.length);
                        SmoothStreamingFragmentWriter.stopAtom(byArray, n += smoothStreamingFragmentWriterMedia.trackAVCCBytes.length, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(58 - -64), (String)";-?\u001e"), n15);
                    }
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, string, n14);
                    break block7;
                }
                int n16 = 0;
                BufferUtils.intToByteArray((int)n16, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"260 ", (int)(38 + 27)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(47 * 7), (String)"\u0018\u001e\u001c>$:*\"\u0004&:8&x *0.>\u001d)12\u0013\u0015\u0011\u0007~e") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTRUNDASH(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, int n2, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n3;
            int n4 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n5 = smoothStreamingFragmentWriterMedia.trunFlags;
            BufferUtils.intToByteArray((int)n5, (byte[])byArray, (int)(++n), (int)3);
            int n6 = smoothStreamingFragmentWriterMedia.packets.size();
            BufferUtils.intToByteArray((int)n6, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            if ((n5 & 1) == 1) {
                BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            if ((n5 & 4) == 4) {
                n3 = 0;
                BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            n3 = 0;
            int n7 = 0;
            while (true) {
                if (n7 >= n6) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"wvph", (int)(860 / 223)), n4);
                    return n;
                }
                long l = n7 != n6 - 1 ? smoothStreamingFragmentWriterMedia.packets.get(n7 + 1).getTimecode() - smoothStreamingFragmentWriterMedia.packets.get(n7).getTimecode() : smoothStreamingFragmentWriterMedia.lastTimecode - smoothStreamingFragmentWriterMedia.packets.get(n7).getTimecode();
                int n8 = smoothStreamingFragmentWriterMedia.packets.get(n7).getSize();
                long l2 = smoothStreamingFragmentWriterMedia.packets.get(n7).getCTTS();
                int n9 = 0;
                n3 = (int)((long)n3 + l);
                if ((n5 & 0x100) == 256) {
                    BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                if ((n5 & 0x200) == 512) {
                    BufferUtils.intToByteArray((int)n8, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                if ((n5 & 0x400) == 1024) {
                    BufferUtils.intToByteArray((int)n9, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                if ((n5 & 0x800) == 2048) {
                    BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(114 + 109), (String)"\u000e\u0014\u00160*0 4\u0012< &8b:<&$4\u0013';8\u0002\u0005\r\u0017\u001e\u001a\u000f\u0015d\u007f") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTRUN(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 2816;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            int n4 = smoothStreamingFragmentWriterMedia.packets.size();
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            int n5 = 0;
            int n6 = 0;
            while (true) {
                if (n6 >= n4) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(27 * 61), (String)";\"$<"), n2);
                    return n;
                }
                long l = (n6 != n4 - 1 ? smoothStreamingFragmentWriterMedia.packets.get(n6 + 1).getTimecode() - smoothStreamingFragmentWriterMedia.packets.get(n6).getTimecode() : smoothStreamingFragmentWriterMedia.lastTimecode - smoothStreamingFragmentWriterMedia.packets.get(n6).getTimecode()) * smoothStreamingFragmentWriterMedia.timescaleAdjust;
                int n7 = smoothStreamingFragmentWriterMedia.packets.get(n6).getSize();
                long l2 = (long)smoothStreamingFragmentWriterMedia.packets.get(n6).getCTTS() * smoothStreamingFragmentWriterMedia.timescaleAdjust;
                n5 = (int)((long)n5 + l);
                BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)n, (int)4);
                BufferUtils.intToByteArray((int)n7, (byte[])byArray, (int)(n += 4), (int)4);
                BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
                ++n6;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"X^\\~dzjbDfzxf8`jpn~]iqrTSWM>%", (int)(23 - 14)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomSDTP(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            int n4 = smoothStreamingFragmentWriterMedia.packets.size();
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(126 + 84), (String)"!7 %"), n2);
                    return n;
                }
                int n6 = smoothStreamingFragmentWriterMedia.packets.get(n5).getFrameType() != 1 ? 20 : 36;
                BufferUtils.longToByteArray((long)n6, (byte[])byArray, (int)n, (int)1);
                ++n;
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(57 * 55), (String)"N\u0014\u00160*0 4\u0012< &8b:<&$4\u0013';8\u0005\u0013\f\t`{") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomPlayReadyTrackUUID(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2;
            int n3 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = BufferUtils.decodeHexString((String)Base64.endsWith((String)"\n~~w{\u0016d`f\u0015l\u0014c>hn\u001anijiC504G32?LO>", (int)(5 * 47)));
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            byArray[n += byArray2.length] = 0;
            byte[] byArray3 = smoothStreamingFragmentWriterMedia.playReadySampleData.getKeyId();
            int n4 = (byArray3 == null ? 0 : 1) + (smoothStreamingFragmentWriterMedia.playReadySampleData.isSubSamples() ? 2 : 0);
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            if (byArray3 != null) {
                n2 = smoothStreamingFragmentWriterMedia.playReadySampleData.getAlgorithmId();
                int n5 = smoothStreamingFragmentWriterMedia.playReadySampleData.getIvLen();
                BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)n, (int)3);
                BufferUtils.intToByteArray((int)n5, (byte[])byArray, (int)(n += 3), (int)1);
                System.arraycopy(byArray3, 0, byArray, ++n, byArray3.length);
                n += byArray3.length;
            }
            n2 = smoothStreamingFragmentWriterMedia.playReadySampleData.getCount();
            BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)n, (int)4);
            n += 4;
            List list = smoothStreamingFragmentWriterMedia.playReadySampleData.getFragments();
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"sram", (int)(45 + -39)), n3);
                    return n;
                }
                RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)iterator.next();
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n, rTPPacketFragment.getLen());
                n += rTPPacketFragment.getLen();
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"WS_{c\u007fi\u007f[{y}a=cg\u007fc}XntqMr~ySgb`|Ruija^YDJ50", (int)(1028 / 168)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomUUID(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            n = SmoothStreamingFragmentWriter.writeAtomUUIDDuration(byArray, n, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
            return SmoothStreamingFragmentWriter.writeAtomUUIDReadAhead(byArray, n, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"HNLntjz2\u00146*(6h0: >.\r9!\"\u0005\u0004\u001b\u0017nu", (int)(51 - -6)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomUUIDDuration(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = BufferUtils.decodeHexString((String)Base64.endsWith((String)"2a7c1k:>8?j:$%w%,%s%)-+\u007f}{x(56`1", (int)(789 / 194)));
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            byArray[n += byArray2.length] = 1;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.startTimecode, (byte[])byArray, (int)(n += 3), (int)8);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)(n += 8), (int)8);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 8, smoothStreamingFragmentWriterContext, FileChunk.lastIndexOf((int)(63 * 33), (String)"juhf"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.lastIndexOf((int)(43 * 17), (String)"\n\b\n,64$0\u00160,*4f>8\"8(\u000f;?<\u0007\u0006\u001d\u0011\u0012\"*8.233d\u007f") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomUUIDReadAhead(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            System.arraycopy(READ_AHEAD_GUID_BYTES, 0, byArray, n, READ_AHEAD_GUID_BYTES.length);
            byArray[n += SmoothStreamingFragmentWriter.READ_AHEAD_GUID_BYTES.length] = 1;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            int n4 = smoothStreamingFragmentWriterMedia.readAheadDurations.length;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 3), (int)1);
            ++n;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.endsWith((String)"onuy", (int)(95 + 91)), n2);
                    return n;
                }
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.readAheadStartTimes[n5], (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.readAheadDurations[n5], (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.endsWith((String)"TRPz`~n~Xzf|b<df|brYmuvIHW[\u0012$#'\u0005-#&,sj", (int)(3 * 55)) + exception.toString());
            return n;
        }
    }
}

