/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class ID3v2_2Frame
extends AbstractID3v2Frame {
    public ID3v2_2Frame() {
    }

    public ID3v2_2Frame(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
    }

    public ID3v2_2Frame(ID3v2_2Frame iD3v2_2Frame) {
        super(iD3v2_2Frame);
    }

    public ID3v2_2Frame(AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame.getBody() != null && TagUtility.isID3v2_2FrameIdentifier(abstractID3v2Frame.getIdentifier())) {
            this.setBody((AbstractID3v2FrameBody)TagUtility.copyObject(abstractID3v2Frame.getBody()));
        }
    }

    public ID3v2_2Frame(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        this.read(randomAccessFile);
    }

    public int getSize() {
        return this.getBody().getSize() + 3 + 3;
    }

    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        long l;
        byte by;
        byte[] byArray = new byte[3];
        do {
            l = randomAccessFile.getFilePointer();
            by = randomAccessFile.readByte();
            AbstractID3v2.incrementPaddingCounter();
        } while (by == 0);
        randomAccessFile.seek(l);
        AbstractID3v2.decrementPaddingCounter();
        randomAccessFile.read(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        if (!ID3v2_2Frame.isValidID3v2FrameIdentifier(string)) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
            throw new InvalidTagException(string + " is not a valid ID3v2.20 frame");
        }
        this.setBody(ID3v2_2Frame.readBody(string, randomAccessFile));
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[4];
        String string = TagUtility.truncate(this.getIdentifier(), 3);
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        randomAccessFile.write(byArray, 0, string.length());
        this.getBody().write(randomAccessFile);
    }
}

