/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.wms.transcoder.model.ITranscoderWorker;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderSession;
import com.wowza.wms.transcoder.model.TranscoderSessionNative;
import com.wowza.wms.vhost.ThreadPool;

public abstract class TranscoderWorkerBase
implements Runnable,
ITranscoderWorker {
    protected boolean isRunning = false;
    protected Object lock = new Object();
    protected ThreadPool threadPool = null;
    protected int maxCycleCount = 20;
    protected LiveStreamTranscoder liveStreamTranscoder = null;
    protected TranscoderSession transcodingSession = null;
    protected TranscoderSessionNative nativeSession = null;
    protected long nativeObj = 0L;
    protected boolean active = true;

    protected abstract boolean isWorkWaiting();

    public void init(LiveStreamTranscoder liveStreamTranscoder) {
        this.liveStreamTranscoder = liveStreamTranscoder;
        this.threadPool = liveStreamTranscoder.getAppInstance().getVHost().getHandlerThreadPool();
        this.transcodingSession = liveStreamTranscoder.getTranscodingSession();
        this.nativeSession = this.transcodingSession.getNativeSession();
        this.nativeObj = this.transcodingSession.getNativeObj();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doNativeLogging() {
        if (this.transcodingSession == null) {
            return;
        }
        this.transcodingSession.doNativeLogging();
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runIfNeeded() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) return;
            if (!this.isWorkWaiting()) return;
            this.isRunning = true;
            this.threadPool.execute((Runnable)this);
            return;
        }
    }

    public int getMaxCycleCount() {
        return this.maxCycleCount;
    }

    public void setMaxCycleCount(int n) {
        this.maxCycleCount = n;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActive(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.active = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deactivate() {
        Object object = this.lock;
        synchronized (object) {
            this.active = false;
            return this.isRunning;
        }
    }
}

