/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerCupertinoUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYSTR_NODVR_PLACHOLDER = "{query_no_dvr}";
    public static final String RESOLUTIONPLACEHOLDER = "{resolution}";
    public static final String RESOLUTIONWIDTHPLACEHOLDER = "{resolution-width}";
    public static final String RESOLUTIONHEIGHTPLACEHOLDER = "{resolution-height}";
    public static final String AUDIOONLYPLACHOLDER = "{audioOnly}";
    public static final String PLAYSTARTNAME = "{playStartName}";
    public static final String PLAYSTARTVALUE = "{playStartValue}";
    public static final String PLAYSTARTPLACHOLDER = "{playStartName}={playStartValue}";
    public static final String PLAYDURATIONNAME = "{playDurationName}";
    public static final String PLAYDURATIONVALUE = "{playDurationValue}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDurationName}={playDurationValue}";
    public static final String QUERYSTRAUDIOONLYPLACHOLDER = "{query}{audioOnly}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCIVPLACEHOLDER = "{encIV}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String ENCKEYSTRWITHIV = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\",IV=\"{encIV}\"";
    public static final String DISCONTINUITYSTR = "#EXT-X-DISCONTINUITY";
    public static final String RESOLUTIONSTR = ",RESOLUTION={resolution-width}x{resolution-height}";
    public static final String FILENAMEPATTERN = "media_{index}{ext}";
    public static final String URLPATTERN = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = FileChunk.getChars((int)(1217 / 180), (String)"(s{");
        switch (n) {
            case 2: {
                string = FileChunk.getChars((int)(21 - -17), (String)"(jx:");
            }
            default: {
                return string;
            }
            case 3: 
        }
        return FileChunk.getChars((int)(385 / 117), (String)"-ede");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoEncInfo cupertinoEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingCupertinoBlock> arrayList;
        List<LiveStreamingCupertinoBlock> list;
        Cipher cipher;
        if (cupertinoEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info(FileChunk.getChars((int)(59 - 48), (String)"Ge{k\\dcwryEwts|nrfxl\\uqgqplhh&of~\u007fe^nszwgg/6v|}Xtis}f\u0003 17( \u0015\"+<8\"84\u001e=?';71'lw") + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), Base64.copyValueOf((String)"GB[", (int)(1490 / 218)));
            long l = liveStreamPacketizerCupertinoChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(FileChunk.getChars((int)(87 + 28), (String)"\u0012\u0011\u0006y\u0014\u001a\u001au\u000b\u0017\u001e\rhP`fgmka"), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerCupertinoChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingCupertinoBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(Base64.copyValueOf((String)"\u001a>.<\t/.8?2\u0010 !(!1/=-;\t><(<;9?=\u0006 <:$v<48.$.+Ciwmo?&FMZ':>5.j~r`jda\u007fxv#:", (int)(53 - -33)) + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerCupertinoChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = list.get(n);
            n4 += liveStreamingCupertinoBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen()) : cipher.update(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingCupertinoBlock liveStreamingCupertinoBlock2 = new LiveStreamingCupertinoBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingCupertinoBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CupertinoEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + FileChunk.getChars((int)(22 + 94), (String)"z>3."));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(FileChunk.getChars((int)(-40 - -47), (String)"rze"));
            if (string3 != null || (string3 = (String)object.get(Base64.copyValueOf((String)"ff|", (int)(-1 - -20)))) != null || (string3 = (String)object.get(Base64.copyValueOf((String)"!64 43!'%88?+.=8<4y43$ikbv)/2", (int)(-2 + 68)))) != null || (string3 = (String)object.get(FileChunk.getChars((int)(13 * 11), (String)"leawa`|xxkmh~}pwqg,cfw44?%|xb"))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.copyValueOf((String)"xql", (int)(13 * 63)))) != null || (string2 = (String)object.get(FileChunk.getChars((int)(400 / 65), (String)"erxlx\u007feca|dcwry|xp5x\u007fh-/&2kd{"))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() == 32) {
                    byArray = BufferUtils.decodeHexString((String)string2);
                } else {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.copyValueOf((String)"\u0007%;+\u001c$#729\u0005743<.2&8,\u001c51'10,((f $\"8wn\u00045(r?1;1#0y35?2,-ebv-$Hst|)hn,<8/rhfvg5>$*9ys}o\u007f|tdpp-%jhfn*P", (int)(7 - 60)) + file + FileChunk.getChars((int)(41 + -22), (String)"N.5") + string2.length());
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new CupertinoEncInfo(string2, byArray, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int millisToSecondsDuration(long l) {
        int n = (int)Math.round((double)l / 1000.0);
        if (n > 0) return n;
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 2: {
                string = Base64.copyValueOf((String)"(6s)g~{b", (int)(18 - -51)) + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 10: 
        }
        if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
        return FileChunk.getChars((int)(52 - -63), (String)">$a7ylit") + mediaCodecInfoAudio.getAudioObjectType();
    }

    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        return LiveStreamPacketizerCupertinoUtils.codecInfoVideoToCodecsStr(mediaCodecInfoVideo, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo, boolean bl) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            case 7: {
                if (!bl) break;
                return Base64.copyValueOf((String)"+=/|`yf\u007fac", (int)(89 + -15));
            }
            default: {
                return string;
            }
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return FileChunk.getChars((int)(83 + 122), (String)",8,a\u007f") + n2 + "." + n;
    }
}

