/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayWriteControl;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264Cursor;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264ReadAheadRequest;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.IQTDataDataToAMF;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderH264
implements IMediaReader,
IQTDataDataToAMF {
    protected MediaReaderItem mediaReaderItem = null;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = FileChunk.getChars((int)(51 * 13), (String)"zh-");
    protected String mediaReaderExt = FileChunk.getChars((int)(58 + 71), (String)"lr7");
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = Base64.copyValueOf((String)"(6s", (int)(13 * 57));
    protected QTMediaContainer container = null;
    protected H264Cursor cursor = null;
    protected H264Cursor cursorReadAhead = null;
    protected H264ReadAheadRequest currReadAhead = null;
    protected H264ReadAheadRequest nextReadAhead = null;
    protected boolean cacheReadAhead = false;
    protected List<H264ReadAheadRequest> readAheadCache = new ArrayList<H264ReadAheadRequest>();
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected int indexBufferSize = 16384;
    protected boolean useDisplaySize = true;
    protected IRandomAccessReader videoFileStream = null;
    protected IRandomAccessReader metaFileStream = null;
    protected List metaData = null;
    protected long duration = -1L;
    protected long length = 0L;
    protected long videoSampleCount = -1L;
    protected long audioSampleCount = -1L;
    protected long dataSampleCount = -1L;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean doSendVideoTrakInfo = false;
    protected boolean doSendAudioTrakInfo = false;
    protected boolean doSendEnhanceSeek = false;
    protected boolean errorReported = false;
    protected int audioType = 175;
    protected int audioExtraSize = 2;
    protected String randomAccessReaderClass = FileChunk.getChars((int)(63 + 76), (String)"hc` x\u007ffhr:|y9\\ph~\u007fiL~nemnEfeb{zXnmik}");
    protected IApplicationInstance appInstance = null;
    protected int videoCodec = 7;
    protected int audioCodec = 10;
    protected boolean openAudioTrack = true;
    protected boolean openVideoTrack = true;
    protected int trackIndexVideo = 0;
    protected int trackIndexAudio = 0;
    protected int trackIndexData = 0;
    protected String trackDataCharSet = FileChunk.getChars((int)(51 + 8), (String)"NH[3'");
    protected IQTDataDataToAMF dataDataToAMFHandler = this;
    static long a = -1L;

    public MediaReaderH264() {
        this.chunkHeaderValues = new int[5];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.readAheadSize = wMSProperties.getPropertyInt(FileChunk.getChars((int)(73 + 59), (String)"iu2UmhnJdhokCxhv"), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(FileChunk.getChars((int)(37 * 61), (String)"<\"g\u0006073\u00191?:8\t,6'&'1"), this.readAheadTrigger);
        this.indexBufferSize = wMSProperties.getPropertyInt(Base64.copyValueOf((String)":(m\u0013588&\u001d5'$&6\u0016/=-", (int)(109 + 106)), this.indexBufferSize);
        this.cacheReadAhead = wMSProperties.getPropertyBoolean(Base64.copyValueOf((String)"jx=Ijoek]upvR|pws", (int)(61 * 51)), this.cacheReadAhead);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(FileChunk.getChars((int)(63 + 49), (String)"\"0<7;8\u00174;<)(\u000e8?;esAoevu"), this.randomAccessReaderClass);
        this.useDisplaySize = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(104 + -57), (String)"b`%G`qQ\u007fdhu{bOtdz"), this.useDisplaySize);
        if (!WMSLoggerFactory.getLogger(MediaReaderH264.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.getChars((int)(613 / 118), (String)"HccahXnmik}X#$':xf#J|{\u007f]u{~dRkya?&") + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.copyValueOf((String)"\u000e!!/&\u001a,+/)?\u0006}fe|>$a\u000429=\u001b39<:\u000brhedaw<'", (int)(31 * 61)) + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.copyValueOf((String)"I`bni[ojhh|G\"'&=ye\"^v}\u007fc^hxyesQj~`<'", (int)(89 + -85)) + this.indexBufferSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.getChars((int)(570 / 112), (String)"HccahXnmik}X#$':gwy|vwZ\u007f~{lsSgb``tDdhyx6-") + this.randomAccessReaderClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.metaFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        this.videoFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            block16: {
                block14: {
                    Exception exception3;
                    block15: {
                        block12: {
                            QTParseContext qTParseContext;
                            block13: {
                                block10: {
                                    block11: {
                                        if (this.metaFileStream.isOpen()) {
                                            this.close();
                                        }
                                        try {
                                            this.metaFileStream.open();
                                            this.videoFileStream.open();
                                            this.errorReported = false;
                                            break block10;
                                        }
                                        catch (Exception exception2) {
                                            if (this.errorReported) break block11;
                                        }
                                        WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, FileChunk.getChars((int)(-30 - -46), (String)"]tvzuGsv||hS.+*1oqgm_4[=(") + exception2.toString(), null, FileChunk.getChars((int)(33 - 42), (String)"$=+,>."), "comment", 404, this.mediaName);
                                    }
                                    this.errorReported = true;
                                }
                                if (this.metaFileStream == null) return;
                                if (!this.metaFileStream.isOpen()) return;
                                try {
                                    this.length = this.metaFileStream.length();
                                    qTParseContext = new QTParseContext();
                                    qTParseContext.setClientId(this.stream.getClientId());
                                    qTParseContext.setIndexBufferSize(this.indexBufferSize);
                                    qTParseContext.setParseAudioTrack(this.openAudioTrack);
                                    qTParseContext.setParseVideoTrack(this.openVideoTrack);
                                    IRandomAccessReader iRandomAccessReader = this.metaFileStream;
                                    this.container = QTUtils.parseQTMediaContainer(iRandomAccessReader, iRandomAccessReader.length(), qTParseContext);
                                    if (this.container == null) break block12;
                                    MediaReaderH264 mediaReaderH264 = this;
                                    this.appInstance.notifyMediaReaderOpen((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
                                    this.readMetadata();
                                    MediaReaderH264 mediaReaderH2642 = this;
                                    this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)mediaReaderH2642, mediaReaderH2642.stream);
                                    QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                    QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                    QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                    this.cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 2);
                                    if (this.cursor == null) break block13;
                                }
                                catch (Exception exception3) {
                                    if (this.errorReported) break block14;
                                    break block15;
                                }
                                this.videoSampleCount = this.cursor.getVideoSampleCount();
                                this.audioSampleCount = this.cursor.getAudioSampleCount();
                                this.dataSampleCount = this.cursor.getDataSampleCount();
                            }
                            if (qTParseContext.getIndexRefCount() <= 0) {
                                this.metaFileStream.close();
                                this.metaFileStream = null;
                            }
                        }
                        if (this.container != null) return;
                        if (!this.errorReported) {
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.copyValueOf((String)"\u0017>84?\re`ffvM41<'$d|h`50T`a{g6gykirrz>yimg#bjtji}*PA]:R", (int)(40 + 82)), null, FileChunk.getChars((int)(17 * 53), (String)"vcu~lx"), "comment", 500, this.mediaName);
                        }
                        this.errorReported = true;
                        break block16;
                    }
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.copyValueOf((String)"\u000e!!/&\u001a,+/)?\u0006}fe|<$08\fj\u0004`{", (int)(-12 - 49)) + exception3.toString(), null, Base64.copyValueOf((String)"$=+,>.", (int)(-5 - 4)), "comment", 404, this.mediaName);
                }
                this.errorReported = true;
                this.container = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.container == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.container = null;
        try {
            if (this.videoFileStream != null) {
                this.videoFileStream.close();
            }
            if (this.metaFileStream != null) {
                this.metaFileStream.close();
            }
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.copyValueOf((String)"]tvzuGsv||hS.+*1oqgm>%", (int)(-66 - 46)) + exception.toString());
        }
        this.metaData = null;
        this.duration = -1L;
        this.videoSampleCount = -1L;
        this.dataSampleCount = -1L;
        this.audioSampleCount = -1L;
        this.cursor = null;
        this.length = 0L;
        MediaReaderH264 mediaReaderH264 = this;
        this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
    }

    /*
     * Unable to fully structure code
     */
    protected void readMetadata() {
        block40: {
            block25: {
                block50: {
                    block42: {
                        block39: {
                            block41: {
                                block44: {
                                    block49: {
                                        block28: {
                                            block33: {
                                                block27: {
                                                    block38: {
                                                        block47: {
                                                            block46: {
                                                                block48: {
                                                                    block30: {
                                                                        block37: {
                                                                            block36: {
                                                                                block29: {
                                                                                    block31: {
                                                                                        block43: {
                                                                                            block45: {
                                                                                                block34: {
                                                                                                    block32: {
                                                                                                        block35: {
                                                                                                            block26: {
                                                                                                                if (this.container != null) break block41;
                                                                                                                break block42;
lbl3:
                                                                                                                // 2 sources

                                                                                                                while (true) {
                                                                                                                    this.audioType = 47;
                                                                                                                    this.audioExtraSize = 1;
                                                                                                                    this.audioCodec = 2;
                                                                                                                    break block25;
                                                                                                                    break;
                                                                                                                }
lbl8:
                                                                                                                // 1 sources

                                                                                                                while (true) {
                                                                                                                    v0 = var3_3.getMdiaAtom().getMinfAtom().getStblAtom();
                                                                                                                    break block26;
                                                                                                                    break;
                                                                                                                }
lbl11:
                                                                                                                // 1 sources

                                                                                                                while (true) {
                                                                                                                    var11_15.put(FileChunk.getChars((int)(43 * 13), (String)"|q|b\u007fqqsd{kskhtqq"), (AMFData)var12_19);
                                                                                                                    var7_7.add((AMFData)var11_15);
                                                                                                                    break block27;
                                                                                                                    break;
                                                                                                                }
lbl15:
                                                                                                                // 1 sources

                                                                                                                while (true) {
                                                                                                                    v0 = null;
                                                                                                                    break block26;
                                                                                                                    break;
                                                                                                                }
lbl18:
                                                                                                                // 1 sources

                                                                                                                while (true) {
                                                                                                                    var10_14 = var2_2.getTrak(var9_9);
                                                                                                                    if (var10_14 != null) break block28;
                                                                                                                    break block27;
lbl22:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        var9_10 = var3_3.getMdiaAtom().getTimescale();
                                                                                                                        var11_16 = 0.0;
                                                                                                                        if (var4_4.getTimeToSample() == null) break block29;
                                                                                                                        break block30;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        var1_1.put(FileChunk.getChars((int)(-45 - 28), (String)"`q}ns"), (AMFData)new AMFDataItem(var4_4.getFrameWidth()));
                                                                                                                        var1_1.put(Base64.copyValueOf((String)"kalao|", (int)(57 * 27)), (AMFData)new AMFDataItem(var4_4.getFrameHeight()));
                                                                                                                        break block31;
                                                                                                                        break;
                                                                                                                    }
lbl31:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        var1_1.put(FileChunk.getChars((int)(35 * 27), (String)"f{w`}"), (AMFData)new AMFDataItem(var4_4.getDisplayWidth()));
                                                                                                                        var1_1.put(FileChunk.getChars((int)(23 - 13), (String)"bnejf{"), (AMFData)new AMFDataItem(var4_4.getDisplayHeight()));
                                                                                                                        break block31;
                                                                                                                        break;
                                                                                                                    }
lbl35:
                                                                                                                    // 2 sources

                                                                                                                    while (var4_4 != null) {
                                                                                                                        break block32;
                                                                                                                    }
                                                                                                                    break block33;
lbl38:
                                                                                                                    // 3 sources

                                                                                                                    while (var6_6 != null) {
                                                                                                                        break block34;
                                                                                                                    }
                                                                                                                    ** GOTO lbl35
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            var4_4 = v0;
                                                                                                            var5_5 = var2_2.getAudioTrack(this.trackIndexAudio);
                                                                                                            if (var5_5 != null) break block43;
                                                                                                            break block44;
lbl46:
                                                                                                            // 1 sources

                                                                                                            while (true) {
                                                                                                                var1_1.put(FileChunk.getChars((int)(61 * 17), (String)"l{ky~q{u{xrtj"), (AMFData)new AMFDataItem(var6_6.getAudioChannels()));
                                                                                                                var1_1.put(Base64.copyValueOf((String)"\"1!/(;('; (<.$4", (int)(45 * 47)), (AMFData)new AMFDataItem(var5_5.getMdiaAtom().getTimescale()));
                                                                                                                break block35;
                                                                                                                break;
                                                                                                            }
lbl50:
                                                                                                            // 1 sources

                                                                                                            while (true) {
                                                                                                                var1_1.put(FileChunk.getChars((int)(48 - -29), (String)"9<.3:;=2:"), (AMFData)var7_7);
                                                                                                                if (var6_6 == null) break block35;
                                                                                                                ** continue;
lbl54:
                                                                                                                // 1 sources

                                                                                                                while ((var9_11 = var4_4.getAVCCData()) != null) {
                                                                                                                    break block36;
                                                                                                                }
                                                                                                                ** GOTO lbl38
                                                                                                                break;
                                                                                                            }
lbl57:
                                                                                                            // 1 sources

                                                                                                            while (true) {
                                                                                                                if (!this.useDisplaySize) ** continue;
                                                                                                                ** continue;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (var4_4 != null) {
                                                                                                            ** continue;
lbl63:
                                                                                                            // 1 sources

                                                                                                            while (true) {
                                                                                                                var11_17 = var5_5.getMdiaAtom().getTimescale();
                                                                                                                var13_21 = var5_5.getMdiaAtom().getDuration();
                                                                                                                var9_12 = (double)var13_21 / (double)var11_17;
                                                                                                                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.getChars((int)(371 / 74), (String)"dscafN~~lzf\u007f\u007f(") + var9_12 + ":" + var11_17 + ":" + var13_21);
                                                                                                                break block37;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        break block45;
                                                                                                    }
                                                                                                    var1_1.put(Base64.copyValueOf((String)"umachkfnnodj", (int)(77 + 86)), (AMFData)new AMFDataItem(var4_4.getDataTypes().get(0)));
                                                                                                    break block33;
                                                                                                }
                                                                                                var1_1.put(FileChunk.getChars((int)(4 + 39), (String)"jyig`s~vvw|r"), (AMFData)new AMFDataItem(var6_6.getDataTypes().get(0)));
                                                                                                ** GOTO lbl35
                                                                                            }
lbl77:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                var1_1.put(FileChunk.getChars((int)(1282 / 221), (String)"dgdif~"), (AMFData)new AMFDataItem(2.0));
                                                                                                if (var4_4 == null) ** GOTO lbl38
                                                                                                ** GOTO lbl54
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        v1 = var5_5.getMdiaAtom().getMinfAtom().getStblAtom();
                                                                                        break block46;
                                                                                    }
                                                                                    var1_1.put(FileChunk.getChars((int)(48 + 54), (String)" 5)$/\u001c%):'"), (AMFData)new AMFDataItem(var4_4.getFrameWidth()));
                                                                                    var1_1.put(Base64.copyValueOf((String)"bwgjmAobkez", (int)(968 / 232)), (AMFData)new AMFDataItem(var4_4.getFrameHeight()));
                                                                                    var1_1.put(FileChunk.getChars((int)(25 * 13), (String)"!/48%+2\u001b$*;8"), (AMFData)new AMFDataItem(var4_4.getDisplayWidth()));
                                                                                    var1_1.put(FileChunk.getChars((int)(34 + 19), (String)"q\u007fdhu{bTxwx(5"), (AMFData)new AMFDataItem(var4_4.getDisplayHeight()));
                                                                                    var9_13 = var4_4.getFrameRate();
                                                                                    if (!(var9_13 > 0.0)) break block47;
                                                                                    break block48;
                                                                                }
lbl93:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    var1_1.put(FileChunk.getChars((int)(-25 - 52), (String)"e}qsx~k{vyo\u007fk%"), (AMFData)new AMFDataItem(var11_16));
                                                                                    ** continue;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            var1_1.put(FileChunk.getChars((int)(19 * 29), (String)"f~jfnzhb"), (AMFData)new AMFDataItem(var9_11.getAvcLevel()));
                                                                            var1_1.put(Base64.copyValueOf((String)"dpdx{emeak", (int)(763 / 133)), (AMFData)new AMFDataItem(var9_11.getAvcProfile()));
                                                                            ** GOTO lbl38
lbl100:
                                                                            // 1 sources

                                                                            while (true) {
                                                                                var13_21 = var3_3.getMdiaAtom().getTimescale();
                                                                                var15_26 = var3_3.getMdiaAtom().getDuration();
                                                                                var11_18 = (double)var15_26 / (double)var13_21;
                                                                                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.getChars((int)(467 / 82), (String)"socmfN~~lzf\u007f\u007f(") + var11_18 + ":" + var13_21 + ":" + var15_26);
                                                                                break block38;
                                                                                break;
                                                                            }
                                                                        }
                                                                        while (true) {
                                                                            var11_18 = 0.0;
                                                                            if (var3_3 != null) {
                                                                                ** continue;
                                                                            }
                                                                            break block38;
                                                                            break;
                                                                        }
                                                                    }
                                                                    var13_22 = var4_4.getTimeToSample().get(0, 1);
                                                                    var11_16 = (double)var9_10 / (double)var13_22;
                                                                    ** while (true)
                                                                }
                                                                var1_1.put(FileChunk.getChars((int)(215 / 70), (String)"evdkbzh~n"), (AMFData)new AMFDataItem(var9_13));
                                                                break block47;
                                                            }
lbl120:
                                                            // 2 sources

                                                            while (true) {
                                                                var6_6 = v1;
                                                                var7_7 = new AMFDataArray();
                                                                var8_8 = var2_2.getTrakCount();
                                                                var9_9 = 0;
                                                                break block39;
                                                                break;
                                                            }
                                                        }
lbl127:
                                                        // 2 sources

                                                        while (true) {
                                                            var1_1.put(FileChunk.getChars((int)(63 * 53), (String)"fcbx\u007f\u007fb{g}zx"), (AMFData)new AMFDataItem(this.container.getMoovAtom().getOffset() + 8L));
                                                            var9_12 = 0.0;
                                                            if (var5_5 == null) ** continue;
                                                            ** continue;
                                                            break;
                                                        }
lbl132:
                                                        // 1 sources

                                                        while (var18_29 == null) {
                                                            ** GOTO lbl3
                                                        }
                                                        break block25;
                                                    }
                                                    WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.getChars((int)(93 + 82), (String)"kecsg}zx-") + Math.max(var9_12, var11_18));
                                                    var13_23 = Math.max(var9_12, var11_18);
                                                    this.duration = Math.round(var13_23 * 1000.0);
                                                    var1_1.put(Base64.copyValueOf((String)"asui}cdb", (int)(740 / 127)), (AMFData)new AMFDataItem(var13_23));
                                                    var15_27 = new AMFDataList();
                                                    var15_27.add((AMFData)new AMFDataItem(FileChunk.getChars((int)(444 / 143), (String)"ljHcsiMk\u007fm")));
                                                    var15_27.add((AMFData)var1_1);
                                                    var16_28 = var15_27.serialize();
                                                    this.metaData.add(ByteBuffer.wrap((byte[])var16_28));
                                                    if (var6_6 == null) break block25;
                                                    break block49;
                                                }
                                                ++var9_9;
                                                break block39;
                                            }
                                            ** while (var4_4 == null)
lbl153:
                                            // 1 sources

                                            ** while (true)
                                        }
                                        var11_15 = new AMFDataObj();
                                        var11_15.put(FileChunk.getChars((int)(115 + -86), (String)"iwrerabh`"), (AMFData)new AMFDataItem(var10_14.getMdiaAtom().getTimescale()));
                                        var11_15.put(Base64.copyValueOf((String)"6>2:*7", (int)(-24 - -18)), (AMFData)new AMFDataItem(var10_14.getMdiaAtom().getDuration()));
                                        var11_15.put(Base64.copyValueOf((String)"-#-#0' -", (int)(-32 - -1)), (AMFData)new AMFDataItem(FileChunk.getChars((int)(23 * 47), (String)"|t|")));
                                        var12_19 = new AMFDataArray();
                                        var13_20 = var10_14.getMdiaAtom().getMinfAtom().getStblAtom().getDataTypes();
                                        var14_24 = var13_20.iterator();
                                        break block40;
                                    }
                                    var17_30 = var6_6.getDataTypes();
                                    var18_29 = this.getAudioCodecConfig(0L);
                                    if (!var17_30.contains(Base64.copyValueOf((String)"{;'k", (int)(35 * 7)))) ** break;
                                    ** while (true)
                                    break block50;
                                }
                                v1 = null;
                                ** while (true)
                            }
                            this.metaData = new ArrayList<E>();
                            var1_1 = new AMFDataMixedArray();
                            ** while ((var3_3 = (var2_2 = this.container.getMoovAtom()).getVideoTrack((int)this.trackIndexVideo)) != null)
lbl176:
                            // 1 sources

                            ** while (true)
                        }
                        ** while (var9_9 >= var8_8)
lbl179:
                        // 1 sources

                        ** while (true)
lbl180:
                        // 1 sources

                        while (true) {
                            var15_25 = new AMFDataObj();
                            var16_28 = var14_24.next();
                            var15_25.put(FileChunk.getChars((int)(-36 - -56), (String)"gt{gt|nblx"), (AMFData)new AMFDataItem((String)var16_28));
                            var12_19.add((AMFData)var15_25);
                            break block40;
                            break;
                        }
                    }
                    this.metaData = null;
                    return;
                }
                if (var17_30.contains(FileChunk.getChars((int)(60 + 121), (String)"xf#y"))) ** GOTO lbl132
            }
            return;
        }
        ** while (!var14_24.hasNext())
lbl195:
        // 1 sources

        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        if (this.duration >= 0L) {
            return this.duration;
        }
        double d = 0.0;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            long l;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            QTParseContext qTParseContext = new QTParseContext();
            qTParseContext.setClientId(this.stream.getClientId());
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            QTMediaContainer qTMediaContainer = QTUtils.parseQTMediaContainer(iRandomAccessReader2, iRandomAccessReader2.length(), qTParseContext);
            QTAtomtrak qTAtomtrak = qTMediaContainer.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = qTMediaContainer.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            double d2 = 0.0;
            if (qTAtomtrak2 != null) {
                long l2 = qTAtomtrak2.getMdiaAtom().getTimescale();
                l = qTAtomtrak2.getMdiaAtom().getDuration();
                d2 = (double)l / (double)l2;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.copyValueOf((String)"0'7=:\u0012\"*8.233d", (int)(93 + 20)) + d2 + ":" + l2 + ":" + l);
            }
            double d3 = 0.0;
            if (qTAtomtrak != null) {
                l = qTAtomtrak.getMdiaAtom().getTimescale();
                long l3 = qTAtomtrak.getMdiaAtom().getDuration();
                d3 = (double)l3 / (double)l;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.copyValueOf((String)"*4::oEwqeqohf3", (int)(31 + 93)) + d3 + ":" + l + ":" + l3);
            }
            d = Math.max(d2, d3);
        }
        catch (Exception exception) {}
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return Math.round(d * 1000.0);
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        if (this.container != null) {
            return new H264StreamPosition(this.cursor.getAudioSample(), this.cursor.getVideoSample(), this.cursor.getDataSample());
        }
        return new H264StreamPosition();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        if (this.container == null) {
            return;
        }
        H264StreamPosition h264StreamPosition = (H264StreamPosition)iMediaReaderStreamPosition;
        long l = h264StreamPosition.getAudioSample();
        long l2 = h264StreamPosition.getVideoSample();
        long l3 = h264StreamPosition.getDataSample();
        if (l >= 0L) {
            this.cursor.setAudioSample(l);
        }
        if (l2 >= 0L) {
            this.cursor.setVideoSample(l2);
        }
        if (l3 < 0L) return;
        this.cursor.setDataSample(l3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.videoFileStream == null) return 0L;
        long l = this.videoFileStream.length();
        return l;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public List getMetadata() {
        return this.metaData;
    }

    public String getPath() {
        return this.basePath;
    }

    public void rewind() {
        if (this.container != null) {
            this.cursor.setAudioSample(0L);
            this.cursor.setVideoSample(0L);
            this.cursor.setDataSample(0L);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlaylistSeekResult seek(long l, int n) {
        if (l > 0L) {
            return this.internalSeek(l, n);
        }
        l = 0L;
        return this.internalSeek(l, n);
    }

    /*
     * Unable to fully structure code
     */
    protected PlaylistSeekResult internalSeek(long var1_1, int var3_2) {
        block27: {
            block23: {
                block26: {
                    block28: {
                        block29: {
                            block25: {
                                block24: {
                                    block22: {
                                        var4_3 = new PlaylistSeekResult(var1_1);
                                        if (this.container != null) ** GOTO lbl58
                                        ** GOTO lbl72
lbl4:
                                        // 2 sources

                                        while (true) {
                                            var13_7 = 0L;
                                            if (var5_4 < 0L) break block22;
                                            break block23;
                                            break;
                                        }
lbl8:
                                        // 1 sources

                                        while (true) {
                                            var7_12 = this.cursor.videoFindKeySample(var9_5, 1);
                                            ** GOTO lbl-1000
                                            break;
                                        }
lbl11:
                                        // 1 sources

                                        while (var5_4 >= 0L) {
                                            ** GOTO lbl45
                                        }
                                        break block27;
lbl14:
                                        // 2 sources

                                        while (this.cursor.containsVideo()) {
                                            break block24;
                                        }
                                        ** GOTO lbl-1000
                                    }
lbl18:
                                    // 2 sources

                                    while (var9_5 >= 0L) {
                                        break block25;
                                    }
                                    ** GOTO lbl11
lbl21:
                                    // 1 sources

                                    while (true) {
                                        var13_7 = this.cursor.videoSampleToTimecode(var7_12);
                                        var15_8 = this.cursor.videoTimecodeToTimeMillis(var13_7);
                                        var17_9 = this.cursor.audioTimeMillisToTimecode(var15_8);
                                        var19_10 = this.cursor.audioTimecodeToSample(var17_9);
                                        var21_11 = this.cursor.dataTimeMillisToTimecode(var15_8);
                                        var23_13 = this.cursor.dataTimecodeToSample(var21_11);
                                        var17_9 = this.cursor.audioSampleToTimecode(var19_10);
                                        if (var17_9 >= var13_7) ** GOTO lbl64
                                        break block26;
                                        break;
                                    }
lbl31:
                                    // 1 sources

                                    while (true) {
                                        v0 = this.cursor;
                                        var11_6 = v0.dataTimecodeToSample(v0.dataTimeMillisToTimecode(var1_1));
                                        ** GOTO lbl14
                                        break;
                                    }
lbl35:
                                    // 2 sources

                                    while (this.cursor.containsData()) {
                                        ** continue;
lbl37:
                                        // 1 sources

                                        ** GOTO lbl31
                                    }
                                    ** GOTO lbl14
                                }
                                v1 = this.cursor;
                                var9_5 = v1.videoTimecodeToSample(v1.videoTimeMillisToTimecode(var1_1));
                                block0 : switch (var3_2) {
                                    case 1: {
                                        ** continue;
                                    }
lbl45:
                                    // 1 sources

                                    var15_8 = this.cursor.audioSampleToTimecode(var5_4);
                                    var13_7 = this.cursor.audioTimecodeToTimeMillis(var15_8);
                                    this.cursor.resetAudioAtEnd();
                                    break block27;
lbl49:
                                    // 1 sources

                                    while (true) {
                                        var15_8 = this.cursor.audioSampleToTimecode(var5_4);
                                        var17_9 = this.cursor.audioTimecodeToTimeMillis(var15_8);
                                        var19_10 = this.cursor.videoSampleToTimecode(var9_5);
                                        var21_11 = this.cursor.videoTimecodeToTimeMillis(var19_10);
                                        var13_7 = Math.min(var17_9, var21_11);
                                        this.cursor.resetAudioAtEnd();
                                        this.cursor.resetVideoAtEnd();
                                        break block27;
                                        break;
                                    }
lbl58:
                                    // 1 sources

                                    var5_4 = -1L;
                                    var7_12 = -1L;
                                    var9_5 = -1L;
                                    var11_6 = -1L;
                                    if (!this.cursor.containsAudio()) ** GOTO lbl35
                                    ** GOTO lbl83
lbl64:
                                    // 3 sources

                                    while (true) {
                                        var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(var19_10, var7_12, var23_13));
                                        if (var5_4 < 0L) break block28;
                                        ** GOTO lbl73
                                        break;
                                    }
lbl68:
                                    // 3 sources

                                    default: lbl-1000:
                                    // 4 sources

                                    {
                                        while (true) {
                                            if (var7_12 < 0L) break block0;
                                            ** continue;
                                            break;
                                        }
                                    }
lbl72:
                                    // 1 sources

                                    return var4_3;
lbl73:
                                    // 1 sources

                                    var25_14 = this.cursor.audioTimecodeToTimeMillis(var17_9);
                                    var4_3.setResultVideoTimecode(Math.min(var25_14, var15_8));
lbl75:
                                    // 2 sources

                                    while (true) {
                                        this.cursor.resetVideoAtEnd();
                                        ** GOTO lbl4
                                        break;
                                    }
lbl78:
                                    // 1 sources

                                    while (true) {
                                        var17_9 = this.cursor.audioSampleToTimecode(++var19_10);
                                        ** GOTO lbl64
                                        break;
                                    }
                                    case 4: {
                                        ** GOTO lbl68
                                    }
lbl83:
                                    // 1 sources

                                    v2 = this.cursor;
                                    var5_4 = v2.audioTimecodeToSample(v2.audioTimeMillisToTimecode(var1_1));
                                    ** GOTO lbl35
                                }
                                var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(-1L, -1L, -1L));
                                ** while (true)
                            }
                            var15_8 = this.cursor.videoSampleToTimecode(var9_5);
                            var13_7 = this.cursor.videoTimecodeToTimeMillis(var15_8);
                            this.cursor.resetVideoAtEnd();
                            break block27;
                            {
                                case 2: {
                                    var7_12 = this.cursor.videoFindKeySample(var9_5, 2);
                                    ** GOTO lbl68
                                }
                            }
lbl96:
                            // 1 sources

                            while (true) {
                                this.cursor.resetDataAtEnd();
                                break block29;
                                break;
                            }
                            {
                                ** case 3:
                            }
lbl100:
                            // 1 sources

                            var7_12 = this.cursor.videoFindKeySample(var9_5, 3);
                            ** while (true)
                        }
lbl103:
                        // 2 sources

                        while (true) {
                            var4_3.setResults((IMediaReaderStreamPosition)new H264StreamPosition(var5_4, var9_5, var11_6), var13_7, 8, 1);
                            var4_3.setResultTimecode(var13_7);
                            var4_3.setSearchTimecode(var1_1);
                            return var4_3;
                        }
                    }
                    var4_3.setResultVideoTimecode(var15_8);
                    ** while (true)
                }
                if (this.cursor.getAudioSampleValid(var19_10 + 1L)) ** break;
                ** while (true)
                ** while (true)
            }
            if (var9_5 < 0L) ** GOTO lbl18
            ** while (true)
        }
        ** while (var11_6 < 0L)
lbl120:
        // 1 sources

        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.chunkWorkBuffer = new byte[n];
    }

    public void startPlayback() {
        this.doSendVideoTrakInfo = true;
        this.doSendAudioTrakInfo = true;
        this.doSendEnhanceSeek = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getSampleDesc(H264Cursor h264Cursor, long l, int n) {
        long l2 = 0L;
        H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
        if (h264ReadAheadPacket == null) return h264Cursor.getSampleDesc();
        return h264ReadAheadPacket.getSampleDesc();
    }

    /*
     * Exception decompiling
     */
    public int writeGeneratedKeyFrame(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 711->734)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte getFirstByte(H264Cursor h264Cursor) {
        byte by = 0;
        int n = h264Cursor.getCurrentType();
        switch (n) {
            case 9: {
                if (!h264Cursor.isKeyFrame()) return 39;
                return 23;
            }
            case 15: 
            case 18: {
                by = 0;
            }
            default: {
                return by;
            }
            case 8: 
        }
        return (byte)this.audioType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int writeEnhancedCmd(int n, int n2, int n3, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, long[] lArray, int n4) {
        int n5 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) {
            return 0;
        }
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), true, n2 != 0 ? 2 : 1, null);
            }
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n3;
            nArray[0] = 9;
            byte[] byArray = new byte[]{(byte)n, (byte)(0xFF & n2)};
            nArray[1] = 2;
            int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
            lArray[2] = lArray[2] + (long)n6;
            lArray[3] = lArray[3] + 1L;
            if (iFasterByteArrayWriteControl == null) return n5;
            iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), false, n2 != 0 ? 2 : 1, null);
            return n5 += n6;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.getChars((int)(117 + 95), (String)"\u001902>9\u000b?:88,\u0017rwvm!+.&&*//\u000f *up") + exception.toString());
            return n5;
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     */
    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        Object object;
        Object object2;
        int n3;
        block9: {
            QTAtommdia qTAtommdia;
            QTAtommoov qTAtommoov;
            byte[] byArray;
            QTAtomstbl qTAtomstbl;
            block8: {
                n3 = 0;
                switch (n) {
                    case 9: {
                        qTAtomstbl = null;
                        byArray = null;
                        qTAtommoov = this.container.getMoovAtom();
                        if (qTAtommoov == null) {
                            break;
                        }
                        break block8;
                    }
                    case 8: {
                        return n3;
                    }
                }
                break block9;
            }
            object2 = qTAtommoov.getVideoTrack(this.trackIndexVideo);
            if (object2 != null && (qTAtommdia = ((QTAtomtrak)object2).getMdiaAtom()) != null && (object = qTAtommdia.getMinfAtom()) != null && (qTAtomstbl = ((QTAtomminf)object).getStblAtom()) != null) {
                AVCCData aVCCData;
                long l = playlistCursor.getVideoSampleDesc();
                if (l < 0L) {
                    l = 0L;
                }
                if ((aVCCData = qTAtomstbl.getAVCCData((int)l)) != null) {
                    byArray = aVCCData.getAvccBytes();
                }
            }
        }
        int n4 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n4);
        object2 = new byte[5];
        int n5 = 0;
        object = new int[5];
        object[1] = false;
        object[2] = n2;
        object[0] = 9;
        object2[0] = 23;
        object2[1] = true;
        object2[2] = false;
        object2[3] = false;
        object2[4] = false;
        object[1] = 5;
        n5 = this.directOutputBuf((int[])object, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, (byte[])object2);
        lArray[2] = lArray[2] + (long)n5;
        lArray[3] = lArray[3] + 1L;
        return n3 += n5;
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getVideoCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        Object var5_4 = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) return byArray;
        AVCCData aVCCData = qTAtomstbl.getAVCCData((int)l);
        if (aVCCData == null) return byArray;
        return aVCCData.getAvccBytes();
    }

    /*
     * Unable to fully structure code
     */
    public int sendVideoTrakData(int var1_1, boolean var2_2, IMediaStream var3_3, OutputStream var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10, byte[] var11_11) {
        block12: {
            block13: {
                block11: {
                    block8: {
                        block10: {
                            block9: {
                                block7: {
                                    block6: {
                                        var12_12 = 0;
                                        var13_13 = this.doSendEnhanceSeek;
                                        this.doSendEnhanceSeek = false;
                                        var14_14 = var6_6.getWriteControl().getChunkSize();
                                        this.checkWorkBuffer(var14_14);
                                        if (var11_11 != null) break block11;
                                        break block12;
lbl8:
                                        // 2 sources

                                        while (true) {
                                            var17_17 = new int[5];
                                            var17_17[1] = 0;
                                            var17_17[2] = var1_1;
                                            var17_17[0] = 9;
                                            var15_15[0] = 23;
                                            var15_15[1] = 2;
                                            var15_15[2] = 0;
                                            var15_15[3] = 0;
                                            var15_15[4] = 0;
                                            var17_17[1] = 5;
                                            var16_16 = this.directOutputBuf(var17_17, var2_2, var3_3.getSrc(), var4_4, var5_5, this.chunkWorkBuffer, var14_14, var15_15);
                                            var12_12 += var16_16;
                                            var9_9[2] = var9_9[2] + (long)var16_16;
                                            var9_9[3] = var9_9[3] + 1L;
                                            if (!var13_13) break block6;
                                            break block7;
lbl25:
                                            // 1 sources

                                            while (true) {
                                                var15_15[0] = 23;
                                                var15_15[1] = 0;
                                                var15_15[2] = 0;
                                                var15_15[3] = 0;
                                                var15_15[4] = 0;
                                                System.arraycopy(var11_11, 0, var15_15, 5, var11_11.length);
                                                var17_17[1] = var11_11.length + 5;
                                                var17_17[2] = 0;
                                                var2_2 = false;
                                                var18_18 = 0;
                                                break block8;
                                                break;
                                            }
lbl37:
                                            // 2 sources

                                            return var12_12;
                                        }
lbl39:
                                        // 2 sources

                                        while (true) {
                                            var15_15 = new byte[v0 + 5];
                                            var16_16 = 0;
                                            if (!var13_13) ** GOTO lbl8
                                            break block9;
                                            break;
                                        }
                                    }
lbl45:
                                    // 2 sources

                                    while (true) {
                                        if (var11_11 == null) ** GOTO lbl37
                                        ** continue;
                                        break;
                                    }
lbl48:
                                    // 2 sources

                                    while (true) {
                                        if (var18_18 < v1) ** break;
                                        ** continue;
                                        break block10;
                                        break;
                                    }
                                }
                                var12_12 += this.writeEnhancedCmd(82, 1, var1_1, var2_2, var3_3, var4_4, var5_5, var9_9, var14_14);
                                ** while (true)
                            }
                            var12_12 += this.writeEnhancedCmd(82, 0, var1_1, var2_2, var3_3, var4_4, var5_5, var9_9, var14_14);
                            ** while (true)
                        }
                        var16_16 = this.directOutputBuf(var17_17, var2_2, var3_3.getSrc(), var4_4, var5_5, this.chunkWorkBuffer, var14_14, var15_15);
                        var12_12 += var16_16;
                        var9_9[2] = var9_9[2] + (long)var16_16;
                        var9_9[3] = var9_9[3] + 1L;
                        ++var18_18;
                    }
                    if (var13_13) break block13;
                    v1 = 1;
                    ** GOTO lbl48
                }
                v0 = var11_11.length;
                ** GOTO lbl39
            }
            v1 = 2;
            ** while (true)
        }
        v0 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getAudioCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        ESDSData eSDSData = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(this.trackIndexAudio);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) {
            return byArray;
        }
        eSDSData = qTAtomstbl.getESDSData((int)l);
        if (eSDSData != null) return eSDSData.specData;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        if (byArray == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = 0;
        nArray[2] = n;
        nArray[0] = 8;
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = -81;
        byArray2[1] = 0;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        nArray[1] = byArray.length + 2;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
        n2 += n4;
        lArray[0] = lArray[0] + (long)n4;
        lArray[1] = lArray[1] + 1L;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (fastPlaySettings == null) return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
        if (fastPlaySettings.getDirection() >= 0) return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        block31: {
            var11_11 = 0;
            var12_12 = false;
            var13_13 = false;
            var14_14 = false;
            var15_15 = 0;
            var16_16 = var7_7.getMaxTC();
            this.videoFileStream.setDirecton(1);
            var18_17 = var6_6.getWriteControl().getChunkSize();
            this.checkWorkBuffer(var18_17);
            var19_18 = 0L;
            var21_19 = 0L;
            ** GOTO lbl165
lbl-1000:
            // 1 sources

            {
                block32: {
                    block33: {
                        while (var27_23 >= var16_16) {
                            // MONITOREXIT : var23_20
                            break block31;
                        }
                        break block33;
                        while (true) {
                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                            if (this.chunkHeaderValues[2] < 0) ** GOTO lbl89
                            var6_6.setSendAbsBroadcastTC(false);
                            ** GOTO lbl76
                            break;
                        }
                        while (true) {
                            this.chunkHeaderValues[2] = 0;
                            ** GOTO lbl80
                            break;
                        }
                        while (true) {
                            v0 = this;
                            var34_34 = v0.sendAudioTrakData(v0.chunkHeaderValues[2], var31_27, var1_1, var2_2, var3_3, var6_6, var7_7, var8_8, var9_9, var10_10, var32_31);
                            if (var34_34 <= 0) ** GOTO lbl135
                            var31_27 = false;
                            this.chunkHeaderValues[2] = 0;
                            ** GOTO lbl135
                            break;
                        }
                        while (true) {
                            if (var10_10) {
                                this.chunkHeaderValues[2] = 0;
                            }
                            if (var21_19 != var6_6.getVideoSampleDesc()) {
                                var31_28 = this.getVideoCodecConfig(var21_19);
                                var32_30 = var6_6.compareAndSetVideoCodecConfig(var31_28);
                                if (var32_30 == 0) {
                                    v1 = this;
                                    var33_33 = v1.sendVideoTrakData(v1.chunkHeaderValues[2], var29_24, var1_1, var2_2, var4_4, var6_6, var7_7, var8_8, var9_9, var10_10, var31_28);
                                    if (var33_33 > 0) {
                                        var29_24 = false;
                                        this.chunkHeaderValues[2] = 0;
                                    }
                                    var11_11 += var33_33;
                                }
                                var6_6.setVideoSampleDesc(var21_19);
                            }
                            var6_6.setLastVideoTC(var27_23);
                            var6_6.incVideoPacketCount();
                            var25_22 = var27_23;
                            var31_27 = var1_1.isReceiveVideo() == false && this.videoCodec == 7;
                            v2 = this;
                            var32_30 = v2.directOutput(v2.chunkHeaderValues, var19_18, var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, var31_27);
                            var11_11 += var32_30;
                            var24_21 = true;
                            var8_8.incVideoPackets();
                            if (this.videoSampleCount > 0L && var19_18 == this.videoSampleCount - 1L) {
                                v3 = this;
                                var33_33 = v3.directOutput(v3.chunkHeaderValues, var19_18, var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, true);
                                var11_11 += var33_33;
                                var8_8.incVideoPackets();
                            }
                            var12_12 = true;
                            var13_13 = true;
                            var9_9[2] = var9_9[2] + (long)var32_30;
                            var9_9[3] = var9_9[3] + 1L;
                            ** GOTO lbl106
                            break;
                        }
lbl65:
                        // 1 sources

                        while (true) {
                            var29_24 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                            if (!var29_24) ** GOTO lbl89
                            var6_6.setWaitForKeyFrame(false);
                            ** GOTO lbl113
                            break;
                        }
                        while (true) {
                            block41: {
                                block42: {
                                    block39: {
                                        block43: {
                                            block35: {
                                                block37: {
                                                    block40: {
                                                        block38: {
                                                            block36: {
                                                                block34: {
                                                                    switch (this.chunkHeaderValues[0]) {
                                                                        case 15: 
                                                                        case 18: {
                                                                            var32_30 = var6_6.isSendAbsBroadcastTC();
                                                                            if (var6_6.isSendAbsBroadcastTC()) ** continue;
                                                                            this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastBroadcastTC() & 0xFFFFFFFFL);
lbl76:
                                                                            // 2 sources

                                                                            var6_6.setLastBroadcastTC(var27_23);
                                                                            var6_6.incDataPacketCount();
                                                                            var25_22 = var27_23;
                                                                            if (var10_10) ** continue;
lbl80:
                                                                            // 2 sources

                                                                            v4 = this;
                                                                            var33_33 = v4.directOutput(v4.chunkHeaderValues, var19_18, (boolean)var32_30, var1_1.getSrc(), var2_2, var5_5, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                                                            var11_11 += var33_33;
                                                                            var9_9[4] = var9_9[4] + (long)var33_33;
                                                                            var9_9[5] = var9_9[5] + 1L;
                                                                            var24_21 = true;
                                                                            ** break;
                                                                        }
                                                                        case 8: {
                                                                            if (var1_1.isReceiveAudio() && !var7_7.isSkipAudio() && !var7_7.isAudioFilter()) ** GOTO lbl91
                                                                        }
lbl89:
                                                                        // 11 sources

                                                                        default: {
                                                                            break block34;
                                                                        }
lbl91:
                                                                        // 1 sources

                                                                        var31_27 = var6_6.isSendAbsAudioTC();
                                                                        if (!var6_6.isSendAbsAudioTC()) ** GOTO lbl96
                                                                        this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                                        if (this.chunkHeaderValues[2] >= 0) ** GOTO lbl98
                                                                        ** GOTO lbl89
lbl96:
                                                                        // 1 sources

                                                                        this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastAudioTC() & 0xFFFFFFFFL);
                                                                        ** GOTO lbl99
lbl98:
                                                                        // 1 sources

                                                                        var6_6.setSendAbsAudioTC(false);
lbl99:
                                                                        // 2 sources

                                                                        if (this.chunkHeaderValues[2] < 0) ** GOTO lbl89
                                                                        break block35;
                                                                        case 9: 
                                                                    }
                                                                    if (!var1_1.isReceiveVideo() && this.videoCodec != 7) break block34;
                                                                    if (var6_6.isWaitForKeyFrame()) {
                                                                        ** continue;
                                                                    }
                                                                    break block36;
                                                                }
                                                                var8_8.setLastTC(var27_23);
                                                                ++var15_15;
                                                                this.cursor.moveNextSample();
                                                                if (var16_16 != 0L) ** GOTO lbl-1000
                                                                break block37;
                                                            }
                                                            var29_24 = var6_6.isSendAbsVideoTC();
                                                            if (!var6_6.isSendAbsVideoTC()) break block38;
                                                            var30_25 = var6_6.getForceVideoTC();
                                                            if (var30_25 < 0L) break block39;
                                                            break block40;
                                                        }
                                                        this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastVideoTC() & 0xFFFFFFFFL);
                                                        break block41;
                                                    }
                                                    this.chunkHeaderValues[2] = (int)(var30_25 + var6_6.getStartTCOffset());
                                                    var27_23 = var30_25;
                                                    break block42;
                                                }
                                                if (!var13_13 && var15_15 <= 20) break;
                                                // MONITOREXIT : var23_20
                                                break block31;
                                            }
                                            if (var10_10) {
                                                this.chunkHeaderValues[2] = 0;
                                            }
                                            if (var21_19 == var6_6.getAudioSampleDesc()) break block43;
                                            if ((var33_33 = (int)var6_6.compareAndSetAudioCodecConfig(var32_31 = this.getAudioCodecConfig(var21_19))) == 0) ** continue;
lbl135:
                                            // 3 sources

                                            var6_6.setAudioSampleDesc(var21_19);
                                        }
                                        var6_6.setLastAudioTC(var27_23);
                                        var6_6.incAudioPacketCount();
                                        var25_22 = var27_23;
                                        v5 = this;
                                        var32_30 = v5.directOutput(v5.chunkHeaderValues, var19_18, var31_27, var1_1.getSrc(), var2_2, var3_3, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                        var11_11 += var32_30;
                                        var24_21 = true;
                                        var8_8.incAudioPackets();
                                        var12_12 = true;
                                        var14_14 = true;
                                        var9_9[0] = var9_9[0] + (long)var32_30;
                                        var9_9[1] = var9_9[1] + 1L;
                                        ** GOTO lbl89
                                    }
                                    this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                }
                                if (this.chunkHeaderValues[2] < 0) ** GOTO lbl89
                                var6_6.setForceVideoTC(-1L);
                                var6_6.setSendAbsVideoTC(false);
                            }
                            var30_26 = var7_7.testVideoFrame(this.chunkHeaderValues[3]);
                            if (this.chunkHeaderValues[2] >= 0 && var30_26) ** continue;
                            if (var30_26) ** GOTO lbl89
                            var9_9[6] = var9_9[6] + (long)this.chunkHeaderValues[1];
                            var9_9[7] = var9_9[7] + 1L;
                            ** GOTO lbl89
                            break;
                        }
                    }
                    // MONITOREXIT : var23_20
lbl165:
                    // 2 sources

                    var23_20 = this.lock;
                    // MONITORENTER : var23_20
                    if (var6_6.isBreakLoop()) {
                        // MONITOREXIT : var23_20
                        break block31;
                    }
                    if (!this.cursor.isAtEnd()) break block32;
                    var8_8.setHitEnd(true);
                    // MONITOREXIT : var23_20
                    break block31;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.getCurrentType();
                v6 = this;
                this.chunkHeaderValues[3] = v6.getFirstByte(v6.cursor);
                var19_18 = this.cursor.getSample();
                v7 = this;
                var21_19 = v7.getSampleDesc(v7.cursor, var19_18, this.chunkHeaderValues[0]);
                var24_21 = false;
                var25_22 = 0L;
                var27_23 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (var16_16 <= 0L || var27_23 < var16_16) ** continue;
                // MONITOREXIT : var23_20
            }
        }
        var8_8.setTotalSize(var11_11);
        return var11_11;
        catch (Throwable var35_35) {
            // MONITOREXIT : var23_20
            throw var35_35;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePacketsFastPlay(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [34[UNCONDITIONALDOLOOP], 33[UNCONDITIONALDOLOOP]], but top level block is 4[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutput(int[] var1_1, long var2_2, boolean var4_3, int var5_4, OutputStream var6_5, AMFObj var7_6, byte[] var8_7, int var9_8, H264Cursor var10_9, boolean var11_10) {
        var12_11 = 0;
        try {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                var13_12 = (long)var1_1[2] & 0xFFFFFFFFL;
                                var15_14 = var1_1[0];
                                var16_15 = 0;
                                var17_16 = null;
                                var18_17 = 0;
                                var19_18 = 0;
                                var20_19 = this.getReadAheadPacket(var15_14, var2_2);
                                if (var20_19 != null) {
                                    var17_16 = var20_19.getBuffer();
                                    var18_17 = var20_19.getBufferOffet();
                                    var19_18 = (int)var20_19.getSize();
                                    if (var19_18 > 0 && (var15_14 == 18 || var15_14 == 15) && var17_16[var18_17] == 0) {
                                        var15_14 = 15;
                                    }
                                    var16_15 = var19_18;
                                }
                                if (var11_10) {
                                    var16_15 = 0;
                                }
                                var1_1[1] = var16_15;
                                var20_20 = 0;
                                if (var15_14 == 8) {
                                    var20_20 = this.audioExtraSize;
                                } else if (var15_14 == 9) {
                                    var20_20 = 5;
                                }
                                var16_15 += var20_20;
                                var21_21 = var7_6.getId();
                                var22_22 = var7_6.isNew();
                                var23_23 = var22_22 | var4_3;
                                var7_6.setNew(false);
                                var24_24 = 1;
                                var8_7[0] = (byte)(255 & var21_21);
                                if (var23_23 || var7_6.getSrc() != var5_4) {
                                    var8_7[8] = (byte)(255 & var5_4);
                                    var8_7[9] = (byte)(255 & var5_4 >> 8);
                                    var8_7[10] = (byte)(255 & var5_4 >> 16);
                                    var8_7[11] = (byte)(255 & var5_4 >> 24);
                                    var7_6.setSrc(var5_4);
                                    var24_24 += 4;
                                    var23_23 = true;
                                }
                                if (var23_23 || var7_6.getSize() != var16_15 || var7_6.getType() != var15_14) {
                                    var8_7[4] = (byte)(255 & var16_15 >> 16);
                                    var8_7[5] = (byte)(255 & var16_15 >> 8);
                                    var8_7[6] = (byte)(255 & var16_15);
                                    var8_7[7] = (byte)var15_14;
                                    var7_6.setSize(var16_15);
                                    var7_6.setType(var15_14);
                                    var24_24 += 4;
                                    var23_23 = true;
                                }
                                var25_25 = false;
                                if (!var23_23) {
                                    // empty if block
                                }
                                if (var13_12 >= 0xFFFFFFL) {
                                    var8_7[1] = -1;
                                    var8_7[2] = -1;
                                    var8_7[3] = -1;
                                    var25_25 = true;
                                } else {
                                    var8_7[1] = (byte)(255L & var13_12 >> 16);
                                    var8_7[2] = (byte)(255L & var13_12 >> 8);
                                    var8_7[3] = (byte)(255L & var13_12);
                                }
                                var7_6.setTimecode(var13_12);
                                var24_24 += 3;
                                var23_23 = true;
                                if (var21_21 < 64) break block39;
                                var26_26 = var21_21 - 64;
                                if (var26_26 <= 255) break block40;
                                ** GOTO lbl82
                            }
                            switch (var24_24) {
                                case 8: {
                                    var8_7[0] = (byte)(var8_7[0] | 64);
                                    break;
                                }
                                case 1: {
                                    var8_7[0] = (byte)(var8_7[0] | 192);
                                    break;
                                }
                                case 4: {
                                    var8_7[0] = (byte)(var8_7[0] | 128);
                                    break;
                                }
                                case 12: {
                                    break;
                                }
lbl82:
                                // 1 sources

                                v0 = 3;
                                break block41;
                            }
                            var6_5.write(var8_7, 0, var24_24);
                            var12_11 += var24_24;
                            break block42;
                        }
                        v0 = 2;
                    }
                    var27_27 = v0;
                    var28_29 = new byte[var27_27];
                    switch (var24_24) {
                        case 1: {
                            var28_29[0] = (byte)(192 + (var27_27 - 2));
                            break;
                        }
                        case 4: {
                            var28_29[0] = (byte)(128 + (var27_27 - 2));
                            break;
                        }
                        case 12: {
                            var28_29[0] = (byte)(0 + (var27_27 - 2));
                            break;
                        }
                        case 8: {
                            var28_29[0] = (byte)(64 + (var27_27 - 2));
                            break;
                        }
                    }
                    var28_29[1] = (byte)(255 & var26_26);
                    if (var27_27 == 3) {
                        var28_29[2] = (byte)(255 & var26_26 >> 8);
                    }
                    var6_5.write(var28_29, 0, var27_27);
                    var6_5.write(var8_7, 1, var24_24 - 1);
                    var12_11 += var24_24 + 1;
                }
                if (!var25_25) break block43;
                var8_7[0] = (byte)(255L & var13_12 >> 24);
                var8_7[1] = (byte)(255L & var13_12 >> 16);
                var8_7[2] = (byte)(255L & var13_12 >> 8);
                var8_7[3] = (byte)(255L & var13_12);
                var6_5.write(var8_7, 0, 4);
                var12_11 = 4;
                break block43;
lbl120:
                // 1 sources

                while (true) {
                    var32_33 = var21_21 - 64;
                    var33_37 = var32_33 <= 255 ? 2 : 3;
                    var8_7[0] = (byte)(192 + (var33_37 - 2));
                    var8_7[1] = (byte)(255 & var32_33);
                    if (var33_37 == 3) {
                        var8_7[2] = (byte)(255 & var32_33 >> 8);
                    }
                    var6_5.write(var8_7, 0, var33_37);
                    var12_11 += var33_37;
lbl129:
                    // 2 sources

                    while (true) {
                        if (!var25_25) ** GOTO lbl-1000
                        var8_7[0] = (byte)(255L & var13_12 >> 24);
                        var8_7[1] = (byte)(255L & var13_12 >> 16);
                        var8_7[2] = (byte)(255L & var13_12 >> 8);
                        var8_7[3] = (byte)(255L & var13_12);
                        var6_5.write(var8_7, 0, 4);
                        var12_11 = 4;
                        ** GOTO lbl-1000
                        break;
                    }
                    break;
                }
            }
            var26_26 = 1;
            if (var16_15 <= 0) return var12_11;
            var27_27 = var16_15;
            var28_28 = 0;
            var29_30 = 0;
            var30_31 = null;
            var31_32 = 0;
            var30_31 = var17_16;
            var31_32 = var18_17;
            do {
                if (var28_28 > 0) {
                    if (var21_21 >= 64) {
                        ** continue;
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if ((var29_30 = var9_8) > var27_27 - var28_28) {
                        var29_30 = var27_27 - var28_28;
                    }
                    if (var20_20 > 0 && var26_26 != 0) {
                        var8_7[0] = this.getFirstByte(var10_9);
                        var8_7[1] = 1;
                        if (var20_20 >= 5 && var10_9.getCurrentType() == 9) {
                            var32_35 = var10_9.getCTTSMillis();
                            var8_7[2] = (byte)(var32_35 >> 16 & 255);
                            var8_7[3] = (byte)(var32_35 >> 8 & 255);
                            var8_7[4] = (byte)(var32_35 & 255);
                        }
                        var6_5.write(var8_7, 0, var20_20);
                    }
                    if (var30_31 != null) {
                        var32_34 = var26_26 == 0 ? var29_30 : var29_30 - var20_20;
                        var6_5.write(var30_31, var31_32, var32_34);
                        var31_32 += var32_34;
                    }
                    var26_26 = 0;
                }
                var8_7[0] = (byte)(255 & var21_21 | 192);
                var6_5.write(var8_7, 0, 1);
                ++var12_11;
                ** continue;
                catch (Exception var32_36) {
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.getChars((int)(1384 / 203), (String)"Kbl`kYiljjbY % ;r~j|yoShjouu8#Twiedlg+~hoky\u007fu3}{fbl9|rpx$?") + var32_36.toString());
                    var32_36.printStackTrace();
                }
                var12_11 += var29_30;
            } while ((var28_28 += var29_30) != var27_27);
            return var12_11;
        }
        catch (Exception var13_13) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.getChars((int)(89 + 114), (String)"\u0006))'.\u00024371'\u001eenmt?5/;<4\u000e77402}h") + var13_13.toString());
            var13_13.printStackTrace();
            return var12_11;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutputBuf(int[] var1_1, boolean var2_2, int var3_3, OutputStream var4_4, AMFObj var5_5, byte[] var6_6, int var7_7, byte[] var8_8) {
        var9_9 = 0;
        try {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            var10_11 = (long)var1_1[2] & 0xFFFFFFFFL;
                            var12_12 = var1_1[1];
                            var13_13 = var1_1[0];
                            var14_14 = var5_5.getId();
                            var15_15 = var5_5.isNew();
                            var16_16 = var15_15 | var2_2;
                            var5_5.setNew(false);
                            var17_17 = 1;
                            var6_6[0] = (byte)(255 & var14_14);
                            if (var16_16 || var5_5.getSrc() != var3_3) {
                                var6_6[8] = (byte)(255 & var3_3);
                                var6_6[9] = (byte)(255 & var3_3 >> 8);
                                var6_6[10] = (byte)(255 & var3_3 >> 16);
                                var6_6[11] = (byte)(255 & var3_3 >> 24);
                                var5_5.setSrc(var3_3);
                                var17_17 += 4;
                                var16_16 = true;
                            }
                            if (var16_16 || var5_5.getSize() != var12_12 || var5_5.getType() != var13_13) {
                                var6_6[4] = (byte)(255 & var12_12 >> 16);
                                var6_6[5] = (byte)(255 & var12_12 >> 8);
                                var6_6[6] = (byte)(255 & var12_12);
                                var6_6[7] = (byte)var13_13;
                                var5_5.setSize(var12_12);
                                var5_5.setType(var13_13);
                                var17_17 += 4;
                                var16_16 = true;
                            }
                            var18_18 = false;
                            if (var16_16 || var5_5.getTimecode() != var10_11) {
                                if (var10_11 >= 0xFFFFFFL) {
                                    var6_6[1] = -1;
                                    var6_6[2] = -1;
                                    var6_6[3] = -1;
                                    var18_18 = true;
                                } else {
                                    var6_6[1] = (byte)(255L & var10_11 >> 16);
                                    var6_6[2] = (byte)(255L & var10_11 >> 8);
                                    var6_6[3] = (byte)(255L & var10_11);
                                }
                                var5_5.setTimecode(var10_11);
                                var17_17 += 3;
                                var16_16 = true;
                            }
                            if (var14_14 < 64) break block29;
                            var19_19 = var14_14 - 64;
                            if (var19_19 <= 255) break block30;
                            ** GOTO lbl60
                        }
                        switch (var17_17) {
                            case 8: {
                                var6_6[0] = (byte)(var6_6[0] | 64);
                                break;
                            }
                            case 12: {
                                break;
                            }
                            case 4: {
                                var6_6[0] = (byte)(var6_6[0] | 128);
                                break;
                            }
                            case 1: {
                                var6_6[0] = (byte)(var6_6[0] | 192);
                                break;
                            }
lbl60:
                            // 1 sources

                            v0 = 3;
                            break block31;
                        }
                        var4_4.write(var6_6, 0, var17_17);
                        var9_9 += var17_17;
                        break block32;
                    }
                    v0 = 2;
                }
                var20_20 = v0;
                var21_21 = new byte[var20_20];
                switch (var17_17) {
                    case 1: {
                        var21_21[0] = (byte)(192 + (var20_20 - 2));
                        break;
                    }
                    case 8: {
                        var21_21[0] = (byte)(64 + (var20_20 - 2));
                        break;
                    }
                    case 12: {
                        var21_21[0] = (byte)(0 + (var20_20 - 2));
                        break;
                    }
                    case 4: {
                        var21_21[0] = (byte)(128 + (var20_20 - 2));
                        break;
                    }
                }
                var21_21[1] = (byte)(255 & var19_19);
                if (var20_20 == 3) {
                    var21_21[2] = (byte)(255 & var19_19 >> 8);
                }
                var4_4.write(var21_21, 0, var20_20);
                var4_4.write(var6_6, 1, var17_17 - 1);
                var9_9 += var17_17 + 1;
            }
            if (var18_18) {
                var6_6[0] = (byte)(255L & var10_11 >> 24);
                var6_6[1] = (byte)(255L & var10_11 >> 16);
                var6_6[2] = (byte)(255L & var10_11 >> 8);
                var6_6[3] = (byte)(255L & var10_11);
                var4_4.write(var6_6, 0, 4);
                var9_9 = 4;
            }
            if (var12_12 <= 0) return var9_9;
            var19_19 = var12_12;
            var20_20 = 0;
            var21_22 = 0;
            ** GOTO lbl-1000
        }
        catch (Exception var10_10) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.copyValueOf((String)"Kbl`kYiljjbY % ;r~j|yoShjouu@vb?&", (int)(-10 - -16)) + var10_10.toString());
            var10_10.printStackTrace();
            return var9_9;
        }
        while (true) {
            v1 = 2;
            ** if (true) goto lbl120
            break;
        }
lbl-1000:
        // 1 sources

        {
            while (true) lbl-1000:
            // 4 sources

            {
                if ((var21_22 = var7_7) > var19_19 - var20_20) {
                    var21_22 = var19_19 - var20_20;
                }
                try {
                    var4_4.write(var8_8, var20_20, var21_22);
                }
                catch (Exception var22_24) {
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.copyValueOf((String)"Vyyw~\u0012$#'!7\u000eu~}d/%?+,$\u001e''$ \"\u0015-?`{\f/1=,$/c6 '#!'-k%#>:$q4:80lw", (int)(17 * 11)) + var22_24.toString());
                }
                var9_9 += var21_22;
                if ((var20_20 += var21_22) == var19_19) {
                    return var9_9;
                } else {
                    ** GOTO lbl-1000
                }
                break;
            }
        }
lbl120:
        // 1 sources

        ** GOTO lbl132
lbl-1000:
        // 3 sources

        {
            block35: {
                block34: {
                    block33: {
                        if (var20_20 <= 0) continue;
                        if (var14_14 < 64) break block33;
                        if ((var22_23 = var14_14 - 64) <= 255) ** continue;
                        break block34;
                    }
                    var6_6[0] = (byte)(255 & var14_14 | 192);
                    var4_4.write(var6_6, 0, 1);
                    ++var9_9;
                    break block35;
                }
                v1 = 3;
lbl132:
                // 2 sources

                var23_25 = v1;
                var6_6[0] = (byte)(192 + (var23_25 - 2));
                var6_6[1] = (byte)(255 & var22_23);
                if (var23_25 == 3) {
                    var6_6[2] = (byte)(255 & var22_23 >> 8);
                }
                var4_4.write(var6_6, 0, var23_25);
                var9_9 += var23_25;
            }
            if (!var18_18) continue;
            var6_6[0] = (byte)(255L & var10_11 >> 24);
            var6_6[1] = (byte)(255L & var10_11 >> 16);
            var6_6[2] = (byte)(255L & var10_11 >> 8);
            var6_6[3] = (byte)(255L & var10_11);
            var4_4.write(var6_6, 0, 4);
            var9_9 = 4;
            ** while (true)
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void debugPackets(int n) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
        QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
        H264Cursor h264Cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 1);
        int n2 = 0;
        while (true) {
            int n3 = (int)h264Cursor.getSize();
            long l = h264Cursor.getTimeMillis();
            if (n3 <= 0 || n3 >= n) {
                wMSLogger.info(FileChunk.getChars((int)(57 * 43), (String)"cuv}rl#:") + n3 + ":" + n);
            }
            h264Cursor.moveNextSample();
            if (h264Cursor.isAtEnd()) {
                wMSLogger.info(Base64.copyValueOf((String)"# !\u007flc\u007f|tq|a{b-8", (int)(-37 - -46)) + n2);
                return;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected H264ReadAheadRequest tiggerNextReadAhead(H264ReadAheadRequest var1_1) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        block13: {
                            block11: {
                                block12: {
                                    block10: {
                                        var2_2 = null;
                                        var3_3 = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                        var4_4 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                        var5_5 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                        if (this.cursorReadAhead != null) break block15;
                                        break block16;
lbl7:
                                        // 2 sources

                                        while (this.cursorReadAhead.isAtEnd()) {
                                            break block10;
                                        }
                                        break block17;
lbl10:
                                        // 1 sources

                                        while (true) {
                                            var2_2 = this.readAheadCache.remove(0);
                                            var2_2.clear();
                                            break block11;
                                            while (true) {
                                                if (!this.cursorReadAhead.isAtEnd()) break block12;
                                                break block13;
                                                break;
                                            }
lbl17:
                                            // 1 sources

                                            while (true) {
                                                var2_2.setCursorPosition(this.cursorReadAhead.getCurrentPosition());
                                                if (this.stream == null) break block10;
                                                break block14;
                                                break;
                                            }
                                            break;
                                        }
lbl21:
                                        // 1 sources

                                        while (true) {
                                            this.cursorReadAhead.setCurrentPosition(var1_1.getCursorPosition());
                                            ** GOTO lbl7
                                            break;
                                        }
                                    }
lbl25:
                                    // 3 sources

                                    return var2_2;
                                }
lbl28:
                                // 2 sources

                                while (true) {
                                    var8_7 = this.cursorReadAhead.getSize();
                                    var10_8 = this.cursorReadAhead.getCurrentType();
                                    var11_9 = this.cursorReadAhead.getSample();
                                    var13_10 = this.cursorReadAhead.getSampleDesc();
                                    var2_2.addPacket(var10_8, var11_9, this.cursorReadAhead.getFileLoc(), var8_7, var13_10);
                                    this.cursorReadAhead.moveNextSample();
                                    if ((var6_6 += var8_7) <= (long)this.readAheadSize) ** continue;
                                    break block13;
                                    break;
                                }
lbl38:
                                // 1 sources

                                while (true) {
                                    this.cursorReadAhead.setCurrentPosition(this.cursor.getCurrentPosition());
                                    ** GOTO lbl7
                                    break;
                                }
                            }
lbl42:
                            // 2 sources

                            while (true) {
                                var2_2.setFileStream(this.videoFileStream);
                                var2_2.setReadAheadTrigger(this.readAheadTrigger);
                                var6_6 = 0L;
                                ** continue;
                                break;
                            }
                        }
                        if (var2_2 == null) ** GOTO lbl25
                        ** while (true)
                    }
                    this.stream.getStreams().getVHost().getIOScheduler().executeRaw((Runnable)var2_2);
                    ** while (true)
lbl53:
                    // 1 sources

                    while (true) {
                        var2_2 = new H264ReadAheadRequest();
                        var2_2.setDataTrack(var5_5);
                        var2_2.setDataDataToAMFHandler(this.dataDataToAMFHandler);
                        ** continue;
                        break;
                    }
                }
                this.cursorReadAhead = new H264Cursor(var3_3, var4_4, var5_5);
                break block15;
            }
            ** while (this.readAheadCache.size() <= 0)
lbl63:
            // 1 sources

            ** while (true)
        }
        ** while (var1_1 == null)
lbl66:
        // 1 sources

        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        block9: {
            block10: {
                block8: {
                    h264ReadAheadPacket = null;
                    if (this.currReadAhead == null) break block8;
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket != null) break block9;
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
                this.currReadAhead = this.nextReadAhead;
                this.nextReadAhead = null;
                if (this.currReadAhead == null) break block10;
                this.currReadAhead.waitForComplete();
                h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                if (h264ReadAheadPacket != null) break block9;
                if (this.cacheReadAhead) {
                    this.readAheadCache.add(this.currReadAhead);
                }
                this.currReadAhead = null;
            }
            this.currReadAhead = this.tiggerNextReadAhead(null);
            if (this.currReadAhead != null) {
                this.currReadAhead.waitForComplete();
                h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                if (h264ReadAheadPacket == null) {
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
            }
        }
        if (h264ReadAheadPacket == null) return h264ReadAheadPacket;
        if (this.nextReadAhead != null) return h264ReadAheadPacket;
        if (!h264ReadAheadPacket.isAfterTrigger) return h264ReadAheadPacket;
        MediaReaderH264 mediaReaderH264 = this;
        mediaReaderH264.nextReadAhead = mediaReaderH264.tiggerNextReadAhead(mediaReaderH264.currReadAhead);
        return h264ReadAheadPacket;
    }

    /*
     * Exception decompiling
     */
    public int writePackets(List<AMFPacket> var1_1, PlaylistCursor var2_2, PlaylistWriteControl var3_3, PlaylistReaderWriteResults var4_4, long[] var5_5, FastPlaySettings var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 191->1020)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket a(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = 23;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        aMFPacket.addDataEx(byArray, 0, 5, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket b(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = -81;
        byArray2[1] = 0;
        aMFPacket.addDataEx(byArray, 0, 2, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket getFramePacket(int[] nArray, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        int n;
        int n2;
        AMFPacket aMFPacket = null;
        try {
            n2 = nArray[0];
            n = 0;
            h264ReadAheadPacket = this.getReadAheadPacket(n2, l);
            if (h264ReadAheadPacket != null) {
                n = (int)h264ReadAheadPacket.getSize();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.copyValueOf((String)"HccahXnmik}X#$':rsc^k{vyM\u007f|kdv9$", (int)(35 * 55)) + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
        if (n <= 0) return aMFPacket;
        int n3 = 5;
        if (n2 != 8) {
            if (n2 == 18 || n2 == 15) {
                n3 = 0;
            }
        } else {
            n3 = this.audioExtraSize;
        }
        aMFPacket = new AMFPacket(nArray[0], 0, n + n3);
        byte[] byArray = aMFPacket.getData();
        byArray[0] = (byte)this.chunkHeaderValues[3];
        if (n3 > 1) {
            byArray[1] = 1;
        }
        if (n3 == 5) {
            int n4 = this.cursor.getCTTSMillis();
            byArray[2] = (byte)(n4 >> 16 & 0xFF);
            byArray[3] = (byte)(n4 >> 8 & 0xFF);
            byArray[4] = (byte)(n4 & 0xFF);
        }
        byte[] byArray2 = null;
        int n5 = 0;
        if (h264ReadAheadPacket != null) {
            byArray2 = h264ReadAheadPacket.getBuffer();
            n5 = h264ReadAheadPacket.boffset;
        }
        aMFPacket.addDataEx(byArray2, n5, n3, n);
        return aMFPacket;
    }

    public int getTrackIndexVideo() {
        return this.trackIndexVideo;
    }

    public void setTrackIndexVideo(int n) {
        this.trackIndexVideo = n;
    }

    public int getTrackIndexAudio() {
        return this.trackIndexAudio;
    }

    public void setTrackIndexAudio(int n) {
        this.trackIndexAudio = n;
    }

    public int getTrackIndexData() {
        return this.trackIndexData;
    }

    public void setTrackIndexData(int n) {
        this.trackIndexData = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountVideo() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getVideoTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountAudio() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getAudioTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountData() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getDataTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageAudio(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getAudioTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageData(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getDataTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackDataTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackAudioTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackDataAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackAudioAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackVideoAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoTrackId(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoWidth(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackWidth();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoHeight(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackHeight();
        return l;
    }

    public String getTrackDataCharSet() {
        return this.trackDataCharSet;
    }

    public void setTrackDataCharSet(String string) {
        this.trackDataCharSet = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] dataDataToAMF(QTAtomtrak qTAtomtrak, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = null;
        AMFDataList aMFDataList = null;
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl != null && (n3 = qTAtomstbl.getDataTrackType()) == 2) {
            aMFDataList = new AMFDataList();
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataList.add((AMFData)new AMFDataItem(Base64.copyValueOf((String)"nlWa}rCi}k", (int)(21 + 108))));
            aMFDataList.add((AMFData)aMFDataObj);
            String string = qTAtomtrak.getLanguageStr();
            aMFDataObj.put(FileChunk.getChars((int)(929 / 145), (String)"rbp}"), (AMFData)new AMFDataItem(""));
            MediaReaderH264 mediaReaderH264 = this;
            aMFDataObj.put(FileChunk.getChars((int)(334 / 74), (String)"pwgdc`n"), (AMFData)new AMFDataItem(mediaReaderH264.getTrackDataTrackId(mediaReaderH264.trackIndexData)));
            aMFDataObj.put(FileChunk.getChars((int)(-6 - 31), (String)"7=39*!&'"), (AMFData)new AMFDataItem(string));
            if (n2 >= 2) {
                int n4 = 0;
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n, (int)2);
                if (n5 > 0 && n5 <= n2 - (n4 += 2)) {
                    String string2 = "";
                    try {
                        string2 = new String(byArray, n + n4, n2 - n4, this.trackDataCharSet);
                    }
                    catch (Exception exception) {}
                    aMFDataObj.put(Base64.copyValueOf((String)"?)5:", (int)(15 * 5)), (AMFData)new AMFDataItem(string2));
                }
            }
        }
        if (aMFDataList == null) return byArray2;
        return aMFDataList.serialize(0);
    }
}

