/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LivePlayerSwitch;
import com.wowza.wms.stream.live.LiveReceiver;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean isBurstCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean checkStreamProperties = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected boolean sendPlaySwitch = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int instantOnBufferTime = 0;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playTransition = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();
    protected AtomicReference<LivePlayerSwitch> liveSwitch = new AtomicReference<Object>(null);
    protected boolean sendOriginalTimecodes = false;
    protected int packetsSent = 0;
    protected int startPacketsSent = 0;
    protected boolean referenceWrite = true;
    protected int[] avgPacketSizes = new int[8];
    protected long avgPacketSizeCount = 0L;
    protected long avgPacketSizeTotal = 0L;
    protected int referenceWritePacketSizeThreshold = 500;
    private boolean a = true;

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{10, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(true);
        try {
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(false);
        try {
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        if (this.startPacketsSent == this.packetsSent) {
            this.sendBurstStart(outputStream, iMediaStream);
        }
        ++this.packetsSent;
        return StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])byArray, (int)n, (boolean)this.referenceWrite);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if ((by & 0xF) == 7 && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(byArray, 0, byArray.length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket6, l, aMFObj2, this.workBuffer, n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            Object var18_19 = null;
            aMFPacket4 = null;
            ResponseFunction responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            responseFunction.createSeekMessage(FileChunk.getChars((int)(1100 / 169), (String)"ii[}k\u007fy~"));
            responseFunction.setSrc(iMediaStream.getSrc());
            responseFunction.setType(18);
            responseFunction.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put(FileChunk.getChars((int)(63 + -17), (String)"m`tt"), (AMFData)new AMFDataItem(FileChunk.getChars((int)(51 - -40), (String)"\u00159)\r+2$#.j\u0001'3)g\u0019?-?:")));
            responseFunction.addBody((AMFData)aMFPacket4);
            n += responseFunction.write(outputStream, true, n2);
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj3, this.workBuffer, n2);
        }
        if (aMFPacket3 == null) return n;
        byte by2 = (byte)aMFPacket3.getFirstByte();
        aMFPacket4 = null;
        if ((by2 & 0xF) == 7 && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
            aMFPacket4.addData(byArray, 0, byArray.length);
        }
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, true), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket4 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket4, l, aMFObj2, this.workBuffer, n2);
        }
        lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
        lArray[3] = lArray[3] + 1L;
        n += this.packetOutput(outputStream, iMediaStream, aMFPacket3, l, aMFObj2, this.workBuffer, n2);
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, false), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket2 == null) return n;
        return n += this.packetOutput(outputStream, iMediaStream, aMFPacket2, l, aMFObj2, this.workBuffer, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        if (wMSProperties != null) {
            this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean(Base64.copyValueOf((String)"aotikfn@byMq\u007fvd}qb\u007fLqhthirvnf", (int)(1254 / 243)), this.disableLowBandwidthThrottling);
            this.instantOn = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(23 - -58), (String)"8<  48#\u00177"), this.instantOn);
            this.instantOnBufferTime = wMSProperties.getPropertyInt(FileChunk.getChars((int)(61 - 44), (String)"x|``txcWwXnz{{mThof"), this.instantOnBufferTime);
            this.waitForBufferFill = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(115 + 89), (String)";,';\u0016> \u0011!302*\u001f370"), this.waitForBufferFill);
            this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(45 * 9), (String)"bw~l_ui^hxyesIf}Ctfel"), this.waitForBufferKeyFrame);
            this.behindDropDFrames = wMSProperties.getPropertyInt(FileChunk.getChars((int)(712 / 127), (String)"gcoagnO~b~KVcs~qf"), this.behindDropDFrames);
            this.behindDropPFrames = wMSProperties.getPropertyInt(Base64.copyValueOf((String)"24:::1\u0012%7)\n\u001d.<3:3", (int)(16 - -64)), this.behindDropPFrames);
            this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt(Base64.copyValueOf((String)"f`nnfmNyc}EIbp\u007fvg", (int)(54 - 50)), this.behindDropKFrames);
            this.behindDropAudio = wMSProperties.getPropertyInt(FileChunk.getChars((int)(158 / 44), (String)"aamoilMxd|L{ky~"), this.behindDropAudio);
            this.maximumLiveLatency = wMSProperties.getPropertyInt(FileChunk.getChars((int)(7 * 61), (String)"fmubfftsfp|y{ym\u007fu\u007fd"), this.maximumLiveLatency);
            this.sendOriginalTimecodes = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(9 * 31), (String)"d}w~Tntyvn`nWmhcdgmox"), this.sendOriginalTimecodes);
            this.referenceWritePacketSizeThreshold = wMSProperties.getPropertyInt(Base64.copyValueOf((String)"qaccumgin[\u007fg{uAsp\u007fpbDqc\u007fOto{l(..'", (int)(20 - -15)), this.referenceWritePacketSizeThreshold);
            this.referenceWrite = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(51 + 97), (String)"fpprj|txyJlvtd"), this.referenceWrite);
            this.a = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(97 + 17), (String)"7=57:2\u001c 4:14=\ftsgbiHguclxx"), this.a);
        }
        this.isDebugLog = WMSLoggerFactory.getLogger(LiveReceiver.class).isDebugEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testVideoFrame(int n, int n2) {
        if ((n & 1 << ((n2 & 0x30) >> 4) - 1) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.workBuffer = new byte[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        this.startPacketsSent = this.packetsSent;
        synchronized (this.lock) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            LivePlayer livePlayer = this;
            livePlayer.isEnhancedSeekCapable = livePlayer.isEnhancedSeekCapable(livePlayer.stream.getParent());
            if (this.a) {
                LivePlayer livePlayer2 = this;
                livePlayer2.isBurstCapable = livePlayer2.isBurstCapable(livePlayer2.stream.getParent());
            }
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)Base64.copyValueOf((String)"p$y{c~", (int)(58 + 78)), (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.getChars((int)(359 / 65), (String)"vrumhg"), "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object = null;
                            AMFDataObj aMFDataObj = null;
                            object = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object.createSeekMessage(Base64.copyValueOf((String)"77\t/=)+,", (int)(-64 - -24)));
                            object.setSrc(this.stream.getParent().getSrc());
                            object.setType(18);
                            object.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put(Base64.copyValueOf((String)"wzrr", (int)(-43 - 33)), (AMFData)new AMFDataItem(Base64.copyValueOf((String)"MaqUszlkf\"Io{q?Agugb", (int)(309 / 96))));
                            object.addBody((AMFData)aMFDataObj);
                            n += object.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket4, l, aMFObj3, this.workBuffer, n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        AMFPacket aMFPacket5 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket5 != null) {
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket5, l, aMFObj2, this.workBuffer, n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer3 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer3.getEnhanceSeekPacket(livePlayer3.stream.getParent(), aMFPacket.getFirstByte(), true), l, aMFObj2, this.workBuffer, n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l, aMFObj2, this.workBuffer, n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer4 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer4.getEnhanceSeekPacket(livePlayer4.stream.getParent(), aMFPacket.getFirstByte(), false), l, aMFObj2, this.workBuffer, n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj, this.workBuffer, n2);
                        aMFObj.setNew(true);
                    }
                    if (n3 == 7 && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object = new byte[5];
                        object[0] = (ResponseFunction)23;
                        object[1] = (ResponseFunction)2;
                        object[2] = (ResponseFunction)false;
                        object[3] = (ResponseFunction)false;
                        object[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object, 0, ((ResponseFunction)object).length);
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l, aMFObj2, this.workBuffer, n2);
                    }
                    if (this.stream.getParent().isSendPlayStopLogEvent()) {
                        this.stream.getParent().setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.getChars((int)(88 + 104), (String)"350&%("), "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (this.startPacketsSent == this.packetsSent) return n;
            this.sendBurstEnd(outputStream, this.stream.getParent());
            return n;
        }
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected long[] getLastPacketTimecodes(List<AMFPacket> var1_1) {
        var2_2 = new long[]{-1L, -1L};
        var3_3 = var1_1.size() - 1;
        if (true) ** GOTO lbl8
        block0: while (true) {
            var2_2[1] = var6_6;
            while (var2_2[0] < 0L || var2_2[1] < 0L) {
                --var3_3;
lbl8:
                // 2 sources

                if (var3_3 < 0) return var2_2;
                var4_4 = var1_1.get(var3_3);
                var5_5 = var4_4.getType();
                var6_6 = var4_4.getAbsTimecode();
                if (var5_5 != 8) {
                    if (var5_5 != 9 || var2_2[1] != -1L) continue;
                    continue block0;
                }
                if (var2_2[0] != -1L) continue;
                var2_2[0] = var6_6;
            }
            break;
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        this.startPacketsSent = this.packetsSent;
        n += this.playAllInternal(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        IMediaStream iMediaStream2 = null;
        LivePlayerSwitch livePlayerSwitch = this.liveSwitch.get();
        if (livePlayerSwitch != null && livePlayerSwitch.switchTimecodeFound) {
            this.sendPlaySwitch = true;
            this.sendFirstAudioFrame = true;
            this.sendFirstVideoFrame = true;
            this.lastSeq = livePlayerSwitch.switchVideoKeyFrameSeq;
            ((MediaStream)this.stream.getParent()).setJustName(livePlayerSwitch.getName());
            iMediaStream2 = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            this.liveSwitch.set(null);
        }
        if (iMediaStream2 != null) {
            n += this.playAllInternal(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        if (this.startPacketsSent == this.packetsSent) return n;
        this.sendBurstEnd(outputStream, this.stream.getParent());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playAllInternal(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, long[] var6_6) {
        var7_7 = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        var8_8 = true;
        var9_9 = true;
        var10_10 = -1;
        var11_11 /* !! */  = this.stream.getParent();
        synchronized (var11_11 /* !! */ ) {
            var8_8 = this.stream.getParent().isReceiveAudio();
            var9_9 = this.stream.getParent().isReceiveVideo();
            var10_10 = this.stream.getParent().getReceiveVideoFPS();
        }
        synchronized (this.lock) {
            block145: {
                block148: {
                    block146: {
                        block170: {
                            block143: {
                                block152: {
                                    block151: {
                                        block153: {
                                            block150: {
                                                block147: {
                                                    block149: {
                                                        block164: {
                                                            block165: {
                                                                block144: {
                                                                    block142: {
                                                                        block141: {
                                                                            var12_14 = this.liveSwitch.get();
                                                                            var13_15 = this.getPlayPackets(var1_1);
                                                                            var14_16 = var1_1.getLastKeyFrame();
                                                                            if (this.checkStreamProperties) {
                                                                                v0 = this;
                                                                                v0.isEnhancedSeekCapable = v0.isEnhancedSeekCapable(v0.stream.getParent());
                                                                                if (this.a) {
                                                                                    v1 = this;
                                                                                    v1.isBurstCapable = v1.isBurstCapable(v1.stream.getParent());
                                                                                }
                                                                                if ((var15_17 = this.stream.getParent().getClient()) != null && var15_17.getLiveRepeaterCapabilities() > 0) {
                                                                                    this.sendOriginalTimecodes = true;
                                                                                }
                                                                                this.checkStreamProperties = false;
                                                                            }
                                                                            var15_17 = (Client)this.stream.getParent().getClient();
                                                                            var16_18 = var15_17.getSendChunkSize();
                                                                            var17_19 = 7;
                                                                            var18_20 = false;
                                                                            var19_21 = 0L;
                                                                            var21_22 = null;
                                                                            var22_23 = null;
                                                                            var23_24 = var15_17.getWriteListener();
                                                                            var24_25 = FileChunk.getChars((int)(303 / 61), (String)"wqtbid") + this.stream.getParent().getSrc();
                                                                            var25_26 = var13_15.size();
                                                                            if (var25_26 == 0) {
                                                                                this.bufferEmptyOnce = true;
                                                                            } else {
                                                                                var26_28 = (AMFPacket)var13_15.get(0);
                                                                                if (!this.waitForBufferFill || !this.sendFirstKeyFrame) break block141;
                                                                                var27_30 = true;
                                                                                var28_31 = System.currentTimeMillis();
                                                                                var30_35 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                                                                                if (this.waitForBufferFillStarTime == -1L) {
                                                                                    this.waitForBufferFillStarTime = var28_31;
                                                                                } else if (var28_31 - this.waitForBufferFillStarTime > var30_35 && !this.waitForBufferKeyFrame) {
                                                                                    var27_30 = false;
                                                                                }
                                                                                if (!var27_30 || var30_35 <= 0L) break block141;
                                                                                var32_38 = (AMFPacket)var13_15.get(var25_26 - 1);
                                                                                if (var32_38.getAbsTimecode() - var26_28.getAbsTimecode() >= var30_35) {
                                                                                    if (this.waitForBufferKeyFrame && var14_16 == null) {
                                                                                        var33_41 = 0;
                                                                                        var34_43 = 0;
                                                                                    }
                                                                                    break block141;
                                                                                }
                                                                            }
                                                                            ** GOTO lbl353
lbl67:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                block154: {
                                                                                    if (var12_14.switchMode != -1) ** GOTO lbl103
                                                                                    if (var12_14.getPlayerTransition() == 12) {
                                                                                        var12_14.switchMode = 1;
                                                                                    }
                                                                                    var36_52 = 0L;
                                                                                    if (var12_14.switchMode == -1) {
                                                                                        var38_61 = 1;
                                                                                        if (var35_47 != null && var35_47.size() > 0) {
                                                                                            var39_60 = this.getLastPacketTimecodes(var13_15);
                                                                                            var40_63 = this.getLastPacketTimecodes(var35_47);
                                                                                            var41_66 = -1L;
                                                                                            var43_70 = false;
                                                                                            var44_71 = -1L;
                                                                                            var46_84 = 0;
                                                                                            if (var39_60[0] >= 0L && var40_63[0] >= 0L) {
                                                                                                var41_66 = var40_63[0] - var39_60[0];
                                                                                                var43_70 = true;
                                                                                            }
                                                                                            if (var39_60[1] >= 0L && var40_63[1] >= 0L) {
                                                                                                var44_71 = var40_63[1] - var39_60[1];
                                                                                                var46_84 = 1;
                                                                                            }
                                                                                            if (var43_70 && var46_84 != 0) {
                                                                                                var36_52 = Math.abs(var44_71) >= Math.abs(var41_66) ? var41_66 : var44_71;
                                                                                            }
                                                                                            var36_52 = var46_84 != 0 ? var44_71 : var41_66;
                                                                                            if (Math.abs(var36_52) <= (long)var33_41) {
                                                                                                var38_61 = 0;
                                                                                            }
                                                                                        }
                                                                                        var12_14.switchMode = var38_61;
                                                                                    }
                                                                                    switch (var12_14.switchMode) {
                                                                                        case 1: {
                                                                                            var12_14.switchTimecodeOffset = var36_52;
                                                                                            ** break;
                                                                                        }
                                                                                        case 0: {
                                                                                            var12_14.switchTimecodeOffset = 0L;
                                                                                            ** break;
                                                                                        }
                                                                                        default: {
                                                                                            if (var12_14.lastSeq != -1L) ** GOTO lbl152
                                                                                            break block154;
                                                                                        }
                                                                                    }
lbl103:
                                                                                    // 3 sources

                                                                                    if (var12_14.lastSeq != -1L) ** GOTO lbl152
                                                                                }
                                                                                if (var35_47 == null || (var36_50 = var35_47.size()) <= 0) ** GOTO lbl152
                                                                                var37_54 = -1L;
                                                                                var39_58 = -1L;
                                                                                var41_66 = -1L;
                                                                                var43_68 = -1L;
                                                                                var45_80 = var29_32;
                                                                                ** GOTO lbl295
                                                                                break;
                                                                            }
                                                                        }
                                                                        while (true) {
                                                                            var27_29 = var26_28.getSeq();
                                                                            var29_32 = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - var27_29 + 1L);
                                                                            if (var29_32 < 0) {
                                                                                var29_32 = 0;
                                                                            }
                                                                            if (var29_32 >= var25_26) ** GOTO lbl353
                                                                            if (this.bufferEmptyOnce && !this.waitForBufferFill || !this.instantOn || !this.sendFirstKeyFrame) break block142;
                                                                            var30_35 = -1L;
                                                                            var32_39 = var25_26 - 1;
                                                                            var33_41 = -1;
                                                                            this.trackerBufferTime = 0L;
                                                                            var34_45 = this.stream.getParent().getBufferTime();
                                                                            break block143;
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            if (var42_106 == 9 && var12_14.switchVideoKeyFrameSeq >= 0L && var38_62 >= var12_14.switchTimecodeTarget && !var12_14.switchTimecodeFound) {
                                                                                var12_14.switchTimecodeFound = true;
                                                                            }
                                                                            if (!var12_14.switchTimecodeFound) ** GOTO lbl597
                                                                            ** GOTO lbl612
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            if (var33_41 <= 2) ** continue;
                                                                            ** GOTO lbl353
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            if (var34_43 >= var25_26 || (var35_47 = (AMFPacket)var13_15.get(var34_43)).getType() == 9 && ++var33_41 > 2) ** continue;
                                                                            ++var34_43;
                                                                        }
lbl138:
                                                                        // 1 sources

                                                                        while (true) {
                                                                            v2 = this;
                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v2.getEnhanceSeekPacket(v2.stream.getParent(), var21_22.getFirstByte(), false), var40_64, var37_55, this.workBuffer, var16_18);
                                                                            break block144;
lbl142:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                var29_33 = v3;
                                                                                this.lastSendTime = var27_29;
                                                                                WMSLoggerFactory.getLogger(LivePlayer.class).debug(FileChunk.getChars((int)(-37 - -62), (String)"j\u007fuxF") + this.stream.getParent().getClientId() + FileChunk.getChars((int)(-63 - -10), (String)"\u0016vm=&*4h") + var7_7 + ":" + var25_27 + FileChunk.getChars((int)(55 * 59), (String)"-hf|ewa.") + var17_19 + FileChunk.getChars((int)(1297 / 193), (String)"&sado1") + var29_33 + Base64.copyValueOf((String)"*\u007fCkh|ue(", (int)(-60 + 70)) + var19_21 + Base64.copyValueOf((String)"z)+/*e", (int)(-65 - -27)) + this.referenceWrite);
                                                                                ** GOTO lbl362
                                                                                break;
                                                                            }
                                                                            break;
                                                                        }
lbl147:
                                                                        // 3 sources

                                                                        while (true) {
                                                                            if (var51_99 < 0) {
                                                                                var51_99 = 0;
                                                                            }
                                                                            var26_28 = (AMFPacket)var35_47.get(var51_99);
                                                                            var12_14.lastSeq = var26_28.getSeq();
lbl152:
                                                                            // 4 sources

                                                                            if (var12_14.lastSeq < 0L || var12_14.switchVideoKeyFrameSeq >= 0L || var35_47 == null || (var36_51 = var35_47.size()) <= 0) break block145;
                                                                            var26_28 = (AMFPacket)var35_47.get(0);
                                                                            var37_54 = var26_28.getSeq();
                                                                            var39_59 = var12_14.lastSeq == -1L ? 0 : (int)(var12_14.lastSeq - var37_54 + 1L);
                                                                            if (var39_59 < 0) {
                                                                                var39_59 = 0;
                                                                            }
                                                                            if (var39_59 >= var36_51) break block145;
                                                                            var40_65 = var39_59;
                                                                            break block146;
                                                                            break;
                                                                        }
lbl161:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            var46_85 = v4;
                                                                            if (!var46_85) {
                                                                                var46_85 = this.testVideoFrame(var17_19, var44_72);
                                                                            }
                                                                            if (var46_85) {
                                                                                if (this.waitForKeyFrame) {
                                                                                    if (!FLVUtils.isVideoKeyFrame((AMFPacket)var26_28)) break block147;
                                                                                    WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.copyValueOf((String)"sdosNfx@itH}q|w)4sybv}", (int)(936 / 192)));
                                                                                    this.waitForKeyFrame = false;
                                                                                }
                                                                            } else {
                                                                                var43_67 = var26_28.getSize();
                                                                                var6_6[6] = var6_6[6] + (long)var43_67;
                                                                                var6_6[7] = var6_6[7] + 1L;
                                                                                break block147;
                                                                            }
                                                                            if (this.firstPacketTC == -1L) {
                                                                                var40_64 = 0L;
                                                                                this.firstPacketTC = var38_62;
                                                                                if (this.sendOriginalTimecodes) {
                                                                                    this.firstPacketTC = 0L;
                                                                                }
                                                                            } else {
                                                                                var40_64 = var38_62 - this.firstPacketTC;
                                                                            }
                                                                            if (var40_64 < 0L) break block147;
                                                                            var37_55 = var4_4;
                                                                            this.lastTC = var40_64;
                                                                            this.lastVideoTC = var40_64;
                                                                            if (!var9_9 && var45_77 == 7) {
                                                                                var47_92 = Math.min(var26_28.getSize(), 5);
                                                                                var26_28 = var26_28.clone();
                                                                                var26_28.truncatePacket(var47_92);
                                                                            }
                                                                            var43_67 = var26_28.getSize();
                                                                            var6_6[2] = var6_6[2] + (long)var43_67;
                                                                            var6_6[3] = var6_6[3] + 1L;
                                                                            break block147;
                                                                            break;
                                                                        }
lbl194:
                                                                        // 3 sources

                                                                        while (true) {
                                                                            block158: {
                                                                                block159: {
                                                                                    block156: {
                                                                                        block157: {
                                                                                            block155: {
                                                                                                if (var22_23 == null) {
                                                                                                    var22_23 = new LiveTracker();
                                                                                                    var22_23.firstTC = var38_62;
                                                                                                }
                                                                                                var22_23.lastTC = var38_62;
                                                                                                var44_73 = false;
                                                                                                if (!this.sendFirstKeyFrame) break block155;
                                                                                                var45_79 = var1_1.getMetaDataProvider();
                                                                                                if (var45_79 == null) break block156;
                                                                                                break block157;
                                                                                            }
                                                                                            if (this.lastReceiveAudio == var8_8) ** GOTO lbl462
                                                                                            if (!var8_8) break block158;
                                                                                            break block159;
                                                                                        }
                                                                                        var46_89 = new ArrayList<E>();
                                                                                        var47_93 = var26_28.getAbsTimecode();
                                                                                        var45_79.onStreamStart(var46_89, var47_93);
                                                                                        if (var46_89.size() > 0) {
                                                                                            var49_97 = null;
                                                                                            var50_110 = null;
                                                                                            var49_97 = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                                                                                            var49_97.createSeekMessage(FileChunk.getChars((int)(222 / 32), (String)"ii[}k\u007fy~"));
                                                                                            var49_97.setSrc(this.stream.getParent().getSrc());
                                                                                            var49_97.setType(18);
                                                                                            var49_97.setTimecode(var40_64);
                                                                                            var50_110 = new AMFDataObj();
                                                                                            var50_110.put(FileChunk.getChars((int)(345 / 111), (String)"`kac"), (AMFData)new AMFDataItem(Base64.copyValueOf((String)"S{kSupfeh(Ci}k%_yo}d", (int)(-40 - 59))));
                                                                                            var49_97.addBody((AMFData)var50_110);
                                                                                            var7_7 += var49_97.write(var2_2, true, var16_18);
                                                                                            for (AMFPacket var52_103 : var46_89) {
                                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var52_103, var40_64, var5_5, this.workBuffer, var16_18);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    var46_86 = true;
                                                                                    if (var21_22 == null) {
                                                                                        var21_22 = this.getLastKeyFrame(var1_1);
                                                                                        var46_86 = false;
                                                                                    }
                                                                                    if (!var9_9) {
                                                                                        var21_22 = null;
                                                                                    }
                                                                                    if (var21_22 == null) ** GOTO lbl457
                                                                                    if (this.sendFirstVideoFrame) {
                                                                                        var47_94 = var1_1.getVideoCodecConfigPacket(var21_22.getAbsTimecode());
                                                                                        if (var47_94 != null) {
                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_94, var40_64, var37_55, this.workBuffer, var16_18);
                                                                                        }
                                                                                        this.sendFirstVideoFrame = false;
                                                                                        var44_73 = true;
                                                                                    }
                                                                                    if (var44_73 && this.isEnhancedSeekCapable) {
                                                                                        v5 = this;
                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v5.getEnhanceSeekPacket(v5.stream.getParent(), var21_22.getFirstByte(), true), var40_64, var37_55, this.workBuffer, var16_18);
                                                                                    }
                                                                                    var6_6[2] = var6_6[2] + (long)var21_22.getSize();
                                                                                    var6_6[3] = var6_6[3] + 1L;
                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var21_22, var40_64, var4_4, this.workBuffer, var16_18);
                                                                                    var4_4.setNew(true);
                                                                                    if (!this.isEnhancedSeekCapable) ** GOTO lbl-1000
                                                                                    var47_91 = var21_22.getSeq();
                                                                                    var49_96 = (int)(var47_91 - var27_29 + 1L);
                                                                                    if (var46_86) {
                                                                                        this.waitForKeyFrame = false;
                                                                                    }
                                                                                    if (!var46_86 || var49_96 < 0 || var49_96 >= var25_26) ** GOTO lbl-1000
                                                                                    var50_109 = 0;
                                                                                    var51_100 = var49_96;
                                                                                    ** GOTO lbl620
                                                                                }
                                                                                var7_7 += this.stream.getParent().sendLivePlaySeek(var2_2, this.stream.getParent().getName(), var40_64);
                                                                            }
                                                                            if ((var45_81 = new AMFPacket(8, var1_1.getSrc(), 0)) != null) {
                                                                                var6_6[0] = var6_6[0] + 0L;
                                                                                var6_6[1] = var6_6[1] + 1L;
                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var45_81, var40_64, var3_3, this.workBuffer, var16_18);
                                                                            }
                                                                            this.lastReceiveAudio = var8_8;
                                                                            ** GOTO lbl462
                                                                            break;
                                                                        }
lbl266:
                                                                        // 1 sources

                                                                        while (FLVUtils.isVideoKeyFrame((AMFPacket)var26_28)) {
                                                                            var44_74 = var26_28.getFirstByte();
                                                                            var45_76 = var26_28.getAbsTimecode();
                                                                            var12_14.switchVideoKeyFrameSeq = var41_66 - 1L;
                                                                            var12_14.switchTimecodeTarget = var45_76 + var12_14.switchTimecodeOffset;
                                                                            break block148;
                                                                        }
                                                                        break block148;
                                                                        while (true) {
                                                                            var41_66 = var47_90;
                                                                            if (true) ** GOTO lbl286
                                                                            break;
                                                                        }
                                                                        do {
                                                                            block163: {
                                                                                block161: {
                                                                                    block162: {
                                                                                        block160: {
                                                                                            var26_28 = (AMFPacket)var13_15.get(var45_80);
                                                                                            var46_84 = var26_28.getType();
                                                                                            var47_90 = var26_28.getAbsTimecode();
                                                                                            if (var46_84 != 8) break block160;
                                                                                            if (var37_54 != -1L) break block161;
                                                                                            break block162;
                                                                                        }
                                                                                        if (var46_84 != 9) break block163;
                                                                                        if (var41_66 == -1L) ** continue;
lbl286:
                                                                                        // 2 sources

                                                                                        var43_68 = var47_90;
                                                                                        break block163;
                                                                                    }
                                                                                    var37_54 = var47_90;
                                                                                }
                                                                                var39_58 = var47_90;
                                                                            }
                                                                            ++var45_80;
lbl295:
                                                                            // 2 sources

                                                                        } while (var45_80 < var25_26);
                                                                        var45_76 = var43_68 - var41_66;
                                                                        var47_90 = var39_58 - var37_54;
                                                                        var49_95 = Math.max(var45_76, var47_90);
                                                                        var37_54 = -1L;
                                                                        var39_58 = -1L;
                                                                        var41_66 = -1L;
                                                                        var43_68 = -1L;
                                                                        var51_99 = -1;
                                                                        var52_102 = var36_50 - 1;
                                                                        break block164;
lbl306:
                                                                        // 1 sources

                                                                        while (true) {
                                                                            if (var45_77 == 7) break block149;
                                                                            break block147;
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            var6_6[2] = var6_6[2] + (long)var52_103.getSize();
                                                                            var6_6[3] = var6_6[3] + 1L;
                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var52_103, var40_64, var4_4, this.workBuffer, var16_18);
                                                                            ++var50_109;
                                                                            break block150;
                                                                            while (true) {
                                                                                if (var42_106 != 9 || !this.sendFirstVideoFrame) ** GOTO lbl463
                                                                                var45_83 = var1_1.getVideoCodecConfigPacket(var26_28.getAbsTimecode());
                                                                                if (var45_83 != null) {
                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var45_83, var40_64, var37_55, this.workBuffer, var16_18);
                                                                                }
                                                                                this.sendFirstVideoFrame = false;
                                                                                var44_73 = true;
                                                                                ** GOTO lbl463
                                                                                break;
                                                                            }
lbl323:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                this.sendFirstAudioFrame = false;
                                                                                ** GOTO lbl463
                                                                                break;
                                                                            }
                                                                            break;
                                                                        }
lbl326:
                                                                        // 1 sources

                                                                        while (var43_68 - var54_105 >= var49_95) {
                                                                            var51_99 = var52_102;
                                                                            ** GOTO lbl147
                                                                        }
                                                                        break block165;
lbl330:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            this.referenceWrite = v6;
                                                                            ** GOTO lbl360
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            var37_55 = var3_3;
                                                                            this.lastTC = var40_64;
                                                                            this.lastAudioTC = var40_64;
                                                                            var43_67 = var26_28.getSize();
                                                                            var6_6[0] = var6_6[0] + (long)var43_67;
                                                                            var6_6[1] = var6_6[1] + 1L;
                                                                            break block147;
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            v7 = this;
                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v7.getEnhanceSeekPacket(v7.stream.getParent(), var26_28.getFirstByte(), false), var40_64, var37_55, this.workBuffer, var16_18);
                                                                            ** GOTO lbl475
                                                                            break;
                                                                        }
                                                                        while (true) {
                                                                            var40_64 = var38_62 - this.firstPacketTC;
                                                                            if (var40_64 >= 0L) ** GOTO lbl578
                                                                            var40_64 = 0L;
                                                                            ** GOTO lbl578
                                                                            break;
                                                                        }
lbl350:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            block167: {
                                                                                block169: {
                                                                                    block168: {
                                                                                        block166: {
                                                                                            if (var34_44 != -1L) {
                                                                                                this.lastSeq = var34_44;
                                                                                            }
lbl353:
                                                                                            // 7 sources

                                                                                            var25_27 = 0L;
                                                                                            if (this.avgPacketSizeCount <= (long)(this.avgPacketSizes.length << 1)) break block166;
                                                                                            var25_27 = this.avgPacketSizeTotal / (long)this.avgPacketSizes.length;
                                                                                            if (this.referenceWritePacketSizeThreshold <= 0) break block166;
                                                                                            if (var25_27 < (long)this.referenceWritePacketSizeThreshold) break block167;
                                                                                            v6 = true;
                                                                                            ** GOTO lbl330
                                                                                        }
                                                                                        if (this.isDebugLog) break block168;
lbl362:
                                                                                        // 2 sources

                                                                                        if (var22_23 == null) return var7_7;
                                                                                        var22_23.totalLen = var7_7;
                                                                                        this.lastSentLiveTracker = var22_23;
                                                                                        var23_24.getPendingTracker().putInfo(var24_25, var22_23);
                                                                                        // ** MonitorExit[var11_11 /* !! */ ] (shouldn't be in output)
                                                                                        return var7_7;
                                                                                    }
                                                                                    var27_29 = System.currentTimeMillis();
                                                                                    if (this.lastSendTime == -1L) break block169;
                                                                                    v3 = var27_29 - this.lastSendTime;
                                                                                    ** GOTO lbl142
                                                                                }
                                                                                v3 = 0L;
                                                                                ** continue;
                                                                            }
                                                                            v6 = false;
                                                                            ** continue;
                                                                            break;
                                                                        }
lbl380:
                                                                        // 1 sources

                                                                        while (true) {
                                                                            this.firstPacketTC = 0L;
                                                                            ** GOTO lbl527
                                                                            break;
                                                                        }
lbl383:
                                                                        // 1 sources

                                                                        while (true) {
                                                                            if (this.sendPlayStop) {
                                                                                var7_7 += this.stream.getParent().sendPlayStop(var2_2, var40_64, this.stream.getParent().getName());
                                                                                this.sendPlayStop = false;
                                                                            }
                                                                            var7_7 += this.stream.getParent().sendLivePlayStart(var2_2, this.stream.getParent().getName(), var40_64, this.firstPacketTC);
                                                                            this.sentPlayStart = true;
                                                                            this.sendPlayStop = true;
                                                                            this.stream.getParent().setSendPlayStopLogEvent(true);
                                                                            WMSLoggerFactory.putGlobalLogValue((String)Base64.copyValueOf((String)"z.wuit", (int)(-2 - -4)), (Object)new Long(0L));
                                                                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.getChars((int)(979 / 246), (String)"ppwcfe"), "play", 200, this.stream.getParent().getName());
                                                                            this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                                                                            var5_5.setNew(true);
                                                                            var3_3.setNew(true);
                                                                            var4_4.setNew(true);
                                                                            ** GOTO lbl563
                                                                            break;
                                                                        }
                                                                    }
lbl399:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        if (var29_32 == 0 && this.lastSeq != -1L && (var26_28 = (AMFPacket)var13_15.get(var29_32)).getSeq() != this.lastSeq + 1L) {
                                                                            this.waitForKeyFrame = true;
                                                                        }
                                                                        if ((var31_36 = (var30_34 = var23_24.getLastTracker()) == null ? null : (LiveTracker)var30_34.getInfo(var24_25)) != null && this.lastSentLiveTracker != null && var31_36.trackerSeq >= this.trackerStartSeq) {
                                                                            var32_40 = var30_34.getSent();
                                                                            var34_46 = var30_34.getSize();
                                                                            var36_53 = var31_36.firstTC + (var31_36.lastTC - var31_36.firstTC) * var32_40 / var34_46;
                                                                            var19_21 = this.lastSentLiveTracker.lastTC - var36_53 - this.trackerBufferTime;
                                                                            if (!this.disableLowBandwidthThrottling) {
                                                                                if (var19_21 > (long)this.behindDropAudio) {
                                                                                    var18_20 = true;
                                                                                }
                                                                                if (var19_21 > (long)this.behindDropKFrames) {
                                                                                    var17_19 = 0;
                                                                                } else if (var19_21 > (long)this.behindDropPFrames) {
                                                                                    var17_19 = 1;
                                                                                } else if (var19_21 > (long)this.behindDropDFrames) {
                                                                                    var17_19 = 3;
                                                                                }
                                                                            }
                                                                            if (this.lastTCFilter != var17_19) {
                                                                                WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.copyValueOf((String)"\\rpi{m[", (int)(36 + 118)) + var24_25 + FileChunk.getChars((int)(622 / 98), (String)"[=(ocgxh|58") + this.lastTCFilter + "-" + var17_19 + FileChunk.getChars((int)(32 - -30), (String)"7?/'$0!1|") + var19_21 + FileChunk.getChars((int)(67 + -47), (String)"4fsylMY!") + this.lastSentLiveTracker.lastTC + FileChunk.getChars((int)(779 / 150), (String)"%tbklc}iiZL*") + var31_36.lastTC + FileChunk.getChars((int)(35 * 63), (String)"=|jfggqPlkb2") + this.trackerBufferTime + FileChunk.getChars((int)(39 * 15), (String)"i>(v") + this.lastTC);
                                                                            }
                                                                            this.lastTCFilter = var17_19;
                                                                        }
                                                                        this.lastTCOffset = var19_21;
                                                                        var32_37 = var10_10;
                                                                        if (var32_37 < -1) {
                                                                            if (var32_37 == -2 && var17_19 == 7) {
                                                                                var17_19 = 3;
                                                                            } else if (var32_37 == -3 && (var17_19 == 7 || var17_19 == 3)) {
                                                                                var17_19 = 1;
                                                                                this.waitForKeyFrame = true;
                                                                            }
                                                                        }
                                                                        var33_41 = 300;
                                                                        if (var12_14 == null) break block145;
                                                                        var34_42 = this.stream.getParent().getStreams().getStream(var12_14.getName());
                                                                        var35_47 = null;
                                                                        if (var34_42 == null) ** GOTO lbl67
                                                                        var35_47 = var34_42.getPlayPackets();
                                                                        ** continue;
                                                                        break;
                                                                    }
                                                                    while (true) {
                                                                        var6_6[0] = var6_6[0] + 0L;
                                                                        var6_6[1] = var6_6[1] + 1L;
                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var45_78, var40_64, var3_3, this.workBuffer, var16_18);
                                                                        var3_3.setNew(true);
lbl442:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            var46_87 = var1_1.getAudioCodecConfigPacket(var26_28.getAbsTimecode());
                                                                            if (var46_87 == null) ** GOTO lbl323
                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var46_87, var40_64, var37_55, this.workBuffer, var16_18);
                                                                            ** continue;
                                                                            break;
                                                                        }
                                                                        break;
                                                                    }
lbl447:
                                                                    // 1 sources

                                                                    while (var39_56) {
                                                                        var21_22 = var26_28;
                                                                        break block151;
                                                                    }
                                                                    break block151;
lbl451:
                                                                    // 1 sources

                                                                    while (var36_48 != 8) {
                                                                        break block152;
                                                                    }
                                                                    break block170;
                                                                }
                                                                while (true) {
                                                                    block172: {
                                                                        block173: {
                                                                            block171: {
                                                                                var44_73 = false;
lbl457:
                                                                                // 2 sources

                                                                                this.trackerStartSeq = var22_23.trackerSeq;
                                                                                this.sendFirstKeyFrame = false;
                                                                                this.lastReceiveAudio = var8_8;
                                                                                this.lastReceiveVideo = var9_9;
                                                                                this.lastReceiveVideoFPS = var10_10;
lbl462:
                                                                                // 3 sources

                                                                                if (this.sendFirstAudioFrame || this.sendFirstVideoFrame) break block171;
lbl463:
                                                                                // 4 sources

                                                                                if (!var44_73 || !this.isEnhancedSeekCapable) break block172;
                                                                                break block173;
                                                                            }
                                                                            if (var42_106 != 8 || !this.sendFirstAudioFrame) ** continue;
                                                                            if ((var45_78 = new AMFPacket(8, var1_1.getSrc(), 0)) != null) ** continue;
                                                                            ** continue;
                                                                        }
                                                                        v8 = this;
                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v8.getEnhanceSeekPacket(v8.stream.getParent(), var26_28.getFirstByte(), true), var40_64, var37_55, this.workBuffer, var16_18);
                                                                    }
                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var26_28, var40_64, var37_55, this.workBuffer, var16_18);
                                                                    if (var44_73 && this.isEnhancedSeekCapable) ** continue;
lbl475:
                                                                    // 2 sources

                                                                    var44_73 = false;
                                                                    ** GOTO lbl549
                                                                    break;
                                                                }
                                                                while (true) {
                                                                    v9 = var33_41;
                                                                    ** GOTO lbl511
                                                                    break;
                                                                }
lbl480:
                                                                // 1 sources

                                                                while (true) {
                                                                    this.firstPacketTC = 0L;
                                                                    ** GOTO lbl578
                                                                    break;
                                                                }
lbl483:
                                                                // 1 sources

                                                                block49: while (true) {
                                                                    block174: {
                                                                        if (var39_58 == -1L) break block174;
                                                                        if (var39_58 - var54_105 < var49_95) break;
                                                                        var51_99 = var52_102;
                                                                        ** GOTO lbl147
                                                                    }
                                                                    var39_58 = var54_105;
                                                                    break;
                                                                    while (true) {
                                                                        if (var53_104 != 9) break block49;
                                                                        if (var43_68 != -1L) ** GOTO lbl326
                                                                        var43_68 = var54_105;
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                            }
                                                            --var52_102;
                                                        }
                                                        if (var52_102 >= 0) ** break;
                                                        ** continue;
                                                        var26_28 = (AMFPacket)var35_47.get(var52_102);
                                                        var53_104 = var26_28.getType();
                                                        var54_105 = var26_28.getAbsTimecode();
                                                        if (var53_104 != 8) ** continue;
                                                        ** continue;
                                                        while (true) {
                                                            v4 = false;
                                                            ** GOTO lbl161
                                                            break;
                                                        }
lbl508:
                                                        // 3 sources

                                                        while (true) {
                                                            if (var33_41 >= 0) ** continue;
                                                            v9 = 0;
lbl511:
                                                            // 2 sources

                                                            var29_32 = v9;
                                                            ** continue;
                                                            break;
                                                        }
                                                    }
                                                    while (true) {
                                                        if (var17_19 != 7) ** continue;
                                                        v4 = true;
                                                        ** continue;
                                                        break;
                                                    }
                                                    while (true) {
                                                        if (var18_20) break block147;
                                                        if (this.firstPacketTC == -1L) {
                                                            var40_64 = 0L;
                                                            this.firstPacketTC = var38_62;
                                                            if (this.sendOriginalTimecodes) {
                                                                ** continue;
                                                            }
                                                        } else {
                                                            var40_64 = var38_62 - this.firstPacketTC;
                                                        }
lbl527:
                                                        // 3 sources

                                                        if (var40_64 >= 0L) ** continue;
                                                        break block147;
lbl529:
                                                        // 1 sources

                                                        while (true) {
                                                            if (!var48_107.hasNext()) ** GOTO lbl194
                                                            var49_98 = (AMFPacket)var48_107.next();
                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var49_98, var40_64, var5_5, this.workBuffer, var16_18);
                                                            continue;
                                                            break;
                                                        }
                                                        break;
                                                    }
lbl534:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var33_41 == -1 && var30_35 - var37_54 > var34_45) {
                                                            var33_41 = var32_39;
                                                        }
                                                        break block153;
                                                        break;
                                                    }
                                                }
lbl539:
                                                // 3 sources

                                                block57: while (true) {
                                                    block176: {
                                                        block177: {
                                                            block175: {
                                                                if (var43_67 > 0) {
                                                                    this.avgPacketSizeTotal -= (long)this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)];
                                                                    this.avgPacketSizeTotal += (long)var43_67;
                                                                    this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)] = var43_67;
                                                                    ++this.avgPacketSizeCount;
                                                                }
                                                                if (var37_55 == null) break block175;
                                                                if (!this.sentPlayStart) {
                                                                    ** continue;
                                                                }
                                                                break block176;
                                                            }
                                                            var34_44 = var26_28.getSeq();
                                                            if (!(this.playLen > 0.0) || var40_64 < Math.round(this.playLen)) break block177;
                                                            if (this.stream.getParent().isSendPlayStopLogEvent()) {
                                                                this.stream.getParent().setSendPlayStopLogEvent(false);
                                                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.copyValueOf((String)":>9),#", (int)(45 * 13)), "stop", 200, this.stream.getParent().getName());
                                                                this.stream.getParent().notifyActionStop();
                                                            }
                                                            var7_7 += this.stream.getParent().sendPlayStatus(var2_2, var40_64, 2, 0.0, 0.0);
                                                            var7_7 += this.stream.getParent().sendPlayStop(var2_2, var40_64, this.stream.getParent().getName());
                                                            this.playlistEnd = true;
                                                            ** GOTO lbl612
                                                        }
                                                        ++var36_49;
                                                        ** GOTO lbl589
                                                    }
                                                    if (!this.sendPlaySwitch) ** GOTO lbl194
                                                    this.sendPlaySwitch = false;
                                                    var7_7 += this.stream.getParent().sendLivePlaySwitch(var2_2, var1_1.getName(), var40_64);
                                                    var44_75 = var1_1.getMetaDataProvider();
                                                    var45_82 = new ArrayList<E>();
                                                    var46_88 = var26_28.getAbsTimecode();
                                                    var44_75.onStreamStart(var45_82, var46_88);
                                                    if (var45_82.size() > 0) ** break;
                                                    ** continue;
                                                    var48_107 = var45_82.iterator();
                                                    ** continue;
lbl575:
                                                    // 1 sources

                                                    while (true) {
                                                        this.waitForKeyFrame = true;
                                                        ** GOTO lbl350
                                                        break;
                                                    }
lbl578:
                                                    // 4 sources

                                                    while (true) {
                                                        var37_55 = var5_5;
                                                        this.lastTC = var40_64;
                                                        this.lastDataTC = var40_64;
                                                        var6_6[4] = var6_6[4] + (long)var26_28.getSize();
                                                        var6_6[5] = var6_6[5] + 1L;
                                                        continue block57;
                                                        break;
                                                    }
                                                    break;
                                                }
lbl585:
                                                // 2 sources

                                                while (true) {
                                                    this.checkWorkBuffer(var16_18);
                                                    var34_44 = -1L;
                                                    var36_49 = var29_32;
lbl589:
                                                    // 2 sources

                                                    if (var36_49 >= var25_26) ** GOTO lbl612
                                                    var26_28 = (AMFPacket)var13_15.get(var36_49);
                                                    var37_55 = null;
                                                    var38_62 = var26_28.getAbsTimecode();
                                                    var40_64 = 0L;
                                                    var42_106 = var26_28.getType();
                                                    var43_67 = 0;
                                                    if (var12_14 != null) ** continue;
lbl597:
                                                    // 2 sources

                                                    switch (var42_106) {
                                                        case 8: {
                                                            if (var8_8) ** continue;
                                                            ** GOTO lbl539
                                                        }
                                                        case 15: 
                                                        case 18: {
                                                            if (this.firstPacketTC != -1L) ** continue;
                                                            var40_64 = 0L;
                                                            this.firstPacketTC = var38_62;
                                                            if (!this.sendOriginalTimecodes) ** continue;
                                                            ** continue;
                                                        }
                                                        case 9: {
                                                            var44_72 = var26_28.getFirstByte();
                                                            var45_77 = FLVUtils.getVideoCodec((int)var44_72);
                                                            if (var9_9) ** continue;
                                                            ** continue;
                                                        }
lbl612:
                                                        // 3 sources

                                                        if (var17_19 == 0 || var17_19 == 1) ** break;
                                                        ** continue;
                                                        ** continue;
                                                    }
                                                    WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info(Base64.copyValueOf((String)"Mk`h2)]F__k|`Bfaqt{d\"9unhmkkShldh`<'}gad{c.\u007fqryv`5bnh| ;", (int)(568 / 123)) + var26_28.getType());
                                                    ** continue;
                                                    break;
                                                }
                                            }
                                            while (true) {
                                                ++var51_100;
lbl620:
                                                // 2 sources

                                                if (var51_100 < var36_49) {
                                                    var52_103 = (AMFPacket)var13_15.get(var51_100);
                                                    if (var52_103.getType() != 9) {
                                                        continue;
                                                    }
                                                } else lbl-1000:
                                                // 3 sources

                                                {
                                                    if (!var44_73 || !this.isEnhancedSeekCapable) ** continue;
                                                    ** continue;
                                                }
                                                if (FLVUtils.getFrameType((int)(var53_104 = var52_103.getFirstByte())) != 3) ** continue;
                                            }
                                        }
lbl630:
                                        // 2 sources

                                        while (true) {
                                            if (var36_48 != 9) break;
                                            var39_56 = FLVUtils.isVideoKeyFrame((AMFPacket)var26_28);
                                            if (!this.isEnhancedSeekCapable) ** GOTO lbl447
                                            if (var33_41 == -1 || !var39_56) break;
                                            var21_22 = var26_28;
                                            if (this.instantOnBufferTime <= 0 || var30_35 - var37_54 >= (long)this.instantOnBufferTime) ** GOTO lbl508
                                            break;
                                        }
                                    }
                                    if (!this.isEnhancedSeekCapable && var33_41 != -1) ** GOTO lbl508
                                }
                                --var32_39;
                            }
                            if (var32_39 >= 0) ** break;
                            ** continue;
                            var26_28 = (AMFPacket)var13_15.get(var32_39);
                            var36_48 = var26_28.getType();
                            if (var36_48 != 9) ** GOTO lbl451
                        }
                        var37_54 = var26_28.getAbsTimecode();
                        if (var30_35 == -1L) {
                            var30_35 = var37_54;
                            ** continue;
                        }
                        if (var33_41 != -1) ** GOTO lbl534
                        this.trackerBufferTime = var30_35 - var37_54;
                        ** continue;
                    }
lbl656:
                    // 2 sources

                    while (var40_65 < var36_51) {
                        var26_28 = (AMFPacket)var35_47.get(var40_65);
                        var41_66 = var26_28.getSeq();
                        var43_69 = var26_28.getType();
                        var12_14.lastSeq = var41_66;
                        if (var43_69 == 9) ** GOTO lbl266
                    }
                    break block145;
                }
                ++var40_65;
                ** GOTO lbl656
            }
            if (this.sendFirstKeyFrame || this.lastReceiveVideo == var9_9) ** GOTO lbl585
            if (var9_9) {
                this.waitForKeyFrame = true;
            }
            this.lastReceiveVideo = var9_9;
            ** continue;
        }
    }

    @Override
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen != 0.0) {
            return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null) return n;
        return n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    @Override
    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        if (iMediaStream != null) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.checkStreamProperties = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            this.liveSwitch.set(null);
            this.sendPlaySwitch = false;
            if (!bl2) return;
            IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            if (iMediaStream == null) return;
            AMFPacket aMFPacket = this.getLastPacket(iMediaStream);
            if (aMFPacket == null) return;
            this.lastSeq = aMFPacket.getSeq();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resetNoLookup() {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)Base64.copyValueOf((String)"|(uwgz", (int)(596 / 139)), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.getChars((int)(474 / 158), (String)"ppwcfe"), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reset(boolean bl) {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)FileChunk.getChars((int)(-34 - -56), (String)"n:kiuh"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.copyValueOf((String)"-+2$#.", (int)(-18 - 16)), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(bl, true);
    }

    @Override
    public void pause(int n, long l) {
    }

    @Override
    public void pauseRaw(int n, long l) {
    }

    @Override
    public void seek(int n) {
    }

    @Override
    public void setBufferTime(int n) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        IMediaStream iMediaStream = this.stream.getParent();
        IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
        String string5 = this.stream.getParent().getStreamType();
        boolean bl = false;
        StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string5);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean(FileChunk.getChars((int)(18 + 104), (String)"3(\u00104(:RdrfeqcuMmmn"), bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, (IClient)iMediaStream.getClient(), (String)string);
        }
        this.liveSwitch.set(new LivePlayerSwitch(string, string2, n));
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
    }

    @Override
    public void interruptPlay() {
    }

    @Override
    public void startPlay() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (WMSLoggerFactory.isGlobalLogValueSet((String)FileChunk.getChars((int)(-35 - 44), (String)"i?`dze"))) return;
        WMSLoggerFactory.putGlobalLogValue((String)Base64.copyValueOf((String)"}+txfy", (int)(-11 - -48)), (Object)new Long(l));
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    @Override
    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }
}

